#ifndef PANEL_H
#define PANEL_H
#include "vfs.h"

extern int mystrcmp(char*,int,int,char*,int,int);

class Lister:public Gui
{
  GC wgcw,fgc;
  GC xpmgc;
  XRectangle rect,rect2;
  FList *last_ff;
  char ff_buf[80];
 public:
  int (*comp)(char*,int,int,char*,int,int);
  Lister *panel2;
  FList *lar;
  int larmax;
  Cmdline *cmdl;
  VFS *vfs,*vfstack;
  DFS dfs;
  AFS afs;
  FTP ftp;
  char curdir[1024];
  int x,y,ty,tdl,bclk,lmx,lmy,lcurn,flen,lowfl,brief,side,mouse;
  uint l,h,tl,th,pl;
  int prflg,col,cl,scanfl,lastn,curn,fixl,selfiles,selsize,lay,fixh,fixy;
  Time dbtime;
  char refindchr[256];
  char *maskchr;
  FList fl;
  FList dl;
  FList *base,*cur;
  Menu *subm;
  void (*viewfunc)(char*);
  void (*viewonlyfunc)(char*);
  void (*editorfunc)(char*);
  int attdx;
  time_t lastscan;
  Lister(int ix,int iy,int il,int ih,int icolumns=2):Gui()
   {x=ix;y=iy;l=il;h=ih;col=icolumns;cl=0;scanfl=1;ty=tdl=bclk=lmx=lmy=lcurn=mouse=0;vfs=&dfs;
    prflg=lastn=curn=0;cmdl=NULL;lowfl=0;maskchr=new char[256];larmax=0;last_ff=NULL;ff_buf[0]=0;
    strcpy(maskchr,"*");lar=NULL;viewfunc=viewonlyfunc=NULL;editorfunc=NULL;comp=mystrcmp;lay=side=0;subm=NULL;
   dfs.set_dir_pointer(curdir,1024);afs.set_dir_pointer(NULL,0);
   ftp.set_dir_pointer(NULL,0);vfstack=NULL;};
  void repanel(int);
  void delall_l(FList*);
  void sortbyext();
  void sortbysize();
  void sortbytime();
  void sortbyname();
  int  direc(char*);
  int findentry(char*);
  int is_filtered(char *s,char *ff);
  void cmdl_insert_name(char *name);
  void reconfigure(int ix,int iy,int il,int ih);
  void reconfigure_without_expose(int ix,int iy,int il,int ih);
  void setcmdl(Cmdline* cmd) {cmdl=cmd;};
  void restore_select();
  void change_dir(char*);
  void save_select();
  void left();
  void right();
  void funcs(int);
  void selected(FList*);
  void reread();
  void showdir();
  void showdirname();
  void showitem(FList*,int);
  void show_item(FList*);
  void showfinfo(FList*);
  void showempty(int);
  void fserror(char*,FList*);
  void setpanel(Lister* pp) {panel2=pp;};
  void set_by_name(char*);
  int  setcur(FList**,int);
  void setviewer(void (*vw)(char*),void (*vow)(char*)) {viewfunc=vw;viewonlyfunc=vow;};
  void seteditor(void (*vw)(char*)) {editorfunc=vw;};
  void setsubmenu(Menu* sbm) {subm=sbm;};
  void activate();
  void select_by_mask(int);
  ~Lister() {XFreeGC(disp,gcw);XFreeGC(disp,fgc);XFreeGC(disp,wgcw);XFreeGC(disp,xpmgc);delall_l(&dl);delete maskchr;};
  virtual void init(Window);
  virtual void click();
  virtual void expose();
  virtual void show();
  
  void view(int);
  void edit();
  void copy();
  void move();
  void copy(VFS*);
  void move(VFS*);
  void del();
  void remount();
  void mkdir();
  void attrib();
  void raise_terminal_if_need();
  void lpr();
  void do_ftp_link();
  void push_n_pop(FTP*);
  void pop_and_show();
  void check_and_pop(VFS *vf);
  
  void fdelete();
  void fcopy();
  int moved(char*);
  void upperpath();
  void addpathcontent(char*);
  void fmove();
  void fedit();
  void fmkdir();
  void chowns();
  void setattr();
  void setattrs(int);
  void ext_exec(char*);
  void menu_exec(char*);
  void wide_exec();
  void ps_info();
  void push_vfs(VFS*);
  VFS* pop_vfs();
  void switch_to_prev_vfs();
  void switch_to_vfs(int vfs_type,char *dir);
  void send_dnd_message();
  void try_to_add_to_bookmark(int cy);
 void check_dnd_dir(unsigned mask);
 void check_dnd_dir_on_panel2(int,int,unsigned mask);
 void fast_find(XEvent*);
 void showfilelist();
 void clear_ff();
 void show_ff_item(int,int);
 void create_ftp_link();
 void bg_view(char *name);
 void bg_edit(char *name);
};

extern Lister *panel;
extern void save_cfg(Lister *,Lister *);
extern void load_cfg(Lister *,Lister *);
extern void qview();
extern void qv_update(FList*);
extern void init_qview();
extern void qv_signal();

extern  int hide_hidden;
const int  S_SELECT=04000000;
const int  S_EXTEND=02000000;                                  

extern char dbuf[];
extern char last_info_message[];
extern char last_error_message[];

extern char vfserr[];  //String with error message from VFS
extern char vfshead[]; //String with vfs header for vfserr
extern int afstmp_defined;
extern AFS afstmp;

extern int ow_file;   //overwrite current file
extern int ow_all;    //overwrite all files without prompt
extern int dont_ask; //don't even ask for overwriting, just do it! Very good choice for me ;)
extern int ow_query_work;
extern int ow_cancel;
extern int ow_no;
extern int symlink_as_is;  //Copy symlink as is (symlink as symlink, not a copy of file it points to) 
extern char *panlist[];
extern char *panlist2[];
extern int psmax;
extern FList otmp;
extern int dont_update;
extern int    disable_reread;        //If 1 reread disables in Panel::expose;

extern void vfs_error(char *h,char *s);
extern void errno2mes();
extern void set_error(char *err);
extern void upper_path(char*);
extern void add_path_content(char*,char*);
extern void get_last_content(char *curdir,char *cont);
extern char* get_first_content(char *curdir,char *cont);
extern void simple_flist_add(FList *base, FList* it);

//////////////////////////////////////////////////End of file/////////////////////////////////////////////
#endif

