/****************************************************************************
*  Copyright (C) 1996-98 by Leo Khramov
*  email:     leo@unix1.jinr.dubna.su
*  
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
*  GNU General Public License for more details.
 ****************************************************************************/
#include "panel.h"
#include "au/key.h"
#include "au/x_actions.h"
#include "au/au_sup.h"
#include "bookmark.h"
#include "dndtypes.h"
#include "query_windows.h"
#include "infowin.h"
#include "ftpfs.h"
extern BookMark *bmark;
extern Cursor cdnd1, cdnd2;
extern char *syspath;
Pixmap panelpixs[6];
Pixmap panelpixmask[6];
int    panelpixl[6];
int    panelpixh[6];
Lister *dnd_creator = NULL;
int    dnd_startx = -10, dnd_starty = -10;
int    dnd_start_valid=0;
long   dnd_startm;
char   shdir[1024] = "";
extern int qvflag;
int    fattr1;
extern int evret, vt_show;
extern Window main_win;
extern int focus_fl;
extern int maingid, mainuid;
extern void donefunc();
extern "C" void tt_printf(char *fmt,...);
extern "C" void tt_write(unsigned char *buf, int count);
extern "C" void process_whole_sequence_event();
extern "C" void process_x_event(XEvent *);
extern "C" int psystem2(char *str,...);

static Atom DndProtocol, DndSelection;
static Atom Old_DndProtocol, Old_DndSelection;


char   dbuf[1024];
char   last_info_message[100];
char   last_error_message[100] = "UNKNOWN Error";

char   vfserr[80];                //String with error message from VFS

char   vfshead[20];                //String with vfs header for vfserr

int    afstmp_defined = 0;
extern AFS afstmp;

int    ow_file = 0;                //overwrite current file

int    ow_all = 0;                //overwrite all files without prompt

int    dont_ask = 0;                //don't even ask for overwriting, just do it! Very good choice for me ;)

int    ow_query_work = 0;
int    ow_cancel = 0;
int    ow_no = 0;
int    dont_update = 0;                //don't ask for update archives on exiting from it. (Never do it);

int    symlink_as_is = 1;        //Copy symlink as is (symlink as symlink, not a copy of file it points to) 

int    disable_reread = 0;        //If 1 reread disables in Panel::expose;


void   vfs_error(char *h, char *s)
{
  strcpy(vfshead, h);
  strcat(vfshead, " Error");
  strcpy(vfserr, s);
  sprintf(last_error_message, "Error: %s", s);
}

void   errno2mes()
{
  sprintf(last_error_message, "Error: %s", strerror(errno));
}

void   set_error(char *err)
{
  strcpy(last_error_message, err);
}

int    flush_expose(Window w)
{
  XEvent dummy;
  int    i = 0;

  while (XCheckTypedWindowEvent(disp, w, Expose, &dummy))
    i++;
  return i;
}

void   senddir(char *d)
{
  if (strcmp(shdir, d) != 0)
    {
      tt_printf("cd '%s'\n", d);
      strcpy(shdir, d);
    }
}

extern "C" int psystem(char *);


/*
 * This is nearly completely copied from the OffiX DragAndDrop library.
 */
void   DndSetData(int Type, unsigned char *Data, unsigned long Size)
{
  Window root = DefaultRootWindow(disp);
  int    AuxSize;
  unsigned char *AuxData;
  unsigned long BackSize = Size;



/* Set the data */
  AuxSize = Size > MAXINT ? MAXINT : (int)Size;
  AuxData = Data;
  XChangeProperty(disp, root, DndSelection, XA_STRING, 8,
                  PropModeReplace, Data, AuxSize);
  for (Size -= (unsigned long)AuxSize; Size; Size -= (unsigned long)AuxSize)
    {
      Data += AuxSize;
      AuxSize = Size > MAXINT ? MAXINT : (int)Size;
      XChangeProperty(disp, root, DndSelection, XA_STRING, 8,
                      PropModeAppend, Data, AuxSize);
    }

  Size = BackSize;
  AuxSize = Size > MAXINT ? MAXINT : (int)Size;
  Data = AuxData;
  XChangeProperty(disp, root, Old_DndSelection, XA_STRING, 8,
                  PropModeReplace, Data, AuxSize);
  for (Size -= (unsigned long)AuxSize; Size; Size -= (unsigned long)AuxSize)
    {
      Data += AuxSize;
      AuxSize = Size > MAXINT ? MAXINT : (int)Size;
      XChangeProperty(disp, root, Old_DndSelection, XA_STRING, 8,
                      PropModeAppend, Data, AuxSize);
    }


/* Everything is now ok */
}


char  *panlist[200];
char  *panlist2[100];
int    psmax = 0;

char  *findsubstr(char *str, char *sub)
{
  int    n = strlen(str), i, j;
  for (i = 0; i < n - 1; i++)
    {
      j = 0;
      while (str[j + i] == sub[j] && str[j + i] != 0 && sub[j] != 0)
        j++;
      if (sub[j] == 0)
        return str + i;
    }
  return NULL;
}


void   try_clean_afs_cache()
{
  char   strtmp2[128];
  if (panel->vfs->fstype == AFS_TYPE || panel->panel2->vfs->fstype == AFS_TYPE)
    {
      simple_mes("Error", "Exit from archive before cleaning cache!");
      return;
    }
  sprintf(strtmp2, "rm -rf '%s'/.%d*", syspath, getpid());
  if (psystem(strtmp2) == 0)
    simple_mes("Report", "Archive cache is clean.");
  else
    simple_mes("Error", "Something wrong with AFS cache!!!");
}

///////////////////////////////////Lister class///////////////////////////////

const int DIRCOL = 7;
const int EXECOL = 8;
const int NORMCOL = 6;
const int SELECTCOL = 5;
const int EXTCOL = 9;
const int LINKCOL = 10;
const int AFSCOL = 11;

int    is_exec(FList * o)
{
  if (mainuid == maingid && mainuid == 0)        //Check we are root or no

    {
      if ((o->mode & S_IXUSR) != 0 || (o->mode & S_IXGRP) != 0 || (o->mode & S_IXOTH) != 0)
        return 1;
      else
        return 0;
    }
  if (((o->mode & S_IXUSR) != 0 && o->uid == mainuid) ||
      ((o->mode & S_IXGRP) != 0 && o->gid == maingid) ||
      (o->mode & S_IXOTH) != 0)
    return 1;
  return 0;
}

void   upper_path(char *);
void   add_path_content(char *, char *);

void   simple_flist_add(FList * base, FList * it)
{
  it->next = base->next;
  if (base->next)
    base->next->prev = it;
  it->prev = base;
  base->next = it;
}

void   Lister::delall_l(FList * n)
{
}

void   Lister::sortbyext()
{
  comp = extcmp;
  reread();
}

void   Lister::sortbysize()
{
  comp = sizecmp;
  reread();
}

void   Lister::sortbytime()
{
  comp = timecmp;
  reread();
}

void   Lister::sortbyname()
{
  comp = mystrcmp;
  reread();
}

int    dirf, mmode;
struct stat dstat;
char   d_name[550];

//Add new content to 'curdir' path
void   add_path_content(char *curdir, char *cont)
{
  if (curdir[strlen(curdir) - 1] != '/')
    strcat(curdir, "/");
  strcat(curdir, cont);
}

//No comments
void   upper_path(char *curdir)
{
  char  *bb = strrchr(curdir, '/');
  if(bb)
          *bb = 0;
  if (strlen(curdir) == 0)
    strcpy(curdir, "/");
}

//Get first content of dirname
char*   get_first_content(char *curdir, char *cont)
{
        char *b=strchr(curdir,'/');
        if(b)
          {
                  strncpy(cont,curdir,b-curdir);
                  cont[b-curdir]=0;
                  return b+1;
          }
        strcpy(cont,curdir);
        return NULL;
}

//Get last content of dirname
void   get_last_content(char *curdir, char *cont)
{
  char  *bb;
  int    l = strlen(curdir);
  if (l == 1)
    {
      strcpy(cont, curdir);
      return;
    };
  if (curdir[l - 1] != '/')
    bb = strrchr(curdir, '/');
  else
    {
      curdir[l - 1] = 0;
      bb = strrchr(curdir, '/');
      curdir[l - 1] = '/';
    }
  if (bb != NULL)
    strcpy(cont, bb + 1);
}



/////////////////////////Disk File System Functions////////////////////////////
DFS    dfstmp;
AFS    afstmp;
VFS    defvfs;                        //These VFSes use for bookmark operations and none default copying

char  *mstr;
FList  otmp;
int    fsiz;
char   strtmp[1024];
char   strtmp2[1024];


//Detect d string and define appropriate VFS
VFS   *define_vfs(char *d)
{
  char  *dd = d;
  int    i;
  for (i = 0; i < 5; i++)
    if (d[i] == 0)
      break;
    else if (d[i] == ':')
      break;
  if (d[i] == ':')
    {
      dd = d + i + 1;
      if (strncasecmp(d, "dfs", 3) != 0)
        {
          if (strncasecmp(d, "afs", 3) != 0 && strncasecmp(d,"arc",3)!=0)
            {
              vfs_error("VFS", "Wrong VFS type!");
              return NULL;
            }
          else if (panel->panel2->vfs->fstype != AFS_TYPE)
            {
              if (afstmp_defined)
                return &afstmp;
              vfs_error("VFS", "Second panel must be inside Archive!");
              return NULL;
            }
          else if (afstmp_defined)
            return &afstmp;
          else
            {
              if (panel->panel2->vfs->curdir[0] != '/')
                panel->panel2->vfs->make_fullpath();
              return panel->panel2->vfs;
            }
        }
    }
  dfstmp.curdir = dd;
  if (dfstmp.curdir[0] != '/')
    dfstmp.make_fullpath();
  return &dfstmp;
}

VFS   *define_vfs(char *type, char *d)
{
  char  *b;
  afstmp_defined = 0;
  if (strcasecmp(type, "dfs") == 0)
    {
      dfstmp.curdir = d;
      if (dfstmp.curdir[0] != '/')
        dfstmp.make_fullpath();
      return &dfstmp;
    }
  else if ((strcasecmp(type, "arc") == 0) || (strcasecmp(type,"afs")==0))
    {
      strcpy(afstmp.fullarcname, d);
      afstmp.dont_construct_path = 1;
      b = strrchr(d, '/');
      afstmp.init_support(b + 1);
      afstmp_defined = 1;
      return &afstmp;
    }
  defvfs.curdir = d;
  if (defvfs.curdir[0] != '/')
    defvfs.make_fullpath();
  return &defvfs;
}


int    Lister::direc(char *dir_ch)
{
  compare = comp;
  int    ret;
  ret = vfs->direc(dir_ch);
  if (ret)
    {
      if(vfs->bgbit)        //If VFS became BG then POP previous VFS
      {
              vfs=pop_vfs();
              vfs->ch_curdir();
              ret=vfs->direc(vfs->curdir);
              if(ret==0) 
                return ret;
      }
/*      lar = vfs->lar;
      larmax = vfs->larmax;
*/
      dl.next = vfs->dl.next;
      fl.next = vfs->fl.next;
      if (strcmp(dl.next->name, ".") == 0)
        dl.next = dl.next->next;
      dl.next->prev = &dl;
      cur = &dl;
      while (cur->next != NULL)
        cur = cur->next;
      cur->next = fl.next;
      if (fl.next != NULL)
        fl.next->prev = cur;
      base = cur = dl.next;
      lcurn = curn = 0;
      selfiles = selsize = 0;
      time(&lastscan);
    }
  return ret;
}


int    dnd_enabled = 0;

void Lister::cmdl_insert_name(char *name)
{
  char *n2=name;
  char term[]=" ;()[]<>'?\"|*&^%$#@!`";
  while (*n2 != 0)
    if(strchr(term, *n2))
    {
           cmdl->insert('\'');
           n2=name;
           while(*n2)
             cmdl->insert(*n2++);
           tt_printf("'%s'", name);
           cmdl->insert('\'');
           return;
    } else n2++;
    n2=name;
    while(*n2)
        cmdl->insert(*n2++);
    tt_printf("%s", name);
}

void   Lister::init(Window ipar)
{
  foc = 0;
  refindchr[0] = 0;
  XWindowAttributes xwa;
  XSetWindowAttributes xswa;
  parent = ipar;
  w = XCreateSimpleWindow(disp, parent, x, y, l, h, 0, 0, keyscol[1]);
  gcv.background = keyscol[1];
  gcv.font = fixfontstr->fid;
  gcw = XCreateGC(disp, w, GCBackground | GCFont, &gcv);
  fgc = XCreateGC(disp, w, GCBackground | GCFont, &gcv);
  gcv.font = lfontstr->fid;
  wgcw = XCreateGC(disp, w, GCBackground | GCFont, &gcv);
  xpmgc = XCreateGC(disp, w, 0, NULL);
  if (XGetWindowAttributes(disp, w, &xwa) != 0)
    {
      xswa.do_not_propagate_mask = xwa.do_not_propagate_mask | ButtonPressMask |
        KeyPressMask;
      XChangeWindowAttributes(disp, w, CWDontPropagate, &xswa);
    }
  else
    fprintf(stderr, "Propagation failed\n");
  XSelectInput(disp, w, ExposureMask | ButtonPressMask | ButtonReleaseMask | PointerMotionMask |
               KeyPressMask | FocusChangeMask | StructureNotifyMask);
  fattr1 = XTextWidth(lfontstr, "-rwxrwxrwx", 9);
  attdx = 8 + (43 - XTextWidth(fixfontstr, "0000", 4)) / 2;
  repanel(col);
  foc = 0;

  DndProtocol = XInternAtom(disp, "_DND_PROTOCOL", 0);
  DndSelection = XInternAtom(disp, "_DND_SELECTION", 0);
  Old_DndProtocol = XInternAtom(disp, "DndProtocol", 0);
  Old_DndSelection = XInternAtom(disp, "DndSelection", 0);

}

void   Lister::repanel(int ic)
{
  col = ic;
  tdl = lfontstr->max_bounds.ascent - lfontstr->max_bounds.descent + 8;
  prflg = 0;
  th = (h - 60) / tdl;
  pl = (l - 14) / col;
  rect.x = 0;
  rect.y = 30;
  rect.width = pl - 8;
  rect.height = h - 65;
  XSetClipRectangles(disp, wgcw, 0, 0, &rect, 1, Unsorted);
  rect2.x = 55;
  rect2.y = h - 29;
  rect2.width = l - 110;
  rect2.height = 20;
  XSetClipRectangles(disp, fgc, 0, 0, &rect2, 1, Unsorted);
  lastn = -1;
  lcurn = 0;
  fixl = fixfontstr->max_bounds.rbearing - fixfontstr->min_bounds.lbearing;
  fixh = fixfontstr->max_bounds.ascent - fixfontstr->max_bounds.descent;
  fixy = fixfontstr->max_bounds.ascent;
  if (curn > 0)
    curn = 0;
  base = cur = dl.next;
}


void   Lister::reconfigure(int ix, int iy, int il, int ih)
{
  x = ix;
  y = iy;
  l = il;
  h = ih;
  XMoveWindow(disp, w, x, y);
  XResizeWindow(disp, w, l, h);
  repanel(col);
  expose();
}

void   Lister::reconfigure_without_expose(int ix, int iy, int il, int ih)
{
  x = ix;
  y = iy;
  l = il;
  h = ih;
  XMoveWindow(disp, w, x, y);
  XResizeWindow(disp, w, l, h);
  repanel(col);
}

void   drawhead(Window w, GC gcw, int x, int y, int l, int h, int fl = 0)
{
  XSetForeground(disp, gcw, keyscol[2]);
  XDrawLine(disp, w, gcw, x, y + h, x, y + 5);
  XDrawLine(disp, w, gcw, x, y + 5, x + 5, y);
  XDrawLine(disp, w, gcw, x + 5, y, x + l - 5, y);
  if (fl)
    {
      XDrawLine(disp, w, gcw, x + 1, y + h + 1, x + 1, y + 5);
      XDrawLine(disp, w, gcw, x + 1, y + 5, x + 5, y + 1);
      XDrawLine(disp, w, gcw, x + 5, y + 1, x + l - 5, y + 1);
    }
  XSetForeground(disp, gcw, keyscol[0]);
  XDrawLine(disp, w, gcw, x + l - 5, y, x + l, y + 5);
  XDrawLine(disp, w, gcw, x + l, y + 5, x + l, y + h);
  if (fl)
    {
      XDrawLine(disp, w, gcw, x + l - 5, y + 1, x + l - 1, y + 5);
      XDrawLine(disp, w, gcw, x + l - 1, y + 5, x + l - 1, y + h + 1);
      XSetForeground(disp, gcw, cols[0]);
      XDrawLine(disp, w, gcw, x + l - 3, y + 1, x + l + 1, y + 5);
      XDrawLine(disp, w, gcw, x + l + 1, y + 6, x + l + 1, y + h - 1);
    }
}

int    just_at_startup = 1;
void   Lister::expose()
{
  time_t tt;
  int    i, px, lx = l / 2 + 15, l2 = l / 2;
  int    lx2 = l2 - 15;
  char  *cdir = panel2->vfs->get_dir_header();
  int    sl = strlen(cdir), vl, fl;
  fl = (l - 88) / 2;
  vl = fl / fixl;
  int    dl = 0;
  if (sl > vl)
    dl = sl - vl;
  vl = sl - dl;
  XSetForeground(disp, gcw, keyscol[2]);
  XDrawLine(disp, w, gcw, 3, h - 4, l - 4, h - 4);
  XDrawLine(disp, w, gcw, 4, h - 5, l - 5, h - 5);
  switch (lay)
    {
    case 0:
      XDrawLine(disp, w, gcw, 0, 0, 0, h);
      XDrawLine(disp, w, gcw, 1, 1, 1, h - 1);
      XDrawLine(disp, w, gcw, 0, 0, l, 0);
      XDrawLine(disp, w, gcw, 1, 1, l - 1, 1);
      XDrawLine(disp, w, gcw, l - 4, 3, l - 4, h - 4);
      XDrawLine(disp, w, gcw, l - 5, 4, l - 5, h - 5);
      break;
    case 1:
      XDrawLine(disp, w, gcw, 0, 10, 0, h);
      XDrawLine(disp, w, gcw, 1, 11, 1, h - 1);
      XDrawLine(disp, w, gcw, lx, 25, l, 25);
      XDrawLine(disp, w, gcw, lx - 1, 26, l - 1, 26);
      XDrawLine(disp, w, gcw, l - 4, 27, l - 4, h - 4);
      XDrawLine(disp, w, gcw, l - 5, 28, l - 5, h - 5);
      break;
    case 2:
      XDrawLine(disp, w, gcw, 0, 26, 0, h);
      XDrawLine(disp, w, gcw, 1, 11, 1, h - 1);
      XDrawLine(disp, w, gcw, 0, 25, lx2, 25);
      XDrawLine(disp, w, gcw, 1, 26, lx2 + 1, 26);
      XDrawLine(disp, w, gcw, l - 4, 27, l - 4, h - 4);
      XDrawLine(disp, w, gcw, l - 5, 28, l - 5, h - 5);
      break;
    };
  XSetForeground(disp, gcw, keyscol[0]);
  XDrawLine(disp, w, gcw, 0, h - 1, l, h - 1);
  XDrawLine(disp, w, gcw, 1, h - 2, l - 1, h - 2);
  switch (lay)
    {
    case 0:
      XDrawLine(disp, w, gcw, l - 1, 0, l - 1, h);
      XDrawLine(disp, w, gcw, l - 2, 1, l - 2, h - 1);
      XDrawLine(disp, w, gcw, 3, 3, l - 4, 3);
      XDrawLine(disp, w, gcw, 3, 3, 3, h - 4);
      XDrawLine(disp, w, gcw, 4, 4, l - 5, 4);
      XDrawLine(disp, w, gcw, 4, 4, 4, h - 5);
      break;
    case 1:
      XDrawLine(disp, w, gcw, l - 1, 25, l - 1, h);
      XDrawLine(disp, w, gcw, l - 2, 26, l - 2, h - 1);
      XDrawLine(disp, w, gcw, 3, 27, l - 4, 27);
      XDrawLine(disp, w, gcw, 3, 27, 3, h - 4);
      XDrawLine(disp, w, gcw, 4, 28, l - 5, 28);
      XDrawLine(disp, w, gcw, 4, 28, 4, h - 5);
      drawhead(w, gcw, lx - 10, 2, l / 2 - 8, 22);
      XSetForeground(disp, gcw, keyscol[1]);
      XFillRectangle(disp, w, gcw, 2, 3, lx - 6, 23);
      drawhead(w, gcw, 0, 0, lx, 25, 1);
      XSetForeground(disp, gcw, keyscol[1]);
      XFillRectangle(disp, w, gcw, l2 + 30, 8, l2 - 35, 17);
      XSetForeground(disp, gcw, cols[0]);
      XDrawString(disp, w, gcw, l2 + 31, 22, cdir + dl, vl);
      XSetForeground(disp, gcw, keyscol[0]);
      XDrawString(disp, w, gcw, l2 + 30, 21, cdir + dl, vl);
      break;
    case 2:
      XDrawLine(disp, w, gcw, l - 1, 25, l - 1, h);
      XDrawLine(disp, w, gcw, l - 2, 26, l - 2, h - 1);
      XDrawLine(disp, w, gcw, 3, 27, l - 4, 27);
      XDrawLine(disp, w, gcw, 3, 27, 3, h - 4);
      XDrawLine(disp, w, gcw, 4, 28, l - 5, 28);
      XDrawLine(disp, w, gcw, 4, 28, 4, h - 5);
      drawhead(w, gcw, 1, 2, l / 2 - 8, 22);
      XSetForeground(disp, gcw, keyscol[1]);
      XFillRectangle(disp, w, gcw, lx2 + 2, 3, l2, 23);
      drawhead(w, gcw, lx2, 0, l2 + 14, 25, 1);
      XSetForeground(disp, gcw, keyscol[1]);
      XFillRectangle(disp, w, gcw, 6, 8, l2 - 25, 17);
      XSetForeground(disp, gcw, cols[0]);
      XDrawString(disp, w, gcw, 11, 22, cdir + dl, vl);
      XSetForeground(disp, gcw, keyscol[0]);
      XDrawString(disp, w, gcw, 10, 21, cdir + dl, vl);
      break;
    };
  if (col > 1)
    {
      pl = (l - 14) / col;
      for (i = 0, px = pl + 7; i < col - 1; i++, px += pl)
        {
          XSetForeground(disp, gcw, keyscol[2]);
          XDrawLine(disp, w, gcw, px - 1, 29, px - 1, h - 35);
          XDrawPoint(disp, w, gcw, px, 28);
          XSetForeground(disp, gcw, keyscol[0]);
          XDrawLine(disp, w, gcw, px + 1, 29, px + 1, h - 35);
          XDrawPoint(disp, w, gcw, px, h - 34);
        }
    }
  if (disable_reread == 0)
    {
      if (scanfl)
        {
          if (vfs->ch_curdir() == -1)
            vfs->ch_to_rootdir();
          direc(curdir);
          scanfl = 0;
          if (panel != this)
            curn = -1;
          showdir();
        }
      else
        {
          time(&tt);
          if (tt == lastscan)
            showdir();
          else
            {
              if (lay == 0)
                panel2->reread();
              reread();
            };
        }
    }
  else
    showdir();
  urect(w, gcw, 7, h - 30, 45, 22);
  urect(w, gcw, 53, h - 30, l - 107, 22);
  urect(w, gcw, l - 53, h - 30, 22, 22);
  urect(w, gcw, l - 30, h - 30, 22, 22);
  XSetForeground(disp, gcw, cols[0]);
  XDrawString(disp, w, gcw, l - 47, h - 12, "<", 1);
  XDrawString(disp, w, gcw, l - 21, h - 12, ">", 1);
  XSetForeground(disp, gcw, cols[5]);
  XDrawString(disp, w, gcw, l - 48, h - 13, "<", 1);
  XDrawString(disp, w, gcw, l - 22, h - 13, ">", 1);
  flen = (l - 109) / fixl;
  if (just_at_startup == 1 && panel == this)
    {
      XSetInputFocus(disp, Main, RevertToNone, CurrentTime);
      just_at_startup = 2;
    };
  if (disable_reread != 2)
    showfinfo(cur);
  else
    disable_reread = 0;
}

void   printperm(char *str, int mode);

void   Lister::show_ff_item(int n, int fflen)
{
  int    iy, ix, piy, delta = 0;
  piy = n % th * tdl + 30;
  iy = piy + lfontstr->max_bounds.ascent;
  ix = n / th * pl + 10;
  if ((cur->mode & S_IFDIR) == S_IFDIR)
    {
      if (allow_dir_icon)
        delta = 19;
    }
  else if (allow_file_icon)
    delta = 19;
  if (lastn != n)
    {
      XSetClipOrigin(disp, wgcw, ix - 5, 0);
      lastn = n;
    };
  XSetForeground(disp, wgcw, cols[5]);
  if (brief)
    XDrawString(disp, w, wgcw, ix + 2 + delta, iy, ff_buf, fflen);
  else
    XDrawString(disp, w, wgcw, ix, iy, ff_buf, fflen);
  XFlush(disp);
}

void   Lister::showitem(FList * ol, int n)
{
  int    cn, iy, ix, piy, delta = 0, pixn = 0;
  char   str[80];
  char   str2[40];
  char  *str3;
  piy = n % th * tdl + 30;
  iy = piy + lfontstr->max_bounds.ascent;
  ix = n / th * pl + 10;
  if ((ol->mode & S_IFDIR) == S_IFDIR)
    {
      cn = DIRCOL;
      if (allow_dir_icon)
        {
          delta = 19;
          piy = iy - panelpixh[0];
          XSetClipMask(disp, xpmgc, panelpixmask[0]);
          XSetClipOrigin(disp, xpmgc, ix + 2, piy);
        }
    }
  else if (is_exec(ol))
    {
      cn = EXECOL;
      if (allow_file_icon)
        {
          pixn = 1;
          delta = 19;
          piy = iy - panelpixh[1];
          XSetClipMask(disp, xpmgc, panelpixmask[1]);
          XSetClipOrigin(disp, xpmgc, ix + 2, piy);
        }
    }
  else
    {
      cn = NORMCOL;
      if (allow_file_icon)
        {
          pixn = 2;
          delta = 19;
          piy = iy - panelpixh[2];
          XSetClipMask(disp, xpmgc, panelpixmask[2]);
          XSetClipOrigin(disp, xpmgc, ix + 2, piy);
        }
    };
  if (ol->mode & S_EXTEND)
    {
      if (is_it_afs_file(ol->name))
        {
          cn = AFSCOL;
          if (allow_file_icon)
            {
              pixn = 4;
              delta = 19;
              piy = iy - panelpixh[4];
              XSetClipMask(disp, xpmgc, panelpixmask[4]);
              XSetClipOrigin(disp, xpmgc, ix + 2, piy);
            }
        }
      else
        {
          cn = 9;
          if (allow_file_icon)
            {
              delta = 19;
              pixn = 3;
              piy = iy - panelpixh[3];
              XSetClipMask(disp, xpmgc, panelpixmask[3]);
              XSetClipOrigin(disp, xpmgc, ix + 2, piy);
            }
        };
    };
  if ((ol->mode & S_IFLNK) == S_IFLNK)
    {
      cn = LINKCOL;
      if (allow_file_icon)
        {
          delta = 19;
          pixn = 5;
          piy = iy - panelpixh[5];
          XSetClipMask(disp, xpmgc, panelpixmask[5]);
          XSetClipOrigin(disp, xpmgc, ix + 2, piy);
        }
    }
  if (ol->mode & S_SELECT)
    cn = SELECTCOL;
  if (lastn != n)
    {
      XSetClipOrigin(disp, wgcw, ix - 5, 0);
      lastn = n;
    };
  if (curn == n)
    {
      XSetForeground(disp, wgcw, selectpix);
      showfinfo(ol);
      if ((ol->mode & S_IFDIR) == S_IFDIR)
        if (qvflag)
          {
            qv_update(ol);
            alarm(2);
          };
      XFillRectangle(disp, w, wgcw, ix, iy - tdl + 5, pl - 14, tdl);
/* XSetForeground(disp,wgcw,cols[1]);
   XDrawRectangle(disp,w,wgcw,ix,iy-tdl+5,pl-14,tdl-1);
 */
    }
  else
    {
      XSetForeground(disp, wgcw, keyscol[1]);
      XFillRectangle(disp, w, wgcw, ix, iy - tdl + 5, pl - 13, tdl);
    }
  XSetForeground(disp, wgcw, cols[cn]);
  if (brief)
    {
      XDrawString(disp, w, wgcw, ix + 2 + delta, iy, ol->name, strlen(ol->name));
      if (delta)
        XCopyArea(disp, panelpixs[pixn], w, xpmgc, 0, 0, (unsigned int)panelpixl[pixn], (unsigned int)panelpixh[pixn], ix + 2, piy);
    }
  else
    {
      XSetClipOrigin(disp, wgcw, ix - 2 * pl / 3 + 4, 0);
      XDrawString(disp, w, wgcw, ix, iy, ol->name, strlen(ol->name));
      XSetClipOrigin(disp, wgcw, ix - 5, 0);
      ix += pl / 3 + 20;
      printperm(str, ol->mode);
      sprintf(str2, "%s.%s", finduser(ol->uid), findgroup(ol->gid));
      str3 = ctime(&ol->time);
      XDrawString(disp, w, wgcw, ix + 2, iy, str, strlen(str));
      XDrawString(disp, w, wgcw, ix + fattr1 + 16, iy, str2, strlen(str2));
      XDrawString(disp, w, wgcw, ix + fattr1 + 120, iy, str3, strlen(str3));
    }
}

char  *devs[] =
{"file", "dir", "socket", "link", "block", "char", "fifo"};
char   perm[] = "rwxrwxrwx";
int    masks[] =
{S_IFREG, S_IFDIR, S_IFSOCK, S_IFLNK, S_IFBLK, S_IFCHR, S_IFIFO};

void   printperm(char *str, int mode)
{
  int    i = 0, mask = 0400;
  if ((mode & S_IFLNK) == S_IFLNK)
    str[i++] = 'l';
  else if ((mode & S_IFDIR) == S_IFDIR)
    str[i++] = 'd';
  else
    str[i++] = 'f';
  while (mask)
    {
      if (mode & mask)
        str[i] = perm[i - 1];
      else
        str[i] = '-';
      mask >>= 1;
      i++;
    };
  str[i] = 0;
}



void   dig2ascii(char *chr, int n)
{
  int    i, j, k;
  char   cchr[20];
  sprintf(cchr, "%d", n);
  k = strlen(cchr);
  for (i = 0, j = 0; i < k; i++, j++)
    {
      if (((k - i) % 3) == 0 && i != 0)
        {
          chr[j] = '.';
          j++;
        };
      chr[j] = cchr[i];
    }
  chr[j] = 0;
}

void   Lister::selected(FList * fo)
{
  fo->mode ^= S_SELECT;
  if (fo->mode & S_SELECT)
    {
      selfiles++;
      selsize += fo->size;
    }
  else
    {
      selfiles--;
      selsize -= fo->size;
    }
}

void   Lister::show()
{
  XMapRaised(disp, w);
  addto_el(this, w);
}

void   Lister::showfinfo(FList * fo)
{
  static char fname[120];
  static char flink[120];
  int    i = 0, sl, vl = flen - 27, dl = 0, ll, dy = h - 25 + fixy;
  char   chr2[30];
  char   chr1[30];
  char   tchr[256];
  if (selfiles == 0)
    {
      if (fo->mode & S_IFDIR)
        sprintf(chr2, ">DIR<%6d", fo->size);
      else
        dig2ascii(chr2, fo->size);
    }
  else
    {
      strcpy(tchr, fo->name);
      dig2ascii(chr2, selsize);
      sprintf(chr1, "%3d file(s) selected", selfiles);
      strcpy(fo->name, chr1);
    }

  XSetForeground(disp, gcw, keyscol[1]);
  XFillRectangle(disp, w, gcw, 8, h - 29, 43, 20);
  XFillRectangle(disp, w, gcw, 54, h - 29, l - 109, 20);
  XSetForeground(disp, fgc, cols[0]);
  if ((fo->mode & S_IFLNK) == S_IFLNK && selfiles == 0)
    {
      for (i = 0; i < 120; i++)
        flink[i] = 0;
      vfs->ch_curdir();
      ll=vfs->readlink(fo, flink, 120);
      if (ll < 117)
        {
          sl = strlen(fo->name);
          if (sl + ll > 117)
            {
              for (i = ll; i >= 0; i--)
                fname[119 - ll + i] = flink[i];
              fname[118 - ll] = '>';
              fname[117 - ll] = '-';
              for (i = sl - 1; i >= 0; i--)
                if (116 - sl + i < 0)
                  break;
                else
                  fname[116 - sl + i] = fo->name[i];
            }
          else
            {
              strcpy(fname, fo->name);
              strcat(fname, "->");
              strcat(fname, flink);
            }
        }
      else
        strcpy(fname, flink + ll - 117);
      sl = strlen(fname);
      if (sl > vl)
        dl = sl - vl;
      vl = sl - dl;
      XDrawString(disp, w, fgc, 56, dy + 1, fname + dl, vl);
      i = strlen(chr2);
      XDrawString(disp, w, fgc, l - 56 - fixl * i, dy + 1, chr2, i);
      XSetForeground(disp, fgc, cols[5]);
      XDrawString(disp, w, fgc, 55, dy, fname + dl, vl);
      XDrawString(disp, w, fgc, l - 57 - fixl * i, dy, chr2, i);
    }
  else
    {
      sl = strlen(fo->name);
      if (sl > vl)
        dl = sl - vl;
      vl = sl - dl;
      XDrawString(disp, w, fgc, 56, dy + 1, fo->name + dl, vl);
      i = strlen(chr2);
      XDrawString(disp, w, fgc, l - 56 - fixl * i, dy + 1, chr2, i);
      XDrawString(disp, w, fgc, l - 56 - fixl * (27), dy + 1, fo->chr_time, 14);
      XSetForeground(disp, fgc, cols[5]);
      XDrawString(disp, w, fgc, 55, dy, fo->name + dl, vl);
      XDrawString(disp, w, fgc, l - 57 - fixl * (27), dy, fo->chr_time, 14);
      XDrawString(disp, w, fgc, l - 57 - fixl * i, dy, chr2, i);
    }
  sprintf(chr1, "%04o", fo->mode & 07777);
  XSetForeground(disp, gcw, cols[0]);
  XDrawString(disp, w, gcw, attdx + 1, dy + 1, chr1, 4);
  XSetForeground(disp, gcw, cols[5]);
  XDrawString(disp, w, gcw, attdx, dy, chr1, 4);
  if (selfiles)
    strcpy(fo->name, tchr);
}

void   Lister::showempty(int n)
{
  int    iy, ix;
  iy = n % th * tdl + 30 + lfontstr->max_bounds.ascent;
  ix = n / th * pl + 10;
  if (lastn != n)
    {
      XSetClipOrigin(disp, wgcw, ix - 5, 0);
      lastn = n;
    };
  XSetForeground(disp, wgcw, keyscol[1]);
  XFillRectangle(disp, w, wgcw, ix, iy - tdl + 5, pl - 8, tdl);
}

void   Lister::showdirname()
{
  char  *curdir = vfs->get_dir_header();
  int    sl = strlen(curdir), vl, fl, l2 = l / 2;
  if (lay == 0)
    fl = l - 38;
  else
    fl = (l - 38) / 2;
  vl = fl / fixl;
  int    dl = 0;
  if (sl > vl)
    dl = sl - vl;
  vl = sl - dl;
  switch (lay)
    {
    case 0:
      urect(w, gcw, 28, 7, l - 36, 19);
      urect(w, gcw, 7, 7, 20, 19);
      prect(w, gcw, 9, 9, 16, 15);
      XSetForeground(disp, gcw, cols[1 + side]);
      XFillRectangle(disp, w, gcw, 12, 12, 11, 10);
      XSetForeground(disp, gcw, keyscol[1]);
      XFillRectangle(disp, w, gcw, 30, 8, fl, 17);
      XSetForeground(disp, gcw, cols[0]);
      XDrawString(disp, w, gcw, 31, 22, curdir + dl, vl);
      XSetForeground(disp, gcw, cols[5]);
      XDrawString(disp, w, gcw, 30, 21, curdir + dl, vl);
      break;
    case 1:
      prect(w, gcw, 7, 7, 16, 15);
      XSetForeground(disp, gcw, cols[1]);
      XFillRectangle(disp, w, gcw, 10, 10, 11, 10);
      XSetForeground(disp, gcw, keyscol[1]);
      XFillRectangle(disp, w, gcw, 30, 8, fl, 17);
      XSetForeground(disp, gcw, cols[0]);
      XDrawString(disp, w, gcw, 31, 22, curdir + dl, vl);
      XSetForeground(disp, gcw, cols[5]);
      XDrawString(disp, w, gcw, 30, 21, curdir + dl, vl);
      break;
    case 2:
      prect(w, gcw, l2 - 7, 7, 16, 15);
      XSetForeground(disp, gcw, cols[3]);
      XFillRectangle(disp, w, gcw, l2 - 4, 10, 11, 10);
      XSetForeground(disp, gcw, keyscol[1]);
      XFillRectangle(disp, w, gcw, l2 + 15, 8, l2 - 20, 17);
      XSetForeground(disp, gcw, cols[0]);
      XDrawString(disp, w, gcw, l2 + 16, 22, curdir + dl, vl);
      XSetForeground(disp, gcw, cols[5]);
      XDrawString(disp, w, gcw, l2 + 15, 21, curdir + dl, vl);
      break;
    }
}

void   Lister::showfilelist()
{
  FList *fo = base;
  int    i = 0, al = col * th;
  cl = -1;
  while (fo != NULL && i < al)
    {
      showitem(fo, i);
      fo = fo->next;
      i++;
    }
  while (i < al)
    {
      showempty(i);
      i++;
    };
}

void   Lister::showdir()
{
  FList *fo = base;
  int    i = 0, al = col * th;
  cl = -1;
  while (fo != NULL && i < al)
    {
      showitem(fo, i);
      fo = fo->next;
      i++;
    }
  while (i < al)
    {
      showempty(i);
      i++;
    };
  showdirname();
  if (cmdl != NULL && foc)
    cmdl->setpath(curdir);
}

void   Lister::fdelete()
{
  FList *pcur, *ko;
  int    ferr = 0;
  disable_reread = 1;
  if (lay == 0)
    panel2->expose();
  expose();
  bmark->set_recycle_image(0);
  if (vfs->is_del_supported() == 0)
    {
      simple_mes("Error", "Can't DELETE on this VFS");
      return;
    }
  create_infowin("Deleting...");
  if (selfiles == 0)
    {
      to_infowin(cur->name);
      if (vfs->remove(cur))
        {
          del_infowin();
          fserror("Delete File", cur);
        }
      else
        {
          if (cur->next)
            cur->next->prev = cur->prev;
          cur->prev->next = cur->next;
          pcur = cur->next;
          ko = cur->prev;
          if (pcur)
            cur = pcur;
          else
            {
              cur = ko;
              curn--;
            };
          del_infowin();
          showdir();
        };
    }
  else
    {
      ko = dl.next;
      infowin->set_coun(selfiles);
      while (ko != NULL)
        {
          if (ko->mode & S_SELECT)
            {
              to_infowin(ko->name);
              if (vfs->remove(ko))
                {
                  ko = ko->next;
                  ferr = 1;
                }
              else                // fserror("Delete Files");

                {
                  pcur = ko->next;
                  if (ko->next)
                    ko->next->prev = ko->prev;
                  ko->prev->next = ko->next;
                  selfiles--;
                  selsize -= ko->size;
                  ko = pcur;
                  infowin->update_coun(1);
                }
            }
          else
            ko = ko->next;
        }
      del_infowin();
      if (ferr)
        {
          ko = dl.next;
          while (ko != NULL)
            if (ko->mode & S_SELECT)
              break;
            else
              ko = ko->next;
          fserror("Delete files", ko);
          XFlush(disp);
        }
      curn = 0;
      cur = base = dl.next;
      showdir();
    }
  disable_reread = 0;
}

int    Lister::setcur(FList ** cr, int dd)
{
  FList *fo = *cr;
  if (dd > 0)
    while (fo->next != NULL && dd > 0)
      {
        fo = fo->next;
        dd--;
      }
  else
    while (fo->prev != &dl && dd < 0)
      {
        fo = fo->prev;
        dd++;
      }
  if (dd == 0)
    {
      *cr = fo;
      return 1;
    };
  return 0;
}

void   Lister::fserror(char *head, FList * o)
{
  msg(head, last_error_message, 2, o);
}

const Time DBLCLICK = 250;

int    Lister::findentry(char *nme)
{
  FList *fo = dl.next;
  int    i = 0;
  while (fo != NULL)
    if (strcmp(fo->name, nme) == 0)
      break;
    else
      {
        fo = fo->next;
        i++;
      };
  if (fo != NULL)
    return i;
  return -1;
}

void   Lister::addpathcontent(char *cont)
{
  if (curdir[strlen(curdir) - 1] != '/')
    strcat(curdir, "/");
  strcat(curdir, cont);
}

void   Lister::upperpath()
{
  char  *bb = strrchr(curdir, '/');
  *bb = 0;
  if (strlen(curdir) == 0)
    strcpy(curdir, "/");
}

void   Lister::fcopy()
{
  FList *ko;
  int    rcode = 0;
  VFS   *vfstmp;
  disable_reread = 1;
  if (lay == 0)
    panel2->expose();
  expose();
  if (vfs->curdir[0] != '/')
    vfs->make_fullpath();
  if (selfiles != 0 && vfs->fstype == AFS_TYPE && vfs->is_full_extract_allowed())
    {
      if (vfs->check_for_full_extract(selfiles))
        {
          vfstmp = define_vfs(dbuf);
          afstmp_defined = 0;
          if (vfstmp == NULL)
            {
              show_vfs_error();
              return;
            }
          create_infowin("Copying...");
          to_infowin("Full Unpack");

          rcode = vfs->full_extract_to_vfs(vfstmp);

          del_infowin();
          if (vfstmp != panel2->vfs)
          {
            vfstmp->delete_vfs_list();
            vfstmp->close_fs();
          }
          if (rcode != 0 && ow_cancel == 0)
            show_vfs_error();
          else
            {
              selfiles = 0;
              selsize = 0;
            };
          XFlush(disp);
          disable_reread = 0;
          if (lay == 0)
            panel2->reread();
          reread();
          vfs->ch_curdir();
          ow_all = 0;
          ow_cancel = ow_no = 0;
          return;
        }
    }

  vfstmp = define_vfs(dbuf);
  afstmp_defined = 0;
  if (vfstmp == NULL)
    {
      show_vfs_error();
      return;
    }
  if (vfstmp->is_copy_supported() == 0)
    {
      simple_mes("Error", "Can't COPY on this VFS");
      return;
    }
  create_infowin("Copying...");

  if (selfiles == 0 || vfs->can_we_optimize() ||
      (vfstmp->fstype == AFS_TYPE && vfstmp->is_pocket_addition_allowed()))
    {
      if (selfiles == 0)
        to_infowin(cur->name);
      else
        to_infowin("Pocket operation");
      if (selfiles)
        vfs->use_optimization();
      rcode = vfs->copy(cur, vfstmp);
      if (selfiles)
        {
          ko = dl.next;
          selfiles = 0;
          selsize = 0;
          while (ko != NULL)
            {
              if (ko->mode & S_SELECT)
                {
                  selfiles++;
                  selsize += ko->size;
                }
              ko = ko->next;
            }
        }
      del_infowin();
      if (vfstmp != panel2->vfs)
      {
        vfstmp->delete_vfs_list();
        vfstmp->close_fs();
      }
      if (rcode != 0 && ow_cancel == 0)
        fserror("Copy file", cur);
      XFlush(disp);
    }
  else
    {
      ko = dl.next;
      infowin->set_coun(selsize);
      while (ko != NULL)
        {
          if (ko->mode & S_SELECT)
            {
              to_infowin(ko->name);
              ow_no = 0;
              rcode = vfs->copy(ko, vfstmp) ? 1 : 0;
              if (rcode && ow_cancel)
                break;
              if (rcode == 0 && ow_no == 0)
                {
                  ko->mode ^= S_SELECT;
                  selfiles--;
                  selsize -= ko->size;
                  infowin->update_coun(ko->size);
                  show_item(ko);
                  XFlush(disp);
                }
              showfinfo(ko);
            };
          ko = ko->next;
        }
      del_infowin();
      if (rcode && ow_cancel == 0)
        {
          ko = dl.next;
          while (ko != NULL)
            if (ko->mode & S_SELECT)
              break;
            else
              ko = ko->next;
          fserror("Copy files", ko);
          XFlush(disp);
        }
      if (vfstmp != panel2->vfs)
      {
        vfstmp->delete_vfs_list();
        vfstmp->close_fs();
      }
    }
  disable_reread = 0;
  if (lay == 0)
    panel2->reread();
  reread();
  vfs->ch_curdir();
  ow_all = 0;
  ow_cancel = ow_no = 0;
}

int    is_exist(char *fname)
{
  if (stat(fname, &dstat) == -1)
    return 0;
  return 1;
}

void   Lister::show_item(FList * o)
{
  FList *t = base;
  int    coun = 0;
  while (t != o && t != NULL)
    {
      t = t->next;
      coun++;
    };
  if (t == o && coun < col * th)
    showitem(o, coun);
}

void   Lister::fmove()
{
  FList *ko;
  int    ferr = 0;
  int    rcode;
  VFS   *vfstmp;
  disable_reread = 1;
  if (lay == 0)
    panel2->expose();
  expose();
  if (vfs->curdir[0] != '/')
    vfs->make_fullpath();
  create_infowin("Moving...");
  if (selfiles == 0)
    {
      to_infowin(cur->name);
      vfstmp = define_vfs(dbuf);
      afstmp_defined = 0;
      if (vfstmp == NULL)
        {
          del_infowin();
          show_vfs_error();
          return;
        }
      if ((vfstmp->is_move_supported()) == 0)
        {
          del_infowin();
          simple_mes("Error", "Can't MOVE on this VFS");
          return;
        }
      rcode = vfs->move(cur, vfstmp);
      if (vfstmp != panel2->vfs)
      {
        vfstmp->delete_vfs_list();
        vfstmp->close_fs();
      }
      if (rcode && ow_cancel == 0)
        {
          del_infowin();
          fserror("Move file", cur);
        }
      else
        del_infowin();
    }
  else
    {
      ko = dl.next;
      vfstmp = define_vfs(dbuf);
      afstmp_defined = 0;
      if (vfstmp == NULL)
        {
          del_infowin();
          show_vfs_error();
          return;
        }
      if ((vfstmp->is_move_supported()) == 0)
        {
          del_infowin();
          simple_mes("Error", "Can't MOVE on this VFS");
          return;
        }
      infowin->set_coun(selsize);
      while (ko != NULL)
        {
          if (ko->mode & S_SELECT)
            {
              to_infowin(ko->name);
              ow_no = 0;
              ferr = vfs->move(ko, vfstmp) ? 1 : 0;
              if (ferr && ow_cancel)
                break;
              if (ferr == 0 && ow_no == 0)
                {
                  ko->mode ^= S_SELECT;
                  selfiles--;
                  selsize -= ko->size;
                  show_item(ko);
                  showfinfo(ko);
                  infowin->update_coun(ko->size);
                  XFlush(disp);
                };
            };
          ko = ko->next;
        }
      del_infowin();
      if (ferr && ow_cancel == 0)
        {
          ko = dl.next;
          while (ko != NULL)
            if (ko->mode & S_SELECT)
              break;
            else
              ko = ko->next;
          fserror("Move files", ko);
        }
      if (vfstmp != panel2->vfs)
      {
        vfstmp->delete_vfs_list();
        vfstmp->close_fs();
      }
    }
  XFlush(disp);
  disable_reread = 0;
  if (lay == 0)
    panel2->reread();
  reread();
  vfs->ch_curdir();
  ow_cancel = ow_no = ow_all = 0;

}

void   Lister::setattrs(int scf)
{
  FList *ko;
  ko = dl.next;
  vfs->ch_curdir();
  while (ko != NULL)
    {
      if (ko->mode & S_SELECT)
        {
          if (scf)
            ko->mode |= attrmode;
          else
            ko->mode &= attrmode;
          if (vfs->chmod(ko->name, ko->mode) >= 0)
            {
              ko->mode ^= S_SELECT;
              selfiles--;
              selsize -= ko->size;
            }
        };
      ko = ko->next;
    }
  reread();
  vfs->ch_curdir();
}

FList *asel;
int    aselmax;

void   Lister::save_select()
{
  FList *o=dl.next;
  asel = new FList[selfiles];
  aselmax = 0;
  while(o)
  {
    if (o->mode & S_SELECT)
      asel[aselmax++].init(o->name, o->mode, 0, 0, 0, 0);
    o=o->next;
  }
}

void   Lister::restore_select()
{
  FList *o;
  selsize = selfiles = 0;
  for (int i = 0; i < aselmax; i++)
  {
    o=dl.next;
    while(o)
    {
      if (strcmp(o->name, asel[i].name) == 0)
        {
          o->mode |= S_SELECT;
          selsize += o->size;
          selfiles++;
          break;
        }
        o=o->next;
    }
  }
  delete asel;
}

void   Lister::reread()
{
  int    kn, kk, sel_fl = 0;
  if (selfiles)
    {
      sel_fl = 1;
      save_select();
    };
  if (cur)
    strcpy(refindchr, cur->name);
  else
    refindchr[0] = 0;
  if (vfs->ch_curdir() == -1)
    vfs->ch_to_rootdir();
  dl.next = fl.next = NULL;
  direc(curdir);
  if (refindchr[0] != 0)
    {
      if (panel != this)
        curn = lcurn;
      kn = findentry(refindchr);
      if (kn != -1)
        {
          curn = kn % (th * col);
          kk = kn - curn;
          setcur(&base, kk);
          setcur(&cur, kn);
        }
    }
  if (sel_fl)
    restore_select();
  if (panel != this)
    {
      lcurn = curn;
      curn = -1;
      if (lay == 0)
        showdir();
    }
  else
    showdir();
}

void   Lister::remount()
{
  char  *mntptr = findmntent(curdir);
  if (mntptr != NULL)
    {
      chdir("..");
      senddir("..");
      tt_printf("umount %s\n", mntptr);
      tt_printf("mount %s\n", mntptr);
      reread();
    }
}

void   Lister::ext_exec(char *exec)
{
  char   findchr[8192];
  char  *s, c;

  if (vfs->is_exec_supported())
    {
      char  *name = vfs->get_file_for_execute(cur->name);
      if (name == NULL)
        {
          show_vfs_error();
          return;
        }
      char  *execdir = vfs->get_execute_dir();
      if (findsubstr(exec, "%s/%s"))
        {
          chdir(panel2->curdir);
          senddir(panel2->curdir);
          sprintf(findchr, exec, execdir, name);
        }
      else
        {
          senddir(execdir);
          sprintf(findchr, exec, name);
        }
      s = findchr;
      while (*++s)
        {
          if (*s == '#')
            {
              *s = 0;
              break;
            }
          if (*s == '\\')
            {
              if (++*s)
                break;
            }
          if (*s == '"' || *s == '\'')
            {
              c = *s;
              while (*++s)
                {
                  if (*s == c)
                    {
                      break;
                    }
                }
              if (!*s)
                break;
            }
        }
      raise_terminal_if_need();
      XFlush(disp);
      tt_printf("%s\n", findchr);
      cmdl->flush();
      senddir(curdir);
      if (lay == 0)
        panel2->reread();
      reread();
      XFlush(disp);
    }
  else
    XBell(disp, 0);
}

void   Lister::menu_exec(char *mecom)
{
  char   findchr[255];
  char  *suc;
  if (vfs->is_exec_supported())
    {
      char  *name = vfs->get_file_for_execute(cur->name);
      if (name == NULL)
        {
          show_vfs_error();
          return;
        }
      char  *execdir = vfs->get_execute_dir();
      int    i = 0;
      if ((suc = findsubstr(mecom, "%p(")))
        {
          suc += 3;
          while (*suc != ')' && *suc != 0)
            wfile[i++] = *suc++;
          wfile[i] = 0;
          newtextfile(wfile, this, 10);
        }
      else
        {
          if (findsubstr(mecom, "%s/%s"))
            {
              chdir(panel2->curdir);
              senddir(panel2->curdir);
              sprintf(findchr, mecom, execdir, name);
            }
          else
            {
              senddir(execdir);
              sprintf(findchr, mecom, name);
            };
          raise_terminal_if_need();
          XFlush(disp);
          tt_printf("%s\n", findchr);
          cmdl->flush();
          senddir(curdir);
          if (lay == 0)
            panel2->reread();
          reread();
          XFlush(disp);
        }
    }
  else
    XBell(disp, 0);
}

void   Lister::set_by_name(char *findchr)
{
  int    kn, kk;
  kn = findentry(findchr);
  if (kn != -1)
    {
      curn = kn % (th * col);
      kk = kn - curn;
      setcur(&base, kk);
      setcur(&cur, kn);
    }
  showdir();
}

void   Lister::wide_exec()
{
  char  *suc;
  int    i = 0;
  suc = findsubstr(menucom[comnumber], "%p(");
  while (menucom[comnumber][i] != *suc)
    combuffer[i] = menucom[comnumber][i++];
  combuffer[i] = 0;
  i = 0;
  strcat(combuffer, dbuf);
  suc += 3;
  while (*suc != ')' && *suc != 0)
    suc++;
  if (*suc != 0)
    strcat(combuffer, suc + 1);
  menu_exec(combuffer);
}

void   Lister::raise_terminal_if_need()
{
  if (allow_t_raising)
    {
      focus_fl = 0;
      if (vt_show)
        {
          XRaiseWindow(disp, main_win);
          XSetInputFocus(disp, main_win, RevertToNone, CurrentTime);
        }
      else
        XMapRaised(disp, main_win);
    }
  else
    {
      delay(100);
    }
}

void   Lister::change_dir(char *newdir)
{
  char   findchr[250];
  int    findfl = 0, kn, kk;
  vfs->ch_curdir();
  if (vfs->chdir(newdir) == 0)
    {
      if (strcmp(newdir, "..") == 0)
        {
          findfl = 1;
          strcpy(findchr, strrchr(curdir, '/') + 1);
        };
      vfs->getcwd(curdir, 1020);
      delall_l(&dl);
      dl.next = fl.next = NULL;
      direc(curdir);
      if (findfl != 0 && findchr[0] != 0)
        {
          kn = findentry(findchr);
          if (kn != -1)
            {
              curn = kn % (th * col);
              kk = kn - curn;
              setcur(&base, kk);
              setcur(&cur, kn);
            }
        }
      showdir();
    };
}

ActionKey defexact;

void   Lister::activate()
{
  char   findchr[250];
  char  *name;
  char   tname[150];
  int    findfl = 0, kn, kk, pid, ef, efn;
  FList *dub;
  ActionKey *ac = action_by_name(AExecute);
  lastscan = 0;
  if (ac == NULL)
    {
      ac = &defexact;
      ac->mods[1] = ShiftMask;
      ac->mods[2] = ControlMask;
      ac->action = AExecute;
    }
  vfs->ch_curdir();
  dub = new FList(cur->name, cur->mode, cur->size, cur->uid, cur->gid, cur->time);
  if ((ev.xkey.state & ac->mods[2]) == ac->mods[2])
    {                                /*+1 */
      pid = 0;
      if ((ev.xkey.state & ac->mods[1]) == ac->mods[1])
        {                        /*+2 */
          cmdl_insert_name(curdir);
          cmdl->insert('/');
          tt_printf("/");
        }
      else
/*-2*/
        {                        /*+3 */
          if (vfs->is_exec_supported())
            {
              name = vfs->get_file_for_execute(cur->name);
              if (name == NULL)
                {
                  show_vfs_error();
                  return;
                }
              cmdl_insert_name(name);
              cmdl->insert(' ');
              tt_printf(" ");
            }
        }
/*-3*/
    }
/*-1*/
  else if (cmdl->bl != 0)
    {                                /*+4 */
      evret = 0;
      raise_terminal_if_need();
      cmdl->flush();
      XFlush(disp);
    }
  else
/*-4*/ if ((cur->mode & S_IFDIR) && cmdl->bl == 0)
    {                                /*+5 */
      vfs->ch_curdir();
      get_last_content(vfs->curdir, findchr);
      if (vfs->chdir(cur->name) == 0)
        {                        /*+6 */
          if (vfs->need_change_vfs)
            {
              if (strcmp(cur->name, "..") == 0)
                {                /*+7 */
                  findfl = 1;
                  if (vfs->fstype == AFS_TYPE)
                    strcpy(findchr, afs.arcname);
                  else
                    get_last_content(curdir, findchr);
                };
/*-7*/
              vfs->delete_vfs_list();
              vfs->close_fs();
              vfs = pop_vfs();
              vfs->ch_curdir();
            }
          else if (strcmp(cur->name, "..") == 0)
            {                        /*+7 */
              findfl = 1;
            };
/*-7*/
          vfs->getcwd(curdir, 1020);
          if (vfs == &dfs)
            senddir(curdir);
          delall_l(&dl);
          dl.next = fl.next = NULL;
          if (direc(vfs->curdir) == 0)
            {                        /*+8 */
              fserror("Reading directory", dub);
              vfs->chdir("..");
              vfs->getcwd(curdir, 1020);
              direc(curdir);
            }
/*-8*/
          if (findfl != 0 && findchr[0] != 0)
            {                        /*+9 */
              kn = findentry(findchr);
              if (kn != -1)
                {                /*+10 */
                  curn = kn % (th * col);
                  kk = kn - curn;
                  setcur(&base, kk);
                  setcur(&cur, kn);
                }
/*-10*/
            }
/*-9*/
          showdir();
        }
      else
        fserror("Changing directory", dub);
/*-6*/
    }
  else
/*-5*/ if (cur->mode & S_EXTEND)
    {                                /*+15 */
      if (is_it_afs_file(cur->name) && (ev.xkey.state & ac->mods[1]) == 0)
        {
          name = vfs->get_file_for_execute(cur->name);
          if (name)
            {
// *INDENT-OFF*        
         ::chdir(vfs->get_execute_dir());
// *INDENT-ON*        


              strcpy(tname, name);
            }
          vfs->delete_vfs_list();
          push_vfs(vfs);
          vfs = &afs;
          if (name == NULL)
            {
              show_vfs_error();
              strcpy(findchr, afs.arcname);
              vfs = pop_vfs();
              findfl = 1;
// *INDENT-OFF*        
         ::chdir(curdir);
// *INDENT-ON*        


            }
          else
            {
              if (afs.init_support(tname) == 0)                //If error we return to panels DFS

                {
                  show_vfs_error();
                  strcpy(findchr, afs.arcname);
                  vfs = pop_vfs();
                  findfl = 1;
                }
// *INDENT-OFF*        
         ::chdir(curdir);
// *INDENT-ON*        


            }
          vfs->ch_curdir();
          if (direc(curdir) == 0)
            {                        /*+8 */
              fserror("Reading directory", dub);
              vfs->chdir("..");
              vfs->getcwd(curdir, 1020);
              direc(curdir);
            }
/*-8*/
          if (findfl != 0 && findchr[0] != 0)
            {                        /*+9 */
              kn = findentry(findchr);
              if (kn != -1)
                {                /*+10 */
                  curn = kn % (th * col);
                  kk = kn - curn;
                  setcur(&base, kk);
                  setcur(&cur, kn);
                }
/*-10*/
            }
/*-9*/
          showdir();
        }
      else
        {
          efn = 0;
          while ((ef = ext_find2(cur->name, efn)) != -1)
            panlist[efn++] = extcom[ef];
          if (efn == 1)
            ext_exec(panlist[0]);
          else
            newpanel("Which command?", efn, panexec);
        }
    }
  else
/*-15*/ if (is_exec(cur))
    {                                /*+11 */
      if ((ev.xkey.state & ac->mods[1]) == 0)
        {                        /*+12 */
          evret = 0;
          if (cmdl->bl == 0)
            {
              if (vfs->is_exec_supported())
                {
                  name = vfs->get_file_for_execute(cur->name);
                  if (name == NULL)
                    {
                      show_vfs_error();
                      return;
                    }
                  if (vfs->fstype != DFS_TYPE)
                    senddir(vfs->get_execute_dir());
                  tt_printf("./");
                  cmdl_insert_name(name);
                  if (mouse)
                    tt_printf("\n");
                  pid = 0;
                  XFlush(disp);
                }
            }
          raise_terminal_if_need();
          cmdl->flush();
          if (vfs->fstype != DFS_TYPE)
            {
              if (mouse == 0)
                tt_printf("\n");
              senddir(curdir);
            }
          XFlush(disp);
        }
/*-12*/
      else
        {                        /*+14 */
          evret = 0;
          if (cmdl->bl == 0 && vfs->is_exec_supported())
           {
            cmdl_insert_name(vfs->get_file_for_execute(cur->name));
            tt_printf(" &");
           }
          cmdl->flush();
          XFlush(disp);
        }
/*-14*/
    }
  else
/*-11*/
    {
      for (ef = 0; ef < extmax; ef++)
        panlist[ef] = extcom[ef];
      newpanel("Execute with...", extmax, panexec);
    };
  delete dub;
}

void   Lister::funcs(int nn)
{
  switch (nn)
    {
    case 0:
      fdelete();
      break;
    case 1:
      fcopy();
      break;
    case 2:
      fmove();
      break;
    case 3:
      fmkdir();
      break;
    case 4:
      fedit();
      break;
    case 5:
      select_by_mask(1);
      break;
    case 6:
      select_by_mask(0);
      break;
    case 7:
      setattr();
      break;
    case 8:
      lpr();
      break;
    case 10:
      wide_exec();
      break;
    case 11:
      man_page();
      break;
    case 12:
      do_ftp_link();
      break;
    case 20:
      chowns();
      break;
    case 22:
      panmntmnt();
      break;
    }
}

void   Lister::chowns()
{
  int    i = 0;
  char  *gr = NULL;
  int    r, ui, gi;
  FList *o, *oo;
  while (dbuf[i] != 0 && dbuf[i] != '.')
    i++;
  if (dbuf[i] == '.')
    {
      dbuf[i] = 0;
      gr = dbuf + i + 1;
    };
  ui = finduserid_by_name(dbuf);
  if (gr != NULL)
    gi = findgroupid_by_name(gr);
  else
    gi = -1;
  if (selfiles == 0)
    {
      r = chown(cur->name, ui, gi);
      oo = cur;
    }
  else
    {
      o = dl.next;
      while (o != NULL)
        {
          if (o->mode & S_SELECT)
            {
              if (chown(o->name, ui, gi) == -1)
                {
                  r |= -1;
                  oo = o;
                }
              else
                {
                  o->mode ^= S_SELECT;
                  selfiles--;
                  selsize -= o->size;
                }
            }
          o = o->next;
        }
    }
  if (r == -1)
    fserror("Change Owner", oo);
}

void   Lister::ps_info()
{
  int    psmax = getps();
  if (psmax > 0)
    newkillpanel("Kill process!", psmax, pankill, 600);
}

void   Lister::lpr()
{
  chdir(curdir);
  tt_printf("lpr %s\n", cur->name);
}

int    Lister::is_filtered(char *s, char *ff)
{
  char  *f;
  while (*s != 0)
    {
      f = ff;
      if (*f == '*')
        {
          f++;
          while (*f != 0 && *s != 0)
            if (*s == *f)
              break;
            else
              s++;
          if (*f == 0)
            return 1;
        }
      while (*s != 0 && *f != 0 && *f != '*')
        if (*f == '?')
          {
            f++;
            s++;
          }
        else if (*s != *f)
          {
            if (*ff == '*')
              break;
            else
              return 0;
          }
        else
          {
            s++;
            f++;
          };

      if (*f == '*')
        ff = f;
    }
  if (*f == 0 || *f == '*')
    return 1;
  return 0;
}

void   Lister::select_by_mask(int sel)
{
  strcpy(maskchr, dbuf);
  FList *o = dl.next->next;
  int coun=0;
  while (o != NULL)
    {
      if (is_filtered(o->name, maskchr))
        {
          if (sel)
            {
              if ((o->mode & S_SELECT) == 0)
                {
                  o->mode |= S_SELECT;
                  selfiles++;
                  coun++;
                  selsize += o->size;
                };
            }
          else if (o->mode & S_SELECT)
            {
              o->mode ^= S_SELECT;
              selfiles--;
              coun++;
              selsize -= o->size;
            }
        }
      o = o->next;
    }
  if (selfiles < 0)
    {
      selfiles = 0;
      selsize = 0;
    }
    if(coun==0)
            simple_mes("Information","No files match given criteria.");
}

void   Lister::setattr()
{
  vfs->ch_curdir();
  if (vfs->chmod(cur->name, cur->mode) == -1)
    fserror("Set attributes", cur);
  reread();
  if (panel->lay == 0)
    panel->panel2->reread();
}

void   Lister::view(int v)
{
  char   str[2*PATH_MAX];
  char  *name;
  chdir(curdir);
  VFS *pvfs=vfs;
  if (strcmp(viewname, "internal") != 0)
    {
      name = vfs->get_file_for_execute(cur->name);
      if (name == NULL && pvfs->bgbit==0)
        {
          show_vfs_error();
          return;
        }
      if(pvfs->bgbit!=0)
      {
        if(pvfs->bgbit==FF_GET)
           ftp_set_bgcode((FTP*)pvfs, FF_VIE);
        return;
      }
      tt_printf("%s %s/%s\n", viewname, vfs->get_execute_dir(), name);
      raise_terminal_if_need();
/* XLowerWindow(disp,Main);
   XFlush(disp);
   psystem(str);
   XRaiseWindow(disp,Main);
   XSetInputFocus(disp,Main,RevertToNone,CurrentTime);
   if(lay==0) panel2->reread();
   reread(); */
    }
  else if (viewfunc != NULL && ((cur->mode & S_IFDIR) == 0) && (cur->size != 0) && v != 0 && vfs->is_exec_supported())
    {
      name = vfs->get_file_for_execute(cur->name);
      if (name == NULL && pvfs->bgbit==0)
        {
          show_vfs_error();
          return;
        }
      if(pvfs->bgbit!=0)
      {
        if(pvfs->bgbit==FF_GET)
           ftp_set_bgcode((FTP*)pvfs, FF_VIE);
        return;
      }
      sprintf(str, "%s/%s", vfs->get_execute_dir(), name);
      viewfunc(str);
    }
  else if (viewonlyfunc != NULL && ((cur->mode & S_IFDIR) == 0) && (cur->size != 0) && v == 0 && vfs->is_exec_supported())
    {
      name = vfs->get_file_for_execute(cur->name);
      if (name == NULL && pvfs->bgbit==0)
        {
          show_vfs_error();
          return;
        }
      if(pvfs->bgbit!=0)
      {
        if(pvfs->bgbit==FF_GET)
           ftp_set_bgcode((FTP*)pvfs, FF_SVI);
        return;
      }
      sprintf(str, "%s/%s", vfs->get_execute_dir(), name);
      viewonlyfunc(str);
    }
}

void   Lister::bg_view(char *name)
{
  if (strcmp(viewname, "internal") != 0)
    {
      tt_printf("%s %s\n", viewname, name);
      raise_terminal_if_need();
    }
  else
    {
     if(vfs->bgbit==FF_VIE)
              viewfunc(name);
     else
             viewonlyfunc(name);
    }
}

void   Lister::bg_edit(char *name)
{
  if (strcmp(viewname, "internal") != 0)
    {
      tt_printf("%s %s\n", editname, name);
      raise_terminal_if_need();
    }
  else
    {
      editorfunc(name);
    }
}

void   Lister::edit()
{
  char   str[1200];
  char  *name;
  chdir(curdir);
  VFS *pvfs=vfs;
  if (strcmp(editname, "internal") != 0 && vfs->is_exec_supported())
    {
      name = vfs->get_file_for_execute(cur->name);
      if (name == NULL && pvfs->bgbit==0)
        {
          show_vfs_error();
          return;
        }
      if(pvfs->bgbit!=0)
      {
        if(pvfs->bgbit==FF_GET)
           ftp_set_bgcode((FTP*)pvfs, FF_EDI);
        return;
      }
      tt_printf("%s %s/%s\n", editname, vfs->get_execute_dir(), name);
      raise_terminal_if_need();
/* XLowerWindow(disp,Main);
   XFlush(disp);
   psystem(str);
   XRaiseWindow(disp,Main);
   XSetInputFocus(disp,Main,RevertToNone,CurrentTime);
   if(lay==0) panel2->reread();
   reread(); */
    }
  else if (editorfunc != NULL && ((cur->mode & S_IFDIR) == 0) && vfs->is_exec_supported())
    {
      name = vfs->get_file_for_execute(cur->name);
      if (name == NULL && pvfs->bgbit==0)
        {
          show_vfs_error();
          return;
        }
      if(pvfs->bgbit!=0)
      {
        if(pvfs->bgbit==FF_GET)
           ftp_set_bgcode((FTP*)pvfs, FF_EDI);
        return;
      }
      sprintf(str, "%s/%s", vfs->get_execute_dir(), name);
      editorfunc(str);
    }
}

void   Lister::del()
{
  if (strcmp(cur->name, "..") != 0 || selfiles != 0)
    {
      vfs->ch_curdir();
      bmark->set_recycle_image(0);
      initquery("Delete file?", this, panel2->vfs, 0);
    }
}

void   Lister::copy()
{
  if (strcmp(cur->name, "..") != 0 || selfiles != 0)
    {
      vfs->ch_curdir();
      if (selfiles)
        init_copymove_query("Copy files?", this, panel2->vfs, 1);
      else
        initdialog("Copy file", this, panel2->vfs, 1);
    }
}

void   Lister::copy(VFS * vf)
{
  if (strcmp(cur->name, "..") != 0 || selfiles != 0)
    {
      vfs->ch_curdir();
      if (selfiles)
        init_copymove_query("Copy files?", this, vf, 1);
      else
        initdialog("Copy file", this, vf, 1);
    }
}

//edit for movedir...

void   Lister::move()
{
  if (strcmp(cur->name, "..") != 0 || selfiles != 0)
    {
      vfs->ch_curdir();
      if (selfiles)
        init_copymove_query("Move files?", this, panel2->vfs, 2);
      else
        initdialog("Move file", this, panel2->vfs, 2);
    }
}

void   Lister::move(VFS * vf)
{
  if (strcmp(cur->name, "..") != 0 || selfiles != 0)
    {
      vfs->ch_curdir();
      if (selfiles)
        init_copymove_query("Move files?", this, vf, 2);
      else
        initdialog("Move file", this, vf, 2);
    }
}

void   Lister::send_dnd_message()
{
  int    cx, cy, rx, ry;
  unsigned kmask;
  Window rw, cw;
  XEvent ev;
  char   buffer[1024];


// For now, only message for single files are supported
  if (selfiles)
    return;

  Window root = DefaultRootWindow(disp);
  XQueryPointer(disp, root, &rw, &cw, &rx, &ry, &cx, &cy, &kmask);
  ev.xclient.type = ClientMessage;
  ev.xclient.display = disp;
  ev.xclient.message_type = DndProtocol;
  ev.xclient.format = 32;
  ev.xclient.window = cw;
  ev.xclient.data.l[0] = (cur->mode & S_IFDIR) ? DndDir : DndFile;
  ev.xclient.data.l[1] = (long)dnd_startm;
  ev.xclient.data.l[2] = (long)0l;
  ev.xclient.data.l[3] = rx + 65536L * (long)ry;
  ev.xclient.data.l[4] = 1;
  sprintf(buffer, "%s/%s", curdir, cur->name);
  DndSetData(DndFile, buffer, strlen(buffer) + 1);
  XSendEvent(disp, cw, True, NoEventMask, &ev);
  ev.xclient.message_type = Old_DndProtocol;
  XSendEvent(disp, cw, True, NoEventMask, &ev);
}

void   Lister::mkdir()
{
  vfs->ch_curdir();
  newtextfile("Make directory", this, 3);
}

void   Lister::fmkdir()
{
  FList *o = new FList(dbuf, S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH);
  if (vfs->mkdir(dbuf, o->mode) == 0)
    {
      strcpy(cur->name, dbuf);
      reread();
    }
  else
    msg("Make directory", "Error: Can't create directory!", 2, o);
  delete o;
}

void   Lister::left()
{
  int    i = 0;
  FList *pcur;
  pcur = cur;
  if (setcur(&cur, -th))
    {
      curn -= th;
      if (curn < 0)
        {
          curn += th;
          if (setcur(&base, -th) == 0)
            {
              base = dl.next;
              pcur = base;
              curn = 0;
              while (pcur != cur)
                {
                  pcur = pcur->next;
                  curn++;
                };
            };
          showdir();
        }
      else
        {
          showitem(pcur, curn + th);
          showitem(cur, curn);
        }
    }
  else if (cur != dl.next)
    {
      i = curn;
      curn = 0;
      showitem(pcur, i);
      if (base != dl.next)
        {
          base = cur = dl.next;
          showdir();
        }
      else
        {
          cur = dl.next;
          showitem(cur, curn);
        };
    }
}

void   Lister::right()
{
  FList *pcur, *ko;
  int    i = 0;
  pcur = cur;
  if (setcur(&cur, th))
    {
      curn += th;
      if (curn >= th * col)
        {
          curn -= th;
          setcur(&base, th);
          showfilelist();
        }
      else
        {
          showitem(pcur, curn - th);
          showitem(cur, curn);
        }
    }
  else
    {
      i = 0;
      ko = cur;
      while (cur->next != NULL)
        {
          i++;
          cur = cur->next;
        };
      if (i > 0)
        {
          curn += i;
          showitem(ko, curn - i);
          if (curn >= th * col)
            {
              curn -= th;
              setcur(&base, th);
              showdir();
            }
          else
            showitem(cur, curn);
        };
    };
}

void   Lister::fedit()
{
  strcpy(cur->name, dbuf);
  cur->size = 0;
  cur->mode = 0666;
  edit();
  reread();
}

void   Lister::attrib()
{
// *INDENT-OFF*        
   if(selfiles==0) 
     ::attrib(cur,7);
   else 
      attrib2();
// *INDENT-ON*        


}

void   Lister::push_vfs(VFS * v)
{
  VFS   *o;
  DFS *df,*df2=(DFS*)v;
  switch (v->fstype)
    {
    case DFS_TYPE:
      df = new DFS;
      memcpy(df, v, sizeof(DFS));
      df->curdir=new char[df2->dlen];
      strcpy(df->curdir,v->curdir);
      o=df;
      break;
    case AFS_TYPE:
      o = new AFS;
      memcpy(o, v, sizeof(AFS));
      o->set_dir_pointer(NULL,0);
      strcpy(o->curdir,v->curdir);
      break;
    default:
      return;
    };
  o->next = vfstack;
  vfstack = o;
}

void   Lister::switch_to_vfs(int vfs_type, char *dir)
{
  char  *name, *b;
  vfs->delete_vfs_list();
  if (vfs->fstype != DFS_TYPE)
    while (vfstack != NULL)
      pop_vfs();
  vfs = &dfs;
  switch (vfs_type)
    {
    case DFS_TYPE:
      vfs = &dfs;
      strcpy(curdir, dir);
      vfs->chdir(curdir);
      senddir(curdir);
      reread();
      expose();
      break;
    case AFS_TYPE:
      vfs->delete_vfs_list();
      push_vfs(vfs);
      vfs = &afs;
      b = strrchr(dir, '/');
      *b = 0;
// *INDENT-OFF*        
   if(*dir==0) 
      ::chdir("/");
   else 
      ::chdir(dir);
// *INDENT-ON*        


      *b = '/';
      name = b + 1;
      if (afs.init_support(name) == 0)        //If error we return to prev VFS

        {
          show_vfs_error();
          vfs = pop_vfs();
        }
// *INDENT-OFF*        
   ::chdir(curdir);
// *INDENT-ON*        


      vfs->ch_curdir();
      direc(".");
      expose();
      break;
    };
}

VFS   *Lister::pop_vfs()
{
  char   *dir;
  VFS   *o = vfstack;
  if (o == NULL)
    return &dfs;
  vfstack = o->next;
  o->need_reread = 1;
  switch (o->fstype)
    {
    case DFS_TYPE:
      dir=dfs.curdir;
      memcpy(&dfs, o, sizeof(DFS));
      dfs.curdir=dir;
      strcpy(dfs.curdir,o->curdir);
      delete o->curdir;
      delete o;
      return &dfs;
    case AFS_TYPE:
      dir=afs.curdir;
      memcpy(&afs, o, sizeof(AFS));
      afs.curdir=dir;
      if(dir==NULL)
              afs.set_dir_pointer(NULL,0);
      strcpy(afs.curdir,o->curdir);
      delete o->curdir;
      delete o;
      return &afs;
    };
  delete o;
  return &dfs;
}

void   Lister::try_to_add_to_bookmark(int cy)
{
  if ((cur->mode & S_IFDIR) && strcmp("..", cur->name) != 0)
    {
      if (vfs->fstype == DFS_TYPE)
        {
          sprintf(strtmp, "%s/%s", curdir, cur->name);
          bmark->add_toempty_book_by_coord(cy, strtmp, vfs->fstype);
          return;
        }
    }
  else
    bmark->add_toempty_book_by_coord(cy, vfs->get_info_for_bookmark(), vfs->fstype);
}

extern int disable_modifiers;

void   Lister::check_dnd_dir_on_panel2(int cx, int cy, unsigned kmask)
{
  if (cy - panel2->y < 30)        //We dropped on title name so use current path!

    {
      if (kmask & ShiftMask)
        move();
      else
        copy();
      return;
    }
  if (panel2->vfs->fstype != DFS_TYPE)
    {
      if (kmask & ShiftMask)
        move();
      else
        copy();
    }
  else
    {
      int    k = (cy - 30 - panel2->y) / tdl + (cx - panel2->x - 8) / (pl + 4) * th;
      FList *o = panel2->base;
      VFS   *ivfs;
      int    i = 0;
      if (k < th * col)
        {
          while (i < k && o != NULL)
            {
              o = o->next;
              i++;
            }
          if (o && (o->mode & S_IFDIR))
            {
              sprintf(strtmp2, "%s/%s", panel2->curdir, o->name);
              ivfs = define_vfs("DFS", strtmp2);
              if (kmask & ShiftMask)
                move(ivfs);
              else
                copy(ivfs);
            }
          else if (o && (o->mode & S_EXTEND) && is_it_afs_file(o->name))
            {
              sprintf(strtmp2, "%s/%s", panel2->curdir, o->name);
              ivfs = define_vfs("ARC", strtmp2);
              if (kmask & ShiftMask)
                move(ivfs);
              else
                copy(ivfs);
            }
          else
            {
              if (kmask & ShiftMask)
                move();
              else
                copy();
            }
        }
    }
}

void   Lister::check_dnd_dir(unsigned mask)
{
  FList *o = base;
  VFS   *ivfs;
  int    i = 0;
  if (vfs->fstype != DFS_TYPE)
    {
      XBell(disp, 0);
      return;
    };
  int    k = (ev.xbutton.y - 30) / tdl + (ev.xbutton.x - 8) / (pl + 4) * th;
  if (k < th * col)
    if (curn != k)
      {
        while (i < k && o != NULL)
          {
            o = o->next;
            i++;
          }
        if (o == NULL)
          return;
        if (o->mode & S_IFDIR)
          {
            sprintf(strtmp2, "%s/%s", curdir, o->name);
            ivfs = define_vfs("DFS", strtmp2);
            if (mask & ShiftMask)
              move(ivfs);
            else
              copy(ivfs);
          }
        else if (o->mode & S_EXTEND)
          if (is_it_afs_file(o->name))
            {
              sprintf(strtmp2, "%s/%s", curdir, o->name);
              ivfs = define_vfs("ARC", strtmp2);
              if (mask & ShiftMask)
                move(ivfs);
              else
                copy(ivfs);
            }
      }
}

void   Lister::clear_ff()
{
  ff_buf[0] = '\0';
  last_ff = NULL;
}

void   Lister::fast_find(XEvent * ev)
{
  FList *o = dl.next;
  int    kn = 0, kk = 0, l;
  KeySym ks;
  XComposeStatus cs;
  char   sym[8];
  ev->xkey.state ^= Mod1Mask;
  XLookupString(&ev->xkey, sym, 4, &ks, &cs);
  if (ks == XK_BackSpace)
    {
      l = strlen(ff_buf);
      if (l)
        {
          ff_buf[l - 1] = 0;
        }
      showitem(cur, curn);
      show_ff_item(curn, l - 1);
      return;
    }
  sym[1] = 0;
  strcat(ff_buf, sym);
  l = strlen(ff_buf);
  while (o)
    if (strncmp(o->name, ff_buf, l) == 0)
      break;
    else
      {
        o = o->next;
        kn++;
      };
  if (o != NULL)
    {
      if (o != last_ff)
        {
          base = dl.next;
          cur = o;
          lcurn = curn = kn % (th * col);
          kk = kn - curn;
          setcur(&base, kk);
          showfilelist();
          last_ff = o;
        }
    }
  else
    {
      last_ff = NULL;
      if (l)
        ff_buf[--l] = 0;
    };
  show_ff_item(curn, l);
}

void   Lister::create_ftp_link()
{
  vfs->ch_curdir();
  newtextfile("Connect to Ftp Host", this, 12);
}

void Lister::push_n_pop(FTP *p)
{
  vfs->delete_vfs_list();
  push_vfs(vfs);
  vfs = &ftp;
  ftp=*p;
  vfs->ch_curdir();
  if (direc(curdir) == 0)
    {
      vfs_error("FTP", "Can't change to dir");
      show_vfs_error();
      vfs->chdir("..");
      vfs->getcwd(curdir, 1020);
      direc(curdir);
    }
  showdir();
  if (lay == 0)
      panel2->reread();
}
  
void   Lister::do_ftp_link()
{
  vfs->delete_vfs_list();
  push_vfs(vfs);
  vfs = &ftp;
  if (ftp.init_support(dbuf) == 0)        //If error we return to panels DFS
    {
      show_vfs_error();
      vfs = pop_vfs();
    } else
      if(ftp.bgbit)
         vfs=pop_vfs();
// *INDENT-OFF*        
        ::chdir(curdir);
// *INDENT-ON*        


  vfs->ch_curdir();
  if (direc(curdir) == 0)
    {
      vfs_error(vfs->vfs_prefix, "Can't change to dir");
      show_vfs_error();
      vfs->chdir("..");
      vfs->getcwd(curdir, 1020);
      direc(curdir);
    }
  showdir();
}

void Lister::check_and_pop(VFS *vf)
{
 int res;
 switch(vf->fstype)
 {
         case DFS_TYPE:
                 res=memcmp(vf,vfs,sizeof(DFS));
                 break;
         case AFS_TYPE:
                 res=memcmp(vf,vfs,sizeof(AFS));
                 break;
         case FTP_TYPE:
                 res=memcmp(vf,vfs,sizeof(FTP));
                 break;
         default:
                 res=1;
 }
 if(res==0)
   pop_and_show();
}

//Pop vfs from vfs_stack and then show directory listing.
void Lister::pop_and_show()
{
   vfs=pop_vfs();
// *INDENT-OFF*        
  ::chdir(curdir);
// *INDENT-ON*        
  vfs->ch_curdir();
  if (direc(curdir) == 0)
    {
      vfs_error(vfs->vfs_prefix, "Can't change to dir");
      show_vfs_error();
      vfs->chdir("..");
      vfs->getcwd(curdir, 1020);
      direc(curdir);
    }
  showdir();
}

void Lister::switch_to_prev_vfs()
{
   vfs=pop_vfs();
// *INDENT-OFF*        
   ::chdir(curdir);
// *INDENT-ON*        
  vfs->ch_curdir();
  if (direc(curdir) == 0)
    {
      vfs_error("VFS", "Can't change to dir");
      show_vfs_error();
      vfs->chdir("..");
      vfs->getcwd(curdir, 1020);
      direc(curdir);
    }
  showdir();
}

void   Lister::click()
{
  int    k, i = 0, action, cx, cy, rx, ry;
  KeySym ks;
  FList *ko;
  unsigned kmask;
  Window rw, cw;
  VFS   *ivfs;
  if (ev.xany.window == w)
    {
      switch (ev.type)
        {
        case Expose:
          flush_expose(w);
          expose();
          break;
        case UnmapNotify:
          break;
        case MapNotify:
          break;
        case ButtonPress:
          dnd_startx = ev.xbutton.x;
          dnd_starty = ev.xbutton.y;
          dnd_start_valid = 1;
          clear_ff();
          switch (lay)
            {
            case 0:
              XSetInputFocus(disp, w, RevertToNone, CurrentTime);
              if (ev.xbutton.x < 25 && ev.xbutton.y < 25 && subm != NULL)
                {
                  subm->setpos(ev.xbutton.x - 2, ev.xbutton.y - 2);
                  subm->init(w);
                  subm->show();
                };
              panel = this;
              break;
            case 1:
              if (ev.xbutton.y < 25)
                {
                  if (ev.xbutton.x > l / 2 + 20)
                    {
                      panel = panel2;
                      XSetInputFocus(disp, panel2->w, RevertToNone, CurrentTime);
                    }
                  else if (ev.xbutton.x < 25)
                    {
                      if (subm)
                        {
                          subm->setpos(ev.xbutton.x - 2, ev.xbutton.y - 2);
                          subm->init(w);
                          subm->show();
                        };
                    }
                  else
                    XSetInputFocus(disp, w, RevertToNone, CurrentTime);
                }
              else
                XSetInputFocus(disp, w, RevertToNone, CurrentTime);
              break;
            case 2:
              if (ev.xbutton.y < 25)
                {
                  if (ev.xbutton.x < l / 2 - 20)
                    {
                      panel = panel2;
                      XSetInputFocus(disp, panel2->w, RevertToNone, CurrentTime);
                    }
                  else if (ev.xbutton.x < l / 2 + 12)
                    {
                      if (subm)
                        {
                          subm->setpos(ev.xbutton.x - 2, ev.xbutton.y - 2);
                          subm->init(w);
                          subm->show();
                        };
                    }
                  else
                    XSetInputFocus(disp, w, RevertToNone, CurrentTime);
                }
              else
                XSetInputFocus(disp, w, RevertToNone, CurrentTime);
              break;
            };
          if (ev.xbutton.y > 30 && ev.xbutton.x > 8 && ev.xbutton.y < h - 30)
            {
              if (cur == NULL)
                break;
              if (curn == -1)
                curn = lcurn;
              k = (ev.xbutton.y - 30) / tdl + (ev.xbutton.x - 8) / (pl + 4) * th;
              if (k < th * col)
                if (curn != k)
                  {
                    i = curn;
                    curn = k;
                    showitem(cur, i);
                    if (setcur(&cur, k - i))
                      curn = k;
                    else
                      curn = i;
                    if (ev.xbutton.button == Button3)
                      selected(cur);
                  }
                else if (ev.xbutton.button == Button3)
                  selected(cur);
              showitem(cur, curn);
            }
          else if (ev.xbutton.y > h - 30)
            if (ev.xbutton.x > l - 53)
              {
                if (curn == -1)
                  curn = lcurn;
                if (ev.xbutton.x < l - 30)
                  left();
                else
                  right();
              }
            else if (ev.xbutton.x < 53)
              {
                if (ev.xbutton.state & ShiftMask)
                  init_chown_dialog(cur);
// *INDENT-OFF*        
      else 
            if(selfiles==0) 
             ::attrib(cur,7); 
            else 
              attrib2();
// *INDENT-ON*        


              };
          prflg = 1;
          break;

        case FocusIn:
          panel = this;
          focus_fl = 1;
          XRaiseWindow(disp, w);
          if (curn == -1)
            {
              vfs->ch_curdir();
              curn = lcurn;
              if (cur == NULL)
                reread();
              showitem(cur, curn);
            }
          if (cmdl)
            cmdl->setpath(curdir);
          senddir(curdir);
          foc = 1;
          break;
        case FocusOut:
          if (curn != -1)
            {
              lcurn = curn;
              curn = -1;
              if (cur != NULL)
                showitem(cur, lcurn);
            };
          foc = 0;
          break;
        case MotionNotify:
          XQueryPointer(disp, Main, &rw, &cw, &rx, &ry, &cx, &cy, &kmask);
          if ((kmask & Button1Mask) || (kmask & Button2Mask))
            {
              if (dnd_enabled)
                {
                  if (cw == bmark->w)
                    bmark->show_dir_banner(cy - 25);
                }
              else if (dnd_start_valid && (abs(dnd_starty - cy + y) > 10 || abs(dnd_startx - cx + x) > 10))
                {
                  if (selfiles)
                    XDefineCursor(disp, w, cdnd2);
                  else
                    XDefineCursor(disp, w, cdnd1);
                  dnd_enabled = 1;
                  dnd_creator = this;
                  dnd_startm = ev.xbutton.state;
                  bmark->set_recycle_image(1);
                }
            }
          else if (cw == w && (kmask & Button3Mask))
            {
              cy -= y;
              cx -= x;
              if (cy > 30 && cx > 8 && cy < h - 30)
                {
                  if (curn == -1)
                    curn = lcurn;
                  k = (cy - 30) / tdl + (cx - 8) / (pl + 4) * th;
                  if (k < th * col)
                    if (curn != k)
                      {
                        i = curn;
                        curn = k;
                        showitem(cur, i);
                        if (setcur(&cur, k - i))
                          curn = k;
                        else
                          curn = i;
                        selected(cur);
                        showitem(cur, curn);
                      }
                }
            }
          break;
        case ButtonRelease:
          dnd_start_valid=0;
          if (dnd_enabled)
            {
              dnd_enabled = 0;
              XUndefineCursor(disp, w);
              send_dnd_message();
              XQueryPointer(disp, Main, &rw, &cw, &rx, &ry, &cx, &cy, &kmask);
              bmark->set_recycle_image(0);
              bmark->hide_dir_banner();
              if (cw == w && ev.xbutton.y > 30)
                check_dnd_dir(kmask);
              else if (cw == bmark->w)
                {
                  if (cy > bmark->h - 50)
                    del();
                  else
                    {
                      ivfs = bmark->get_vfs_by_coord(cy - 25);
                      if (ivfs)
                        {
                          if (kmask & ShiftMask)
                            move(ivfs);
                          else
                            copy(ivfs);
                        }
                      else if (dnd_starty > 25)
                        try_to_add_to_bookmark(cy - 25);
                      else
                        bmark->add_toempty_book_by_coord(cy - 25, vfs->get_info_for_bookmark(), vfs->fstype);
                    }
                }
              else if (cmdl->w == cw)
                {
                  mouse = 1;
                  activate();
                  mouse = 0;
                }
              else if (cw == panel2->w)
                {
                  check_dnd_dir_on_panel2(cx, cy, kmask);
                }
              else if (ev.xbutton.y < 25)
                {
                  switch (lay)
                    {
                    case 1:
                      if (ev.xbutton.x > l / 2 + 20)
                        {
                          if (kmask & ShiftMask)
                            move();
                          else
                            copy();
                        }
                      else
                        XBell(disp, 0);
                      break;
                    case 2:
                      if (ev.xbutton.x < l / 2 - 20)
                        {
                          if (kmask & ShiftMask)
                            move();
                          else
                            copy();
                        }
                      else
                        XBell(disp, 0);
                      break;
                    }
                };
            }
          else if (bclk)
            {
              prflg = 0;
              bclk = 0;
              if (((ev.xbutton.time - dbtime) <= DBLCLICK &&
                   abs(ev.xbutton.x - lmx) <= 10 && abs(ev.xbutton.y - lmy) <= 10 &&
                   ev.xbutton.y > 30 && ev.xbutton.x > 8 && ev.xbutton.y < h - 30) || ev.xbutton.button == Button2)

                {
                  mouse = 1;
                  activate();
                  mouse = 0;
                }

              else
                prflg = 1;
            }
          else if (ev.xbutton.button == Button2)
            {
              mouse = 1;
              activate();
              mouse = 0;
            }
          if (prflg)
            {
              dbtime = ev.xbutton.time;
              lmx = ev.xbutton.x;
              lmy = ev.xbutton.y;
              prflg = 0;
              bclk = 1;
            }
          break;
        case KeyPress:
          action = look_for_key(&ev);
          switch (action)
            {
            case ASwitchTab:
              clear_ff();
              panel = panel2;
              XSetInputFocus(disp, panel->w, RevertToNone, CurrentTime);
              break;
            case AExecute:
              clear_ff();
              activate();
              break;
            case AInsert:
              if (strcmp(cur->name, "..") != 0)
                {
                  selected(cur);
                  showitem(cur, curn);
                };
            case AMoveDown:
              clear_ff();
              if (cur->next)
                {
                  curn++;
                  cur = cur->next;
                  if (curn >= col * th)
                    {
                      curn--;
                      base = base->next;
                      showfilelist();
                    }
                  else
                    {
                      showitem(cur->prev, curn - 1);
                      showitem(cur, curn);
                    };
                };
              break;
            case ACmdDown:
              cmdl->press(XK_Down);
              break;
            case ACmdUp:
              cmdl->press(XK_Up);
              break;
            case AMoveUp:
              clear_ff();
              if (cur->prev != &dl)
                {
                  curn--;
                  cur = cur->prev;
                  if (curn < 0)
                    {
                      curn = 0;
                      base = base->prev;
                      showfilelist();
                    }
                  else
                    {
                      showitem(cur->next, curn + 1);
                      showitem(cur, curn);
                    };
                };
              break;
            case ACmdRight:
              cmdl->press(XK_Right);
              disable_modifiers = 1;
              evret = 0;
              break;
            case AMoveRight:
              clear_ff();
              right();
              break;
            case ACmdLeft:
              cmdl->press(XK_Left);
              disable_modifiers = 1;
              evret = 0;
              break;
            case AMoveLeft:
              clear_ff();
              left();
              break;
            case AInvertMask:
              ko = dl.next->next;
              while (ko != NULL)
                {
                  selected(ko);
                  ko = ko->next;
                };
              showfilelist();
              break;
            case ASelectMask:
              selectmask(this, 5);
              break;
            case ADeselectMask:
              selectmask(this, 6);
              break;
            case ARemountList:
              for (i = 0; i < mntmax; i++)
                panlist[i] = mnt[i];
              newpanel("Remount Device ?", mntmax, panmnt);
              break;
            case ARemount:
              remount();
              break;
            case AMan:
              newtextfile("Man page", this, 11);
              break;
            case AFDelete:
              clear_ff();
              del();
              break;
            case AFCopy:
              clear_ff();
              copy();
              break;
            case AFMove:
              clear_ff();
              move();
              break;
            case AQuit:
              donefunc();
              break;
            case APrint:
              initquery("Print file", this, panel2->vfs, 8);
              break;
            case AAttributes:
// *INDENT-OFF*        
                 if(selfiles==0) 
                   ::attrib(cur,7); 
                 else 
                   attrib2();
// *INDENT-ON*        


              break;
            case AKill:
              clear_ff();
              ps_info();
              break;
#ifdef NO_INTERNAL_VT
            case ARaise:
              if (lowfl)
                XRaiseWindow(disp, Main);
              else
                XLowerWindow(disp, Main);
              lowfl ^= 1;
              XFlush(disp);
              if (foc)
                cmdl->setpath(curdir);
              chdir(curdir);
              break;
#endif
            case AFNewEdit:
              clear_ff();
              newtextfile("New text file", this, 4);
              break;
            case AFEdit:
              vfs->ch_curdir();
              clear_ff();
              edit();
              break;
            case AFView:
              view(1);
              break;
            case AFSimpleView:
              view(0);
              break;
            case AMenu:
              menupanel(panexec2);
              break;
            case AMakeDir:
              vfs->ch_curdir();
              newtextfile("Make directory", this, 3);
              break;
            case ARereadDir:
              lastscan = 0;
              reread();
              break;
            case AFind:
              find_panel();
              break;
            case ADiskInfo:
              dfs_info(centerx * 2 - 40);
              break;
            case AQuickView:
              qview();
              break;
            case AMemory:
              free_info(centerx * 2 - 40);
              break;
            case ABookAdd:
              bmark->add_toempty_book(vfs->get_info_for_bookmark(), vfs->fstype);
              break;
            case ABook1:
              bmark->switch_books(0);
              break;
            case ABook2:
              bmark->switch_books(1);
              break;
            case ABook3:
              bmark->switch_books(2);
              break;
            case ABook4:
              bmark->switch_books(3);
              break;
            case ABook5:
              bmark->switch_books(4);
              break;
            case ABook6:
              bmark->switch_books(5);
              break;
            case ABook7:
              bmark->switch_books(6);
              break;
            case ABook8:
              bmark->switch_books(7);
              break;
            case ABook9:
              bmark->swap_books(8);
              break;
            case ADelBook:
              bmark->del_book(bmark->last_used);
              break;
            case AChown:
              init_chown_dialog(cur);
              break;
            case ACleanCache:
              try_clean_afs_cache();
              break;
#ifndef DISABLE_FTP
            case AFtpLink:
              create_ftp_link();
              break;
#endif
//    case ASwitchToTerm: raise_terminal_if_need();break;
            default:
              if ((ev.xkey.state & ControlMask) == 0)
                {
                  ks = XLookupKeysym(&ev.xkey, 0);
                  if ((ev.xkey.state & Mod1Mask) == 0)
                    cmdl->press(ks);
                  else
                    {
                      fast_find(&ev);
                      evret = 1;
                      break;
                    }
                };
              evret = 0;
            };
          break;
        }
    }
}
////////////////////////////////End of file/////////////////////////////////////////
