/****************************************************************************
*  Copyright (C) 1996-98 by Leo Khramov
*  email:   leo@unix1.jinr.dubna.su
* 
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
 ****************************************************************************/
#include "panel.h"
#include "scroll.h"
#include "ver.h"
#include "build.h"
#include "comp.h"
#include "image/image.h"
#include "au/key.h"
#include "bookmark.h"
#include "au/au_sup.h"
#include "ftpfs.h"
#include "internals.h"
#include "query_windows.h"
#include "ftpvisuals.h"
#include "xncversion.h"

char   ver[] = "X Northern Captain "XNCVERSION;

extern "C" void clean_exit();
extern Window main_win;

extern char *syspath;
extern Atom wmDeleteWindow;
char   dispstr[40] = "";
int    main_show = 1;
int    resize_done = 0;
int    mainuid, maingid;
extern int term_sticky;
BookMark *bmark;
Switcher *fsw1;
FtpVisual *fvis;

////////////////////////////////////Shared Memory routines////////////////////////
#include <sys/ipc.h>
#include <sys/shm.h>
#include <signal.h>

char   ivesrun[40];

#include "ives/ivestruct.h"

IVESid *sm;
char  *smem;
char  *umem;
int    pid, sid;

int    ives_initshare()
{
  int    key = 0x1976;
  pid = getpid();
  key += geteuid();
  sid = shmget(key, 1024, 0666 | IPC_CREAT | IPC_EXCL);
  while (sid == -1)
    {
      sid = shmget(key, 1024, 0666 | IPC_CREAT);
      if (sid != -1)
        {
          smem = shmat(sid, NULL, 0);
          sm = (IVESid *) smem;
          if (strcmp("IVES", sm->name) == 0)
            {
              umem = smem + sizeof(IVESid);
              fprintf(stderr, "OK\n");
              return 0;
            }
          else
            {
              shmdt(smem);
              key++;
              sid = shmget(key, 1024, 0666 | IPC_CREAT | IPC_EXCL);
            };
        }
      else
        key++;
    }
  shmdt(smem);
  shmctl(sid, IPC_RMID, NULL);
  fprintf(stderr, "failed\n");
  fprintf(stderr, "Runing IVES!\n");
  psystem(ivesrun);
  sleep(5);
  return 1;
}

void   ives_deinit()
{
  shmid_ds shm_info;
  if (strcmp(viewname, "internal") == 0 || strcmp(editname, "internal") == 0)
    {
      shmdt(smem);
      shmctl(sid, IPC_STAT, &shm_info);
      if (shm_info.shm_nattch == 0)
        shmctl(sid, IPC_RMID, NULL);
    }
}

int    is_ives(IVESid * s)
{
  int    uid = geteuid(), rr = 0, i;
  for (i = 0; i < s->maxent; i++)
    if (s->ivespid[i][1] == uid)
      if (((rr = kill(s->ivespid[i][0], SIGUSR2)) == 0) || (rr == -1 && errno != ESRCH))
        return s->ivespid[i][0];
  return -1;
}

extern "C" void psystem(char *);
void   sendtoives(char *name, int type, int ret = 0)
{
  int    ipid;
  while ((ipid = is_ives(sm)) == -1)
    {
      XBell(disp, 0);
      show_mes("Loading IVES", "   Please wait...");
      psystem(ivesrun);
      sleep(1);
      hide_mes();
    };
  while (sm->ready != 1)
    sleep(1);
  sm->ready = 0;
  sm->type = type;
  sm->autopid = getpid();
  sm->retval = ret;
  if (main_show)
    sm->focus_to = Main;
  else
    sm->focus_to = 0;
  if (name[0] != '/')
    {
      getcwd(umem, 255);
      strcat(umem, "/");
      strcat(umem, name);
    }
  else
    strcpy(umem, name);
  if (kill(ipid, SIGUSR1) == -1)
    fprintf(stderr, "XNC(%d): SIGUSR2 to IVES failed\n", getpid());
}


void   defret()
{
  if (panel->lay == 0)
    panel->panel2->reread();
  panel->reread();
// XSetInputFocus(disp,panel->w,RevertToNone,CurrentTime);
}

void   manret()
{
  char   tmps[200];
  strcpy(tmps, syspath);
  strcat(tmps, "/xnc.tmp");
  chdir(panel->curdir);
  unlink(tmps);
  defret();
}

void   extret()
{
  load_ext();
  defret();
}

void   menuret()
{
  load_menu();
  defret();
}

void   (*funcs[]) () =
{
  defret, manret, extret, menuret
};


void   sigusr(int)
{
  int    ret;
  if (sm->ready != 1)
    {
      ret = sm->retval;
      sm->ready = 1;
      funcs[ret] ();
    }
  signal(SIGUSR1, sigusr);
}

void   viewhighlight(char *name)
{
  sendtoives(name, 3, 1);
}

extern void init_chown_dialog(FList *);
void   dfs_info(int);
void   free_info(int);
void   find_panel(int);
void   p_info()
{
  panel->ps_info();
};
void   m_info()
{
  free_info(centerx * 2 - 40);
};
void   d_info()
{
  dfs_info(centerx * 2 - 40);
};
void   ownerfunc()
{
  init_chown_dialog(panel->cur);
};
void   findfunc()
{
  find_panel(centerx * 2 - 40);
};
extern int layout;
void   donefunc();
void   viewfunc();
void   editfunc();
void   copyfunc();
void   movefunc();
void   delfunc();
void   mkdirfunc();
void   remntfunc();
void   manfunc();
void   p1col1();
void   p1col2();
void   p1col3();
void   p2col1();
void   p2col2();
void   p2col3();
void   p2col4();
void   p1col4();
void   p1ext();
void   p2ext();
void   p1name();
void   p2name();
void   p1time();
void   p2time();
void   p1size();
void   p2size();
void   p1brief();
void   p2brief();
void   p1full();
void   p2full();
void   edit_ext();
void   edit_menu();
void   attrfunc();
void   menu_func();
void   try_clean_afs_cache();
void   show_hidden_files();
extern Viewer vw1;
extern Editor ew1;
MenuBar *emn;
MenuBar *ftpmn;
FList *node;

char   so1[11][25] =
{"PBrief", "pFull ", "pOne column", "PTwo columns", "pThree columns",
 "pFour columns ", "pSort by Names", "PSort by Extensions", "pSort by Size", "pSort by Time ", "FQuit"};

MenuItem subm1[] =
{
  so1[0], 5, p1brief, NULL,
  so1[1], 5, p1full, NULL,
  so1[2], 5, p1col1, NULL,
  so1[3], 5, p1col2, NULL,
  so1[4], 5, p1col3, NULL,
  so1[5], 5, p1col4, NULL,
  so1[6], 5, p1name, NULL,
  so1[7], 5, p1ext, NULL,
  so1[8], 5, p1size, NULL,
  so1[9], 5, p1time, NULL,
  so1[10], 2, donefunc, NULL
};
char   hidechr[] = "SShow hidden files";
MenuItem optmenu[] =
{
  "FEdit menu file", 5, edit_menu, NULL,
  "FEdit extension file ", 5, edit_ext, NULL,
  "FClean AFS cache ", 5, try_clean_afs_cache, NULL,
  hidechr, 5, show_hidden_files, NULL
};
char   so2[10][25] =
{"PBrief", "pFull ", "pOne column", "PTwo columns", "pThree columns",
 "pFour columns ", "pSort by Names", "PSort by Extensions", "pSort by Size", "pSort by Time"};
MenuItem subm2[] =
{
  so2[0], 5, p2brief, NULL,
  so2[1], 5, p2full, NULL,
  so2[2], 5, p2col1, NULL,
  so2[3], 5, p2col2, NULL,
  so2[4], 5, p2col3, NULL,
  so2[5], 5, p2col4, NULL,
  so2[6], 5, p2name, NULL,
  so2[7], 5, p2ext, NULL,
  so2[8], 5, p2size, NULL,
  so2[9], 5, p2time, NULL,
};
MenuItem submnu2[] =
{
  "FRemount current directory", 5, remntfunc, NULL,
  "FMenu", 5, menu_func, NULL,
  "FView file", 5, viewfunc, NULL,
  "FEdit file", 5, editfunc, NULL,
  "FCopy file", 5, copyfunc, NULL,
  "FMove/Rename file", 5, movefunc, NULL,
  "FMake directory", 5, mkdirfunc, NULL,
  "FDelete file", 5, delfunc, NULL,
  "FAttributes of file", 5, attrfunc, NULL,
  "FChange Owner", 5, ownerfunc, NULL,
  "FFind files", 5, findfunc, NULL,
  "FQuick ScanDir Info", 5, qview, NULL,
  "FProcesses Info", 5, p_info, NULL,
  "FMemory Info", 5, m_info, NULL,
  "FDisk Info", 5, d_info, NULL
};

Menu   submenu1(subm1, 11);
Menu   submenu2(subm2, 10);
Menu   submenu3(submnu2, 15);
Menu   submenu4(optmenu, 4);
MenuItem menu[] =
{"Left", 1, NULL, &submenu1,
 "Commands", 1, NULL, &submenu3,
 "Options", 1, NULL, &submenu4,
 "-Right", 3, NULL, &submenu2,
};

MenuItem ftpmenu[] =
{"FTP", 1, NULL, &submenu1};

MenuItem menu2[] =
{"1.Man", 5, manfunc, NULL,
 "2.Menu", 5, menu_func, NULL,
 "3.View", 5, viewfunc, NULL,
 "4.Edit", 5, editfunc, NULL,
 "5.Copy", 5, copyfunc, NULL,
 "6.Move", 5, movefunc, NULL,
 "7.Mkdir", 5, mkdirfunc, NULL,
 "8.Delete", 5, delfunc, NULL,
 "9.Attr", 5, attrfunc, NULL,
 "-0.Quit", 2, donefunc, NULL
};

void   fqok();
void   fqcan();


extern void menupanel(int (*)(int, char *));
extern int panexec2(int, char *);


void   menu_func()
{
  menupanel(panexec2);
}

Win    w1(300, 80, 200, 80, "Really, QUIT?", 5);
KEY    qok(10, 35, 80, 25, "Yes", 2, fqok);
KEY    qcan(110, 35, 80, 25, "Never", 1, fqcan);

void   donefunc()
{
  w1.link(&qok);
  qok.link(&qcan);
  qcan.link(&qok);
  qok.set_escapefunc(fqcan);
  qcan.set_escapefunc(fqcan);
  XMoveWindow(disp, w1.w, Mainl / 2 - 100, Mainh / 2 - 70);
  w1.show();
  qok.show();
  qcan.show();
}

void   attrfunc()
{
  panel->attrib();
}

void   fqok()
{
  qok.hide();
  qcan.hide();
  w1.hide();
  clean_exit();
  exit(0);
}

void   fqcan()
{
  qok.hide();
  qcan.hide();
  w1.hide();
  XSetInputFocus(disp, panel->w, RevertToParent, CurrentTime);
}

Lister *lst1;
Lister *lst2;
MenuBar *mn;
MenuBar *mn2;
Cmdline *cmdl;

void   show_hidden_files()
{
  hide_hidden ^= 1;
  panel->reread();
  if (panel->lay == 0)
    panel->panel2->reread();
}

void   p1brief()
{
  lst1->brief = 1;
  lst1->reread();
}

void   p2brief()
{
  lst2->brief = 1;
  lst2->reread();
}

void   p1full()
{
  lst1->brief = 0;
  p1col1();
}

void   p2full()
{
  lst2->brief = 0;
  p2col1();
}

void   p1ext()
{
  lst1->sortbyext();
}
void   p1name()
{
  lst1->sortbyname();
}

void   p1time()
{
  lst1->sortbytime();
}
void   p1size()
{
  lst1->sortbysize();
}

void   p2ext()
{
  lst2->sortbyext();
}
void   p2name()
{
  lst2->sortbyname();
}

void   p2time()
{
  lst2->sortbytime();
}
void   p2size()
{
  lst2->sortbysize();
}

void   p1col1()
{
  lst1->repanel(1);
  XClearWindow(disp, lst1->w);
  lst1->expose();
}

void   p1col2()
{
  lst1->repanel(2);
  XClearWindow(disp, lst1->w);
  lst1->expose();
}

void   p1col3()
{
  lst1->repanel(3);
  XClearWindow(disp, lst1->w);
  lst1->expose();
}

void   p2col1()
{
  lst2->repanel(1);
  XClearWindow(disp, lst2->w);
  lst2->expose();
}

void   p1col4()
{
  lst1->repanel(4);
  XClearWindow(disp, lst1->w);
  lst1->expose();
}

void   p2col4()
{
  lst2->repanel(4);
  XClearWindow(disp, lst2->w);
  lst2->expose();
}

void   p2col2()
{
  lst2->repanel(2);
  XClearWindow(disp, lst2->w);
  lst2->expose();
}

void   p2col3()
{
  lst2->repanel(3);
  XClearWindow(disp, lst2->w);
  lst2->expose();
}

void   editfunc()
{
  panel->edit();
}

void   viewfunc()
{
  panel->view(1);
}

void   viewload(char *cur)
{
  sendtoives(cur, 2);
}

void   viewonlyload(char *cur)
{
  sendtoives(cur, 4);
}

void   edit_ext()
{
  char   name[120];
  strcpy(name, getenv("HOME"));
  strcat(name, "/.xnc/.xnc.ext");
  if (strcmp(editname, "internal") == 0)
    sendtoives(name, 1, 2);
  else
    {
      tt_printf("%s %s\n", editname, name);
      panel->raise_terminal_if_need();
    }
}

void   edit_menu()
{
  char   name[120];
  strcpy(name, getenv("HOME"));
  strcat(name, "/.xnc/.xnc.menu");
  if (strcmp(editname, "internal") == 0)
    sendtoives(name, 1, 3);
  else
    {
      tt_printf("%s %s\n", editname, name);
      panel->raise_terminal_if_need();
    }
}

void   editload(char *cur)
{
  sendtoives(cur, 1);
}

void   copyfunc()
{
  panel->copy();
}

void   movefunc()
{
  panel->move();
}

void   delfunc()
{
  panel->del();
}

void   mkdirfunc()
{
  panel->mkdir();
}

void   remntfunc()
{
  panel->remount();
}

extern void newtextfile(char *, Lister *, int);
void   manfunc()
{
  newtextfile("Man page", panel, 11);
}

void   XEVENT()
{
};
int    evret;
int    iii = 0;
extern int focus_fl;
int    resize_done2 = 0;
extern int just_at_startup;
int    Main_x = -1, Main_y = -1;
int    XEVENT(XEvent * event)
{
  Gui   *o;
  int    fiflg = 1;
  ev = *event;
  evret = 1;
  if (just_at_startup == 2 && ev.xany.window == Main)
    {
      XSetInputFocus(disp, panel->w, RevertToParent, CurrentTime);
      just_at_startup = 0;
      return 1;
    };
  if (ev.xany.window != Main)
    {
      if (ev.type == Expose)
        {
/*    if(ev.xexpose.count==0)
   { */
          o = findexp(ev.xany.window);
          if (o)
            o->click();
          else
            return 0;
/*   } else return 0; */
        }
      else
        {
          o = find(ev.xany.window);
/*    if(o==panel && ev.type==FocusIn) fprintf(stderr,"%2d:focus  Panel %X\n",iii++,o);
   if(o==panel->panel2 && ev.type==FocusIn) fprintf(stderr,"%2d:focus  Panel2 %X\n",iii++,o); */
          if (ev.type == FocusIn)
            {
              if (o == panel->panel2)
                {
                  XSetInputFocus(disp, panel->w, RevertToParent, CurrentTime);
                  return 0;
                }
              else if (o != NULL)
                o->click();
              else
                return 0;
            }
          else if (o)
            o->click();
          else
            return 0;
        }
    }
  else if (ev.type == FocusIn)
    {
      focus_fl = 1;
      if (XPending(disp))
        {
          XPeekEvent(disp, &ev);
          if (ev.type == FocusIn)
            {
              XNextEvent(disp, &ev);
              return XEVENT(&ev);
            }
          else
            XSetInputFocus(disp, panel->w, RevertToParent, CurrentTime);
        }
      else
        XSetInputFocus(disp, panel->w, RevertToParent, CurrentTime);
    }
  else if (ev.type == Expose && fiflg == 1 && focus_fl)
    {
      XSetInputFocus(disp, panel->w, RevertToParent, CurrentTime);
      fiflg = 0;
    }
  else if (ev.type == ClientMessage)
    {
      if (ev.xclient.format == 32 && ev.xclient.data.l[0] == wmDeleteWindow)
        donefunc();
    }
  else if (ev.type == MapNotify)
    main_show = 1;
  else if (ev.type == UnmapNotify)
    main_show = 0;
  else if (ev.type == ConfigureNotify)
    {                                //1

      if (Mainl != ev.xconfigure.width || Mainh != ev.xconfigure.height)
        {                        //2

          Mainl = ev.xconfigure.width;
          Mainh = ev.xconfigure.height;
          mn->reconfigure(0, 0, Mainl-20, 20);
          mn2->reconfigure(0, Mainh - 20, Mainl, 20);
          cmdl->reconfigure(0, Mainh - 43, Mainl, 20);
          fsw1->reconfigure(Mainl-20,0,20,20);
          centerx = Mainl / 2;
          centery = Mainh / 2;
          bmark->reconfigure(0, 20, Mainl, Mainh - 63);
          if (term_sticky && resize_done2 == 0)
            {
              XResizeWindow(disp, main_win, Mainl, Mainh);
              resize_done = 1;
            };
          resize_done2 = 0;
        }
      else if (ev.xconfigure.x != Main_x || ev.xconfigure.y != Main_y)
        {
          Main_x = Mainx = ev.xconfigure.x;
          Main_y = Mainy = ev.xconfigure.y;
          {
            if (term_sticky && resize_done2 == 0 && just_at_startup == 0)        //-2,2

              {
                XMoveWindow(disp, main_win, ev.xconfigure.x, ev.xconfigure.y);        //3

                resize_done = 1;
              };                //-3

            resize_done2 = 0;
          };
        };
    };
  return evret;
}
extern "C" void tt_printf(char *f,...);
extern char shdir[];
void   xnc_sdir()
{
  tt_printf("cd '%s'\n", panel->curdir);
  strcpy(shdir, panel->curdir);
}

void   sig_fault(int)
{
  fprintf(stderr, "\n\n*******************************************************************************\n");
  fprintf(stderr, "OOPS! It seems that You found a bug in XNC!!!\n");
  fprintf(stderr, "If You can repeat this situation then send me a bug report\n");
  fprintf(stderr, "to <leo@unix1.jinr.dubna.su> with subject  'XNC - bug report'\n");
  fprintf(stderr, "Body of mail:\n");
  fprintf(stderr, "   -What are You doing to produce this bug.\n"
          "   -XNC configuration (~/.xnc/.xnc.ini) file.\n"
          "   -Output of 'ldd xnc' command.\n"
          "   -X Server configuration (resolution and color depth)\n");
  fprintf(stderr, "   -And Your reply mail address, for more information about situation if need\n");
  fprintf(stderr, "Do NOT include 'CORE' dump file in the following letter.\nThanks, and sorry for BUG\n");
  fprintf(stderr, "*******************************************************************************\n");
  chdir("/core");
}


void   xnc_main(int argc, char **argv)
{
  int    i;
  signal(SIGSEGV, sig_fault);
  fprintf(stderr, "Initialisation:\n");
  margc = argc;
  margv = argv;
  InitXClient(argc, argv, 15, 70, 740, 455, ver);
  init_imagengine();
  show_intro();
  fprintf(stderr, "Connecting to IVE System.................");
  if (strcmp(viewname, "internal") != 0 && strcmp(editname, "internal") != 0)
    fprintf(stderr, "using externals\n");
  else
    {
      strcpy(ivesrun, "ives ");
      if (argc > 1)
        {
          i = 1;
          while (i < argc - 1)
            if (strcmp(argv[i], "-d") == 0 || strcmp(argv[i], "-display") == 0)
              {
                strcat(ivesrun, argv[i]);
                strcat(ivesrun, " ");
                strcat(ivesrun, argv[i + 1]);
                strcpy(dispstr, argv[i + 1]);
                break;
              }
            else
              i++;
        }
      if (ives_initshare())
        ives_initshare();
    }
  compile_key_support();
  compile_AFS_supports(".xnc.afs");
  init_ftp_globals();
  create_dnd_cursors();
  fprintf(stderr, "Loading Pixmaps.");
  load_pixmaps();
  bmark = new BookMark(35, Mainh - 63);
  bmark->load_flags(7);
  fprintf(stderr, "OK\n");
  hide_intro();
}

void   xnc_exit();

void   xnc_sig()
{
  signal(SIGUSR1, sigusr);
  signal(SIGSEGV, sig_fault);
  qv_signal();
}

extern AFS afstmp;
void   xnc_gofunc()
{
  XMapWindow(disp, Main);
  mainuid = getuid();
  maingid = getgid();
  init_scroll();
  init_qview();
  mn = new MenuBar(0, 0, menu, 4);
  mn2 = new MenuBar(0, Mainh - 20, menu2, 10);
  emn = new MenuBar(0, viewh - 20, NULL, 4);
  cmdl = new Cmdline(0, Mainh - 43, Mainl, 6);
  fsw1= new Switcher(Mainl-20,0,20,20);
  fvis= new FtpVisual(0,0,Mainl-20,20);
  mn->substract_from_l(20);
  mn->init(Main);
  fvis->init(Main);
  mn2->init(Main);
  bmark->init(Main);
  fsw1->init(Main);
  fsw1->add_gui(mn);
#ifndef DISABLE_FTP
  fsw1->add_gui(fvis);
#endif
  bmark->create_listers(&lst1, &lst2);
  lst1->init(Main);
  lst2->init(Main);
  cmdl->init(Main);
  w1.init(Main);
  qok.init(w1.w);
  qcan.init(w1.w);
  lst1->setviewer(viewload, viewonlyload);
  lst2->setviewer(viewload, viewonlyload);
  lst1->seteditor(editload);
  lst2->seteditor(editload);
  fprintf(stderr, "Last version :  %s\n", created);
  fprintf(stderr, "Code compiled : %s\n", compiled);
  load_cfg(lst1, lst2);
  bmark->rebuild_listers();
  lst1->show();
  lst2->show();
  mn->show();
  mn2->show();
  cmdl->show();
  fsw1->show();
  lst1->setpanel(lst2);
  lst2->setpanel(lst1);
  lst1->setcmdl(cmdl);
  lst2->setcmdl(cmdl);
  lst1->setsubmenu(&submenu1);
  lst2->setsubmenu(&submenu2);
  cmdl->setpath(panel->curdir);
  bmark->show();
  afstmp.set_dir_pointer(NULL, 1024);
  wmDeleteWindow = XInternAtom(disp, "WM_DELETE_WINDOW", False);
  XSetWMProtocols(disp, Main, &wmDeleteWindow, 1);
  fprintf(stderr, "Copyright (c) 1995-98 Leonid V. KHramov aka Leo <leo@unix1.jinr.dubna.su>\n");
}

void   xnc_animate()
{
  bmark->animate();
}

void   (*xnc_init) (int, char **) = xnc_main;
void   (*xnc_go) () = xnc_gofunc;
void   (*xnc_setsignals) () = xnc_sig;
void   (*xnc_setdir) () = xnc_sdir;
void   (*xnc_work_anim) () = xnc_animate;
int    (*xnc_look_for_key) (XEvent *) = look_for_key;
int    (*xnc_event) (XEvent *) = XEVENT;

int    xnc_ex = 1;
void   xnc_exit()
{
  char  *str;
  if (xnc_ex)
    {
      xnc_ex = 0;
      fprintf(stderr, "Exiting from XNC....");
      if (lst1 == NULL)
        {
          disp = NULL;
          fprintf(stderr, "OK\nSession aborted\n");
          return;
        };
      save_cfg(lst1, lst2);
      deinit_all_ftp();
      delete lst1;
      delete lst2;
      delete mn;
      delete mn2;
      delete cmdl;
      if (disp)
        {
          x_free_pixmaps();
        }
      str = new char[2048];
      sprintf(str, "rm -rf %s/.%d.*", syspath, getpid());
      psystem(str);
      sprintf(str, "rm -rf %s/AFS/afs.%d.*", syspath, getpid());
      psystem(str);
      delete str;
      deinit_scroll();
      ives_deinit();
      deinit_keysupport();
      deinit_AFS_supports();
      fprintf(stderr, "OK\n");
      DeinitXClient();
    }
}
void   (*xnc_kill) () = xnc_exit;
