/****************************************************************************
*  Copyright (C) 1996-98 by Leo Khramov
*  email:     leo@unix1.jinr.dubna.su
*  
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
 ****************************************************************************/
#include "infowin.h"
#include "panel.h"

//This file contains InfoWin class functions.
//InfoWin class used for showing file information 
//while copying/moving/deleting files.

///////////////////////////////////InfoWin class///////////////////////////////

void   InfoWin::init(Window ipar)
{
  int    tw;
  parent = ipar;
  w = XCreateSimpleWindow(disp, parent, x, y, l, h, 0, 0, keyscol[1]);
  gcv.background = keyscol[1];
  gcv.font = fontstr->fid;
  gcw = XCreateGC(disp, w, GCBackground | GCFont, &gcv);
  XSelectInput(disp, w, ExposureMask | ButtonPressMask | ButtonReleaseMask);
  tl = strlen(name);
  tw = XTextWidth(fontstr, name, tl);
  if (l < tw + 40)
    l = tw + 40;
  ty = (21 + fontstr->max_bounds.ascent - fontstr->max_bounds.descent) / 2;
  prflg = 0;
  bgbit=0;
  if(need_key)
  {
  bgkey=new KEY(-10,-10,40,20,"to BG",1,NULL);
  bgkey->init(w);
  bgkey->link(bgkey);
  bgkey->guiobj=this;
  }
}

void   InfoWin::expose()
{
  XSetForeground(disp, gcw, keyscol[2]);
  XDrawLine(disp, w, gcw, 0, 0, l, 0);
  XDrawLine(disp, w, gcw, 0, 0, 0, h);
  XDrawLine(disp, w, gcw, 1, 1, l - 1, 1);
  XDrawLine(disp, w, gcw, 1, 1, 1, h - 1);
  XDrawLine(disp, w, gcw, 1, 21, l - 1, 21);
  XDrawLine(disp, w, gcw, 21, 2, 21, 20);
  XSetForeground(disp, gcw, keyscol[0]);
  XDrawLine(disp, w, gcw, 0, h - 1, l, h - 1);
  XDrawLine(disp, w, gcw, l - 1, 0, l - 1, h);
  XDrawLine(disp, w, gcw, 1, h - 2, l - 1, h - 2);
  XDrawLine(disp, w, gcw, l - 2, 1, l - 2, h - 1);
  XDrawLine(disp, w, gcw, 2, 20, l - 2, 20);
  XDrawLine(disp, w, gcw, 20, 2, 20, 20);
  XSetForeground(disp, gcw, cols[0]);
  XDrawString(disp, w, gcw, 25, ty + 1, name, tl);
  XDrawString(disp, w, gcw, 6, ty + 2, "X", 1);
  XSetForeground(disp, gcw, cols[col]);
  XDrawString(disp, w, gcw, 24, ty, name, tl);
  XSetForeground(disp, gcw, cols[2]);
  XDrawString(disp, w, gcw, 4, ty, "X", 1);
  XDrawString(disp, w, gcw, 5, ty + 1, "X", 1);
  expose_clip_area(); 
  if (ffl)
    {
      if (next)
        if (next->foc == 0 && next->w != w)
          XSetInputFocus(disp, next->w, RevertToNone, CurrentTime);
        else if (next->next)
          XSetInputFocus(disp, next->next->w, RevertToNone, CurrentTime);
      ffl = 0;
    }
  if (next)
    if (next->w == w)
      next->expose();
  if (guiexpose)
    guiexpose->expose();
}

void InfoWin::expose_clip_area()
{
  int textl;
  if(shown)
  {
          XSetForeground(disp, gcw, keyscol[1]);
          if(fullcoun)
          {
                  XFillRectangle(disp, w, gcw, 2, 30, l-4, 30);
                  XSetForeground(disp, gcw, cols[1]);
                  textl=strlen(message);
                  XDrawString(disp, w, gcw, l / 2 - XTextWidth(fontstr, message, textl) / 2, 45, message, textl);
                  prect(w, gcw, 10, h-25, l-20, 10);
                  XSetForeground(disp,gcw,cols[4]);
                  XFillRectangle(disp, w, gcw, 12, h-23, (l-24)*currentcoun/fullcoun,6);
          } else
          {
                  XFillRectangle(disp, w, gcw, 2, 40, l-4, 30);
                  XSetForeground(disp, gcw, cols[1]);
                  textl=strlen(message);
                  XDrawString(disp, w, gcw, l / 2 - XTextWidth(fontstr, message, textl) / 2, need_key ? 45 : 55, message, textl);
          }
  }
}

void   InfoWin::update_coun(int delta)
{
 currentcoun+=delta;
 if(currentcoun<0)
         currentcoun=0;
 else if(currentcoun>fullcoun)
                 currentcoun=fullcoun;
 expose_clip_area();
 XFlush(disp);
}

void InfoWin::set_coun(int fullcounter)
{
  fullcoun=fullcounter;
  currentcoun=0;
  expose_clip_area();
  XFlush(disp);
}

void   InfoWin::click()
{
  if (ev.xany.window == w)
    {
      switch (ev.type)
        {
        case Expose:
          expose();
          break;
        case ButtonPress:
          if (hflg)
            if (ev.xbutton.x < 21 && ev.xbutton.y < 21)
              {
                XSetForeground(disp, gcw, keyscol[2]);
                XDrawLine(disp, w, gcw, 1, 20, 20, 20);
                XDrawLine(disp, w, gcw, 20, 2, 20, 20);
                XSetForeground(disp, gcw, keyscol[0]);
                XDrawLine(disp, w, gcw, 2, 2, 20, 2);
                XDrawLine(disp, w, gcw, 2, 2, 2, 20);
                prflg = 1;
              };
          break;
        case ButtonRelease:
          if (prflg)
            {
              prflg = 0;
              if (escape_func)
                escape_func();
            };
          break;
        };
    }
}

void   InfoWin::show()
{
  if(shown==0)
  {
          oldel = el.next;
          el.next = NULL;
          if(x!=centerx-l/2 || y!=centery-h/2)
          {
                  x=centerx-l/2;
                  y=centery-h/2;
                  XMoveWindow(disp,w,x,y);
          }
          XMapRaised(disp, w);
          addto_el(this, w);
          ffl = 1;
          shown=1;
          if(need_key)
                  bgkey->show();
  }
}

void   InfoWin::set_message(char* msg)
{
 strcpy(message, msg);
 expose_clip_area();
}

void   InfoWin::hide()
{
  if(shown)
  {
          if(need_key)
                  bgkey->hide();
          delall_el();
          delfrom_exp(this);
          el.next = oldel;
          XUnmapWindow(disp, w);
          shown=fullcoun=0;
  }
}

void   InfoWin::guifunc(Gui * o, int nu,...)
{
        bgbit=1;
}

//Global InfoWin object. Listers fcopy/fmove/fdelete make calls to it.
InfoWin *infowin=NULL;

void   create_infowin(char *head)
{
  if (infowin == NULL)
    {
      infowin = new InfoWin(10, 50, 290, 85, head, 5);
      infowin->init(Main);
      infowin->show();
      infowin->expose();
      XFlush(disp);
    }
}

void   create_ftp_infowin(char *head)
{
  if (infowin == NULL)
    {
      infowin = new InfoWin(10, 50, 290, 85, head, 5, 1);
      infowin->init(Main);
      infowin->show();
      infowin->expose();
      XFlush(disp);
    }
}

void   del_infowin()
{
  if (infowin == NULL)
          return;
  infowin->hide();
  delete infowin;
  XFlush(disp);
  infowin = NULL;
  if (panel)
    XSetInputFocus(disp, panel->w, RevertToNone, CurrentTime);
}

void   to_infowin(char *str)
{
  if (infowin == NULL)
          return;
  infowin->set_message(str);
  XFlush(disp);
}

void   to_infowin_lastused()
{
  if (infowin == NULL)
          return;
  infowin->expose_clip_area();
  XFlush(disp);
}

