#ifndef GUI_H
#define GUI_H
#include <X11/cursorfont.h>
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "types.h"

#define FLIST_NAME        160

class Gui
{
 public:
  int foc;
  Gui *next,*prev,*guiobj;
  Window w,parent;
  GC gcw;
  short int guitype;
  Gui() {next=prev=NULL;foc=0;guiobj=NULL;};
  virtual void expose() {};
  virtual void click()=0;
  virtual void show();
  virtual void hide();
  virtual void init(Window) {};
  virtual void link(Gui *o) {next=o;o->prev=this;};
  virtual void scrollup(Gui*) {};
  virtual void scrolldown(Gui*) {};
  virtual void scroll(Gui*) {};
  virtual void scrolling(Gui*) {};
  virtual void guifunc(Gui*,int,...) {};
};

extern Gui *focobj;

class KEY: public Gui
{
  void (*func)();
 public:
  int x,y,prflg,tx,ty,hflg,dflg;
  uint l,h,tl;
  ulong col;
  char *name;
  void (*escfunc)();
  KEY(int ix,int iy,int il,int ih,char *iname,ulong icol,void (*ifunc)());
  ~KEY() {if(disp) XFreeGC(disp,gcw);hflg=0;dflg=0;};
  void set_escapefunc(void (*v)()) {escfunc=v;};
  virtual void init(Window ipar);
  virtual void expose();
  virtual void click();
  void press();
};         

class ScrollBar;

class Panel: public Gui
{
  int (*func)(int,char*);
 public:
  int x,y,prflg,tx,ty,hflg,max,base,cur,vh;
  uint l,h,tl;
  ulong col;
  char **names;
  void (*canfunc)();
  void (*keyfunc)(KeySym,Panel*);
  ScrollBar *scr;
  int dbtime;
  int lmx,lmy,bclk;
  Panel(int ix,int iy,int il,int ih,char **iname,int imax,ulong icol,int (*ifunc)(int,char*));
  ~Panel() {if(disp) XFreeGC(disp,gcw);hflg=0;};
  void setkeyfunc(void (*ik)(KeySym,Panel*)) {keyfunc=ik;}
  virtual void init(Window ipar);
  virtual void expose();
  virtual void click();
  virtual void show();
  virtual void hide();
  virtual void scroll(Gui*);
  virtual void scrollup(Gui* o) {scroll(o);};
  virtual void scrolling(Gui* o) {scroll(o);};
  virtual void scrolldown(Gui* o) {scroll(o);};
  void shownames();
  void reset_list();
  void showcurs(int=1);
  void escfunc(void (*ecanfunc)()) {canfunc=ecanfunc;};
  void add_element(char*);
  void find_and_set(char*);
  void activate_function();
};

class Sw_panel;

class Switch: public Gui
{
  void (*func)();
 public:
  int x,y,prflg,tx,ty,hflg,sw,excl;
  uint l,h,tl;
  ulong col;
  char *name;
  Pixmap gl;
  Sw_panel *sp;
  int disable;

  Switch(int ix,int iy,int il,char *iname,ulong icol,void (*ifunc)()=NULL);
  ~Switch() {if(disp){ XFreeGC(disp,gcw);XFreePixmap(disp,gl);hflg=0;};};
  virtual void init(Window ipar);
  virtual void expose();
  virtual void click();
  void press();
  void select();
  void setexcl() {excl=1;};
  void setpanel(Sw_panel* isp) {sp=isp;};
  void set_disable(int i) {disable=i;};
};

struct MenuItem;

class Sw_panel: public Gui
{
  int max;
  MenuItem *smn;
 public:
  Switch **ar;
  int x,y,l,h,ty,tx,shown,initfl,columns,columnl;
  char *head;
  
  Sw_panel(int ix,int iy,int il,char *ihead,MenuItem* mn,int imax, int icolumn=1);
  ~Sw_panel();
  virtual void init(Window ipar);
  virtual void expose();
  virtual void click();
  virtual void show();
  virtual void hide();
  virtual void link(Gui*);
  void set(int n,int s);
  void excl();
  int get(int n) {return ar[n]->sw;};
  void reaction(Switch*);
};

struct List;

class Win:public Gui
{
 public:
  int x,y,ty,ffl;
  uint l,h,tl;
  int col,prflg,hflg;
  char *name;
  List *oldel;
  Gui *guiexpose;
  void (*escape_func)();
  Win(int ix,int iy,int il,int ih,char *iname,int icol,int hfl=0):Gui()
   {x=ix;y=iy;l=il;h=ih;col=icol;name=iname;hflg=hfl;guitype=1;guiexpose=NULL;escape_func=NULL;};
  ~Win() {if(disp){XFreeGC(disp,gcw);XDestroyWindow(disp,w);};};
  virtual void init(Window);
  virtual void show();
  virtual void hide();
  virtual void click();
  virtual void expose();
  void nonresizable();
  void add_toexpose(Gui* ex) {guiexpose=ex;};
  void set_escapefunc(void (*v)()) {escape_func=v;hflg=1;};
};

class Separator:public Gui
{
  public:
   int x,y,l;
   Gui *win;
   Separator(int ix,int iy,int il,Gui *ww) : Gui() {x=ix;y=iy;l=il;win=ww;guitype=2;};
   virtual void init(Window) {w=win->w;gcw=win->gcw;};
   virtual void show() {}; 
   virtual void hide() {};
   virtual void click();
   virtual void expose();
};

struct FList
{
 FList *next,*prev;
 char name[FLIST_NAME];
 unsigned int mode;
 int size,gid,uid;
 time_t time;
 char chr_time[17];                // DD.MM.YY/HH:MM
 int        options;
 FList *link;
 FList() {prev=next=link=NULL;mode=0;name[0]=0;size=0;options=0;};
 FList(char *iname,int imode=0,int is=0,int iuid=0,int igid=0,time_t t=0);
 void init(char *iname,int imode=0,int is=0,int iuid=0,int igid=0,time_t t=0);
// ~FList() {if(name && *name!=0) delete name;};
 void add(FList*);
 void out();
};

#define S_FList        sizeof(FList)

class Viewer:public Gui
{
 public:
  uint l,h;
  int x,y;
  GC gct;
  int ty,ffl,tx,cx,cy,row,highlight,unmap,totallines;
  uint tl;
  int col,prflg,hflg,base,vish,visl,cbase,sl,nn,n,hex,tab,stx,koi;
  char *name;
  char *buf;
  char findbuf[255];
  List *oldel;
  FList *node;
  ScrollBar *scr;
  void (*endfunc)(Viewer*);
  void (*swfunc)(Viewer*);
  void (*external_reconfigure)(Viewer*,int,int,int,int);
  Viewer(int ix,int iy,int il,int ih,
         char *iname,int icol,void(*ff)(Viewer*)=NULL):Gui()
   {x=ix;y=iy;l=il;h=ih;col=icol;name=iname;unmap=0;hflg=0;buf=NULL;guitype=3;
     endfunc=ff;findbuf[0]=0;swfunc=NULL;external_reconfigure=NULL;};
  ~Viewer() {if(disp) {XFreeGC(disp,gcw);XFreeGC(disp,gct);};};
  virtual void init(Window);
  virtual void show();
  virtual void hide();
  virtual void click();
  virtual void expose();
  virtual void scroll(Gui*);
  virtual void scrolling(Gui*);
  virtual void scrollup(Gui*);
  virtual void scrolldown(Gui*);
  void view(FList*);
  char* scanlines();
  void viewmem(FList*,char*);
  void showhexfile();
  void showasc();
  void back();
  void hexoff();
  void rusconvert();
  void reconfigure(int,int);
  void set_external_reconfigure(void (*reconf)(Viewer*,int,int,int,int)) {external_reconfigure=reconf;};
  void wrusconvert();
  void linenum();
  void showcurs(int=1);
  void setswfunc(void (*ff)(Viewer*)) {swfunc=ff;};
  int pagedown(int);
  void info();
  void insert(KeySym*);
  void line(int);
  void save();
  void func(int);
  void hex_asc();
  void find();
};

class Editor:public Gui
{
 public:
  uint l,h;
  int x,y;
  GC gct;
  ScrollBar *scr;
  int ty,ffl,tx,cx,cy,row,dx,bw,ent,dos,koi,rmode;
  int *xl;
  int *chl;
  uint tl;
  int col,prflg,hflg,base,vish,visl,stx,maxr,mod,highe,highb,unmap;
  char *name;
  char **buf;
  char fname[255];
  char findbuf[255];
  List *oldel;
  FList *node;
  void (*endfunc)(Editor*);
  void (*swfunc)(Editor*);
  void (*external_reconfigure)(Editor*,int,int,int,int);
  Editor(int ix,int iy,int il,int ih,
         char *iname,int icol,void(*ff)(Editor*)=NULL):Gui()
   {x=ix;y=iy;l=il;h=ih;col=icol;name=iname;mod=unmap=0;hflg=0;guitype=4;
    endfunc=ff;findbuf[0]=0;swfunc=NULL;external_reconfigure=NULL;};
  ~Editor() {if(disp){XFreeGC(disp,gcw);XFreeGC(disp,gct);XDestroyWindow(disp,w);};};
  virtual void init(Window);
  virtual void show();
  virtual void hide();
  virtual void click();
  virtual void expose();
  virtual void scroll(Gui*);
  virtual void scrolling(Gui*);
  virtual void scrollup(Gui*);
  virtual void scrolldown(Gui*);
  char trans(int mode,char sym);
  void set_external_reconfigure(void (*reconf)(Editor*,int,int,int,int)) {external_reconfigure=reconf;};
  void setswfunc(void (*ff)(Editor*)) {swfunc=ff;};
  void load(FList*);
  void newfile(FList*);
  void view();
  void showcurs(int=1);
  void showline(int);
  int calclen(int,int);
  void do_convertion();
  void do_wconvertion();
  void pageup();
  void pagedown();
  void rusconvert();
  void reconfigure(int,int);
  void wrusconvert();
  void info();
  void xyinfo();
  void back();
  void backln();
  void delln(int);
  void insertln();
  void insert(char);
  void insspace();
  void insempty(int);
  void func(int);
  int   save();
  void find();
  void find_brackets();
  void reverse_find_bracket();
  void ssave();
  void sfind();
  void copy();
  void paste();
  void cut();
  void del();
  void sgoto();
  void gotoln();
  void exit_and_save();
};

class SpecialWin:public Gui
{
 public:
  int x,y,ty,ffl;
  uint l,h,tl;
  int col,prflg,hflg,nn,al;
  char *name;
  Pixmap pm1;
  SpecialWin(int ix,int iy):Gui()
   {x=ix;y=iy;guitype=5;};
  ~SpecialWin() {if(disp) {XFreePixmap(disp,pm1);XFreeGC(disp,gcw);};};
  virtual void init(Window);
  virtual void show();
  virtual void hide();
  virtual void click();
  virtual void expose();
  void nextpiece();
  void initroute(FList *,int);
};

class Cmdline:public Gui
{
 public:
  int x,y,ty,bbp,bp;
  uint l,h,tl,tw,bl;
  int col,hflg,cp,ll,el;
  char name[1024];
  char buf[256];
  char bak[10][256];
  Cmdline(int ix,int iy,int il,int icol):Gui()
   {x=ix;y=iy;l=il;col=icol;name[0]=0;tl=0;cp=0;bl=0;buf[0]=0;el=255;guitype=6;};
  ~Cmdline() {if(disp) XFreeGC(disp,gcw);};
  void setpath(char*);
  void press(int);
  void showbuf();
  void flush();
  void insert(char);
  void reconfigure(int ix,int iy,int il,int ih);
  void backup();
  void look_for_cd();
  virtual void init(Window);
  virtual void show();
  virtual void hide();
  virtual void click();
  virtual void expose();
};

class Input:public Gui
{
  void (*func)();
 public:
  int x,y,ty;
  uint l,h,dl,bl;
  int col,hflg,cp,ll,tl,el,firstfl;
  char *buf;
  void (*escfunc)();
  Input(int ix,int iy,int il,int icol,void (*ifunc)()=NULL):Gui()
   {x=ix;y=iy;l=il;col=icol;tl=0;cp=0;bl=0;el=255;func=ifunc;escfunc=NULL;guitype=7;};
  ~Input() {if(disp) XFreeGC(disp,gcw);};
  void press();
  void showbuf();
  void flush();
  void insert(char);
  void set_escapefunc(void (*esc)()) {escfunc=esc;};
  void setbuf(char *ibuf,int nn) {buf=ibuf;el=nn;cp=0;bl=strlen(buf);dl=0;};
  virtual void init(Window);
  virtual void click();
  virtual void expose();
};

class Text:public Gui
{
 public:
  int x,y;
  uint l,h,tl;
  int col;
  char *name;
  Text(int ix,int iy,char *iname,int icol):Gui()
   {x=ix;y=iy;col=icol;name=iname;guitype=8;};
  ~Text() {if(disp) XFreeGC(disp,gcw);};
  void recalc();
  virtual void init(Window);
  virtual void show();
  virtual void hide();
  virtual void click();
  virtual void expose();
};

class WText:public Gui
{
 public:
  int x,y,ty;
  uint l,h,tl,tx;
  int col,centered;
  char *name;
  WText(int ix,int iy,int il,char *iname,int icol):Gui()
   {x=ix;y=iy;col=icol;l=il;h=18;name=iname;guitype=18;centered=1;};
  ~WText() {if(disp) XFreeGC(disp,gcw);};
  void recalc();
  virtual void init(Window);
  virtual void show();
  virtual void hide();
  virtual void click();
  virtual void expose();
};

const unsigned menuh=20;
class Menu;
struct MenuItem
{
 char *name;
 ulong col;
 void (*func)();
 Menu *o;
};

class MenuBar:public Gui
{
  int *dx;
  int *tl;
  int *dl;
  MenuItem *items;
  int x,y,l,max,ty,cur,prflg,enx,stx,deltal;
 public:
  
  MenuBar(int ix,int iy,MenuItem *ii,int maxi):Gui() 
    {x=ix;y=iy;max=maxi;items=ii;dx=new int[max];tl=new int[max];dl=new int[max];guitype=9;deltal=0;};
  virtual ~MenuBar() {delete dx;delete tl;delete dl;if(disp) XFreeGC(disp,gcw);};
  virtual void init(Window);
  virtual void expose();
  virtual void click();
  void showitem(int);
  void reconfigure(int ix,int iy,int pl,int ph);
  void pressitem(int);
  Menu* getmenu() {return items[cur].o;};
  void substract_from_l(int dd) {deltal=dd;};
};

const unsigned mitemh=20;  
class Menu:public Gui
{
  int *dx;
  int *tl;
  int *dl;
  MenuItem *items;
  Pixmap xpm;
  List *oldel;
 public:
  int x,y,l,max,ty,cur,prflg,shflg,actfl;
  uint h;
  
  Menu(MenuItem *ii,int maxi) :Gui()
    {max=maxi;h=max*mitemh+6;items=ii;shflg=0;tl=new int[max];guitype=10;
     for(int i=0;i<max;i++)
       tl[i]=strlen(items[i].name);
    };
  virtual ~Menu() {delete tl;};
  virtual void init(Window);
  virtual void expose();
  virtual void click();
  virtual void show();
  virtual void hide();
  void showitem(int);
  void select(int);
  void setpos(int ix,int iy) {x=ix;y=iy;};
  int is_shown() {return shflg;};
  int is_active() {return actfl;};
  void switches();
  void set(int i) {cur=i;switches();};
};

extern void delay(int usec);
extern int (*compare)(char*,int,int,char*,int,int);
extern char *getext(char* str);
extern int extcmp(char *str1,int aa1,int aa2,char*str2,int aa3,int aa4);
extern int mystrcmp(char *str1,int aa1,int aa2,char*str2,int aa3,int aa4);
extern int sizecmp(char *str1,int aa1,int aa2,char*str2,int aa3,int aa4);
extern int timecmp(char *str1,int aa1,int aa2,char*str2,int aa3,int aa4);
extern void prect(Window w, GC & gcw, int x, int y, int l, int h);
extern void urect(Window w, GC & gcw, int x, int y, int l, int h);

#endif
///////////////////////////////////////End of file///////////////////////////////////////////