/****************************************************************************
*  Copyright (C) 1997 by Leo Khramov
*  email:   leo@pop.convey.ru
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
 ****************************************************************************/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <signal.h>
#include <string.h>
#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif

#include "ives/ivestruct.h"

struct IVESid *sm;
char  *smem;
char  *umem;
int    pid, sid, parpid;

int    is_ives(struct IVESid *s)
{
  int    uid = geteuid(), rr = 0, i;
  for (i = 0; i < s->maxent; i++)
    if (s->ivespid[i][1] == uid)
      if (((rr = kill(s->ivespid[i][0], SIGUSR2)) == 0) || (rr == -1 && errno != ESRCH))
	return s->ivespid[i][0];
  return -1;
}


int    ivpid;
void   ives_initshare()
{
  int    key = 0x1976;
  pid = getpid();
  key += geteuid();
  sid = shmget(key, 1024, 0666 | IPC_CREAT | IPC_EXCL);
  while (sid == -1)
    {
      sid = shmget(key, 1024, 0666 | IPC_CREAT);
      smem = shmat(sid, NULL, 0);
      sm = (struct IVESid *)smem;
      if (strcmp("IVES", sm->name) == 0)
	{
	  umem = smem + sizeof(struct IVESid);
	  return;
	}
      else
	{
	  shmdt(smem);
	  key++;
	  sid = shmget(key, 1024, 0666 | IPC_CREAT | IPC_EXCL);
	}
    }
  shmdt(smem);
  shmctl(sid, IPC_RMID, NULL);
  fprintf(stderr, "Run IVES first!\n");
  exit(1);
}

void   ives_deinit()
{
  shmdt(smem);
}

FILE  *p;
void   sigu2(int)
{
  sm->ready = 1;
  ives_deinit();
  pclose(p);
  exit(0);
}

int    gogo;
void   sigu1(int)
{
  signal(SIGUSR1, sigu1);
  gogo = 0;
}

char   curdir[512];
char   runstr[512];
char   buf[512];
void   main(int argc, char **argv)
{
  int    i, j;
  if (argc > 3)
    {
      sscanf(argv[3], "%d", &parpid);
      ives_initshare();
      getcwd(curdir, 512);
      while (sm->ready != 1)
	{
	  fprintf(stderr, "Sleep\n");
	  sleep(1);
	};
      signal(SIGUSR2, sigu2);
      signal(SIGUSR1, sigu1);
      sprintf(runstr, "find %s -name '%s' -print", argv[1], argv[2]);
      p = (FILE *) popen(runstr, "r");
      if (p)
	{
	  sm->autopid = getpid();
	  while (fgets(buf, 512, p) != NULL)
	    {
	      i = 0;
	      if (buf[0] == '.')
		{
		  while (*(curdir + i))
		    umem[i] = curdir[i++];
		  j = 0;
		  while (buf[j])
		    umem[i + j] = buf[j + 1], j++;
		  umem[i + j - 2] = 0;
		}
	      else
		{
		  while (buf[i])
		    umem[i] = buf[i++];
		  umem[i - 1] = 0;
		}
	      sm->ready = 0;
	      kill(parpid, SIGUSR1);
	      gogo = 1;
	      while (gogo)
		pause();
	    }
	  pclose(p);
	  umem[0] = 0;
	  sm->ready = 0;
	  kill(parpid, SIGUSR1);
	}
      ives_deinit();
    }
  else
    fprintf(stderr, "Finder-Slave.\n Usage : fslave dir filemask parentpid\n");
}
