
/****************************************************************************
*  Copyright (C) 1997 by Leo Khramov
*  email:   leo@pop.convey.ru
*  Fido:    2:5030/627.15
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
 ****************************************************************************/
#include "panel.h"
extern void prect(Window w, GC & gcw, int x, int y, int l, int h);
///////////////////////////////Cmdline class/////////////////////////////
extern Lister *panel;
void   Cmdline::show()
{
  XMapWindow(disp, w);
  addto_exp(this, w);
}

void   Cmdline::setpath(char *path)
{
  strcpy(name, host);
  strcat(name, path);
  if (getuid() != 0)
    strcat(name, "$");
  else
    strcat(name, "#");
  tl = strlen(name);
  if (hflg)
    expose();
}

void   Cmdline::init(Window ip)
{
  parent = ip;
  bbp = bp = 0;
  for (int i = 0; i < 9; i++)
    bak[i][0] = 0;
  w = XCreateSimpleWindow(disp, parent, x, y, l, 21, 0, 0, keyscol[1]);
  gcw = XCreateGC(disp, w, 0, NULL);
  XSetFont(disp, gcw, fixfontstr->fid);
  XSetForeground(disp, gcw, cols[col]);
  XSelectInput(disp, w, ExposureMask);
  tl = strlen(name);
  ty = (21 + fixfontstr->max_bounds.ascent - fixfontstr->max_bounds.descent) / 2;
  ll = fixfontstr->max_bounds.rbearing - fixfontstr->min_bounds.lbearing;
  hflg = 0;
}


void   Cmdline::look_for_cd()
{
  int    i, j;
  i = 0;
  char   tmp[256];
  while (buf[i])
    {
      if (buf[i] == 'c' && buf[i + 1] == 'd')
	{
	  if (i > 0)
	    if (buf[i - 1] != ';' && buf[i - 1] != ' ')
	      {
		i++;
		continue;
	      };
	  if (buf[i + 2] == 0)
	    panel->change_dir(getenv("HOME"));
	  else if (buf[i + 2] == ' ')
	    {
	      j = 0;
	      i += 2;
	      while (buf[i] == ' ')
		i++;
	      if (buf[i] == 0)
		panel->change_dir(getenv("HOME"));
	      else
		{
		  while (buf[i + j] != ';' && buf[i + j] != 0)
		    {
		      tmp[j] = buf[i + j];
		      j++;
		    };
		  tmp[j] = 0;
		  if (j = 0)
		    panel->change_dir(getenv("HOME"));
		  else
		    panel->change_dir(tmp);
		}
	    }
	}
      i++;
    }
}

void   Cmdline::flush()
{
  if (bl != 0)
    backup();
  look_for_cd();
  bl = cp = 0;
  buf[0] = 0;
  expose();
}

void   Cmdline::backup()
{
  bp++;
  if (bp > 9)
    bp = 0;
  bbp = bp;
  strcpy(bak[bp], buf);
  bbp++;
  if (bbp > 9)
    bbp = 0;
}

void   Cmdline::reconfigure(int ix, int iy, int il, int ih)
{
  x = ix;
  y = iy;
  l = il;
  XMoveWindow(disp, w, x, y);
  XResizeWindow(disp, w, l, 21);
  expose();
}

void   Cmdline::hide()
{
  XUnmapWindow(disp, w);
  foc = 0;
  hflg = 0;
  delfrom_exp(this);
}

void   Cmdline::expose()
{
  XClearWindow(disp, w);
  prect(w, gcw, 0, 0, l - 1, 20);
  XSetForeground(disp, gcw, cols[col]);
  XDrawString(disp, w, gcw, 4, ty, name, tl);
  tw = XTextWidth(fixfontstr, name, tl) + 9;
  el = (l - tw - 4) / ll;
  showbuf();
  hflg = 1;
}

void   Cmdline::insert(char ch)
{
  int    i;
  for (i = (int)bl; i >= cp; i--)
    buf[i + 1] = buf[i];
  buf[cp] = ch;
  cp++;
  bl++;
  showbuf();
}

void   Cmdline::press(int k)
{
  int    i;
  KeySym ks;
  XComposeStatus cs;
  char   sym[4];
  XLookupString(&ev.xkey, sym, 4, &ks, &cs);
  if (k < 128 && k > 31 && bl < el)
    insert(sym[0]);
  else
    switch (k)
      {
      case XK_BackSpace:
      case XK_Delete:
	if (cp != 0)
	  {
	    cp--;
	    for (i = cp; i < bl; i++)
	      buf[i] = buf[i + 1];
	    bl--;
	    showbuf();
	  };
	break;
      case XK_Left:
	if (cp != 0)
	  {
	    XSetForeground(disp, gcw, keyscol[1]);
	    XDrawRectangle(disp, w, gcw, tw + cp * ll, 1, ll, 18);
	    cp--;
	    XSetForeground(disp, gcw, cols[col]);
	    XDrawRectangle(disp, w, gcw, tw + cp * ll, 1, ll, 18);
	  };
	break;
      case XK_Right:
	if (cp != bl)
	  {
	    XSetForeground(disp, gcw, keyscol[1]);
	    XDrawRectangle(disp, w, gcw, tw + cp * ll, 1, ll, 18);
	    cp++;
	    XSetForeground(disp, gcw, cols[col]);
	    XDrawRectangle(disp, w, gcw, tw + cp * ll, 1, ll, 18);
	  };
	break;
      case XK_Up:
	for (i = 0; i < bl; i++)
	  tt_printf("%c", 8);
	bbp--;
	if (bbp < 0)
	  bbp = 9;
	strcpy(buf, bak[bbp]);
	bl = cp = strlen(buf);
	tt_write(buf, bl);
	showbuf();
	break;
      case XK_Down:
	for (i = 0; i < bl; i++)
	  tt_printf("%c", 8);
	bbp++;
	if (bbp > 9)
	  bbp = 0;
	strcpy(buf, bak[bbp]);
	bl = cp = strlen(buf);
	tt_write(buf, bl);
	showbuf();
	break;
      }
}

void   Cmdline::showbuf()
{
  XSetForeground(disp, gcw, keyscol[1]);
  XFillRectangle(disp, w, gcw, tw, 1, l - tw - 1, 19);
  XSetForeground(disp, gcw, cols[col]);
  XDrawString(disp, w, gcw, tw, ty, buf, bl);
  XDrawRectangle(disp, w, gcw, tw + cp * ll, 1, ll, 18);
}

void   Cmdline::click()
{
  if (ev.xany.window == w && ev.type == Expose)
    expose();
}
