/* File: parser.h
 *
 *	Declarations for parsing the toolbar resource file.
 */

#ifndef PARSER_H
#define PARSER_H

typedef enum {
	tkError, tkEOF, tkTitle, tkButton, tkSeparator, tkIPath, tkImage, tkPopup, tkEndPopup, tkPopupImage
} TokenType;

struct PixList {
	XpmAttributes	Attr;
	XImage		*Image;
	Pixmap		Pix;
	struct PixList	*Next;
};

#define MAX_BUTTONS	256

typedef struct {
	Widget		parent;
	Widget		topShell;
	Widget		manager;
	Widget		restartButton;
	Widget		quitButton;
	Widget		iconShell;
	char		*Command[MAX_BUTTONS];
	int		CommandCount;
	struct PixList	*Pixmaps;
	char		*file_name;
} Toolbar;

Toolbar * CreateToolbar(Widget parent, char *file_name, unsigned char orientation);
char BuildToolbar(Toolbar *user_tools, FILE *fp, unsigned char orientation);
void DeleteToolbar(Toolbar *tools);
char ParseFile(Toolbar *tools, FILE *fp, unsigned char orientation);
TokenType GetToken(FILE *fp);
Pixmap LoadImage(Toolbar *tools, char *file_name, char *image_name);

char * fgetstring(FILE *fp, char *s);

void Toolbar_quitButton(Widget widget, Toolbar *tools);
void Toolbar_restartButton(Widget widget, Toolbar *tools);
void Toolbar_userButton(Widget widget, Toolbar *tools);
void Toolbar_userPopup(Widget widget, Toolbar *tools);
void Toolbar_closePopup(Widget widget, Widget popup);
void Toolbar_iconifyButton(Widget widget, Toolbar *tools);
void Toolbar_deiconifyButton(Widget widget, Toolbar *tools);
void Toolbar_resizeButton(Widget widget, Toolbar *tools);

#endif
