#ifndef Hash_h
#define Hash_h

#include "lst.h"


#ifdef DEBUG
#define _InvalidArg(s)  ((fprintf(stderr, s)?NULL:NULL)) /* This returns NULL */#else
#define _InvalidArg(s)	(NULL)
#endif

/*
 * Hash table
 */


/*
 * Hash Table Structure
 */


typedef struct hash {
   size_t	n_buckets;	/* number of buckets in the table */
   size_t	n_orig;		/* original number of buckets     */
   _SimpleList **buckets;
   int 		(*hash) ();	/* hash function		  */
} Hash;

/*
 * Entry structure
 */

typedef struct egg {
   struct _elem *elm_nxt, *elm_prv; /* Next and previous Elements */
   int elm_stat;                    /* Element Status             */
   char *key, *value;
} Egg;

#define HASHSIZE	sizeof(Hash)

/*
 * Operations
 */

extern Hash	*hash__Create ();
extern Egg	*hash__Store ();
extern int	 hash__Delete ();
extern void	 hash__Clear ();
extern void	 hash__Debug ();
extern char 	*hash__Lookup();
extern Egg	*hash__EggLookup();
extern void	 hash__Debug();
extern Egg 	*hash__Replace();
extern void	 hash__Destroy();

#endif
