/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */


/*
 * Properties module
 */

#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <X11/Shell.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "lst.h"
#include "build_option.h"
#include "Dir.h"
#include "Xsh.h"
#include "etc.h"
#include "X.h"
#include "file.h"
#include "XedwList.h"
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>

#include <pwd.h>
#include <grp.h>

#include "pixmaps.h"

extern PicInfo pic_tbl[];

static EntryFormObject propForm = NULL;        /* Properties form */
static char **currFile = NULL;
static char **selFiles = NULL;
static char *currDir = NULL;
static char **lentry = NULL;
static char badparm[] = "invalid parameters\n";
static uid_t euid;

/*
 * Create the list of user names
 */

int buildOwnerList (list_w)
Widget list_w;
{
  struct passwd *pw;
  XmString str;

   setpwent ();

   while (pw = getpwent()) {
        str = XmStringCreateSimple(pw->pw_name);
        XmListAddItem(list_w, str, 0);
        XmStringFree (str);
   }

   endpwent ();

}

/*
 * Create the list of user groups
 */

int buildGroupList (list_w)
Widget list_w;
{
  struct group *gr;
  XmString str;

   setgrent ();

   while (gr = getgrent()) {
        str = XmStringCreateSimple(gr->gr_name);
        XmListAddItem(list_w, str, 0);
        XmStringFree (str);
   }

   endgrent ();

}

/*
 * createPropertiesForm: Create an entry form structure and add fields to it
 */

createPropertiesForm (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{

   if (!propForm) {
        propForm = _EntryFormCreate ();
   }

   if (!propForm ) {
        fprintf (stderr, "createPropertiesForm: _EntryFormCreate failed\n");
        return;
   }

   _EntryFormSInsertField (propForm, w, (int) client);

}

/*
 * loadProperties: load file properties into the file properties dialog
 */

int loadProperties (path, file)
char *path;
char *file;
{
struct stat fstat;
int ftype;
char *fullname;
char *data[25];
extern char *typeToStr ();
Pixmap pixmap;
extern Pixmap get_fpixmap ();

   if (!path || !file) {
	fprintf (stderr, badparm);
	return (T_INVALID);
   }

   fullname =  _dircat(path, file);

   if (!fullname) {
	fprintf (stderr, "loadProperties: _dircat failed\n");
	return (T_INVALID);
   }

   if(lstat(fullname, &fstat) < 0) {
	perror(fullname);
	free (fullname);
        return (T_INVALID);
   }


   ftype = _fasttype (fullname, &fstat);

   lentry = long_list_entry (path, file,
        PERMS | NLINKS | OWNER | GROUP | SIZE | SCTM | MODTM | ACCTM | LONG);


   if (!lentry) {
	fprintf (stderr, "XshProperties: long_list_entry\n");
	free (fullname);
	return (T_INVALID);
   }

   data[0] = fullname;
   if (ftype == T_IFBLK || ftype == T_IFCHR)
	data[1] = lentry[_DEVID];
   else
	data[1] = lentry[_SIZE];

   data[2] = lentry[_NLINKS];
   data[3] = lentry[_LINKED];

   if (!strcmp (data[3], "")) {
	_EntryFormInvisibleField (_EntryFormPosToField (propForm, 31));
	XtUnmanageChild (_EntryFormPosToWidget (propForm, 3));
   } else {
        data[3] = lentry[_LINKED];
	_EntryFormVisibleField (_EntryFormPosToField (propForm, 31));
        XtManageChild (_EntryFormPosToWidget (propForm, 3));
   }

   data[4] = typeToStr (ftype);
   if (!data[4])
        data[4] = "Unknown type";
   data[5] = lentry[_OWNER];
   data[6] = lentry[_GROUP];

   data[7] = lentry[_ACCTM];
   data[8] = lentry[_MODTM];
   data[9] = lentry[_SCTM]; 

   permsToData (lentry[_PERMS], &data[10]);

   data[22] = NULL;
   _EntryFormSLoadData (propForm, data); 
   if (data[4]) {
	free (data[4]);
	data[4] = NULL;
   }
   free (fullname);

   pixmap = get_fpixmap (ftype);
#ifdef DEBUG
   fprintf (stderr, "loadProperties: ftype = %d, pixmap = %ld\n",
				ftype, pixmap); 
#endif				
   if (pixmap)
      XtVaSetValues (_EntryFormPosToWidget (propForm, 29), XmNlabelPixmap,  
	pixmap, NULL); 
   else
      XtVaSetValues (_EntryFormPosToWidget (propForm, 29), XmNlabelPixmap,  
	pic_tbl[0].pixmap, NULL); 

   if (euid && (euid != fstat.st_uid)) {
	XtSetSensitive (_EntryFormPosToWidget (propForm, 30), False);
	XtSetSensitive (_EntryFormPosToWidget (propForm, 22), False);

   } else {
	XtSetSensitive (_EntryFormPosToWidget (propForm, 30), True);
	XtSetSensitive (_EntryFormPosToWidget (propForm, 22), True);
   }
		
   return (ftype);
}

/*
 * showFirstFile: display the information related to the first file in the list
 * of selected files.
 */

int showFirstFile (directory, files) 
char *directory;
char **files;
{
   static short initted = 0;
   int ftype;
   register Widget nextButton = _EntryFormPosToWidget (propForm, 25);
   Widget ownerList = _EntryFormPosToWidget (propForm, 5);
   Widget groupList = _EntryFormPosToWidget (propForm, 6);
   Widget toggle22;
   Widget toggle23;
   Widget toggle28;


   if (!files || !directory)
	return (-1); 

   currDir = strdup (directory);

   if (!currDir) {
	fprintf (stderr, "showFirstFile: not enough memory\n");
	return (-1);
   }

   XmListDeleteAllItems (ownerList);
   XmListDeleteAllItems (groupList);
   buildOwnerList (ownerList);
   buildGroupList (groupList);
   selFiles = currFile = files;

   toggle22 = _EntryFormPosToWidget (propForm, 22);
   toggle23 = _EntryFormPosToWidget (propForm, 23);
   toggle28 = _EntryFormPosToWidget (propForm, 28);

   if (!initted) {
	euid = getuid ();
	initted++;
	_EntryFormFieldSetAppendMode (_EntryFormPosToField (propForm, 1), 1);
        _EntryFormFieldSetAppendMode (_EntryFormPosToField (propForm, 2), 1);
#ifdef OLD
        _EntryFormFieldSetAppendMode (_EntryFormPosToField (propForm, 3), 1);
#endif

        _EntryFormFieldSetAppendMode (_EntryFormPosToField (propForm, 7), 1);
        _EntryFormFieldSetAppendMode (_EntryFormPosToField (propForm, 8), 1);
        _EntryFormFieldSetAppendMode (_EntryFormPosToField (propForm, 9), 1);
   	if (euid) {
	   XtVaSetValues (XtParent(ownerList), 
		XmNsensitive, False, NULL);
		/*
	   XtVaSetValues (XtParent(groupList), 
		XmNsensitive, False, NULL);
		*/
	   XtVaSetValues (ownerList, XmNsensitive, False, NULL);
/*
	   XtVaSetValues (groupList, XmNsensitive, False, NULL);
	   XtVaSetValues (toggle23, XmNsensitive, False, NULL);
*/	 
	   XtVaSetValues (toggle28, XmNsensitive, False, NULL);
	}
   }

   ftype = loadProperties (directory, *currFile);
   
   if (ftype == T_INVALID) {
      _EntryFormPerror (propForm, *currFile); /*check this */
      return (-1);
   }
      
   _EntryFormSPLoadPos (propForm, "OFF", 22);
   _EntryFormSPLoadPos (propForm, "OFF", 23);
   _EntryFormSPLoadPos (propForm, "OFF", 28);

   XtManageChild (toggle22);
   XtManageChild (toggle23);
   XtManageChild (toggle28);

   if (*(currFile + 1)) {
	XtVaSetValues (nextButton, XmNsensitive, True, NULL);
	_XmClabelSetString (toggle22, "Apply to all selected");
	_XmClabelSetString (toggle23, "Apply to all selected");
	_XmClabelSetString (toggle28, "Apply to all selected");
   } else {
	XtVaSetValues (nextButton, XmNsensitive, False, NULL);
	if (ftype == T_IFDIR) {
	   _XmClabelSetString (toggle22, "Descend through directories");
	   _XmClabelSetString (toggle23, "Descend through directories");
	   _XmClabelSetString (toggle28, "Descend through directories");
   	} else {
   	   XtUnmanageChild (toggle22);
   	   XtUnmanageChild (toggle23);
   	   XtUnmanageChild (toggle28);
	}
   }


   XtVaSetValues (_EntryFormPosToWidget (propForm, 26), 
		XmNsensitive, False, NULL);

   _EntryFormSSave (propForm);
   return (1);

}

/*
 * changeOwner: change owner
 */

changeOwner (dw, filenames, owner, desc)
Widget dw;
char *filenames;
int desc; 
{
   char *cmd;
   char **argv;
#ifdef SUNOS
   static char chown_path[] = "/usr/etc/chown";
#else
   static char chown_path[] = "/bin/chown";
#endif

   if (!filenames || !owner)
	return;
   
   if (desc) {
      cmd = cmcat (chown_path, "chown", "-R", owner, filenames, NULL);
   } else
      cmd = cmcat (chown_path, "chown", owner, filenames, NULL);

   if (!cmd)
	return; /* print error message - memory problems */

   argv = cnvStrToArgv (cmd);

   if (!argv) {
	return; 
   }

   XwDirExecute1 (dw, argv, 0);
   free (cmd);

}

/*
 * changeGroup: change group
 */

changeGroup (dw, filenames, group, desc)
Widget dw;
char *filenames;
int desc;
{
   char *cmd;
   char **argv;

   if (!filenames || !group)
        return;

   if (desc) {
      cmd = cmcat ("/bin/chgrp", "chgrp", "-R", group, filenames, NULL);
   } else
      cmd = cmcat ("/bin/chgrp", "chgrp", group, filenames, NULL);

   if (!cmd)
        return;

   argv = cnvStrToArgv (cmd);

   if (!argv) {
        return;
   }

   XwDirExecute1 (dw, argv, 0);
   free (cmd);

}

/*
 * propApplyCB: apply button activate callback
 */

void propApplyCB(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   char **data;
   int md1, md2; 
   char mode[10];
   char *cmd;
   static char *msg = "Sorry, you don't belong to the selected group.\nThis operation will probably fail. Do you still want to continue ?";
#ifdef OLD
   Widget dw = ((XshCallbackStruct *) client)->XshDirWidget;
#endif
   static Widget dw;
   int desc_o = 0, desc_g = 0, desc_m = 0, all_o = 0, all_g = 0, all_m = 0;
   char *filenames;
   char *name;
   char *_basename ();


   data = _EntryFormSDumpData (propForm); 
   
   if (!data) {
	fprintf (stderr, "propApplyCB: _EntryFormSDumpData failed\n");
	return;
   }

   if (!lentry) {
	_freeargv (data);
	return;
   }
   
   if (client) {
        
	dw = ((XshCallbackStruct *) client)->XshDirWidget;
        
        /* check if user belongs to the selected group (groups list) */
        if (euid && !_in_groups (_EntryFormSPDumpPos (propForm, 6))) {
    
    		 /* The user does not belong to the selected group. This operation 
    		  * is likely to fail.
         	  * Popup a confirmation dialog. Set the OK button activate callback
         	  * to be this function (client = NULL)
         	  */  
         	  
		_XmCConfirmationDialogPost (dw,
			msg, "Confirmation", propApplyCB, NULL, NULL);
		return;   
	}
   }

   md1 = permsToMode (lentry[_PERMS]);
   md2 = dataToMode (&data[10]); 

   sprintf (mode, "%o", md2);

   filenames = XwDirFilesSelected(dw);
   if  (!filenames) {
        _freeargv (data);
	return;
   }

   if (XwDirSelectedItemCount (dw) > 1) {
	if (!euid) {
	   all_o = (strcmp (data[28], "OFF") == 0)?0:1;
	}
	all_g = (strcmp (data[23], "OFF") == 0)?0:1;
	all_m = (strcmp (data[22], "OFF") == 0)?0:1;
   } else {
	if (!euid) {
	   desc_o = (strcmp (data[28], "OFF") == 0)?0:1;
	}
	desc_g = (strcmp (data[23], "OFF") == 0)?0:1;
	desc_m = (strcmp (data[22], "OFF") == 0)?0:1;
   }

   _freeargv (data);

   if (desc_m)
	cmd = cmcat ("/bin/chmod", "chmod", "-R", mode, *currFile, NULL);
   else if (all_m)
	   cmd = cmcat ("/bin/chmod", "chmod", mode, filenames, NULL); 
   else 
	   cmd = cmcat ("/bin/chmod", "chmod", mode, *currFile, NULL);

   if (cmd) {
   char **argv;
	argv = cnvStrToArgv (cmd); 
	if (!argv) {
	   free (cmd);
	   fprintf (stderr, "Too many files\n");
	   return;
	}
	   
	XwDirExecute1 (dw, argv, 0);
	free (cmd);
	free (argv);

	if (!all_m) {
	   name = _basename (*currFile);
	   if (!name)
		return;
	   XwUpdateItem (dw, name); 
	} else {
           char **tmp;
	   char *dummy;

	   dummy = strdup (filenames);
	   if (!dummy)
		return;
	   tmp = argv = cnvStrToArgv (dummy);
	   if (!tmp) {
#ifdef DEBUG
		fprintf (stderr, "propApplyCB: cnvStrToArgv failed\n");
#endif
		return;

	   }
	   while (*tmp) {
	   	name = _basename (*tmp++);
	        if (!name)
		   continue;
	   	XwUpdateItem (dw, name);
	   }
	   free (argv);
	   free (dummy);
	   
	}
   }

   if (desc_o)
	changeOwner (dw, *currFile, _EntryFormSPDumpPos (propForm, 5), desc_o);
   else if (all_o)
	changeOwner (dw, filenames, _EntryFormSPDumpPos (propForm, 5), desc_o);
   else if (!euid)
	changeOwner (dw, *currFile, _EntryFormSPDumpPos (propForm, 5), desc_o);

   if (desc_g)
        changeGroup (dw, *currFile, _EntryFormSPDumpPos (propForm, 6), desc_g);
   else if (all_g)
        changeGroup (dw, filenames, _EntryFormSPDumpPos (propForm, 6), desc_g);
   else
        changeGroup (dw, *currFile, _EntryFormSPDumpPos (propForm, 6), desc_g);
}


/*
 * propCancelCB: dismiss button activate callback
 */

void propCancelCB(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
        _EntryFormPopdown (propForm);

}


/*
 * propNextCB: next button activate callback
 */

void propNextCB(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   register Widget nextButton = _EntryFormPosToWidget (propForm, 25);

   if (*(currFile + 1)) {
        if (loadProperties (currDir, *++currFile) == T_INVALID) {
      	   _EntryFormPerror (propForm, *currFile);
           currFile--;
      	   return;
        }
            
	_EntryFormSSave (propForm);
   }

   if (*(currFile + 1))
        XtVaSetValues (nextButton, XmNsensitive, True, NULL);
   else
        XtVaSetValues (nextButton, XmNsensitive, False, NULL);

   XtVaSetValues (_EntryFormPosToWidget (propForm, 26),
                XmNsensitive, True, NULL); 

}


/*
 * propPrevCB: previous button activate callback
 */

void propPrevCB(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   register Widget prevButton = _EntryFormPosToWidget (propForm, 26);

   if (currFile != selFiles) {
        if (loadProperties (currDir, *--currFile) == T_INVALID) {
      	   _EntryFormPerror (propForm, *currFile);
           currFile++;
      	   return;
        }
	_EntryFormSSave (propForm);
   }

   if (currFile != selFiles)
        XtVaSetValues (prevButton, XmNsensitive, True, NULL);
   else
        XtVaSetValues (prevButton, XmNsensitive, False, NULL);
   XtVaSetValues (_EntryFormPosToWidget (propForm, 25),
                XmNsensitive, True, NULL); 
}
