
/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <Xm/ArrowB.h>
#include <Xm/ArrowBG.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/Command.h>
#include <Xm/CutPaste.h>
#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
#include <Xm/MainW.h>
#include <Xm/MenuShell.h>
#include <Xm/MessageB.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/SeparatoG.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>

#include "Xsh.h"
#include "X.h"

#ifndef IGNORE_COLOR
static unsigned long
COLOR(w, name)
Widget w;
char *name;
{
XrmValue	fromVal, toVal;
unsigned long *pixel;

    fromVal.size = sizeof(char*);
    fromVal.addr = name;

    XtConvert(w, XmRString, &fromVal, XmRPixel, &toVal);
    pixel = (unsigned long*)toVal.addr;
    if( pixel == NULL )
    {
    	fromVal.addr = XtDefaultBackground;
    	XtConvert(w, XmRString, &fromVal, XmRPixel, &toVal);
    	pixel = (unsigned long*)toVal.addr;
    }
    return(*pixel);
}
#endif

extern void ScrollCreate();
extern void XshChangeTo();
extern void XshCleanupWindow();
extern void XshClose();
extern void XshCopyTo();
extern void XshCreateActionMenu();
extern void XshDirCreate();
extern void XshDirTextCreate();
extern void XshEmptyTrash();
extern void XshFileSBoxCreate();
extern void XshFind();
extern void XshHiddenFiles();
extern void XshHome();
extern void XshLongListing();
extern void XshMoveTo();
extern void XshNewDirectory();
extern void XshOpen();
extern void XshOpenTrash();
extern void XshPanedWindowCreate();
extern void XshPrint();
extern void XshProperties();
extern void XshRemove();
extern void XshSelectAll();
extern void XshSetDirectory();
extern void XshShortListing();
extern void XshSmallIcons();
extern void XshSortByDate();
extern void XshSortByName();
extern void XshSortBySize();
extern void XshSortByType();
extern void XshSynchronize();
extern void XshUnselectAll();
extern void XshUp();
extern void cancelCopyMoveCB();
extern void createCopyMoveForm();
extern void createMenuForm();
extern void createPropertiesForm();
extern void helpCB();
extern void okCopyMoveCB();
extern void propApplyCB();
extern void propCancelCB();
extern void propNextCB();
extern void propPrevCB();
extern void setXshPixmap();
extern int XshCbs;

Widget
Createmain_window(parent)
Widget parent;
{
    Arg    	args[512];
    int    	argcnt;
    Widget 	retval;
    XmString	xmstr[32];
    XmString	*xmstrTable[8];
    Widget	main_window;
    Widget	menu_bar;
    Widget	menuShell;
    Widget	pulldown_menu;
    Widget	open_button;
    Widget	separator;
    Widget	new_directory_button;
    Widget	change_to_button;
    Widget	home_button;
    Widget	up_button;
    Widget	separatorD;
    Widget	copy_to_button;
    Widget	move_to_button;
    Widget	properties_button;
    Widget	separatorE;
    Widget	print_button;
    Widget	find_button;
    Widget	remove_button;
    Widget	close_button;
    Widget	file_cascade;
    Widget	menuShell1;
    Widget	pulldown_menu1;
    Widget	select_all_button;
    Widget	unselect_all_button;
    Widget	edit_cascade;
    Widget	menuShell2;
    Widget	pulldown_menu2;
    Widget	small_icons_button;
    Widget	icons_button;
    Widget	long_listing_button;
    Widget	separatorG;
    Widget	hidden_toggle;
    Widget	separator1;
    Widget	menuShell3;
    Widget	sort_pulldown_menu;
    Widget	byname_button;
    Widget	bydate_button;
    Widget	bysize_button;
    Widget	bytype_button;
    Widget	sort_cascade;
    Widget	separatorH;
    Widget	cleanup_button;
    Widget	view_cascade;
    Widget	menuShell4;
    Widget	pulldown_menu3;
    Widget	onFSButton;
    Widget	onVersionButton;
    Widget	onFreedomDesktopButton;
    Widget	help_cascade;
    Widget	menuShell5;
    Widget	pulldown_menu4;
    Widget	actions_cascade;
    Widget	menuShell6;
    Widget	pulldown_menu5;
    Widget	open_trash_button;
    Widget	empty_trash_button;
    Widget	separatorJ;
    Widget	synchronize_button;
    Widget	util_cascade;
    Widget	form;
    Widget	paned_window;
    Widget	paned_window1;
    Widget	scrolled_window;
    Widget	directory_label;
    Widget	separatorA;
    Widget	directory_text;
    Widget	label;
    Widget	separatorB;
    XmRegisterConverters();
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNsensitive, True); argcnt++;
    XtSetArg(args[argcnt], XmNshowSeparator, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 594); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 450); argcnt++;
    main_window = XtCreateWidget("main_window",
		xmMainWindowWidgetClass,
		parent,
		args,
		argcnt);

    retval = main_window;
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNspacing, (Dimension)7); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 594); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 31); argcnt++;
    XtSetArg(args[argcnt], XmNrowColumnType, XmMENU_BAR); argcnt++;
    menu_bar = XtCreateWidget("menu_bar",
		xmRowColumnWidgetClass,
		main_window,
		args,
		argcnt);

    XtManageChild(menu_bar);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNwidth, 1); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 1); argcnt++;
    menuShell = XtCreatePopupShell("menuShell",
		xmMenuShellWidgetClass,
		menu_bar,
		args,
		argcnt);

    XtManageChild(menuShell);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNradioBehavior, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 195); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 268); argcnt++;
    XtSetArg(args[argcnt], XmNrowColumnType, XmMENU_PULLDOWN); argcnt++;
    pulldown_menu = XtCreateWidget("pulldown_menu",
		xmRowColumnWidgetClass,
		menuShell,
		args,
		argcnt);

 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Open",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'O'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>O"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+O",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    open_button = XtCreateWidget("open_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(open_button, XmNactivateCallback, XshOpen, (caddr_t)&XshCbs);
    XtManageChild(open_button);
 
    argcnt = 0;
    separator = XtCreateWidget("separator",
		xmSeparatorWidgetClass,
		pulldown_menu,
		args,
		argcnt);

    XtManageChild(separator);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"New Directory ..",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'N'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>N"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+N",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    new_directory_button = XtCreateWidget("new_directory_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(new_directory_button, XmNactivateCallback, XshNewDirectory, (caddr_t)&XshCbs);
    XtManageChild(new_directory_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Change To ..",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'g'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>G"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+G",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    change_to_button = XtCreateWidget("change_to_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(change_to_button, XmNactivateCallback, XshChangeTo, (caddr_t)&XshCbs);
    XtManageChild(change_to_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Home",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'H'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>H"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+H",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    home_button = XtCreateWidget("home_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(home_button, XmNactivateCallback, XshHome, (caddr_t)&XshCbs);
    XtManageChild(home_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Up",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'U'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>U"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+U",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    up_button = XtCreateWidget("up_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(up_button, XmNactivateCallback, XshUp, (caddr_t)&XshCbs);
    XtManageChild(up_button);
 
    argcnt = 0;
    separatorD = XtCreateWidget("separatorD",
		xmSeparatorWidgetClass,
		pulldown_menu,
		args,
		argcnt);

    XtManageChild(separatorD);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Copy To ..",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'C'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>C"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+C",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    copy_to_button = XtCreateWidget("copy_to_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(copy_to_button, XmNactivateCallback, XshCopyTo, (caddr_t)&XshCbs);
    XtManageChild(copy_to_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Move To ..",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'M'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>M"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+M",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    move_to_button = XtCreateWidget("move_to_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(move_to_button, XmNactivateCallback, XshMoveTo, (caddr_t)&XshCbs);
    XtManageChild(move_to_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Properties ..",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'r'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>R"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+R",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    properties_button = XtCreateWidget("properties_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(properties_button, XmNactivateCallback, XshProperties, (caddr_t)&XshCbs);
    XtManageChild(properties_button);
 
    argcnt = 0;
    separatorE = XtCreateWidget("separatorE",
		xmSeparatorWidgetClass,
		pulldown_menu,
		args,
		argcnt);

    XtManageChild(separatorE);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Print ..",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'P'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>P"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+P",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    print_button = XtCreateWidget("print_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(print_button, XmNactivateCallback, XshPrint, (caddr_t)&XshCbs);
    XtManageChild(print_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Find ..",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'F'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>F"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+F",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    find_button = XtCreateWidget("find_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(find_button, XmNactivateCallback, XshFind, (caddr_t)&XshCbs);
    XtManageChild(find_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Move To Trash",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    remove_button = XtCreateWidget("remove_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(remove_button, XmNactivateCallback, XshRemove, (caddr_t)&XshCbs);
    XtManageChild(remove_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Close",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'C'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt<Key>F4"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+F4",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    close_button = XtCreateWidget("close_button",
		xmPushButtonWidgetClass,
		pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(close_button, XmNactivateCallback, XshClose, (caddr_t)&XshCbs);
    XtManageChild(close_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"File",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'F'); argcnt++;
    XtSetArg(args[argcnt], XmNx, 5); argcnt++;
    XtSetArg(args[argcnt], XmNy, 5); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 40); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 21); argcnt++;
    XtSetArg(args[argcnt], XmNsubMenuId, pulldown_menu); argcnt++;
    file_cascade = XtCreateWidget("file_cascade",
		xmCascadeButtonWidgetClass,
		menu_bar,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(file_cascade);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNwidth, 1); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 1); argcnt++;
    menuShell1 = XtCreatePopupShell("menuShell1",
		xmMenuShellWidgetClass,
		menu_bar,
		args,
		argcnt);

    XtManageChild(menuShell1);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 171); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 52); argcnt++;
    XtSetArg(args[argcnt], XmNrowColumnType, XmMENU_PULLDOWN); argcnt++;
    pulldown_menu1 = XtCreateWidget("pulldown_menu1",
		xmRowColumnWidgetClass,
		menuShell1,
		args,
		argcnt);

 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Select All",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'A'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>A"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+A",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    select_all_button = XtCreateWidget("select_all_button",
		xmPushButtonWidgetClass,
		pulldown_menu1,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(select_all_button, XmNactivateCallback, XshSelectAll, (caddr_t)&XshCbs);
    XtManageChild(select_all_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Unselect All",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'U'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, ""); argcnt++;
    unselect_all_button = XtCreateWidget("unselect_all_button",
		xmPushButtonWidgetClass,
		pulldown_menu1,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(unselect_all_button, XmNactivateCallback, XshUnselectAll, (caddr_t)&XshCbs);
    XtManageChild(unselect_all_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Edit",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'E'); argcnt++;
    XtSetArg(args[argcnt], XmNx, 52); argcnt++;
    XtSetArg(args[argcnt], XmNy, 5); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 40); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 21); argcnt++;
    XtSetArg(args[argcnt], XmNsubMenuId, pulldown_menu1); argcnt++;
    edit_cascade = XtCreateWidget("edit_cascade",
		xmCascadeButtonWidgetClass,
		menu_bar,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(edit_cascade);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNwidth, 1); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 1); argcnt++;
    menuShell2 = XtCreatePopupShell("menuShell2",
		xmMenuShellWidgetClass,
		menu_bar,
		args,
		argcnt);

    XtManageChild(menuShell2);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNradioBehavior, False); argcnt++;
    XtSetArg(args[argcnt], XmNradioAlwaysOne, True); argcnt++;
    XtSetArg(args[argcnt], XmNisHomogeneous, False); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 218); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 145); argcnt++;
    XtSetArg(args[argcnt], XmNrowColumnType, XmMENU_PULLDOWN); argcnt++;
    pulldown_menu2 = XtCreateWidget("pulldown_menu2",
		xmRowColumnWidgetClass,
		menuShell2,
		args,
		argcnt);

 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Icons",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'I'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>I"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+I",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNindicatorType, 2); argcnt++;
    XtSetArg(args[argcnt], XmNset, True); argcnt++;
    small_icons_button = XtCreateWidget("small_icons_button",
		xmToggleButtonWidgetClass,
		pulldown_menu2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(small_icons_button, XmNvalueChangedCallback, XshSmallIcons, (caddr_t)&XshCbs);
    createMenuForm(small_icons_button, (caddr_t)10, (caddr_t)0);
    XtManageChild(small_icons_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Short Listing",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, ""); argcnt++;
    XtSetArg(args[argcnt], XmNindicatorType, 2); argcnt++;
    XtSetArg(args[argcnt], XmNset, False); argcnt++;
    icons_button = XtCreateWidget("icons_button",
		xmToggleButtonWidgetClass,
		pulldown_menu2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(icons_button, XmNvalueChangedCallback, XshShortListing, (caddr_t)&XshCbs);
    createMenuForm(icons_button, (caddr_t)11, (caddr_t)0);
    XtManageChild(icons_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Long Listing",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'L'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>L"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+L",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNindicatorType, 2); argcnt++;
    XtSetArg(args[argcnt], XmNset, False); argcnt++;
    long_listing_button = XtCreateWidget("long_listing_button",
		xmToggleButtonWidgetClass,
		pulldown_menu2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(long_listing_button, XmNvalueChangedCallback, XshLongListing, (caddr_t)&XshCbs);
    createMenuForm(long_listing_button, (caddr_t)12, (caddr_t)0);
    XtManageChild(long_listing_button);
 
    argcnt = 0;
    separatorG = XtCreateWidget("separatorG",
		xmSeparatorWidgetClass,
		pulldown_menu2,
		args,
		argcnt);

    XtManageChild(separatorG);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Show Hidden Files",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'H'); argcnt++;
    XtSetArg(args[argcnt], XmNindicatorType, 1); argcnt++;
    XtSetArg(args[argcnt], XmNvisibleWhenOff, False); argcnt++;
    hidden_toggle = XtCreateWidget("hidden_toggle",
		xmToggleButtonWidgetClass,
		pulldown_menu2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(hidden_toggle, XmNvalueChangedCallback, XshHiddenFiles, (caddr_t)&XshCbs);
    XtManageChild(hidden_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNbackground, COLOR(parent, "grey")); argcnt++;
    separator1 = XtCreateWidget("separator1",
		xmSeparatorWidgetClass,
		pulldown_menu2,
		args,
		argcnt);

    XtManageChild(separator1);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNwidth, 1); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 1); argcnt++;
    menuShell3 = XtCreatePopupShell("menuShell3",
		xmMenuShellWidgetClass,
		menuShell2,
		args,
		argcnt);

 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 42); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 94); argcnt++;
    XtSetArg(args[argcnt], XmNrowColumnType, XmMENU_PULLDOWN); argcnt++;
    sort_pulldown_menu = XtCreateWidget("sort_pulldown_menu",
		xmRowColumnWidgetClass,
		menuShell3,
		args,
		argcnt);

 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Name",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'N'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, ""); argcnt++;
    byname_button = XtCreateWidget("byname_button",
		xmPushButtonWidgetClass,
		sort_pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(byname_button, XmNactivateCallback, XshSortByName, (caddr_t)&XshCbs);
    XtManageChild(byname_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Date",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'D'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, ""); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    bydate_button = XtCreateWidget("bydate_button",
		xmPushButtonWidgetClass,
		sort_pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(bydate_button, XmNactivateCallback, XshSortByDate, (caddr_t)&XshCbs);
    XtManageChild(bydate_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Size",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'S'); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    bysize_button = XtCreateWidget("bysize_button",
		xmPushButtonWidgetClass,
		sort_pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(bysize_button, XmNactivateCallback, XshSortBySize, (caddr_t)&XshCbs);
    XtManageChild(bysize_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Type",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'T'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, ""); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    bytype_button = XtCreateWidget("bytype_button",
		xmPushButtonWidgetClass,
		sort_pulldown_menu,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(bytype_button, XmNactivateCallback, XshSortByType, (caddr_t)&XshCbs);
    XtManageChild(bytype_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Sort",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'S'); argcnt++;
    XtSetArg(args[argcnt], XmNsubMenuId, sort_pulldown_menu); argcnt++;
    sort_cascade = XtCreateWidget("sort_cascade",
		xmCascadeButtonWidgetClass,
		pulldown_menu2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(sort_cascade);
 
    argcnt = 0;
    separatorH = XtCreateWidget("separatorH",
		xmSeparatorWidgetClass,
		pulldown_menu2,
		args,
		argcnt);

    XtManageChild(separatorH);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Arrange Icons ",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'A'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, ""); argcnt++;
    cleanup_button = XtCreateWidget("cleanup_button",
		xmPushButtonWidgetClass,
		pulldown_menu2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(cleanup_button, XmNactivateCallback, XshCleanupWindow, (caddr_t)&XshCbs);
    XtManageChild(cleanup_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"View",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'V'); argcnt++;
    XtSetArg(args[argcnt], XmNx, 99); argcnt++;
    XtSetArg(args[argcnt], XmNy, 5); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 40); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 21); argcnt++;
    XtSetArg(args[argcnt], XmNsubMenuId, pulldown_menu2); argcnt++;
    view_cascade = XtCreateWidget("view_cascade",
		xmCascadeButtonWidgetClass,
		menu_bar,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(view_cascade);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNwidth, 1); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 1); argcnt++;
    menuShell4 = XtCreatePopupShell("menuShell4",
		xmMenuShellWidgetClass,
		menu_bar,
		args,
		argcnt);

    XtManageChild(menuShell4);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNmnemonic, 'H'); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 132); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 73); argcnt++;
    XtSetArg(args[argcnt], XmNrowColumnType, XmMENU_PULLDOWN); argcnt++;
    pulldown_menu3 = XtCreateWidget("pulldown_menu3",
		xmRowColumnWidgetClass,
		menuShell4,
		args,
		argcnt);

 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"On Freedom Software",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'S'); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    onFSButton = XtCreateWidget("onFSButton",
		xmPushButtonWidgetClass,
		pulldown_menu3,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(onFSButton, XmNactivateCallback, helpCB, (caddr_t)0);
    XtManageChild(onFSButton);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"On Version",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'V'); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    onVersionButton = XtCreateWidget("onVersionButton",
		xmPushButtonWidgetClass,
		pulldown_menu3,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(onVersionButton, XmNactivateCallback, helpCB, (caddr_t)1);
    XtManageChild(onVersionButton);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"On Freedom Desktop",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'D'); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    onFreedomDesktopButton = XtCreateWidget("onFreedomDesktopButton",
		xmPushButtonWidgetClass,
		pulldown_menu3,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(onFreedomDesktopButton, XmNactivateCallback, helpCB, (caddr_t)2);
    XtManageChild(onFreedomDesktopButton);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Help",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNx, 549); argcnt++;
    XtSetArg(args[argcnt], XmNy, 5); argcnt++;
    XtSetArg(args[argcnt], XmNsubMenuId, pulldown_menu3); argcnt++;
    help_cascade = XtCreateWidget("help_cascade",
		xmCascadeButtonWidgetClass,
		menu_bar,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createMenuForm(help_cascade, (caddr_t)30, (caddr_t)0);
    XtManageChild(help_cascade);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNwidth, 1); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 1); argcnt++;
    menuShell5 = XtCreatePopupShell("menuShell5",
		xmMenuShellWidgetClass,
		menu_bar,
		args,
		argcnt);

    XtManageChild(menuShell5);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 16); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 16); argcnt++;
    XtSetArg(args[argcnt], XmNrowColumnType, XmMENU_PULLDOWN); argcnt++;
    pulldown_menu4 = XtCreateWidget("pulldown_menu4",
		xmRowColumnWidgetClass,
		menuShell5,
		args,
		argcnt);

 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNsensitive, False); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Actions",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'A'); argcnt++;
    XtSetArg(args[argcnt], XmNx, 146); argcnt++;
    XtSetArg(args[argcnt], XmNy, 5); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 58); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 21); argcnt++;
    XtSetArg(args[argcnt], XmNsubMenuId, pulldown_menu4); argcnt++;
    actions_cascade = XtCreateWidget("actions_cascade",
		xmCascadeButtonWidgetClass,
		menu_bar,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(actions_cascade, XmNcascadingCallback, XshCreateActionMenu, (caddr_t)&XshCbs);
    createMenuForm(actions_cascade, (caddr_t)16, (caddr_t)0);
    XtManageChild(actions_cascade);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNwidth, 1); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 1); argcnt++;
    menuShell6 = XtCreatePopupShell("menuShell6",
		xmMenuShellWidgetClass,
		menu_bar,
		args,
		argcnt);

    XtManageChild(menuShell6);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 177); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 75); argcnt++;
    XtSetArg(args[argcnt], XmNrowColumnType, XmMENU_PULLDOWN); argcnt++;
    pulldown_menu5 = XtCreateWidget("pulldown_menu5",
		xmRowColumnWidgetClass,
		menuShell6,
		args,
		argcnt);

 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Open Trash ..",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'T'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>T"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+T",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    open_trash_button = XtCreateWidget("open_trash_button",
		xmPushButtonWidgetClass,
		pulldown_menu5,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(open_trash_button, XmNactivateCallback, XshOpenTrash, (caddr_t)0);
    XtManageChild(open_trash_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Empty Trash",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'E'); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    empty_trash_button = XtCreateWidget("empty_trash_button",
		xmPushButtonWidgetClass,
		pulldown_menu5,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(empty_trash_button, XmNactivateCallback, XshEmptyTrash, (caddr_t)&XshCbs);
    XtManageChild(empty_trash_button);
 
    argcnt = 0;
    separatorJ = XtCreateWidget("separatorJ",
		xmSeparatorWidgetClass,
		pulldown_menu5,
		args,
		argcnt);

    XtManageChild(separatorJ);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Synchronize",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'S'); argcnt++;
    XtSetArg(args[argcnt], XmNaccelerator, "Alt Shift<Key>S"); argcnt++;
    XtSetArg(args[argcnt], XmNacceleratorText, (xmstr[1]=XmStringCreateLtoR(
		"Alt+Shift+S",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    synchronize_button = XtCreateWidget("synchronize_button",
		xmPushButtonWidgetClass,
		pulldown_menu5,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );

    XtAddCallback(synchronize_button, XmNactivateCallback, XshSynchronize, (caddr_t)&XshCbs);
    XtManageChild(synchronize_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Utilities",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNmnemonic, 'U'); argcnt++;
    XtSetArg(args[argcnt], XmNx, 211); argcnt++;
    XtSetArg(args[argcnt], XmNy, 5); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 70); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 21); argcnt++;
    XtSetArg(args[argcnt], XmNsubMenuId, pulldown_menu5); argcnt++;
    util_cascade = XtCreateWidget("util_cascade",
		xmCascadeButtonWidgetClass,
		menu_bar,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(util_cascade);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNmenuHelpWidget, help_cascade); argcnt++;
    XtSetValues(menu_bar, args, argcnt);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 33); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 594); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 417); argcnt++;
    form = XtCreateWidget("form",
		xmFormWidgetClass,
		main_window,
		args,
		argcnt);

    XtManageChild(form);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNbottomOffset, (int)20); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)1); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)1); argcnt++;
    XtSetArg(args[argcnt], XmNx, 1); argcnt++;
    XtSetArg(args[argcnt], XmNy, 387); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 592); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 10); argcnt++;
    separatorB = XtCreateWidget("separatorB",
		xmSeparatorWidgetClass,
		form,
		args,
		argcnt);

    XtManageChild(separatorB);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelType, 1); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNresizable, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 580); argcnt++;
    XtSetArg(args[argcnt], XmNy, 15); argcnt++;
    label = XtCreateWidget("label",
		xmLabelWidgetClass,
		form,
		args,
		argcnt);

    setXshPixmap(label, (caddr_t)0, (caddr_t)0);
    XtManageChild(label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNsensitive, True); argcnt++;
    XtSetArg(args[argcnt], XmNeditable, False); argcnt++;
    XtSetArg(args[argcnt], XmNcolumns, (short)80); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)1); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)-5); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)80); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 80); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNrightWidget, label); argcnt++;
    directory_text = XtCreateWidget("directory_text",
		xmTextWidgetClass,
		form,
		args,
		argcnt);

    XtAddCallback(directory_text, XmNactivateCallback, XshSetDirectory, (caddr_t)&XshCbs);
    XshDirTextCreate(directory_text, (caddr_t)0, (caddr_t)0);
    XtManageChild(directory_text);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)20); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)1); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)1); argcnt++;
    XtSetArg(args[argcnt], XmNx, 1); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 592); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 5); argcnt++;
    separatorA = XtCreateWidget("separatorA",
		xmSeparatorWidgetClass,
		form,
		args,
		argcnt);

    XtManageChild(separatorA);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNalignment, XmALIGNMENT_BEGINNING); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Directory:",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)20); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNx, 5); argcnt++;
    XtSetArg(args[argcnt], XmNy, 20); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 70); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 20); argcnt++;
    directory_label = XtCreateWidget("directory_label",
		xmLabelWidgetClass,
		form,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(directory_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNhighlightColor, COLOR(parent, "#000082")); argcnt++;
    XtSetArg(args[argcnt], XmNmarginWidth, (short)3); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNbottomOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 594); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 322); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, separatorA); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNbottomWidget, separatorB); argcnt++;
    paned_window = XtCreateWidget("paned_window",
		xmPanedWindowWidgetClass,
		form,
		args,
		argcnt);

    XtManageChild(paned_window);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNmarginWidth, (short)0); argcnt++;
    XtSetArg(args[argcnt], XmNallowResize, False); argcnt++;
    XtSetArg(args[argcnt], XmNpaneMinimum, (int)100); argcnt++;
    XtSetArg(args[argcnt], XmNx, 3); argcnt++;
    XtSetArg(args[argcnt], XmNy, 3); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 588); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 316); argcnt++;
    paned_window1 = XtCreateWidget("paned_window1",
		xmPanedWindowWidgetClass,
		paned_window,
		args,
		argcnt);

    XshPanedWindowCreate(paned_window1, (caddr_t)0, (caddr_t)0);
    XtManageChild(paned_window1);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNscrollingPolicy, XmAUTOMATIC); argcnt++;
    XtSetArg(args[argcnt], XmNscrollBarDisplayPolicy, XmSTATIC); argcnt++;
    XtSetArg(args[argcnt], XmNscrollBarPlacement, XmBOTTOM_LEFT); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 3); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 588); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 310); argcnt++;
    scrolled_window = XtCreateWidget("scrolled_window",
		xmScrolledWindowWidgetClass,
		paned_window1,
		args,
		argcnt);

    ScrollCreate(scrolled_window, (caddr_t)&XshCbs, (caddr_t)0);
    XtManageChild(scrolled_window);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)20); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, directory_label); argcnt++;
    XtSetValues(separatorA, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)-5); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, directory_label); argcnt++;
    XtSetValues(directory_text, args, argcnt);

    return( retval );
}

Widget
Createselection_box(parent)
Widget parent;
{
    Arg    	args[512];
    int    	argcnt;
    Widget 	retval;
    XmString	xmstr[32];
    XmString	*xmstrTable[8];
    Widget	selection_box;
    XmRegisterConverters();
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNsensitive, True); argcnt++;
    XtSetArg(args[argcnt], XmNmappedWhenManaged, True); argcnt++;
    XtSetArg(args[argcnt], XmNallowOverlap, True); argcnt++;
    XtSetArg(args[argcnt], XmNdialogTitle, (xmstr[0]=XmStringCreateLtoR(
		"Create Directory",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNselectionLabelString, (xmstr[1]=XmStringCreateLtoR(
		"Directory Name",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNokLabelString, (xmstr[2]=XmStringCreateLtoR(
		"OK",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNapplyLabelString, (xmstr[3]=XmStringCreateLtoR(
		"Apply",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNcancelLabelString, (xmstr[4]=XmStringCreateLtoR(
		"Cancel",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNhelpLabelString, (xmstr[5]=XmStringCreateLtoR(
		"Help",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNdialogType, XmDIALOG_PROMPT); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 172); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 113); argcnt++;
    selection_box = XtCreateWidget("selection_box",
		xmSelectionBoxWidgetClass,
		parent,
		args,
		argcnt);
    XmStringFree( xmstr[0] );
    XmStringFree( xmstr[1] );
    XmStringFree( xmstr[2] );
    XmStringFree( xmstr[3] );
    XmStringFree( xmstr[4] );
    XmStringFree( xmstr[5] );

    XtAddCallback(selection_box, XmNokCallback, XshDirCreate, (caddr_t)&XshCbs);
    retval = selection_box;

    return( retval );
}

Widget
Createdirectory_selection(parent)
Widget parent;
{
    Arg    	args[512];
    int    	argcnt;
    Widget 	retval;
    XmString	xmstr[32];
    XmString	*xmstrTable[8];
    Widget	directory_selection;
    XmRegisterConverters();
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNmarginHeight, (short)10); argcnt++;
    XtSetArg(args[argcnt], XmNautoUnmanage, True); argcnt++;
    XtSetArg(args[argcnt], XmNlistVisibleItemCount, (int)7); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 394); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 350); argcnt++;
    directory_selection = XtCreateWidget("directory_selection",
		xmFileSelectionBoxWidgetClass,
		parent,
		args,
		argcnt);

    XshFileSBoxCreate(directory_selection, (caddr_t)0, (caddr_t)0);
    retval = directory_selection;

    return( retval );
}

Widget
Createform1(parent)
Widget parent;
{
    Arg    	args[512];
    int    	argcnt;
    Widget 	retval;
    XmString	xmstr[32];
    XmString	*xmstrTable[8];
    Widget	form1;
    Widget	from_text;
    Widget	current_label;
    Widget	from_label;
    Widget	to_label;
    Widget	to_text;
    Widget	separatorI;
    Widget	ok_button;
    Widget	cancel_button;
    XmRegisterConverters();
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNresizePolicy, XmRESIZE_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNnoResize, False); argcnt++;
    XtSetArg(args[argcnt], XmNfractionBase, (int)7); argcnt++;
    XtSetArg(args[argcnt], XmNrubberPositioning, False); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 415); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 200); argcnt++;
    form1 = XtCreateWidget("form1",
		xmFormWidgetClass,
		parent,
		args,
		argcnt);

    createCopyMoveForm(form1, (caddr_t)0, (caddr_t)0);
    retval = form1;
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNshadowThickness, (short)2); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Cancel",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_POSITION); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNleftPosition, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNrightPosition, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNx, 296); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 60); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 32); argcnt++;
    cancel_button = XtCreateWidget("cancel_button",
		xmPushButtonWidgetClass,
		form1,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(cancel_button, XmNactivateCallback, cancelCopyMoveCB, (caddr_t)0);
    XtManageChild(cancel_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNhighlightOnEnter, True); argcnt++;
    XtSetArg(args[argcnt], XmNshadowThickness, (short)2); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"OK",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNshowAsDefault, (short)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_POSITION); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNleftPosition, (int)1); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 59); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 60); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 32); argcnt++;
    ok_button = XtCreateWidget("ok_button",
		xmPushButtonWidgetClass,
		form1,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(ok_button, XmNactivateCallback, okCopyMoveCB, (caddr_t)&XshCbs);
    XtManageChild(ok_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)2); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)2); argcnt++;
    XtSetArg(args[argcnt], XmNx, 2); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 411); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 10); argcnt++;
    separatorI = XtCreateWidget("separatorI",
		xmSeparatorWidgetClass,
		form1,
		args,
		argcnt);

    XtManageChild(separatorI);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNcolumns, (short)65); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)1); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    to_text = XtCreateWidget("to_text",
		xmTextWidgetClass,
		form1,
		args,
		argcnt);

    XtManageChild(to_text);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"To:",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 20); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 20); argcnt++;
    to_label = XtCreateWidget("to_label",
		xmLabelWidgetClass,
		form1,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(to_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"From:",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 20); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 40); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 20); argcnt++;
    from_label = XtCreateWidget("from_label",
		xmLabelWidgetClass,
		form1,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(from_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNalignment, XmALIGNMENT_BEGINNING); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Current directory is",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    XtSetArg(args[argcnt], XmNy, 10); argcnt++;
    current_label = XtCreateWidget("current_label",
		xmLabelWidgetClass,
		form1,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(current_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNshadowThickness, (short)2); argcnt++;
    XtSetArg(args[argcnt], XmNcolumns, (short)54); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)1); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, from_label); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNleftWidget, from_label); argcnt++;
    from_text = XtCreateWidget("from_text",
		xmTextWidgetClass,
		form1,
		args,
		argcnt);

    XtManageChild(from_text);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, current_label); argcnt++;
    XtSetValues(from_label, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, from_text); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNleftWidget, from_label); argcnt++;
    XtSetValues(to_label, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, to_label); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNleftWidget, from_text); argcnt++;
    XtSetValues(to_text, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, to_text); argcnt++;
    XtSetValues(separatorI, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, separatorI); argcnt++;
    XtSetValues(ok_button, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, ok_button); argcnt++;
    XtSetValues(cancel_button, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNdefaultButton, ok_button); argcnt++;
    XtSetValues(form1, args, argcnt);

    return( retval );
}

Widget
Createform2(parent)
Widget parent;
{
    Arg    	args[512];
    int    	argcnt;
    Widget 	retval;
    XmString	xmstr[32];
    XmString	*xmstrTable[8];
    Widget	form2;
    Widget	size_label;
    Widget	type_label;
    Widget	nlinks_label;
    Widget	times_label;
    Widget	access_label;
    Widget	modification_label;
    Widget	status_label;
    Widget	permissions_label;
    Widget	name_label;
    Widget	name_text;
    Widget	separatorC;
    Widget	previous_button;
    Widget	next_button;
    Widget	apply_button;
    Widget	dismiss_button;
    Widget	frame1;
    Widget	form3;
    Widget	row_column;
    Widget	owner_label1;
    Widget	group_label1;
    Widget	others_label;
    Widget	read1_toggle;
    Widget	read2_toggle;
    Widget	read3_toggle;
    Widget	write1_toggle;
    Widget	write2_toggle;
    Widget	write3_toggle;
    Widget	execute1_toggle;
    Widget	execute2_toggle;
    Widget	execute3_toggle;
    Widget	setuid_toggle;
    Widget	setgid_toggle;
    Widget	sticky_toggle;
    Widget	frame;
    Widget	icon_label;
    Widget	linked_to_label;
    Widget	scrolled_window2;
    Widget	list1;
    Widget	owner_label;
    Widget	group_label;
    Widget	scrolled_window1;
    Widget	list2;
    Widget	apply_all_toggle;
    Widget	apply1_all_toggle;
    Widget	apply2_all_toggle;
    Widget	linked_to_text;
    XmRegisterConverters();
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNautoUnmanage, False); argcnt++;
    XtSetArg(args[argcnt], XmNnoResize, False); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 535); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 710); argcnt++;
    form2 = XtCreateWidget("form2",
		xmFormWidgetClass,
		parent,
		args,
		argcnt);

    retval = form2;
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNvalue, "\n\
"); argcnt++;
    XtSetArg(args[argcnt], XmNeditable, False); argcnt++;
    XtSetArg(args[argcnt], XmNcolumns, (short)58); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)1); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)12); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)0); argcnt++;
    linked_to_text = XtCreateWidget("linked_to_text",
		xmTextWidgetClass,
		form2,
		args,
		argcnt);

    createPropertiesForm(linked_to_text, (caddr_t)3, (caddr_t)0);
    XtManageChild(linked_to_text);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNalignment, XmALIGNMENT_BEGINNING); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Apply to all selected",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 378); argcnt++;
    apply2_all_toggle = XtCreateWidget("apply2_all_toggle",
		xmToggleButtonWidgetClass,
		form2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(apply2_all_toggle, (caddr_t)23, (caddr_t)0);
    XtManageChild(apply2_all_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNalignment, XmALIGNMENT_BEGINNING); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Apply to all selected",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 378); argcnt++;
    apply1_all_toggle = XtCreateWidget("apply1_all_toggle",
		xmToggleButtonWidgetClass,
		form2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(apply1_all_toggle, (caddr_t)28, (caddr_t)0);
    XtManageChild(apply1_all_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNalignment, XmALIGNMENT_BEGINNING); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Apply to all selected",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 378); argcnt++;
    apply_all_toggle = XtCreateWidget("apply_all_toggle",
		xmToggleButtonWidgetClass,
		form2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(apply_all_toggle, (caddr_t)22, (caddr_t)0);
    XtManageChild(apply_all_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNscrollingPolicy, XmAPPLICATION_DEFINED); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 160); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 56); argcnt++;
    scrolled_window1 = XtCreateWidget("scrolled_window1",
		xmScrolledWindowWidgetClass,
		form2,
		args,
		argcnt);

    XtManageChild(scrolled_window1);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Group",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    group_label = XtCreateWidget("group_label",
		xmLabelWidgetClass,
		form2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(group_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Owner",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)30); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    owner_label = XtCreateWidget("owner_label",
		xmLabelWidgetClass,
		form2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(owner_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNscrollingPolicy, XmAPPLICATION_DEFINED); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)20); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 160); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 56); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, owner_label); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNleftWidget, owner_label); argcnt++;
    scrolled_window2 = XtCreateWidget("scrolled_window2",
		xmScrolledWindowWidgetClass,
		form2,
		args,
		argcnt);

    XtManageChild(scrolled_window2);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Linked To",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)17); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    linked_to_label = XtCreateWidget("linked_to_label",
		xmLabelWidgetClass,
		form2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(linked_to_label, (caddr_t)31, (caddr_t)0);
    XtManageChild(linked_to_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNshadowThickness, (short)5); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNresizable, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 450); argcnt++;
    XtSetArg(args[argcnt], XmNy, 10); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 70); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 50); argcnt++;
    frame = XtCreateWidget("frame",
		xmFrameWidgetClass,
		form2,
		args,
		argcnt);

    XtManageChild(frame);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNmarginHeight, (short)10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 515); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 155); argcnt++;
    frame1 = XtCreateWidget("frame1",
		xmFrameWidgetClass,
		form2,
		args,
		argcnt);

    XtManageChild(frame1);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Dismiss",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_POSITION); argcnt++;
    XtSetArg(args[argcnt], XmNleftPosition, (int)77); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNx, 412); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 80); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 32); argcnt++;
    dismiss_button = XtCreateWidget("dismiss_button",
		xmPushButtonWidgetClass,
		form2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(dismiss_button, XmNactivateCallback, propCancelCB, (caddr_t)&XshCbs);
    createPropertiesForm(dismiss_button, (caddr_t)27, (caddr_t)0);
    XtManageChild(dismiss_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Apply",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNshowAsDefault, (short)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_POSITION); argcnt++;
    XtSetArg(args[argcnt], XmNleftPosition, (int)3); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNx, 16); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 80); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 32); argcnt++;
    apply_button = XtCreateWidget("apply_button",
		xmPushButtonWidgetClass,
		form2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(apply_button, XmNactivateCallback, propApplyCB, (caddr_t)&XshCbs);
    createPropertiesForm(apply_button, (caddr_t)24, (caddr_t)0);
    XtManageChild(apply_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Next",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_POSITION); argcnt++;
    XtSetArg(args[argcnt], XmNleftPosition, (int)28); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNx, 150); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 80); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 32); argcnt++;
    next_button = XtCreateWidget("next_button",
		xmPushButtonWidgetClass,
		form2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(next_button, XmNactivateCallback, propNextCB, (caddr_t)&XshCbs);
    createPropertiesForm(next_button, (caddr_t)25, (caddr_t)0);
    XtManageChild(next_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Previous",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_POSITION); argcnt++;
    XtSetArg(args[argcnt], XmNleftPosition, (int)53); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNx, 284); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 80); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 32); argcnt++;
    previous_button = XtCreateWidget("previous_button",
		xmPushButtonWidgetClass,
		form2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(previous_button, XmNactivateCallback, propPrevCB, (caddr_t)&XshCbs);
    createPropertiesForm(previous_button, (caddr_t)26, (caddr_t)0);
    XtManageChild(previous_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNshadowThickness, (short)3); argcnt++;
    XtSetArg(args[argcnt], XmNtopShadowColor, COLOR(parent, "#ffffff")); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)2); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 533); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 20); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, frame1); argcnt++;
    separatorC = XtCreateWidget("separatorC",
		xmSeparatorWidgetClass,
		form2,
		args,
		argcnt);

    XtManageChild(separatorC);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNeditable, False); argcnt++;
    XtSetArg(args[argcnt], XmNcolumns, (short)62); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)1); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNy, 15); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNrightWidget, frame); argcnt++;
    name_text = XtCreateWidget("name_text",
		xmTextWidgetClass,
		form2,
		args,
		argcnt);

    createPropertiesForm(name_text, (caddr_t)0, (caddr_t)0);
    XtManageChild(name_text);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Name",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    XtSetArg(args[argcnt], XmNy, 20); argcnt++;
    name_label = XtCreateWidget("name_label",
		xmLabelWidgetClass,
		form2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(name_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Permissions",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    permissions_label = XtCreateWidget("permissions_label",
		xmLabelWidgetClass,
		form2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(permissions_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Last status change: ",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)20); argcnt++;
    XtSetArg(args[argcnt], XmNx, 20); argcnt++;
    status_label = XtCreateWidget("status_label",
		xmLabelWidgetClass,
		form2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(status_label, (caddr_t)9, (caddr_t)0);
    XtManageChild(status_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Last modification: ",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)20); argcnt++;
    XtSetArg(args[argcnt], XmNx, 20); argcnt++;
    modification_label = XtCreateWidget("modification_label",
		xmLabelWidgetClass,
		form2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(modification_label, (caddr_t)8, (caddr_t)0);
    XtManageChild(modification_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Last access: ",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)20); argcnt++;
    XtSetArg(args[argcnt], XmNx, 20); argcnt++;
    access_label = XtCreateWidget("access_label",
		xmLabelWidgetClass,
		form2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(access_label, (caddr_t)7, (caddr_t)0);
    XtManageChild(access_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Access times",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, scrolled_window1); argcnt++;
    times_label = XtCreateWidget("times_label",
		xmLabelWidgetClass,
		form2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(times_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Number of links: ",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    nlinks_label = XtCreateWidget("nlinks_label",
		xmLabelWidgetClass,
		form2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(nlinks_label, (caddr_t)2, (caddr_t)0);
    XtManageChild(nlinks_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Type",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)8); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, frame); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNleftWidget, frame); argcnt++;
    type_label = XtCreateWidget("type_label",
		xmLabelWidgetClass,
		form2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(type_label, (caddr_t)4, (caddr_t)0);
    XtManageChild(type_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Size: ",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, name_label); argcnt++;
    size_label = XtCreateWidget("size_label",
		xmLabelWidgetClass,
		form2,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(size_label, (caddr_t)1, (caddr_t)0);
    XtManageChild(size_label);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, size_label); argcnt++;
    XtSetValues(nlinks_label, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, times_label); argcnt++;
    XtSetValues(access_label, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, access_label); argcnt++;
    XtSetValues(modification_label, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, modification_label); argcnt++;
    XtSetValues(status_label, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, status_label); argcnt++;
    XtSetValues(permissions_label, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNleftWidget, name_label); argcnt++;
    XtSetValues(name_text, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, separatorC); argcnt++;
    XtSetValues(previous_button, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, separatorC); argcnt++;
    XtSetValues(next_button, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, separatorC); argcnt++;
    XtSetValues(apply_button, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, separatorC); argcnt++;
    XtSetValues(dismiss_button, args, argcnt);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNsensitive, True); argcnt++;
    XtSetArg(args[argcnt], XmNrubberPositioning, False); argcnt++;
    XtSetArg(args[argcnt], XmNx, 3); argcnt++;
    XtSetArg(args[argcnt], XmNy, 13); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 509); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 129); argcnt++;
    form3 = XtCreateWidget("form3",
		xmFormWidgetClass,
		frame1,
		args,
		argcnt);

    createPropertiesForm(form3, (caddr_t)30, (caddr_t)0);
    XtManageChild(form3);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNalignment, XmALIGNMENT_BEGINNING); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Sticky bit",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)4); argcnt++;
    XtSetArg(args[argcnt], XmNbottomOffset, (int)11); argcnt++;
    XtSetArg(args[argcnt], XmNx, 50); argcnt++;
    sticky_toggle = XtCreateWidget("sticky_toggle",
		xmToggleButtonWidgetClass,
		form3,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(sticky_toggle, (caddr_t)21, (caddr_t)0);
    XtManageChild(sticky_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNsensitive, True); argcnt++;
    XtSetArg(args[argcnt], XmNadjustLast, True); argcnt++;
    XtSetArg(args[argcnt], XmNspacing, (Dimension)1); argcnt++;
    XtSetArg(args[argcnt], XmNentryAlignment, XmALIGNMENT_BEGINNING); argcnt++;
    XtSetArg(args[argcnt], XmNadjustMargin, True); argcnt++;
    XtSetArg(args[argcnt], XmNpacking, XmPACK_COLUMN); argcnt++;
    XtSetArg(args[argcnt], XmNnumColumns, (short)5); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_POSITION); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopPosition, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 6); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 509); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 59); argcnt++;
    row_column = XtCreateWidget("row_column",
		xmRowColumnWidgetClass,
		form3,
		args,
		argcnt);

    XtManageChild(row_column);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Owner",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 3); argcnt++;
    XtSetArg(args[argcnt], XmNy, 3); argcnt++;
    owner_label1 = XtCreateWidget("owner_label1",
		xmLabelWidgetClass,
		row_column,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(owner_label1);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Group",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 3); argcnt++;
    XtSetArg(args[argcnt], XmNy, 21); argcnt++;
    group_label1 = XtCreateWidget("group_label1",
		xmLabelWidgetClass,
		row_column,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(group_label1);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Others",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 3); argcnt++;
    XtSetArg(args[argcnt], XmNy, 39); argcnt++;
    others_label = XtCreateWidget("others_label",
		xmLabelWidgetClass,
		row_column,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(others_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNalignment, XmALIGNMENT_BEGINNING); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Read",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 67); argcnt++;
    XtSetArg(args[argcnt], XmNy, 3); argcnt++;
    read1_toggle = XtCreateWidget("read1_toggle",
		xmToggleButtonWidgetClass,
		row_column,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(read1_toggle, (caddr_t)10, (caddr_t)0);
    XtManageChild(read1_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNalignment, XmALIGNMENT_BEGINNING); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Read",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 67); argcnt++;
    XtSetArg(args[argcnt], XmNy, 21); argcnt++;
    read2_toggle = XtCreateWidget("read2_toggle",
		xmToggleButtonWidgetClass,
		row_column,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(read2_toggle, (caddr_t)14, (caddr_t)0);
    XtManageChild(read2_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNalignment, XmALIGNMENT_BEGINNING); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Read",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 67); argcnt++;
    XtSetArg(args[argcnt], XmNy, 39); argcnt++;
    read3_toggle = XtCreateWidget("read3_toggle",
		xmToggleButtonWidgetClass,
		row_column,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(read3_toggle, (caddr_t)18, (caddr_t)0);
    XtManageChild(read3_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNalignment, XmALIGNMENT_BEGINNING); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Write",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 131); argcnt++;
    XtSetArg(args[argcnt], XmNy, 3); argcnt++;
    write1_toggle = XtCreateWidget("write1_toggle",
		xmToggleButtonWidgetClass,
		row_column,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(write1_toggle, (caddr_t)11, (caddr_t)0);
    XtManageChild(write1_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNalignment, XmALIGNMENT_BEGINNING); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Write",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 131); argcnt++;
    XtSetArg(args[argcnt], XmNy, 21); argcnt++;
    write2_toggle = XtCreateWidget("write2_toggle",
		xmToggleButtonWidgetClass,
		row_column,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(write2_toggle, (caddr_t)15, (caddr_t)0);
    XtManageChild(write2_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNalignment, XmALIGNMENT_BEGINNING); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Write",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 131); argcnt++;
    XtSetArg(args[argcnt], XmNy, 39); argcnt++;
    write3_toggle = XtCreateWidget("write3_toggle",
		xmToggleButtonWidgetClass,
		row_column,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(write3_toggle, (caddr_t)19, (caddr_t)0);
    XtManageChild(write3_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNalignment, XmALIGNMENT_BEGINNING); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Execute",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNfillOnSelect, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 195); argcnt++;
    XtSetArg(args[argcnt], XmNy, 3); argcnt++;
    execute1_toggle = XtCreateWidget("execute1_toggle",
		xmToggleButtonWidgetClass,
		row_column,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(execute1_toggle, (caddr_t)12, (caddr_t)0);
    XtManageChild(execute1_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNalignment, XmALIGNMENT_BEGINNING); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Execute",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 195); argcnt++;
    XtSetArg(args[argcnt], XmNy, 21); argcnt++;
    execute2_toggle = XtCreateWidget("execute2_toggle",
		xmToggleButtonWidgetClass,
		row_column,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(execute2_toggle, (caddr_t)16, (caddr_t)0);
    XtManageChild(execute2_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNalignment, XmALIGNMENT_BEGINNING); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Execute",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 195); argcnt++;
    XtSetArg(args[argcnt], XmNy, 39); argcnt++;
    execute3_toggle = XtCreateWidget("execute3_toggle",
		xmToggleButtonWidgetClass,
		row_column,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(execute3_toggle, (caddr_t)20, (caddr_t)0);
    XtManageChild(execute3_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNalignment, XmALIGNMENT_BEGINNING); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"SetUid",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 259); argcnt++;
    XtSetArg(args[argcnt], XmNy, 3); argcnt++;
    setuid_toggle = XtCreateWidget("setuid_toggle",
		xmToggleButtonWidgetClass,
		row_column,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(setuid_toggle, (caddr_t)13, (caddr_t)0);
    XtManageChild(setuid_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNalignment, XmALIGNMENT_BEGINNING); argcnt++;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"SetGid",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 259); argcnt++;
    XtSetArg(args[argcnt], XmNy, 21); argcnt++;
    setgid_toggle = XtCreateWidget("setgid_toggle",
		xmToggleButtonWidgetClass,
		row_column,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createPropertiesForm(setgid_toggle, (caddr_t)17, (caddr_t)0);
    XtManageChild(setgid_toggle);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)4); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, row_column); argcnt++;
    XtSetValues(sticky_toggle, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, permissions_label); argcnt++;
    XtSetValues(frame1, args, argcnt);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNsensitive, True); argcnt++;
    XtSetArg(args[argcnt], XmNlabelType, 1); argcnt++;
    XtSetArg(args[argcnt], XmNmarginWidth, (short)30); argcnt++;
    XtSetArg(args[argcnt], XmNmarginHeight, (short)20); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 5); argcnt++;
    XtSetArg(args[argcnt], XmNy, 5); argcnt++;
    icon_label = XtCreateWidget("icon_label",
		xmLabelWidgetClass,
		frame,
		args,
		argcnt);

    createPropertiesForm(icon_label, (caddr_t)29, (caddr_t)0);
    XtManageChild(icon_label);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)17); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, nlinks_label); argcnt++;
    XtSetValues(linked_to_label, args, argcnt);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNitemCount, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNselectedItemCount, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNlistSizePolicy, XmCONSTANT); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 160); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 56); argcnt++;
    list1 = XtCreateWidget("list1",
		xmListWidgetClass,
		scrolled_window2,
		args,
		argcnt);

    createPropertiesForm(list1, (caddr_t)5, (caddr_t)0);
    XtManageChild(list1);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)30); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, linked_to_label); argcnt++;
    XtSetValues(owner_label, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)15); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, scrolled_window2); argcnt++;
    XtSetValues(group_label, args, argcnt);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNitemCount, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNlistSizePolicy, XmCONSTANT); argcnt++;
    XtSetArg(args[argcnt], XmNscrollBarDisplayPolicy, XmDYNAMIC); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 160); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 56); argcnt++;
    list2 = XtCreateWidget("list2",
		xmListWidgetClass,
		scrolled_window1,
		args,
		argcnt);

    createPropertiesForm(list2, (caddr_t)6, (caddr_t)0);
    XtManageChild(list2);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, group_label); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNleftWidget, scrolled_window2); argcnt++;
    XtSetValues(scrolled_window1, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, permissions_label); argcnt++;
    XtSetValues(apply_all_toggle, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, owner_label); argcnt++;
    XtSetValues(apply1_all_toggle, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, group_label); argcnt++;
    XtSetValues(apply2_all_toggle, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)12); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, nlinks_label); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNleftWidget, linked_to_label); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNrightWidget, name_text); argcnt++;
    XtSetValues(linked_to_text, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNdefaultButton, apply_button); argcnt++;
    XtSetValues(form2, args, argcnt);

    return( retval );
}

Widget
Createform4(parent)
Widget parent;
{
    Arg    	args[512];
    int    	argcnt;
    Widget 	retval;
    XmString	xmstr[32];
    XmString	*xmstrTable[8];
    Widget	form4;
    Widget	scrolled_window3;
    Widget	dismiss_button1;
    XmRegisterConverters();
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 352); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 372); argcnt++;
    form4 = XtCreateWidget("form4",
		xmFormWidgetClass,
		parent,
		args,
		argcnt);

    retval = form4;
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNx, 20); argcnt++;
    XtSetArg(args[argcnt], XmNy, 340); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 100); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 32); argcnt++;
    dismiss_button1 = XtCreateWidget("dismiss_button1",
		xmPushButtonWidgetClass,
		form4,
		args,
		argcnt);

    XtManageChild(dismiss_button1);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNscrollingPolicy, XmAUTOMATIC); argcnt++;
    XtSetArg(args[argcnt], XmNbottomAttachment, XmATTACH_POSITION); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNbottomPosition, (int)80); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 10); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 352); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 288); argcnt++;
    scrolled_window3 = XtCreateWidget("scrolled_window3",
		xmScrolledWindowWidgetClass,
		form4,
		args,
		argcnt);

    XtManageChild(scrolled_window3);

    return( retval );
}

