
/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * Macros
 */

#include <string.h>
#include "platform_dependent.h"

#define max(x,y)        ((x)>(y)?(x):(y))

#define LINK_MAX	45
#define MAXLINE		80


#define PERMS   1
#define NLINKS  2
#define OWNER   4
#define GROUP   8
#define SIZE    16
#define ACCTM   32
#define MODTM   64
#define SCTM	128
#define LONG    256


#define _PERMS	0
#define _NLINKS 1
#define _OWNER	2
#define _GROUP	3
#define _DEVID	4
#define _SIZE	5
#define _ACCTM	6
#define _MODTM	7
#define _SCTM	8
#define _FILENAME 9
#define _LINKED	10


/*
 * Path functions
 */

extern int 	_pathcmp();
extern char 	*_pathcat (); 
extern char	*_dircat ();
extern int	_isfilename ();
extern int	_isdir ();
extern char 	*long_listing_entry();
extern char	**long_list_entry();
extern char	*fgettoken();
extern char    *basename ();
extern char	*_dirname ();
extern char	*_getcwd ();

/*
 * String functions
 */

extern char 	*_strclone ();
extern char	*_stralloc ();
extern char	*_strconcat ();
extern char	*_stripnl ();
extern char	*_sgettoken ();
extern char	*_sskipspaces ();
extern char	*_sgetword ();
extern char	*_sgetnum ();
extern char	*_stripquotes ();

/*
 * argv functions
 */

extern char     **_preappend ();
extern char     **_append ();
extern char     **_argvconcat ();


/*
 * Miscellaneous Functions
 */

int _panic ();
extern char *cmcat ();
extern char **cnvStrToArgv ();
extern char *_Cargvtocmd ();
extern char *_syserror ();
extern char **_dirtoargv ();
extern char *_basename ();
extern char *_vstrconcat ();
extern char *_mktmp ();


#define _ptradjust(p,old,new) \
((p)?((char *) (new) + ((char *) (p) - (char *) (old))):NULL)

#define _InvalidArg(s)  ((fprintf(stderr, s)?NULL:NULL)) /* This returns
 NULL */


/*
 * String Macros (deal with Null pointers)
 */

#define _strlen(s)	(s?strlen(s):0)
#define _strcmp(s,s1)   (s?(s1?strcmp(s,s1):1):(s1?-1:0))
#define _strcat(s,s1)   (s?(s1?strcat(s,s1):s):(char *) _InvalidArg("_strcat:Invalid arguments\n"))
