
/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/Text.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/LabelG.h>
#include <Xm/CascadeB.h>

#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <signal.h>


#include "lst.h"
#include "Dir.h"
#include "Xsh.h"
#include "X.h"
#include "xentry_form.h"
#include "XedwList.h"
#include "build_option.h"
#include "etc.h"
#include "file.h"
#include "Openscript.h"



extern char *_homepath;
extern char *_freedompath;	/* Path to .freedom under the home directory */
extern char *_lgroupspath;	/* Path to the Groups directory              */
extern char *_lfreedompath;	/* Path to the Freedom Software directory    */
extern char *_groupsname;	/* Name of the Group directory               */
extern char *_maingroup;	/* Name of the main group directory          */
static char *_startgroup = "Startup";	/* Name of the startup group directory       */
static char *lstartpath;	/* Path of the Startup group                 */

XshCallbackStruct XshCbs;

void XpmOpenItem();
void XpmNewGroup();
void XpmNewItem();
void XpmProperties();
void XpmCopyTo();
void XpmMoveTo();
void XpmRemove();
void XpmRemoveGroup();
void closeCB ();
void XpmCreateActionMenu ();
void XpmSelectCB ();
void XpmCreateASubMenu ();

/*
 * Popup menus (Right mouse button)
 */
 
MenuItem file_menu[] = {
	{"separator0", &xmSeparatorWidgetClass, NULL, NULL, NULL,
	NULL, NULL, NULL},
	{"Open", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XpmOpenItem, (XtPointer) &XshCbs, NULL},
	{"separator1", &xmSeparatorWidgetClass, NULL, NULL, NULL,
	NULL, NULL, NULL},
	{"New Group ..", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XpmNewGroup, NULL, NULL}, 
	{"New Item ..", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XpmNewItem, NULL, NULL}, 
	{"separator2", &xmSeparatorWidgetClass, NULL, NULL, NULL,
	NULL, NULL, NULL},
	{"Copy To ..", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XpmCopyTo, (XtPointer) &XshCbs, NULL}, 
	{"Move To ..", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XpmMoveTo, (XtPointer) &XshCbs, NULL}, 
	{"separator3", &xmSeparatorWidgetClass, NULL, NULL, NULL,
	NULL, NULL, NULL},
	{"Remove Group ..", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XpmRemoveGroup, NULL, NULL}, 
	{"Close", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	closeCB, NULL, NULL}, 
	NULL,
};

MenuItem dummy_actions[] = {
	{"Open", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XpmOpenItem, (XtPointer) &XshCbs, NULL},
	NULL,
};

MenuItem item_menu[] = {
	{"Actions", &xmCascadeButtonWidgetClass, NULL, NULL, NULL,
	NULL, NULL, dummy_actions},
	{"separator1", &xmSeparatorWidgetClass, NULL, NULL, NULL,
	NULL, NULL, NULL},
	{"Properties ..", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XpmProperties, (XtPointer) &XshCbs, NULL}, 
	{"Copy To ..", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XpmCopyTo, (XtPointer) &XshCbs, NULL}, 
	{"Move To ..", &xmPushButtonWidgetClass, NULL, NULL, NULL,
	XpmMoveTo, (XtPointer) &XshCbs, NULL}, 
	NULL,
};

static EntryFormObject moveToTrashForm = NULL; /* moveToTrash form */
static EntryFormObject helpForm = NULL;        /* help form */
static EntryFormObject helpSelForm = NULL;     /* help selection dialog */
static EntryFormObject mcForm = NULL;          /* Move/Copy dialog      */
static EntryFormObject appForm = NULL;         /* OpenScript dialog */
static EntryFormObject xpmForm = NULL;         /* Program Manager form */

static char *_missionname = "mission";
extern Widget shell, NewGroupBox, RemoveGroupBox;

static XwDirWidget dirWidget;
static Widget xterm_toggle = NULL;
#ifdef OLD
Widget *mwidgets = NULL;			/* for now */
#endif
MenuItem *menutbl = NULL;			/* for now */

char productname[] = "Freedom Open Desktop";
char version[] = "1.30";

int _demo_mode = 0;	/* demo mode - key not needed */

extern void createCascadeCB ();

/* Macro to free the menu table */

#define _freeMenutbl(mtp) { \
   MenuItem *tmp = mtp;	\
	while (tmp->label) { \
	  free (tmp->label); \
	  tmp++;	\
	} \
	free (mtp); \
	mtp = NULL; \
}

/* helpCB - Help callback */

void helpCB(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   static char *_lmissionpath = NULL;
   Widget dialog;

   switch ((int) client) {
	case 0:

	   XtManageChild  (_EntryFormPosToWidget (helpForm, 0));

	   /* Popup help window */
	   _EntryFormPopup (helpForm);

	   if (!_lmissionpath)
     		_lmissionpath = _dircat (_lfreedompath, _missionname);

     	   if (!_lmissionpath) {
        	fprintf (stderr, "helpCB: _dircat failed\n");
        	return;
     	   }

	   /* Load file into text widget */
	   _XmCloadTextFromFile (_EntryFormPosToWidget (helpForm, 1),
				_lmissionpath);
	   break;
	case 1:
	   _XmCMessageDialogPost (shell,
	   "          Freedom Desktop Lite Version 1.32     \n                     Copyright 1994\n                   Freedom Software\nFull-blown version available on http://www.fsw.com", "Version");
	   break;
	case 2:
	   dialog = _EntryFormPosToWidget (helpSelForm, 0);
	   XtManageChild (dialog);
	   XtPopup (XtParent(dialog), XtGrabNone);
	   break;
	default:
	   break;
   }
	   
}

/* XpmOpenItem - Open Item */

void XpmOpenItem(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
#ifdef OLD
   char *files;
#endif
   XwDirWidget dw = (XwDirWidget) ((XshCallbackStruct *) client)->XshDirWidget;
#ifdef OLD
   extern void XpmNewItem ();
#endif

#ifdef OLD
   /* Get selected items */
   files = XwDirFilesSelected(dw);

   if (!files || !*files) {	/* No items selected */
	XpmNewItem (w, client, call);	/* Invoke dialog to create a new item */
	return;
   }
#endif
	 
   /* Invoke the "Activate" Action procedure */
   XtCallActionProc (dw, "Activate", NULL, NULL, 0);
}


/* XpmNewGroup - Create a new group */

void XpmNewGroup(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
        XtManageChild (NewGroupBox); /* Popup new group dialog */
        XtPopup (XtParent(NewGroupBox), XtGrabNone);
}

/* XpmProperties - Popup the item properties dialog */

void XpmProperties(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   char **files;
   char **data;
   Widget form;
   Widget dw = ((XshCallbackStruct *) client)->XshDirWidget;
   char *path;

   files = XwCollVItemsSelected(dw);
   form = _EntryFormPosToWidget (appForm, 0);

   /* check for selected items */
   if (!files || !*files) {
        _XmCErrorDialogPost (dw,
             "Please select a file before invoking this operation", "Warning");
	return;
   }

   /* Get current path */
   XtVaGetValues (dw, XtNdirectoryPath, &path, NULL);

   path = _dircat (path, *files);
   if (!path)
	return;
	
   /* Try to open the file (assumes OpenScript format) */
   data = _OpenScriptRead (path);

   if (!data) {
  	/* appForm has been unmanaged */
	if (errno > 0)
	   _EntryFormPerror (appForm, path);
	else /* The file is not an OpenScript */
           _XmCErrorDialogPost (dw,
             "Invalid format, please check the file with the editor", "Warning");
	return;
   }

   _EntryFormSLoadData (appForm, data);
   _EntryFormSLoadData (appForm, data); /* hack to make sure that             */
					/* the data gets loaded into the      */
					/* entry form                         */
   XtManageChild (form);
   _EntryFormPopup (appForm);
	
}

/* XpmNewItem - Create a new item */

void XpmNewItem(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
	XtManageChild (_EntryFormPosToWidget (appForm, 0));
	_EntryFormSClear (appForm);	/* Clear the entry form */

	/* Set things up inside the entry form */
	_EntryFormSLoadField (_EntryFormPosToField (appForm, 5), "ON");
	_EntryFormSLoadField (_EntryFormPosToField (appForm, 6), "OFF");
	_EntryFormSLoadField (_EntryFormPosToField (appForm, 7), "OFF");
	_EntryFormPopup (appForm);
}

/* createMoveToTrashForm - Create an entry form (moveToTrashForm) an add  */
/*			   fields to it					  */


createMoveToTrashForm (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{

   if (!moveToTrashForm)
        moveToTrashForm = _EntryFormCreate ();	/* Create an entry form */

   if (!moveToTrashForm ) {
        fprintf (stderr, "createMoveToTrashForm: _EntryFormCreate failed\n");
        return;
   }

   /* Add fields to the entry form */
   _EntryFormSInsertField (moveToTrashForm, w, (int) client);


   /* Unmanage unneeded buttons */
   XtUnmanageChild (XmSelectionBoxGetChild (w, XmDIALOG_HELP_BUTTON));
   XtUnmanageChild (XmSelectionBoxGetChild (w, XmDIALOG_APPLY_BUTTON));


}

/* createAppForm - Create an entry form (appForm) an add  */
/*	           fields to it					  */

createAppForm (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{

   if (!appForm)
        appForm = _EntryFormCreate ();

   if (!appForm ) {
        fprintf (stderr, "createAppForm: _EntryFormCreate failed\n");
        return;
   }


   if ((int) client == 5)
   	xterm_toggle = w;
   	
   _EntryFormSInsertField (appForm, w, (int) client);


}

/* createXpmForm - Create an entry form (xpmForm) an add  */
/*	           fields to it				  */

createXpmForm (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{

   if (!xpmForm)
        xpmForm = _EntryFormCreate ();

   if (!xpmForm ) {
        fprintf (stderr, "createXpmForm: _EntryFormCreate failed\n");
        return;
   }

   _EntryFormSInsertField (xpmForm, w, (int) client);


}

/* createCopyMoveForm - Create an entry form (copyMoveForm) an add  */
/*	                fields to it	    			    */

createCopyMoveForm (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{

   if (!mcForm)
        mcForm = _EntryFormCreate ();

   if (!mcForm ) {
        fprintf (stderr, "createMoveCopyForm: _EntryFormCreate failed\n");
        return;
   }

   _EntryFormSInsertField (mcForm, w, (int) client);

   if ((int) client == 4)
	XtUnmanageChild (XtParent(w));

}

/* XpmGroupToggle - Toggle groups list */

void XpmGroupToggle (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   XmToggleButtonCallbackStruct *acs=(XmToggleButtonCallbackStruct*)call;
   Widget separatorW, listW, scrollW;
   char **dirlist;

   separatorW = _EntryFormPosToWidget (mcForm, 5);
   listW = _EntryFormPosToWidget (mcForm, 4);
   scrollW = XtParent (listW);

   if (!acs->set) {
	XtManageChild (_EntryFormPosToWidget (mcForm, 3));
        XtVaSetValues (separatorW, XmNtopOffset, (int) 5,
                  XmNtopAttachment, XmATTACH_WIDGET,
                  XmNtopWidget, _EntryFormPosToWidget (mcForm, 3), NULL);
	XtUnmanageChild (scrollW);
	return;
   }


   XtManageChild (scrollW);

   XtVaSetValues (separatorW, XmNtopOffset, (int) 5, 
		  XmNtopAttachment, XmATTACH_WIDGET, 
		  XmNtopWidget, scrollW, NULL);

   XtUnmanageChild (_EntryFormPosToWidget (mcForm, 3));
    

   /* Stuff dirlist with the list of group directories */
   dirlist = _dirtoargv (_lgroupspath, 1);
   if (!dirlist)
        return;

   /* Load the entry form mcform with dirlist */
   _XmCListLoad (_EntryFormPosToWidget (mcForm, 4), dirlist);

   /* free dirlist */
   _freeargv (dirlist);
	
}


/* cancelCopyMoveCB - Cancel Button Activate Callback (Copy/Move dialog) */

cancelCopyMoveCB (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   _EntryFormPopdown (mcForm); /* Popdown mcform */
   /* Reset "Copy To Group" toggle button */
   XmToggleButtonSetState (_EntryFormPosToWidget (mcForm, 1), False, True);

}

/* okCopyMoveCB - Ok Button Activate Callback */

okCopyMoveCB (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
  static Widget from = NULL, to = NULL;
  Widget shell;
  char *source, *target;
  char **argv;
  static char mvCmd[] = "mv";
  static char cpCmd[] = "cp -r";
  char *title;
  char *cmd;
  int groupflag = 0;
  char *groupname;
  char *path;


   /* Check state of the "Copy To Group" toggle    */
   if (XmToggleButtonGetState(_EntryFormPosToWidget (mcForm, 1)) == True)
	groupflag = 1;
	
	
   shell = locateShell (_EntryFormPosToWidget (mcForm, 0));
 
   if (!shell)
	return; /* check this */

   /* get source and target */

   if (!from)
        from = _EntryFormPosToWidget (mcForm, 2);

   if (!groupflag && !to)
        to = _EntryFormPosToWidget (mcForm, 3);

#ifdef OLD
   if (!from || !to) {
        XtPopdown(shell);
        return;
   }
#endif

   XtVaGetValues (shell, XmNtitle, &title, NULL);

   source = XmTextGetString (from);
   if (!groupflag)
   	target = XmTextGetString (to);
   else {
	groupname = _EntryFormSGetField (_EntryFormPosToField(mcForm, 4));

	if (!groupname || !strcmp (groupname, ""))
	  return;

        target = _dircat (_lgroupspath, groupname);

	free (groupname);

   }

   if (!strcmp (source, "") || !strcmp (target, "")) {
#ifdef DEBUG
        fprintf (stderr, "okCopyMoveCB: Missing source and/or target\n");
#endif
        XtPopdown((shell));
        return;
   }

   XmTextSetString (from, "");
   if (to)
   	XmTextSetString (to, "");

   /* build command line */
   if (!strcmp (title, "Move"))
        cmd = cmcat (mvCmd, source, target, NULL);
   else
        cmd = cmcat (cpCmd, source, target, NULL);

   if (!cmd) {
        fprintf (stderr, "cmcat failed\n"); 
        XtPopdown((shell));
        return;
   }


   argv = cnvStrToArgv (cmd);

   if (!argv) {
        fprintf (stderr, "okCopyMoveCB: Too many parameters\n");
        XtPopdown(shell);
        return;
   }

   XtVaGetValues (((XshCallbackStruct *) client)->XshDirWidget,
                XtNdirectoryPath, &path, NULL);


   XwDirExecute (((XshCallbackStruct *) client)->XshDirWidget, argv, path, _SHELL);

   XtFree (source);
   XtFree (target); 
   XmToggleButtonSetState (_EntryFormPosToWidget (mcForm, 1), False, True);
   XtPopdown(shell);
}

/* XpmCopyTo - Popup Copy/Move dialog */

void XpmCopyTo(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
  char *path;
  Widget dw = ((XshCallbackStruct *) client)->XshDirWidget;
  Widget shell, from;

	shell = locateShell (_EntryFormPosToWidget (mcForm, 0));

        from = _EntryFormPosToWidget (mcForm, 2);

        if (!from || !shell) {
           return;
        }

        XtVaSetValues (shell, XmNtitle, "Copy", NULL);

        XmTextSetString (from, XwDirFilesSelected(dw));

        _XmClabelSetString (_EntryFormPosToWidget (mcForm, 1), 
		"Copy To Group");

        XtManageChild (_EntryFormPosToWidget (mcForm, 0));
        XtPopup (shell, XtGrabNone);
}


/* XpmCopyTo - Popup Copy/Move dialog */

void XpmMoveTo(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
  char *path;
  Widget dw = ((XshCallbackStruct *) client)->XshDirWidget;
  char *label;
  Widget shell, from;

	shell = locateShell (_EntryFormPosToWidget (mcForm, 0));

        from = _EntryFormPosToWidget (mcForm, 2);

        if (!from || !shell) {
           return;
        }

        XtVaSetValues (shell, XmNtitle, "Move", NULL);

        XmTextSetString (from, XwDirFilesSelected(dw));

        _XmClabelSetString (_EntryFormPosToWidget (mcForm, 1), 
		"Move To Group");

        XtManageChild (_EntryFormPosToWidget (mcForm, 0));
        XtPopup (shell, XtGrabNone);
}

/* XpmRemoveGroup - Popup remove group dialog */

void XpmRemoveGroup(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   Widget dialog_list, widget;
   char **dirlist;


   XtManageChild (RemoveGroupBox);
   XtPopup (XtParent(RemoveGroupBox), XtGrabNone);

   /* Create groups list */
   dirlist = _dirtoargv (_lgroupspath, 1);
   if (!dirlist)
        return;
   widget = _EntryFormPosToWidget (moveToTrashForm, 0);
   if (!widget)
	return;
   dialog_list = XmSelectionBoxGetChild (widget, XmDIALOG_LIST);

   /* Load dialog_list with the content of dirlist */
   _XmCListLoad (dialog_list, dirlist);

   /* free dirlist */
   _freeargv (dirlist);

   XmTextSetString (XmSelectionBoxGetChild (widget, XmDIALOG_TEXT), "");
}

#ifdef OLD
/* locate_widget - Locate a widget by label */

Widget locate_widget (mwidgets, label) 
Widget *mwidgets;
char *label;
{
   char *lbl;
  
        if (mwidgets) { /* widget table */
           while (*mwidgets) {
		lbl = XLabelGetString(*mwidgets); /* Get widget's label */
		if (!lbl)
		   return (NULL);
		if (!strcmp (lbl, label)) /* Compare labels */
		   return (*mwidgets);
		mwidgets++;
	   }

	   return (NULL);
        }
}
#endif

/* XpmRemoveGroupOkCB - Ok Button Activate callback (remove group dialog) */

void XpmRemoveGroupOkCB (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   Widget shell;
   XmSelectionBoxCallbackStruct *cbs = (XmSelectionBoxCallbackStruct *) call;
   char *value;
   char *path;
   char *currpath;
   char *name;
   Widget widget, menu;

        shell = locateShell (_EntryFormPosToWidget (moveToTrashForm, 0));

        switch (cbs->reason) {
           case XmCR_OK:
                XmStringGetLtoR (cbs->value, XmSTRING_DEFAULT_CHARSET,
                        &value);

		/* check if the group is the Main group */
		if (!strcmp (value, "Main")) {
		   if (shell)
                        _XmCErrorDialogPost (shell,
                         	"The Main group can't be removed", "Error");
		   /* what happens if the user removes the Main group by hand ?*/
		   return;
		}
		   
        	path = _dircat (_lgroupspath, value);

		/* check if the group is empty */

		if (!_isempty(path)) {
                        _XmCErrorDialogPost (shell,
"Remove all the group items \n before trying to remove the group itself", "Error");
			return;
		}
		   
		/* unlink group */

		if (rmdir (path) < 0) {
		   free (path);
		   return;
		}
		
		/* eliminate group from the group menu */
#ifdef OLD
		widget = locate_widget (mwidgets, value);
#endif
                XtVaGetValues (_EntryFormPosToWidget (xpmForm, 2), 
                	XmNsubMenuId, &menu, NULL);

                if (!menu) {
                   fprintf (stderr, "BuildMenu: couldn't get submenu widget\n");
                }
		widget = _XmCFindMenuItem (menu, value);		

		if (widget) {
                   XtUnmanageChild (widget);
		   XtDestroyWidget (widget);
		}
		/* check for current group */

        	XtVaGetValues (dirWidget, XtNdirectoryPath, &currpath, NULL);

		name = _basename (currpath);

		if (strcmp (name, value)) {
			_EntryFormPopdown (moveToTrashForm);
			return;
		}

   		path = _dircat (_lgroupspath, _maingroup);

   		if (!path) {
        	   fprintf (stderr, 
			"XpmRemoveGroupOkCB: _dircat failed!\n");
        	   return;
   		}

      		XwDirChange (dirWidget, path);
      		set_curr_group (dirWidget);
		free (path);

		_EntryFormPopdown (moveToTrashForm);
		break;
	   case XmCR_NO_MATCH:
		if (shell)
                        _XmCErrorDialogPost (shell,
                         "Not a valid selection", "Error");
		break;
	   default:
		if (shell)
                        _XmCErrorDialogPost (shell,
                        "Unknown selection", "Error");
	}

}

/*
 * XpmGroupCreate - OK button activate callback (new group dialog)
 */

void XpmGroupCreate (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   char *dname; /* Directory Name */
   char *path;

   XmSelectionBoxCallbackStruct *cbs=(XmSelectionBoxCallbackStruct*)call;

#ifdef DEMO
        _XmCErrorDialogPost (shell,
             "This feature has been disable in this demonstration version", 
	     "Warning");
	return;
#endif

	/* Get group name */
        XmStringGetLtoR (cbs->value, XmSTRING_DEFAULT_CHARSET, &dname);

	path = _dircat (_lgroupspath, dname);
        XtFree (dname);

   	if (!path) {
           fprintf (stderr, "XpmGroupCreate: _dircat failed\n");
           return;
   	}

	/* Create directory */
        XwDirCreate (((XshCallbackStruct *) client)->XshDirWidget, path);
	free (path);

#ifdef OLD
	if (mwidgets) {
	   while (*mwidgets)
	     XtDestroyWidget (*mwidgets++);
	   mwidgets = NULL;
	}
#endif
	_XmCDeleteMenuItems (_XmCGetSubmenu(_EntryFormPosToWidget(xpmForm, 2)));
	if (menutbl) {
	  _freeMenutbl (menutbl);
	}

#ifdef OLD
	createCascadeCB (_EntryFormPosToWidget (xpmForm, 2), NULL, NULL);
#endif
	buildGroupsMenu (_EntryFormPosToWidget (xpmForm, 2), 
		_lgroupspath);
}

XpmHandlePopupMenu(dw, client, call_data)
Widget dw;
caddr_t client;
XedwCallbackStruct *call_data;
{
  static Widget fmenu = NULL;		/* file menu 				*/ 
  static Widget imenu = NULL;		/* item menu (one item selected) 	*/
  int cnt;
  static Widget actions_cascade = NULL;
  
   cnt = XwDirSelectedItemCount (dirWidget);
   
   if (!cnt) {
      if (!fmenu) {
         fmenu = BuildMenu(dw, XmMENU_POPUP, "File", '\0', file_menu, 0);
      }
      
      if (!fmenu) {
#ifdef DEBUG
	fprintf (stderr, "XpmHandlePopupMenu: buildMenu failed\n");
#endif
      	return;
      }
      	
      XmMenuPosition(fmenu, (XButtonPressedEvent *) call_data->event);
      XtManageChild(fmenu);
      return;
   }
   
   if (cnt >= 1) {
      if (!imenu) {
         imenu = BuildMenu(dw, XmMENU_POPUP, "Item", '\0', item_menu, 0);
      }
      
      if (!imenu) {
#ifdef DEBUG
	fprintf (stderr, "XpmHandlePopupMenu: buildMenu failed\n");
#endif
      	return;
      }
      
      if (!actions_cascade)
         actions_cascade = _XmCFindMenuItem (imenu, "Actions");
         
      if (actions_cascade) 
         XpmCreateASubMenu (dw, actions_cascade);
         
      XmMenuPosition(imenu, (XButtonPressedEvent *) call_data->event);
      XtManageChild(imenu);
      return;
   }

}

void createScrolledWindow(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   XmAnyCallbackStruct *acs=(XmAnyCallbackStruct*)call;
   char *path;
   char *params[2];


   /* Get environment variables */
   if (!get_env_var ()) {
        fprintf (stderr,
           "Freedom program  Manager failed while retrieving environment variables\n");
           exit (1);
   }

#ifdef SECURITY
   /* Validate key */
   if (!validate_key (productname, version)) {
        fprintf (stderr, "Xpm: Evaluation mode\n");
	_demo_mode = 1;
   }
#endif

   /* Set up system files */
   if (_setup () != 0) {
           fprintf (stderr,
           "Xpm Warning: problem detected while setting up system files\n");
   }

   _lgroupspath = _dircat (_lfreedompath, _groupsname);

   if (!_lgroupspath) {
	fprintf (stderr, "createScrolledWindow: _dircat failed\n");
	exit (1);
   }

   path = _dircat (_lgroupspath, _maingroup);

   if (!path) {
        fprintf (stderr, "createScrolledWindow: _dircat failed!\n"); 
        exit (1);
   }

#ifdef VERSION2
   /* check that the directory exists and it is readable and writable */
   /* If it does not exist try to create it                           */
#endif
   dirWidget = (XwDirWidget) XtVaCreateManagedWidget( "directoryManager",
        xwDirWidgetClass, w,
        XtNcolumnSpacing, 15,
        XtNrowSpacing, 5,
        XtNdirectoryPath, path,
	XtNinternalHeight, 15,
	XtNinternalWidth, 15,
	XtNshowHidden, True,
        XtNmSelections,    True,
        XtNshowIcons, True,
        XtNbaseDirectory, _freedompath,
        XtNshowParent, False,
        XmNwidth, 300,
        XmNheight, 100,
        NULL );
        
  ((XshCallbackStruct *) client)->XshDirWidget = (Widget) dirWidget;

  XtAddCallback(dirWidget, XtNhandlePopup, XpmHandlePopupMenu, 
  		NULL);

  XtAddCallback(dirWidget, XtNcallback, XpmSelectCB , 
  		NULL);
   
   /* compute path to statup directory */
   lstartpath = _dircat (_lgroupspath, _startgroup);

   if (!lstartpath) {
        fprintf (stderr, "createScrolledWindow: _dircat failed!\n"); 
        exit (1);
   }

   
   if (!_exists (lstartpath)) {		/* Startup directory does not exist */
       /* Set text widget with the name of the current group */
       set_curr_group (dirWidget);
       return;
   }

   params[0] = lstartpath;
   params[1] = NULL;
   
   /* invoke all the files inside the Startup directory */
   XtCallActionProc (dirWidget, "Start", NULL, params, 1);
   
   /* Set text widget with the name of the current group */
   set_curr_group (dirWidget);

}

/* 
 * set_curr_group: Set text widget with the name of the current group
 */
  
set_curr_group (dw)
XwDirWidget dw;
{
   char *name;
   char *currpath;
   Widget curr_group_text;
   char *msg;
   
   XtVaGetValues (dw, XtNdirectoryPath, &currpath, NULL);
   
   if (!currpath)
   	return;
   	
   /* extract basename */ 
   name = _basename (currpath);
   
   msg = (char *) _strconcat ("Current group: ", name);

   XmTextSetString (_EntryFormPosToWidget (xpmForm, 0), msg);
   
   free (msg);
}

/* Dummy function */

unparsefputs () {

}

/* closeCB - Close callback */

void closeCB (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   if (!client) {
   	_XmCConfirmationDialogPost (shell, 
   	"Do you want to exit your Freedom Desktop session ?", 
   	"Confirmation",
   	closeCB, (caddr_t) shell, NULL, NULL);
   	return;
   }

   kill (0, SIGTERM);
   exit (0);
}

/* arrangeIconsCB - Rearrange icons inside the window */

arrangeIconsCB (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
    Widget dir = ((XshCallbackStruct *) client)->XshDirWidget;

   XtCallActionProc (dir, "Cleanup", NULL, NULL, 0);


}

demoCB (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{

   _XmCMessageDialogPost (shell,
	"This feature has been disable in this demonstration version", 
	"Demo version");
}


void XwDirInvokeActionCB (dw, client_data, call_data)
  XwDirWidget     dw;
  caddr_t    client_data;
  XedwCallbackStruct *call_data;
{
   char option[2];
   char *params[2];

   if ((int) client_data < 0 || (int) client_data > 30)
        return;

   sprintf (option, "%d", (int) client_data); /* check limits */
   params[0] = option;
   params[1] = NULL;

   XtCallActionProc (dirWidget, "InvokeAction", NULL, params, 1);
}

/* 
 * popupGroupCB - Change to a different group
 */

void popupGroupCB (dw, client_data, call_data)
  XwDirWidget     dw;
  caddr_t    client_data;
  XedwCallbackStruct *call_data;
{
   String path;
   String params[2];

   path = (String) _dircat (_lgroupspath, (char *) client_data);

   if (!path) {
#ifdef DEBUG
	fprintf (stderr, "popupGroupCB: failed\n");
#endif
	return;
   }

   params[0] = path;
   params[1] = '\0'; 
   XtCallActionProc (dirWidget, "ChangeDirectory", NULL, params, 1);
   
   set_curr_group (dirWidget);

}

  
#define CHUNKSIZE 10

void createCascadeCB (widget, client_data, call_data)
  Widget     widget;
  caddr_t    client_data;
  XedwCallbackStruct *call_data;
{

   createXpmForm (widget, (caddr_t) 2, NULL);
   if (!buildGroupsMenu (widget, _lgroupspath)) {
#ifdef DEBUG
	fprintf (stderr, "createCascadeCB: buildGroupsMenu failed\n");
#endif
	return;
   }

}

/*
 * buildGroupsMenu - Build groups menu
 */

int buildGroupsMenu (cascade, path)
Widget cascade;
char *path;
{

DIR             *dirp;
register struct dirent   *dp;
char *tmp;
MenuItem 	*aux;
MenuItem 	*mtp;
int		tblsiz;
register int	cnt = 0;

  menutbl = (MenuItem *) malloc (sizeof (MenuItem) * CHUNKSIZE);

  if (!menutbl) {
#ifdef DEBUG
	fprintf (stderr, "buildGroupsMenu: not enough memory\n");
#endif
	return (0);
  }

  tblsiz = CHUNKSIZE;
  mtp = menutbl;
  mtp->label = NULL;


  if ((dirp = opendir(path)) == NULL) {
        perror (path);
        return (0);
  }

  while ((dp = readdir(dirp)) != NULL) {
	if (!_strcmp (dp->d_name, "."))
	   continue;
  	if (!_strcmp (dp->d_name, "..")) 
	   continue;
	tmp = _dircat (path, dp->d_name);
	if (!tmp) {
#ifdef DEBUG
	   fprintf (stderr, "buildGroupsMenu: _dircat failed\n");
#endif
	   return (0);
	}
	/* look for directories */
        if (!_isdir (tmp)) {
	   free (tmp);
	   continue;
	}

	free (tmp);

	if (cnt >= tblsiz-1) { /* reserve space for NULL */
	   tblsiz += CHUNKSIZE;
	   aux = (MenuItem *) realloc (menutbl, tblsiz * sizeof (MenuItem));
	   if (!aux) {
#ifdef DEBUG
		fprintf (stderr, "buildGroupsMenu: not enough memory");
#endif
		_freeMenutbl (menutbl);
		return (0);
	   }
	   menutbl = aux;
	   mtp = &aux[cnt];
	}

	mtp->label = strdup (dp->d_name); 

        if (!mtp->label) {
	   _freeMenutbl (menutbl);
	   return (0);
	}

	mtp->class = &xmPushButtonWidgetClass;
	mtp->mnemonic = NULL; 
	mtp->accelerator = NULL;
	mtp->accel_text = NULL;
	mtp->callback = popupGroupCB; 
	mtp->callback_data = (XtPointer) mtp->label;
	mtp->subitems = NULL;
	mtp++;
	cnt++;
   }
   mtp->label = NULL;
   closedir(dirp);

#ifdef OLD
   *mwidgets = (Widget *) malloc (sizeof (Widget) * (cnt + 1));

   if (!*mwidgets) {
	_freeMenutbl (menutbl);
	return (0);
   }
#endif
	
   BuildMenu(cascade, XmMENU_PULLDOWN,"", '\0', menutbl, _SKIP_CREATION);
   
   return (1);

}


char *convert (value)
char *value;
{
  register char *vp, *vp1;
  register int cnt = 0;

   vp = vp1 = value;

   while (*vp) {
	if (!isalpha (*vp)) {
          vp++;
          continue;
        }
	*vp1++ = *vp++;
	if (cnt++ >= 15) {
	   *vp1 = '\0';
	   break;
	}
   }
   *vp1 = '\0';
   return (value);
}


void popupHelpFile (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   static char *_helppath = NULL;
   XmSelectionBoxCallbackStruct *cbs = (XmSelectionBoxCallbackStruct *) call;
   char *value, *path;
   Widget shell;

	if (!_helppath)
               _helppath = _dircat (_freedompath, "help");

        if (!_helppath) {
                fprintf (stderr, "popupHelpFile: _dircat failed\n");
                return;
        }

	shell = locateShell (_EntryFormPosToWidget (helpSelForm, 0));
	switch (cbs->reason) {
	   case XmCR_OK:
           	XtManageChild  (_EntryFormPosToWidget (helpForm, 0));

		XmStringGetLtoR (cbs->value, XmSTRING_DEFAULT_CHARSET,
			&value);
		
		/* Determine path to help file 	       */
		path = _dircat (_helppath, convert(value));

		if (!path) {
		   fprintf (stderr, "popupHelpFile: _dircat failed\n");
		   return;
		}
		/* Load help file into the text widget */
		_XmCloadTextFromFile (_EntryFormPosToWidget (helpForm, 1),
                                path);
		
		break;
	   case XmCR_NO_MATCH:
		if (shell)
			_XmCErrorDialogPost (shell,
			 "Not a valid selection", "Error");
		break;
	   default:
		if (shell)
			_XmCErrorDialogPost (shell,
        		"Unknown selection", "Error");
	}
}

/* 
 * createHelpForm - Create entry form (helpForm) and add fields to it
 */

createHelpForm (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   Widget dialog_list;

   if (!helpForm) {
        helpForm = _EntryFormCreate ();
   }

   if (!helpForm ) {
        fprintf (stderr, "createHelpForm: _EntryFormCreate failed\n");
        return;
   }

   _EntryFormSInsertField (helpForm, w, (int) client);

}


static char *listv[] = { 
	"Introduction",
        "Accelerator Keys",
	"Actions Menu",
	"Clicking and Double Clicking",
	"Default Groups",
	"Drag and Drop",
        "Editor Variable",
	"Edit - Select All",
	"Edit - Unselect All",
	"File - Change To",
	"File - Close",
	"File - Copy Item",
	"File - Copy To",
	"File - Find",
	"File - Home",
	"File - Move Item",
	"File - Move Item(s) To Trash",
	"File - Move To",
	"File - Move To Trash",
	"File - New Group",
	"File - New Directory",
	"File - New Item",
	"File - Open",
	"File - Print",
	"File - Properties",
	"File - Properties (Program Manager)",
	"File - Remove Group",
	"File - Up",
	"File Manager",
	"File Window",
        "Files - .f",
        "Files - .h",
        "Files - Compressed",
	"Files - cpio",
        "Files - Executable",
        "Files - Libraries",
        "Files - Object",
        "Files - OpenScript",
        "Files - Packed",
        "Files - Postscript",
        "Files - XPM",
        "Files - makefile",
        "Files - tar",
        "Files - xwd",
	"Groups Menu",
	"Help",
	"Meta Key",
        "Motif - Window Close",
        "Motif - Window Maximize",
        "Motif - Window Minimize",
        "Motif - Window Panes",
        "Motif - Window Sash",
        "Motif - Window Scroll",
        "Motif - Window Size",
	"Mouse",
	"Mouse - Right Mouse Button",
	"Options - Keep Synchronized",
	"Options - Terminal Mode",
	"Program Manager",
	"Selecting Multiple Items",
	"Terminal Window",
	"Tips",
	"Utilities - Empty Trash",
	"Utilities - Open Trash",
	"Utilities - Synchronize",
	"View - Arrange Icons",
	"View - Hidden Files",
	"View - Icons",
	"View - Long Listing",
	"View - Short Listing",
	"View - Sort",
	NULL
};

/*
 * createHelpSelectionForm - Create entry form (helpSelForm) and add fields 
 * to it
 */

void createHelpSelectionForm (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   Widget dialog_list;

   if (!helpSelForm) {
        helpSelForm = _EntryFormCreate ();
   }

   if (!helpSelForm ) {
        fprintf (stderr, "createHelpForm: _EntryFormCreate failed\n");
        return;
   }

   _EntryFormSInsertField (helpSelForm, w, (int) client);

   XtUnmanageChild (XmSelectionBoxGetChild (w, XmDIALOG_HELP_BUTTON));
   XtUnmanageChild (XmSelectionBoxGetChild (w, XmDIALOG_APPLY_BUTTON));

   dialog_list = XmSelectionBoxGetChild (w, XmDIALOG_LIST);
   _XmCListLoad (dialog_list, listv);

}

/* 
 * cancelHelpCB - Cancel button activate callback (Help dialog)
 */

void cancelHelpCB (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
        _EntryFormPopdown (helpSelForm);

}

/*
 * cancelRemoveGroupCB - Cancel button activate callback (remove group dialog)
 */
 
void cancelRemoveGroupCB (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
        _EntryFormPopdown (moveToTrashForm);

}

/*
 * XpmRemove - Trash items
 */

void XpmRemove(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   char **files;
   Widget dw = ((XshCallbackStruct *) client)->XshDirWidget;
   XmAnyCallbackStruct *acs=(XmAnyCallbackStruct*)call;


   	files = XwCollVItemsSelected(dw);

   	if (!files || !*files) {
           _XmCErrorDialogPost (dw,
           "Please select a file before invoking this operation", "Warning");
           return;
   	}

        XwDirEntriesRemove (dw);

}

/*
 * cancelAppForm: popdown properties dialog
 */

void cancelAppForm(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
        _EntryFormPopdown (appForm);
}

/*
 * okAppForm: Ok button activate callback (properties dialog)
 */

okAppForm(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   XwDirWidget dw = (XwDirWidget) ((XshCallbackStruct *) client)->XshDirWidget;
   char **data;
   struct stat buf;
   Widget shell = locateShell (_EntryFormPosToWidget (appForm, 0));
   char *currpath;
   char *path;
   char *msg;
   char *name;
   int ftype;
   struct stat st;
   int status;


   name = _EntryFormSPDumpPos (appForm, 1); 

   if (!name)
	return;

   if (*name != '/' && *name != '~') { /* check this */
        XtVaGetValues (dw, XtNdirectoryPath, &currpath, NULL);
        path = _dircat (currpath, name);
        free (name);
        if (!path) {
                fprintf (stderr, "okAppForm: _dircat failed\n");
                return;
        }
   } else
        path = name;


   data = _EntryFormSDumpData (appForm);
   if (!data)
        return;

   if (lstat (path, &st) < 0) {
        _EntryFormPerror (appForm, path);
        return;
   }

   ftype = _fasttype (path, &st);

   if (ftype == T_IFLNK) {
        if (stat (path, &st) == 0) {
           ftype = _fasttype (path, &st);
        } else {
           _EntryFormPerror (appForm, path);
	   return;
        }
   }

   if (ftype != T_IFOSCRPT) {
	_EntryFormWarning (appForm, 
	"Can't handle this file format, try to save unto a different filename");
	return;
   }


   if (!(status = _OpenScriptUpdate (path, &data[1]))) {
   	free (path);
   	_freeargv(data);
   	_EntryFormPopdown (appForm);
        return;
   }

   _EntryFormWarning (appForm, 
		"Couldn't update file, Please try a different filename"); 

   _freeargv(data);
   free (path);


}

/*
 * xtermToggleCB: xterm toggle callback
 */

void xtermToggleCB (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
    XmToggleButtonCallbackStruct *acs=(XmToggleButtonCallbackStruct*)call;

#ifdef OLD
   if (acs->set) {
	XtManageChild (_EntryFormPosToWidget (appForm, 6));
	XtManageChild (_EntryFormPosToWidget (appForm, 7));
   } else {
	XtUnmanageChild (_EntryFormPosToWidget (appForm, 6));
	XtUnmanageChild (_EntryFormPosToWidget (appForm, 7));
   }
#endif
   if (!acs->set) {
	_EntryFormSLoadField (_EntryFormPosToField (appForm, 6), "OFF");
	_EntryFormSLoadField (_EntryFormPosToField (appForm, 7), "OFF");
   }


}

/*
 * pauseToggleCB: pause after done toggle callback
 */

void pauseToggleCB (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
    XmToggleButtonCallbackStruct *acs=(XmToggleButtonCallbackStruct*)call;
        
    
   if (acs->set && xterm_toggle) {
 	XmToggleButtonSetState (xterm_toggle,
 		True, False);
   }
}

/*
 * pageToggleCB: page through toggle callback
 */

void pageToggleCB (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
    XmToggleButtonCallbackStruct *acs=(XmToggleButtonCallbackStruct*)call;
        
    
   if (acs->set && xterm_toggle) {
 	XmToggleButtonSetState (xterm_toggle, True, False);
   }
}


/*
 * saveAppForm: Save openscript (save button activate callback)
 */

void saveAppForm(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   XwDirWidget dw = (XwDirWidget) ((XshCallbackStruct *) client)->XshDirWidget;
   char **data;
   struct stat buf;
   char *currpath;
   char *path;
   char *name;
   char *cmd;
   char *cmd1;
   int vtype;
   Widget shell = locateShell (_EntryFormPosToWidget (appForm, 0));


#ifdef DEMO
   _EntryFormWarning (appForm,
                "This feature has been disable in this demo version");
   return;
#endif


   name = _EntryFormSPDumpPos (appForm, 1); 

   if (!name)
	return;


   if (!strcmp (name, "")) {
        _EntryFormWarning (appForm,
                "Please specify the name of the new item");
        return;

   }


   cmd = _EntryFormSPDumpPos (appForm, 2);
   if (cmd) {
	cmd1 = cmd;
	while (*cmd1 == ' ')
	  cmd1++;
	if (!strcmp (name, cmd1)) {
	   _EntryFormWarning (appForm,
	"The item name is the same as the command name. Please use a different item name");
	   free (name);
	   free (cmd);
           return;

	}
	free (cmd);
   }

   if (*name != '/' && *name != '~') { 
   	XtVaGetValues (dw, XtNdirectoryPath, &currpath, NULL);
   	path = _dircat (currpath, name);
	free (name);
	if (!path) {
		fprintf (stderr, "saveAppForm: _dircat failed\n");
		return;
	}
   } else
	path = name;


   if (stat (path, &buf) == 0) {
        vtype = _virtualtype (path); /* for now. */
	if (vtype == T_IFOSCRPT) {
	   _XmCConfirmationDialogPost (shell, 
	   "File already exists. Do you want to replace the information at\n the top of the file?", "Confirmation",
	    okAppForm, client, NULL, NULL);
	} else {
           _EntryFormWarning (appForm,
		"Can't handle file format, try to save unto a different filename");
           return;

	}
        free (path);
        return;
   }

   data = _EntryFormSDumpData (appForm);
   if (!data)
	return;

   if (!_OpenScriptWrite (path, &data[1])) {
        _EntryFormPopdown (appForm);
   	free (path);
        _freeargv(data);
	return;
   }


   free (path);
   _freeargv(data);

   _EntryFormPerror (appForm, path);

}


/*
 * XpmActionMenuDelItems: destroy all widgets in the actions menu
 */

XpmActionMenuDelItems (w)
register Widget *w;
{
   Widget menu;
   
   menu = _XmCGetSubmenu (w);
   
   if (!menu) {
#ifdef DEBUG
	fprintf (stderr, "XpmActionMenuDelItems: _XmCGetSubmenu failed\n"); 
#endif
	return;
   
   }
   _XmCTraverseChildren (menu, XtDestroyWidget, NULL);      
}

/*
 * XpmSelectCB: Callback invoked when there is a change
 *              in the list of items selected
 */

void XpmSelectCB (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   int cnt;
   Widget dw = w;
   Widget actions_button = _EntryFormPosToWidget (xpmForm, 1);
   
   cnt = XwDirSelectedItemCount (dw);
   
   if (cnt != 1) {
	XtSetSensitive (actions_button, False);
        XpmActionMenuDelItems (actions_button);
        return;
   }
   
   XpmActionMenuDelItems (actions_button); 
   
   /*
    * Slow
    */
    
   XwDirActionMenuAddItems (dw, actions_button, _SKIP_CREATION);
   if (!XwDirIfDefActions (dw))
	XtSetSensitive (actions_button, False);
   else   	   
	XtSetSensitive (actions_button, True);
}


/*
 * XpmCreateActionMenu: create actions menu
 */

void XpmCreateActionMenu (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   int cnt;
   Widget actions_button = _EntryFormPosToWidget (xpmForm, 1);
   Widget dw = ((XshCallbackStruct *) client)->XshDirWidget;
   
   cnt = XwDirSelectedItemCount (dw);
   
   if (cnt != 1) {
	XtSetSensitive (actions_button, False);
        XpmActionMenuDelItems (actions_button);
        return;
   }

   XpmActionMenuDelItems (actions_button);
   XwDirActionMenuAddItems (dw, actions_button, _SKIP_CREATION);
   if (!XwDirIfDefActions (dw))
	XtSetSensitive (actions_button, False);
   else   	   
	XtSetSensitive (actions_button, True);

}

/*
 * XpmCreateASubMenu: create actions submenu (submenu of the popup menu)
 */

void XpmCreateASubMenu (dw, actions_cascade)
Widget dw;
Widget actions_cascade;
{
   int cnt;
   
   cnt = XwDirSelectedItemCount (dw);
   
   if (cnt != 1) {
	XtSetSensitive (actions_cascade, False);
        XpmActionMenuDelItems (actions_cascade);
        return;
   }
   
   XpmActionMenuDelItems (actions_cascade);
   XwDirActionMenuAddItems (dw, actions_cascade, _SKIP_CREATION);
   if (!XwDirIfDefActions (dw))
	XtSetSensitive (actions_cascade, False);
   else   	   
	XtSetSensitive (actions_cascade, True);

}

