#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <Xm/DialogS.h>
#include "DragDrop.h"
#include "PrintModule.h"

/* 
 * Print module object.  This object is used to interactively print  
 * a set of files on a selected printer. The user can also query the
 * status of the print queues. 
 */

/* Print module methods */

void PMInitialize ();
void PMActivate ();
int  PMRealize ();
void PMDestroy ();
void PMSetValues ();
void PMProcessMessage ();

static RtResource resources[] = {
   {RtNpmFiles, NULL, RtPOINTER_TYPE, sizeof(char **), 
   RtOffset(PrintModuleObj,pm.files), 0, NULL, 0, NULL},
   {RtNpmPrinter, NULL, RtSTRING_TYPE, sizeof(char *), 
   RtOffset(PrintModuleObj,pm.printer), 0, NULL, 0, NULL},
   {RtNpmEntryForm, NULL, RtPOINTER_TYPE, sizeof(void *), 
   RtOffset(PrintModuleObj,pm.lp_form), 0, NULL, 0, NULL},
   {RtNpmShell, NULL, RtPOINTER_TYPE, sizeof(Widget), 
   RtOffset(PrintModuleObj,pm.shell), 0, NULL, 0, NULL},
   {RtNpmBsdPrint, NULL, RtBIT_TYPE, 1, 
   RtOffset(PrintModuleObj,pm.flags), 0, NULL, 0, 
   (char *) RtPM_BSD_PRINT}        
};
	
/* Print module class record */

PrintModuleClassRec printModuleClassRec = {
  {
    (ObjClass) &rtWidgetClassRec,	/* superclass		*/
    "Print",				/* class name		*/
    NULL,	
    0,
    resources,				/* resource		*/
    RtNumber (resources),		/* number of resources  */
    /* object size              */  sizeof(PrintModuleRec),
    PMInitialize,
    PMRealize,
    NULL,
    PMSetValues,
    NULL,
    PMDestroy,
    PMProcessMessage,
    "pm",
    "Rt1.00",
    NULL
  },
  {
  0,
  }
  
};

ObjClass printModuleObjClass = (ObjClass) &printModuleClassRec; 

/*
 * PMSetValues: set object values
 */
 
void PMSetValues (current, new)
PrintModuleObj current, new;
{

char *files;

   if (current->pm.files != new->pm.files) {
   	files = _Cargvtocmd (new->pm.files, 0);   
        _EntryFormSChangeField (new->pm.lp_form, 
        	(char *) files, 0);
        free (files);
   }
   if (current->pm.printer != new->pm.printer)
   	RtUpdateString (current->pm.printer, new->pm.printer)
   	
}


void PMInitialize (new)
PrintModuleObj new;
{
}

/*
 * PMRealize: Realize print module
 */
 
int PMRealize (new)
PrintModuleObj new;
{
    Obj object;
    Widget widget;
    char *title = NULL;
    
    if (!new->pm.shell && !new->widget.parent)
       return;
    
    if (!new->pm.shell)
    	new->pm.shell = XtCreatePopupShell( "pm_shell",
    	xmDialogShellWidgetClass, new->widget.parent, NULL, 0);

    /* For now. The realize method needs to be changed */
    RtGetValue (new, RtNwidgetTitle, &title);
    if (title)
           XtVaSetValues (new->pm.shell, 
           	XtNtitle, title, NULL);

    /* Create a drag/drop object */
    object = new->pm.dd_object = RtCreateObject (NULL, dragDropObjClass); 
    new->pm.queues =  RtCreateObject (NULL, xmTextWrapperObjClass); 
    new->pm.cmd = (CommandObj) RtCreateObject (NULL, 
   		commandObjClass);

    widget = CreatemainW (new->pm.shell);

    XtManageChild (widget);
    
    RtSetValue (new, RtNwidget, widget);

#ifdef OLD    
    XtRealizeWidget (new->widget.parent);

    /* Set drop site widget      */
    RtSetValue (object, RtNddDropSite, widget);
    RtRealizeObject (object);
#endif
    RtSetValue (object, RtNobjStdout, new); 
    
    RtSetValue (new->pm.cmd, RtNcmdWidget, widget);
    RtSetValue (new->pm.cmd, RtNcmdWaitPid, 1);
    RtSetValue (new->pm.cmd, RtNobjStdout, new);
    RtRealizeObject (new->pm.cmd);
    
}


void PMDestroy (obj)
PrintModuleObj obj;
{
}

/*
 * PMProcessMessage: process object messages
 */
 
void PMProcessMessage (obj, data, client)
PrintModuleObj obj;
void *data;
void *client;
{
  Widget shell;
  MessageObj msg;
  char *content;
  int message_id;
  char *msg_client;
  char *aux;
  
   msg = (MessageObj) data;
   RtGetValue (msg, RtNmsgId, &message_id);   
   RtGetValue (msg, RtNmsgContent, &content); 
   RtGetValue (msg, RtNmsgClient, &msg_client); 
     
      
   switch (message_id) {
      case RtDD_DROP_DATA:
        if (obj->pm.lp_form) {
          _EntryFormSChangeField (obj->pm.lp_form, (char *) content, 0);
          
           /* locate the shell associated to this object */
           shell = locateShell (obj->widget.widget); 
           if (!shell)
           	return;
           /* Map the shell window */
	   XMapRaised (XtDisplay (obj->widget.widget), 
	   		XtWindow (shell));       
        }
        break;
      case RtCMD_OUTPUT: 
        /* data comming from a command object (stdout) */
        if (!msg_client || !content)
        	return;
   	msg = RtCreateMessage ();
 	aux = malloc ((int) msg_client + 1);
 	memcpy (aux, content, (int) msg_client);
 	aux[(int) msg_client] = '\0';
 	RtSetValue (msg, RtNmsgId, RtXMTW_APPEND);
 	RtSetValue (msg, RtNmsgContent, aux);
   	RtSendMessage (obj->pm.queues, msg, NULL);
   	RtDestroyObject (msg);
 	break;
      case RtWIDGET_POPUP:
    	/* Set drop site widget      */
	RtSuperclassProcessMessage (printModuleObjClass, obj, 
		data, client);
    	RtSetValue (obj->pm.dd_object, RtNddDropSite, 
    		obj->widget.widget);
    	RtRealizeObject (obj->pm.dd_object); 
    	       
      	break;
      default:
#ifdef DEBUG
   	fprintf (stderr, 
   		"Print Module: I don't know how to process this message\n");
#endif
	RtSuperclassProcessMessage (printModuleObjClass, obj, data, 
			client);
	break;
   }
  
}

