/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 * http://www.fsw.com
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THE SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * This program demonstrates the use of the Freedom Print Object
 * http://fsw.com
 */
 
#include <Xm/Xm.h>
#include <X11/Shell.h>

#define APP_CLASS "Freedom"
#define APP_NAME  "Xlp"

#include "printtool.xbm"
#include "PrintModule.h"
#include "lst.h"
#include "etc.h"
#include "X.h"
#include "XpmObj.h"
#include "print50x50.xpm"

static char *fallback_resources[] = {
    ".geometry:  390x455",
    NULL
};



extern EntryFormObject lpForm;
PrintModuleObj pm_object;

main(argc, argv)
int argc;
char **argv;
{
    Display     *display;
    Obj object;
    XtAppContext context;
    Widget widget;
    Widget Shell;

    Shell = XtVaAppInitialize (&context, APP_CLASS, NULL,
   		0, &argc, argv, fallback_resources, 
   		NULL);

    XtVaSetValues (Shell, XmNiconName, "Print", 
    			XmNtitle, "Print",
    			XmNwidth, 390,
#ifdef SOLARIS
    			XmNheight, 470, NULL);
#else
    			XmNheight, 465, NULL);
#endif
    			
    display = XtDisplay (Shell);


    XmRegisterConverters ();

    /* Create a print module object */
    
    pm_object = (PrintModuleObj) RtCreateObject (NULL, 
    	printModuleObjClass); 
    	
    RtSetValue (pm_object, RtNwidgetParent, Shell);
    RtSetValue (pm_object, RtNwidgetTitle, "Print Tool");
    RtRealizeObject (pm_object);
    
    /* Specify an Entry Form for the print object */
    RtSetValue (pm_object, RtNpmEntryForm, (void *) lpForm);

    /* files to be printed */
    if (argc > 1)
    	RtSetValue (pm_object, RtNpmFiles, &(argv[1]));

    /* Popup the print object */
    RtSetValue (stdmsg, RtNmsgId, RtWIDGET_POPUP);
    RtSendMessage (pm_object, stdmsg, NULL);
    XtAppMainLoop (context);
}
