/*
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */
 

/*
 * REQUIRED MOTIF INCLUDE FILES
 */
#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <Xm/ArrowB.h>
#include <Xm/ArrowBG.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/Command.h>
#include <Xm/CutPaste.h>
#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
#include <Xm/MainW.h>
#include <Xm/MenuShell.h>
#include <Xm/MessageB.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/SeparatoG.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>

#ifndef IGNORE_COLOR
static unsigned long
COLOR(w, name)
Widget w;
char *name;
{
XrmValue	fromVal, toVal;
unsigned long *pixel;

    fromVal.size = sizeof(char*);
    fromVal.addr = name;

    XtConvert(w, XmRString, &fromVal, XmRPixel, &toVal);
    pixel = (unsigned long*)toVal.addr;
    if( pixel == NULL )
    {
    	fromVal.addr = XtDefaultBackground;
    	XtConvert(w, XmRString, &fromVal, XmRPixel, &toVal);
    	pixel = (unsigned long*)toVal.addr;
    }
    return(*pixel);
}
#endif

extern void createFindForm();
extern void findDismissCB();
extern void findStartCB();
extern void findStopCB();
extern void toggledCB();

Widget
CreatemainW(parent)
Widget parent;
{
    Arg    	args[512];
    int    	argcnt;
    Widget 	retval;
    XmString	xmstr[32];
    XmString	*xmstrTable[8];
    Widget	main_window;
    Widget	form;
    Widget	directory_text;
    Widget	files_label;
    Widget	files_window;
    Widget	files_text;
    Widget	separator;
    Widget	start_button;
    Widget	stop_button;
    Widget	dissmiss_button;
    Widget	search_label;
    Widget	frame;
    Widget	search_box;
    Widget	name_toggle;
    Widget	content_toggle;
    Widget	descend_toggle;
    Widget	type_label;
    Widget	directory_label;
    Widget	search_text;
    XmRegisterConverters();
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 377); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 492); argcnt++;
    main_window = XtCreateWidget("main_window",
		xmMainWindowWidgetClass,
		parent,
		args,
		argcnt);

    retval = main_window;
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 377); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 492); argcnt++;
    form = XtCreateWidget("form",
		xmFormWidgetClass,
		main_window,
		args,
		argcnt);

    XtManageChild(form);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNcolumns, (short)57); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)1); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    search_text = XtCreateWidget("search_text",
		xmTextWidgetClass,
		form,
		args,
		argcnt);

    createFindForm(search_text, (caddr_t)0, (caddr_t)0);
    XtManageChild(search_text);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Search directory",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    directory_label = XtCreateWidget("directory_label",
		xmLabelWidgetClass,
		form,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(directory_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Search type",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, search_text); argcnt++;
    type_label = XtCreateWidget("type_label",
		xmLabelWidgetClass,
		form,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(type_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"descend through directories",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNset, False); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 184); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, directory_label); argcnt++;
    descend_toggle = XtCreateWidget("descend_toggle",
		xmToggleButtonWidgetClass,
		form,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    createFindForm(descend_toggle, (caddr_t)3, (caddr_t)0);
    XtManageChild(descend_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)8); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 357); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 27); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, type_label); argcnt++;
    frame = XtCreateWidget("frame",
		xmFrameWidgetClass,
		form,
		args,
		argcnt);

    XtManageChild(frame);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Search for",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_NONE); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    XtSetArg(args[argcnt], XmNy, 10); argcnt++;
    search_label = XtCreateWidget("search_label",
		xmLabelWidgetClass,
		form,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(search_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Dismiss",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_POSITION); argcnt++;
    XtSetArg(args[argcnt], XmNleftPosition, (int)74); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNx, 279); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 80); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 30); argcnt++;
    dissmiss_button = XtCreateWidget("dissmiss_button",
		xmPushButtonWidgetClass,
		form,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(dissmiss_button, XmNactivateCallback, findDismissCB, (caddr_t)0);
    createFindForm(dissmiss_button, (caddr_t)8, (caddr_t)0);
    XtManageChild(dissmiss_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Stop",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_POSITION); argcnt++;
    XtSetArg(args[argcnt], XmNleftPosition, (int)40); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNx, 151); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 80); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 30); argcnt++;
    stop_button = XtCreateWidget("stop_button",
		xmPushButtonWidgetClass,
		form,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(stop_button, XmNactivateCallback, findStopCB, (caddr_t)0);
    createFindForm(stop_button, (caddr_t)7, (caddr_t)0);
    XtManageChild(stop_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Start",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, False); argcnt++;
    XtSetArg(args[argcnt], XmNshowAsDefault, (short)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNx, 20); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 80); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 30); argcnt++;
    start_button = XtCreateWidget("start_button",
		xmPushButtonWidgetClass,
		form,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(start_button, XmNactivateCallback, findStartCB, (caddr_t)0);
    createFindForm(start_button, (caddr_t)6, (caddr_t)0);
    XtManageChild(start_button);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 377); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 20); argcnt++;
    separator = XtCreateWidget("separator",
		xmSeparatorWidgetClass,
		form,
		args,
		argcnt);

    XtManageChild(separator);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNscrollingPolicy, XmAPPLICATION_DEFINED); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 357); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 133); argcnt++;
    files_window = XtCreateWidget("files_window",
		xmScrolledWindowWidgetClass,
		form,
		args,
		argcnt);

    XtManageChild(files_window);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"Files found",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNrecomputeSize, True); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    files_label = XtCreateWidget("files_label",
		xmLabelWidgetClass,
		form,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtManageChild(files_label);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNcolumns, (short)57); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)1); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNleftAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNrightAttachment, XmATTACH_FORM); argcnt++;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNleftOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNrightOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNx, 10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, descend_toggle); argcnt++;
    directory_text = XtCreateWidget("directory_text",
		xmTextWidgetClass,
		form,
		args,
		argcnt);

    createFindForm(directory_text, (caddr_t)4, (caddr_t)0);
    XtManageChild(directory_text);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, directory_text); argcnt++;
    XtSetValues(files_label, args, argcnt);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNeditMode, XmMULTI_LINE_EDIT); argcnt++;
    XtSetArg(args[argcnt], XmNeditable, False); argcnt++;
    XtSetArg(args[argcnt], XmNcolumns, (short)54); argcnt++;
    XtSetArg(args[argcnt], XmNrows, (short)8); argcnt++;
    XtSetArg(args[argcnt], XmNcursorPositionVisible, False); argcnt++;
    XtSetArg(args[argcnt], XmNx, 0); argcnt++;
    XtSetArg(args[argcnt], XmNy, 0); argcnt++;
    files_text = XtCreateWidget("files_text",
		xmTextWidgetClass,
		files_window,
		args,
		argcnt);

    createFindForm(files_text, (caddr_t)5, (caddr_t)0);
    XtManageChild(files_text);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, files_label); argcnt++;
    XtSetValues(files_window, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, files_window); argcnt++;
    XtSetValues(separator, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, separator); argcnt++;
    XtSetValues(start_button, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, start_button); argcnt++;
    XtSetValues(stop_button, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)0); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, start_button); argcnt++;
    XtSetValues(dissmiss_button, args, argcnt);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNradioBehavior, True); argcnt++;
    XtSetArg(args[argcnt], XmNradioAlwaysOne, True); argcnt++;
    XtSetArg(args[argcnt], XmNpacking, XmPACK_COLUMN); argcnt++;
    XtSetArg(args[argcnt], XmNorientation, XmHORIZONTAL); argcnt++;
    XtSetArg(args[argcnt], XmNspacing, (Dimension)75); argcnt++;
    XtSetArg(args[argcnt], XmNx, 2); argcnt++;
    XtSetArg(args[argcnt], XmNy, 2); argcnt++;
    XtSetArg(args[argcnt], XmNwidth, 353); argcnt++;
    XtSetArg(args[argcnt], XmNheight, 23); argcnt++;
    search_box = XtCreateWidget("search_box",
		xmRowColumnWidgetClass,
		frame,
		args,
		argcnt);

    XtManageChild(search_box);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"File name",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNset, True); argcnt++;
    XtSetArg(args[argcnt], XmNx, 3); argcnt++;
    XtSetArg(args[argcnt], XmNy, 3); argcnt++;
    name_toggle = XtCreateWidget("name_toggle",
		xmToggleButtonWidgetClass,
		search_box,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(name_toggle, XmNvalueChangedCallback, toggledCB, (caddr_t)0);
    createFindForm(name_toggle, (caddr_t)1, (caddr_t)0);
    XtManageChild(name_toggle);
 
    argcnt = 0;
    XtSetArg(args[argcnt], XmNlabelString, (xmstr[0]=XmStringCreateLtoR(
		"File content",
		XmSTRING_DEFAULT_CHARSET))); argcnt++;
    XtSetArg(args[argcnt], XmNspacing, (short)4); argcnt++;
    XtSetArg(args[argcnt], XmNx, 171); argcnt++;
    XtSetArg(args[argcnt], XmNy, 3); argcnt++;
    content_toggle = XtCreateWidget("content_toggle",
		xmToggleButtonWidgetClass,
		search_box,
		args,
		argcnt);
    XmStringFree( xmstr[0] );

    XtAddCallback(content_toggle, XmNvalueChangedCallback, toggledCB, (caddr_t)1);
    createFindForm(content_toggle, (caddr_t)2, (caddr_t)0);
    XtManageChild(content_toggle);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)10); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, frame); argcnt++;
    XtSetValues(directory_label, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtopOffset, (int)5); argcnt++;
    XtSetArg(args[argcnt], XmNtopAttachment, XmATTACH_WIDGET); argcnt++;
    XtSetArg(args[argcnt], XmNtopWidget, search_label); argcnt++;
    XtSetValues(search_text, args, argcnt);

    argcnt = 0;
    XtSetArg(args[argcnt], XmNdefaultButton, start_button); argcnt++;
    XtSetValues(form, args, argcnt);

    return( retval );
}

