/*
 * Freedom Desktop 
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 * 
 * The commercial use of this Software shall be governed by a separate License 
 * agreement. Any individual or institution wishing to make commercial use of 
 * the Software must sign a license agreement with Freedom Software. In such 
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's 
 * internal business purposes; (ii) to use, copy, and distribute this Software 
 * or the derivative works provided that the copyright notice and this 
 * permission notice appear on all copies and that NO CHARGE is associated 
 * with such copies. However, if Licensee distributes any derivative work 
 * based on the Software, then Licensee shall (i) notify Licensor in writing 
 * (ii) clearly state that such derivative work is a modified and not the 
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide 
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 * 
 * By using, copying, modifying or distributing this Software (or any 
 * derivative work based on this Software) Licensee indicates acceptance 
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD 
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#include <signal.h>
#include <sys/wait.h>
#include <Xm/Xm.h>
#include "lst.h"
#include "X.h"
#include "etc.h"

static EntryFormObject findForm = NULL; /* form */

extern char *argv[];
extern int argc;
extern XtAppContext context;
extern Boolean _reapchild ();
int _childpid = 0;


void createFindForm(w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{

   if (!findForm) {
        findForm = _EntryFormCreate ();
   }

   if (!findForm ) {
        fprintf (stderr, "createFindForm: _EntryFormCreate failed\n");
        return;
   }

   _EntryFormSInsertField (findForm, w, (int) client);

#ifdef DEBUG
   fprintf (stderr, "fileno = %d\n", fileno(stdin));
#endif
   if ((int) client == 5)
  	XtAppAddInput(context, fileno(stdin), XtInputReadMask,
            _XCgetFromCmd, w);
   if ((int) client == 3) {
	_EntryFormSChangeField (findForm, "ON", 3);
   	XtSetSensitive (w, False);
   }
   if ((int) client == 7)
        XtSetSensitive (_EntryFormPosToWidget (findForm, 7), False);

}

void findDismissCB (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   exit (0);
}

#define checkstatus(status) { \
   if (WIFEXITED (status)) { \
        if (WEXITSTATUS(status)) { \
           _XmCErrorDialogPost (dw, "Command terminated abnormally", "Error"); \        } \
   } else { \
}

void findStartCB (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
char **data;
Widget shell, text;
char *argv[9];
char *cwd;
int status;
short type;

   _childpid = 0;

   data = _EntryFormSDumpData (findForm);
   shell = locateShell (w);
   text = _EntryFormPosToWidget (findForm, 5);
   type = (!strcmp (data[1], "ON"))?0:1;

   XmTextSetString (text, "");
   XmTextSetInsertionPosition (text, 0);

   /* check this - include function in the library to validate forms */
   if (!strcmp (data[0], "")) {
	if (!strcmp (data[1], "ON"))
	   _XmCErrorDialogPost (shell, "Please enter filename", "Error");
	else
	   _XmCErrorDialogPost (shell, "Please enter search pattern", "Error");
	_freeargv (data);
	return;
   }

   if (!strcmp (data[4], "")) {
	_XmCErrorDialogPost (shell, "Please enter directory", "Error");
	_freeargv (data);
	return;
   }

#ifdef OLD
   if (!(cwd = _ugetcwd ())) {
	_XmCErrorDialogPost (shell, "Couldn't get current directory", "Error");
	return;
   }
#endif

   if (type == 0) {
      argv[0] = "/usr/bin/find";
      argv[1] = "find";
      argv[2] = data[4];
      argv[3] = "-name";
      argv[4] = data[0];
      argv[5] = "-print";
      argv[6] = '\0';
   } else {
     argv[0] = "/bin/sh";
     argv[1] = "sh";
     argv[2] = "-c";
     argv[3] = _vstrconcat ("fgrep -il ", data[0], " *", NULL);
     if (!argv[3])
	return; 
     argv[4] = '\0';

   }

   XtSetSensitive (_EntryFormPosToWidget (findForm, 7), True);
   XtSetSensitive (_EntryFormPosToWidget (findForm, 6), False);
   XSync (XtDisplay(w), False);

   if ((_childpid = _talkto (argv)) < 0) {
        XtSetSensitive (_EntryFormPosToWidget (findForm, 6), True);
        XtSetSensitive (_EntryFormPosToWidget (findForm, 7), False);
   	XSync (XtDisplay(w), False);
	_XmCErrorDialogPost (shell, _syserror (), "Error");
	return;
   }
   XSync (XtDisplay(w), False);
   XtAppAddWorkProc (context, _reapchild, _childpid);
   _freeargv (data);

}
	

void findStopCB (w, client, call)
Widget w;
caddr_t client;
caddr_t call;
{
   if (_childpid <= 0)
	return;
   if (kill (_childpid, 9) < 0)
	perror ("kill");
}

void toggledCB (w, client, state)
Widget w;
caddr_t client;
XmToggleButtonCallbackStruct *state;
{
   Widget tmp;

   if (state->set) {
     tmp = _EntryFormPosToWidget (findForm, 3);
     if ((int) client == 0) {
	_EntryFormSChangeField (findForm, "ON", 3);
     } else {
	_EntryFormSChangeField (findForm, "OFF", 3);
     }
   }
}

loadFindForm (argv, argc)
char **argv;
int argc;
{
  if (argc > 2)
	_EntryFormSChangeField (findForm, argv[2], 0);
  if (argc > 1)
	_EntryFormSChangeField (findForm, argv[1], 4);
}

Boolean _reapchild (client_data) 
XtPointer client_data;
{
  int status, pid = (int) client_data;	
  int ret;

    if ((ret = waitpid(pid, &status, WNOHANG)) < 0) {
	perror ("_reapchild");
	return (False);
    } else if (ret == 0) {
#ifdef DEBUG
	fprintf (stderr, "_reapchild\n");
#endif
	return (False);
    } else {
#ifdef DEBUG
	fprintf (stderr, "pid = %d, status = %d\n", ret, status);
#endif
        XtSetSensitive (_EntryFormPosToWidget (findForm, 6), True);
        XtSetSensitive (_EntryFormPosToWidget (findForm, 7), False);
        XSync (XtDisplay(_EntryFormPosToWidget (findForm, 6)), False);
	return (True);
    }
}
