
/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#ifdef MOTIF
#include "ptyx.h"

#include <Xm/Xm.h>
#include <Xm/FileSB.h>
#include <X11/Shell.h>
#include <Xm/DialogS.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/Form.h>
#include <Xm/ScrolledW.h>
#include <Xm/MainW.h>
#include <stdio.h>
#include "lst.h"
#include "Dir.h"
#include "Xsh.h"
#include "xentry_form.h"
#include "Rt.h"
#include "xpm.h"
#include "XpmObj.h"
#include "filemgr50x50.xpm"

#ifdef OLD
extern XtermWidget term; 
extern WidgetClass xtermWidgetClass;
extern char defaultTranslations[];
#endif
extern XwDirWidget dirWidget;

Widget Create_directory_selection ();
Widget Create_selection_box ();
Widget Create_main_window();

Widget selection_box;
static Widget file_selection;

Widget mainW;
Widget shellA, shellB, shellC, shellD;
Widget Form1;
Widget Createform1();
Widget Form2;
Widget Createform2();

char productname[] = "Freedom Open Desktop";
char version[] = "1.30";


int _demo_mode = 0;
Widget button;

void
pushCB(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
	XmProcessTraversal (w, XmTRAVERSE_NEXT_TAB_GROUP);
}

Widget panedWindow;

#include "filemgr.xbm"

createWidgets (toplevel, app_con)
Widget toplevel;
XtAppContext app_con;
{
  Widget form, pane;
  Arg         args[256];
  int         argcnt;
  Obj object;
  Pixmap pixmap, i_pixmap = NULL;
  Window window;
  Display     *display;
  
    display = XtDisplay (toplevel);
    
    /* Create an icon window */
    window = XCreateSimpleWindow (display, RootWindow(display,
		DefaultScreen(display)), 0, 0, 50, 
		50, (unsigned) 0, 
		CopyFromParent, CopyFromParent);

    /* Create Xpm object. This object is used to define a pixmap */
    /* for the icon window					 */
    
    object = RtCreateObject (NULL, xpmObjClass);
    RtSetValue (object, RtNxpmData, filemgr50x50_xpm);
    RtSetValue (object, RtNxpmDisplay, display);
    if (RtRealizeObject (object) >= 0)
       RtGetValue (object, RtNxpmPixmap, &i_pixmap);

    if (i_pixmap) {
       /* Set background of the icon window */
       XSetWindowBackgroundPixmap (display, window, i_pixmap);
       /* Set icon window resource */
       XtVaSetValues (toplevel, XmNiconWindow, window, NULL);
       XClearWindow (display, window);
    } else
       /* use the bitmap in case a pixmap couldn't be made */ 
       XtVaSetValues(toplevel,XmNiconPixmap,
            XCreateBitmapFromData(XtDisplay(toplevel),
            XtScreen(toplevel)->root,
            filemgr_bits, filemgr_width, filemgr_height),
	    NULL
            );


#ifdef SYNC
	XSynchronize (XtDisplay (toplevel), True);
#endif

#ifdef SECURITY
	if (!validate_key (productname, version)) {
	    fprintf (stderr, "Xsh: Evaluation mode\n");
	    _demo_mode = 1;
	}
#endif


        rddInit (toplevel, app_con);

        mainW = Createmain_window(toplevel);
        XtManageChild(mainW);

#ifdef OLD
        term = (XtermWidget) XtVaCreateManagedWidget(
            "vt100", xtermWidgetClass, panedWindow, 
		XmNx, 0,
		XmNy, 0,
		XmNborderWidth, 0,
		XmNpaneMinimum, 20,
		XmNallowResize, True,
	        NULL);

        _XmCTurnOffSashTraversal (panedWindow);

        XtOverrideTranslations (term, 
		XtParseTranslationTable (defaultTranslations));
#endif

	argcnt = 0;
	shellA = XtCreatePopupShell( "shellA",
        xmDialogShellWidgetClass, toplevel, args, argcnt);

    	argcnt = 0;
    	shellB = XtCreatePopupShell( "Change Directory",
        xmDialogShellWidgetClass, toplevel, args, argcnt);

	argcnt = 0;
	XtSetArg(args[argcnt], XmNtitle, "File/Directory Properties"); argcnt++;
	shellC = XtCreatePopupShell( "shellC",
        xmDialogShellWidgetClass, toplevel, args, argcnt);

	argcnt = 0;
	shellD = XtCreatePopupShell( "shellD",
        xmDialogShellWidgetClass, toplevel, args, argcnt);

    	selection_box = Createselection_box(shellA);
    	XtVaSetValues (selection_box, XmNdialogStyle,
        XmDIALOG_PRIMARY_APPLICATION_MODAL, NULL);
	XtUnmanageChild (XmSelectionBoxGetChild(selection_box, 
		XmDIALOG_HELP_BUTTON));

    	file_selection = Createdirectory_selection(shellB);
    	XtUnmanageChild (XmSelectionBoxGetChild(file_selection, 
		XmDIALOG_HELP_BUTTON));


	widgetArray[FORM2] = Form2 = Createform2(shellC);
	XtVaSetValues (Form2, XmNdialogStyle,
        XmDIALOG_PRIMARY_APPLICATION_MODAL, NULL);


	widgetArray[FORM1] = Form1 = Createform1(shellD);
	XtVaSetValues (Form1, XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL, 
	NULL);

{
  extern EntryFormObject menuForm;        /* for now */

   	XtUnmanageChild (_EntryFormPosToWidget (menuForm, 30)); /* for now */
}


}

#endif
