
/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <Xm/DialogS.h>
#include <sys/wait.h>
#include <signal.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include "Xsh.h"
#include "X.h"
#include "XpmObj.h"
#include "filemgr50x50.xpm"

#define APP_NAME "Xfile"
#define APP_CLASS "Freedom"

#ifdef EDITRES
#include <X11/Xmu/Editres.h>
#endif

#include "filemgr.xbm"



Widget shell;
extern Widget Create_main_window(), Create_help_form ();
extern Widget Create_help_selection (), Create_new_group_selection ();
extern Widget Create_remove_group_selection(), Createmcform();
extern Widget Createappform ();

void reapchild ();


main(argc, argv)
int argc;
char **argv;
{
    Arg 	args[12];
    register int argcnt;
    Display *display;
    Pixmap i_pixmap = NULL;
    XtAppContext context;
    Obj object;
    Window window;

    XtToolkitInitialize();

    context = XtCreateApplicationContext();
    display = XtOpenDisplay(context, 0, APP_NAME, APP_CLASS, 0, 0, &argc, argv);

    if(!display) {
	XtWarning("cannot open display");
	exit(1);
    }

    XmRegisterConverters();

    argcnt = 0;
    XtSetArg(args[argcnt], XmNtitle, "File Manager"); argcnt++;
    XtSetArg(args[argcnt], XmNiconName, "Files"); argcnt++;
    shell = XtAppCreateShell( APP_NAME, APP_CLASS,
        applicationShellWidgetClass, display, args, argcnt);

#ifndef DEMO
#ifdef EDITRES
    XtAddEventHandler (shell, (EventMask) 0, True, _XEditResCheckMessages
, NULL);
#endif
#endif

    if (!get_env_var ()) {
	fprintf (stderr,
	"Freedom File Manager failed while retrieving environment variables\n");
	exit (1);
    }



    /* Create an icon window */
    window = XCreateSimpleWindow (display, RootWindow(display,
		DefaultScreen(display)), 0, 0, 50, 
		50, (unsigned) 0, 
		CopyFromParent, CopyFromParent);

    /* Create Xpm object. This object is used to define a pixmap */
    /* for the icon window					 */
    
    object = RtCreateObject (NULL, xpmObjClass);
    RtSetValue (object, RtNxpmData, filemgr50x50_xpm);
    RtSetValue (object, RtNxpmWidget, shell);
    RtSetValue (object, RtNxpmWhiteBackground, 1);
    RtRealizeObject (object);
    RtGetValue (object, RtNxpmPixmap, &i_pixmap);

    if (i_pixmap) {
       /* Set background of the icon window */
       XSetWindowBackgroundPixmap (display, window, i_pixmap);
       /* Set icon window resource */
       XtVaSetValues (shell, XmNiconWindow, window, NULL);
       XClearWindow (display, window);
    } else
       /* use the bitmap in case a pixmap couldn't be made */ 
       XtVaSetValues(shell, XmNiconPixmap,
            XCreateBitmapFromData(XtDisplay(shell),
            XtScreen(shell)->root,
            filemgr_bits, filemgr_width, filemgr_height),
            NULL
            );




    createWidgets (shell, context);

     /* RDD  initialize the rdd package */
     rddInit (shell, context);

    _usignal (SIGCHLD, reapchild);

    XtRealizeWidget(shell);

#ifdef OLD
    if ((fcntl (ConnectionNumber(display), F_SETFD, 1)) == -1)
	fprintf (stderr, "Xpm: child cannot disinherit TCP fd");
#endif

    rddAppMainLoop(context);

}

/* Dummy function */

unparsefputs () {

}

