
/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#include <stdio.h>
#include <sys/stat.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "xpm.h"
#include "pixmaps.h"
#include "build_option.h"
#include "XedwListP.h"
#include "XedwList.h"
#include "Dir.h"
#include "DirP.h"
#include "file.h"
#include "etc.h"

int _fasttype(); 
char *_extract_fname();
int _match_extension();
int _match_name();

/*
 * Icon table (indexed by file type)
 */

char *xpm_tbl[] = {
		    NULL,
		    NULL,
		    "dir.xpm",
		    NULL,
		    NULL,
		    NULL,
		    "link.xpm",
		    NULL,
		    NULL,
		    "appl.xpm",
		    NULL,
		    NULL,
		    NULL,
		    NULL,
		    "compressed.xpm",
		    "ar.xpm",
		    "ps.xpm",
		    NULL,
		    "executable.xpm",
		    "o.xpm",
		    NULL,
		    NULL,
		    NULL,
		    NULL,
		    NULL,
		    "tar.xpm",
		    "data.xpm",
		    "c.xpm",
		    "h.xpm",
		    NULL,
		    NULL,
		    NULL,
		    "shell.xpm",
		    "ascii.xpm",
		    "ascii.xpm",
		    NULL,
		    "core.xpm",
		    "makefile.xpm",
		   };

PicInfo pic_tbl[38];


/*
 * _IconFree: free icon
 */

_IconFree (w, icon)
Widget w;
PicInfo *icon;
{
    if (icon->pixmap) {
        XFreePixmap(XtDisplay (w), icon->pixmap);
        if (icon->mask)
            XFreePixmap(XtDisplay (w), icon->mask);


        XpmFreeAttributes(&icon->attributes);
    }
}

/*
 * IconRead: read icon
 */

PicInfo *_IconRead (w, path)
Widget w;
char *path;
{
   PicInfo *icon;
   static size_t picsize = PICSIZ;
   int status;

   icon = (PicInfo *) malloc (picsize);
   if (!icon)
	return (NULL);

   memset ((char *) icon, '\0', picsize);
   icon->attributes.valuemask = XpmReturnPixels;
   status = XpmReadFileToPixmap(XtDisplay (w),
            			    XRootWindowOfScreen(XtScreen(w)),
                                    path,
                                    &icon->pixmap,
                                    &icon->mask,
                                    &icon->attributes);
   if (status != XpmSuccess &&
          status != XpmColorError) {
	_IconFree (w, icon); 
	return (NULL);
   }
   return (icon);

}


/*
 * get_icon: returns the icon corresponding to the file type
 */

PicInfo *get_icon (w, item)
XwDirWidget w;
DirItemObject item;
{
   char *path;
   char *icon_path;
   static char *icons_path = NULL;
   short ftype;
   struct stat linkstat;
   static PicInfo default_icon;
   static PicInfo *open_icon = NULL;
   PicInfo icon, *tmp;
   int status;
   static size_t attsiz = ATTSIZ;
   static size_t picsiz = PICSIZ;
   char *_get_icon_name ();

	if (!w || !item) {
		_InvalidArg ("get_icon: Invalid argument\n");
		return (NULL);
	}

	path = _dircat (w->dir.directory_path, item->item_name);
	if (!path) {
	   fprintf (stderr, "get_icon: _dircat failed\n");
	   return (NULL);
	}

	memset ((char *) &icon, '\0', picsiz);
	icon.attributes.valuemask = XpmReturnPixels;
	default_icon.attributes.valuemask = XpmReturnPixels;

	ftype = item->fileInfo.ftype;

	if (ftype == T_IFLNK) {
		if (stat (path, &linkstat) == 0) {
		   ftype = _fasttype (path, &linkstat); 
		} else {
#ifdef DEBUG
		   perror (path);
#endif
		}
	}
		   
	ftype = (ftype > 38? 5:ftype); /* check this */


	if (pic_tbl[ftype].pixmap) {
	   free (path);
	   return (&pic_tbl[ftype]);
	}
	if (!icons_path) {

	   	icons_path = _dircat(w->dir.base_directory, ICONS_SUBDIRECTORY);
		icon_path = _dircat (icons_path, "plainfile.xpm");
		if (!icon_path) {
	   	   fprintf (stderr, "get_icon: _dircat failed\n");
		   free (path);
	   	   return (NULL);
		}

     		status = XpmReadFileToPixmap(XtDisplay (w),
                             XRootWindowOfScreen(XtScreen(w)),
                                    icon_path,
                                    &default_icon.pixmap, 
				    &default_icon.mask,
                                    &default_icon.attributes);

		free (icon_path);
		if (status != XpmSuccess && 
			status != XpmColorError) {
			default_icon.pixmap = NULL;
			default_icon.mask = NULL;
			free (path);
			return (NULL);
		}
		   
		memcpy ((char *) &pic_tbl[0], (char *) &default_icon, picsiz);
	}
	if (ftype == T_IFOSCRPT) {
	   char *icon_name = _get_icon_name (path); 

	   if (!open_icon) {
		icon_path = _dircat (icons_path, "appl.xpm");
		if (icon_path) {
		   open_icon = _IconRead (w, icon_path);
		   if (!open_icon)
			open_icon = &default_icon;
		   free (icon_path);
		}
		
	   }

	   if (!icon_name) {

		free (path);
		return (open_icon->pixmap?open_icon:NULL);
	   }
	   if (*icon_name == '/')
	      icon_path = strdup (icon_name);
	   else
	      icon_path = _dircat (icons_path, icon_name);
	   if (!icon_path) {
		fprintf (stderr, "get_icon: _dircat or strdup failed\n");
		free (path);
                return (default_icon.pixmap?&default_icon:NULL);
	   }
     	   status = XpmReadFileToPixmap(XtDisplay (w),
                             	 	  XRootWindowOfScreen(XtScreen(w)),
                                          icon_path,
                                          &icon.pixmap, &icon.mask,
					  &icon.attributes);

	   free (icon_path);
           free (path);
	   if (status != XpmSuccess &&
		status != XpmColorError)
			return (open_icon->pixmap?open_icon:NULL);
	   tmp = (PicInfo *) malloc (picsiz);
	   if (!tmp)
		return (open_icon->pixmap?open_icon:NULL);
	   memcpy (tmp, &icon, picsiz);
	   tmp->nvolatile = 1;
	   /* volatile */
	   return (tmp);
	}
	if (xpm_tbl[ftype]) {
	   	icon_path = _dircat (icons_path, xpm_tbl[ftype]);
		if (icon_path) {
           		status = XpmReadFileToPixmap(XtDisplay (w),
                                          XRootWindowOfScreen(XtScreen(w)),
                                          icon_path,
                                          &icon.pixmap, &icon.mask,
                                          &icon.attributes);

			free (icon_path);
                	if (status != XpmSuccess &&
                        	status != XpmColorError)
	   			memcpy ((char *) &pic_tbl[ftype], 
					(char *) &default_icon, picsiz);
			else
	   			memcpy ((char *) &pic_tbl[ftype], 
				(char *) &icon, picsiz);
		}
	} else
		memcpy ((char *) &pic_tbl[ftype], 
			(char *) &default_icon, picsiz);
	   
	   
        free (path);
	return (pic_tbl[ftype].pixmap?&pic_tbl[ftype]:NULL);

}

struct entry {
   char *s;
   int   n;
};

/*
 * Extension and file types
 */

static struct entry extensions[] =  
			  {{".c", T_IFC},
			   {".h", T_IFH},
			   {".o", T_IFOBJ},
			   {".for", T_IFORTRN},
			   {".f", T_IFORTRN},
			   {".tar", T_IFTAR},
			   {".sh", T_IFSCRPT},
			   {".ar", T_IFAR},
			   {".z", T_IFPCKD},
			   {".Z", T_IFCMP},
			   {".s", T_IFASSM},
			   {".S", T_IFASSM},
			   {".xwd", T_IFXWD},
			   {".l", T_IFLEX},
			   {".y", T_IFYACC},
			   {NULL, 0}
		          };

/*
 * Well known filenames
 */

static struct entry names[] = 
		    {{"core", T_IFCORE},
		     {"makefile", T_IFMAKEFILE},
		     {"Makefile", T_IFMAKEFILE},
		     {NULL, 0}
		    };


/*
 * _match_extension: try to match file extension
 */
int _match_extension (path) 
char *path;
{
   size_t le, lp;
   register struct entry *ep;

   ep = &extensions[0];

	while (ep->s != NULL) {
	   le = strlen (ep->s);
	   lp = strlen (path);
	   if (lp >= le)
		if (!_strcmp (&path[lp-le], ep->s))
		   return (ep->n);
	   ep++;
	}
	return (0);
}

/*
 * _match_name: try to match filename
 */

int _match_name (fname)
char *fname;
{
   register struct entry *ep;

   ep = &names[0];

	while (ep->s != NULL) {
	   if (!_strcmp (fname, ep->s))
		return (ep->n);
	   ep++;
	}
	return (0);
}

/*
 * _virtualtype: determine the type of a file. In case of a symbolic
 *               link it returns the type of file referenced by the
 *	  	 link
 */
 
int _virtualtype (path)
char *path;
{
   struct stat linkstat;
   int ftype;

   if (!path)
   	return (-1);
   	
   if (stat (path, &linkstat) == 0) {
           ftype = _fasttype (path, &linkstat); 
   } else {
#ifdef DEBUG
           perror (path);
#endif
	   ftype = -1;
   }
   return (ftype);
}

/*
 * _fasttype: determine the type of a file. Try shortcuts
 *	      first in order to avoid expensive calculations
 */

int _fasttype (path, fstat)
char *path; 
struct stat *fstat;
{
   int ftype = 0;
   /* check mode */
   switch (fstat->st_mode & S_IFMT) {
        case S_IFCHR:
	   return (T_IFCHR);
	case S_IFDIR:
	   return (T_IFDIR);
	case S_IFIFO:
	   return (T_IFIFO);
	case S_IFBLK:
	   return (T_IFBLK);
	case S_IFLNK:
	   return (T_IFLNK);
	case S_IFSOCK:
	   return (T_IFSOCK);
   }
   /* check size */
   if (!fstat->st_size)
	return (T_IFEMPTY);
   /* check extension */
   if (ftype = _match_extension (path)) {
	return (ftype);
   }

   /* check name */
   if (ftype = _match_name (_extract_fname (path)))
	return (ftype);
   return (type (path, fstat)); 
}

/*
 * _veryfasttype: determine the type of a file. Only try shortcuts
 *	      in order to avoid expensive calculations
 */

int _veryfasttype (path, fstat)
char *path; 
struct stat *fstat;
{
   int ftype = 0;
   /* check mode */
   switch (fstat->st_mode & S_IFMT) {
        case S_IFCHR:
	   return (T_IFCHR);
	case S_IFDIR:
	   return (T_IFDIR);
	case S_IFIFO:
	   return (T_IFIFO);
	case S_IFBLK:
	   return (T_IFBLK);
	case S_IFLNK:
	   return (T_IFLNK);
	case S_IFSOCK:
	   return (T_IFSOCK);
   }
   /* check size */
   if (!fstat->st_size)
	return (T_IFEMPTY);
   /* check extension */
   if (ftype = _match_extension (path)) {
	return (ftype);
   }

   /* check name */
   if (ftype = _match_name (_extract_fname (path)))
	return (ftype);
   return (T_IFREG);   
}

/*
 * _extract_fname: extract filename (last component of path)
 */

char *_extract_fname (path)
char *path;
{
   size_t len;
   char *p = path;

	len = _strlen (path);
	if (len)
	   p += (len - 1);

	while (p != path && *p != '/')
	   p--;
	
	if (*p == '/')
	   return (p+1);
	   
	/* *p != '/' &&  p == path */
	return (p);
}


Pixmap get_fpixmap (ftype)
int ftype;
{
   if (pic_tbl[ftype].pixmap)
	return (pic_tbl[ftype].pixmap);
   else
	return (pic_tbl[0].pixmap);
   
}
