
/*
	Dual Systems Hydrix source file
	@(#)file.c	1.2 at 12/16/84 
 */
/*	@(#)file.c	1.9	*/


#include	<stdio.h>
#include	<ctype.h>
#include	<signal.h>
#include	<sys/param.h>
#include	<sys/types.h>
#include	<sys/sysmacros.h>
#include	<sys/stat.h>
#include 	"file.h"
#include	"string.h"


/*
**	Types
*/

#define	BYTE	0
#define	SHORT	2
#define	LONG	4
#define	STR	8

/*
**	Opcodes
*/

#define	EQ	0
#define	GT	1
#define	LT	2
#define	STRC	3	/* string compare */
#define	ANY	4
#define	SUB	64	/* or'ed in */

/*
**	Misc
*/

#define	NENT	200
#define	BSZ	128
#define	FBSZ	1024
#define	reg	register

/* Ass lang comment char */
#ifdef pdp11
#define ASCOMCHAR '/'
#else
#define ASCOMCHAR '#'
#endif
/*
**	Structure of magic file entry
*/

struct	entry	{
	char	e_level;	/* 0 or 1 */
	long	e_off;		/* in bytes */
	char	e_type;
	char	e_opcode;
	union	{
		long	num;
		char	*str;
	}	e_value;
	char	*e_str;
};

typedef	struct entry	Entry;

Entry	*mtab;
char	fbuf[FBSZ];
char	*mfile = "magic";
char	*fort[] = {
	"function","subroutine","common","dimension","block","integer",
	"real","data","double",0};
char	*asc[] = {
	"sys","mov","tst","clr","jmp",0};
char	*c[] = {
	"int","char","float","double","struct","extern",0};
char	*as[] = {
	"globl","byte","even","text","data","bss","comm",0};
char	*strchr();
char	*malloc();
long	atolo();
int	i = 0;
int	fbsz;
int	ifd;

#define	prf(x)	printf("%s:%s", x, strlen(x)>6 ? "\t" : "\t\t");

char *getstr();
void showstr();
extern char *_freedompath;


/*
 * type - determine the type of a file
 */

int type(file, fstat)
char	*file;
struct stat *fstat;
{
	int	j,nl;
	char	ch;
	int ftype = 0;

	ifd = -1; 
	switch (fstat->st_mode & S_IFMT) {
	case S_IFCHR:
#ifdef DEBUG
		printf("character");
#endif
                ftype = T_IFCHR;
                goto spcl;


	case S_IFDIR:
#ifdef DEBUG
		printf("directory\n");
#endif
                return (T_IFDIR);

	case S_IFIFO:
#ifdef DEBUG
		printf("fifo\n");
#endif
                return (T_IFIFO);

	case S_IFBLK:
#ifdef DEBUG
		printf("block");
#endif

spcl:
#ifdef DEBUG
		printf(" special (%d/%d)\n", major(fstat->st_rdev),
							minor(fstat->st_rdev));
#endif
		ftype = T_IFBLK;
		return (ftype);

        case S_IFLNK:
#ifdef DEBUG
		printf("link");
#endif
           	return (T_IFLNK);
        case S_IFSOCK:
#ifdef DEBUG
		printf("socket");
#endif
           	return (T_IFSOCK);

	}
	ifd = open(file, 0);
	if(ifd < 0) {
		return (T_IFREG);
	}


	fbsz = read(ifd, fbuf, FBSZ);
	if(fbsz == 0) {
#ifdef DEBUG
		printf("empty\n");
#endif
		ftype = T_IFEMPTY;
		goto out;
	}
	if(sccs()) {
#ifdef DEBUG
		printf("sccs \n");
#endif
		ftype = T_IFSCCS;
		goto out;
	}
	if(ftype = ckmtab()) {
		goto out;
	}

        switch (is_tar(fbuf)) {
        case 1:
#ifdef DEBUG
                printf("tar archive", stdout);
#endif
		ftype = T_IFTAR;
                goto out;
        case 2:
#ifdef DEBUG
                printf("POSIX tar archive", stdout);
#endif
		ftype = T_IFTAR;
                goto out;
        }
	i = 0;
	if(ccom() == 0)
		goto notc;
	while(fbuf[i] == '#') {
		j = i;
		while(fbuf[i++] != '\n') {
			if(i - j > 255) {
#ifdef DEBUG
				printf("data\n"); 
#endif
				ftype = T_IFDATA;
				goto out;
			}
			if(i >= fbsz)
				goto notc;
		}
		if(ccom() == 0)
			goto notc;
	}
check:
	if(lookup(c) == 1) {
		while((ch = fbuf[i++]) != ';' && ch != '{')
			if(i >= fbsz)
				goto notc;
#ifdef DEBUG
		printf("c program text");
#endif
		ftype = T_IFC;
		goto outa;
	}
	nl = 0;
	while(fbuf[i] != '(') {
		if(fbuf[i] <= 0)
			goto notas;
		if(fbuf[i] == ';'){
			i++; 
			goto check; 
		}
		if(fbuf[i++] == '\n')
			if(nl++ > 6)goto notc;
		if(i >= fbsz)goto notc;
	}
	while(fbuf[i] != ')') {
		if(fbuf[i++] == '\n')
			if(nl++ > 6)
				goto notc;
		if(i >= fbsz)
			goto notc;
	}
	while(fbuf[i] != '{') {
		if(fbuf[i++] == '\n')
			if(nl++ > 6)
				goto notc;
		if(i >= fbsz)
			goto notc;
	}
#ifdef DEBUG
	printf("c program text");
#endif
	ftype = T_IFC;
	goto outa;
notc:
	i = 0;
	while(fbuf[i] == 'c' || fbuf[i] == '#') {
		while(fbuf[i++] != '\n')
			if(i >= fbsz)
				goto notfort;
	}
	if(lookup(fort) == 1){
#ifdef DEBUG
		printf("fortran program text");
#endif
		ftype = T_IFORTRN;
		goto outa;
	}
notfort:
	i = 0;
	if(ascom() == 0)
		goto notas;
	j = i-1;
	if(fbuf[i] == '.') {
		i++;
		if(lookup(as) == 1){
#ifdef DEBUG
			printf("assembler program text"); 
#endif
			ftype = T_IFASSM;
			goto outa;
		}
		else if(j != -1 && fbuf[j] == '\n' && isalpha(fbuf[j+2])){
#ifdef DEBUG
			printf("[nt]roff, tbl, or eqn input text");
#endif
			ftype = T_IFTROFF;
			goto outa;
		}
	}
	while(lookup(asc) == 0) {
		if(ascom() == 0)
			goto notas;
		while(fbuf[i] != '\n' && fbuf[i++] != ':')
			if(i >= fbsz)
				goto notas;
		while(fbuf[i] == '\n' || fbuf[i] == ' ' || fbuf[i] == '\t')
			if(i++ >= fbsz)
				goto notas;
		j = i - 1;
		if(fbuf[i] == '.'){
			i++;
			if(lookup(as) == 1) {
#ifdef DEBUG
				printf("assembler program text"); 
#endif
                        	ftype = T_IFASSM;
				goto outa; 
			}
			else if(fbuf[j] == '\n' && isalpha(fbuf[j+2])) {
#ifdef DEBUG
				printf("[nt]roff, tbl, or eqn input text");
#endif
				ftype = T_IFTROFF;
				goto outa;
			}
		}
	}
#ifdef DEBUG
	printf("assembler program text");
#endif
        ftype = T_IFASSM;
	goto outa;
notas:
	for(i=0; i < fbsz; i++)
		if(fbuf[i]&0200) {
			if (fbuf[0]=='\100' && fbuf[1]=='\357') {
#ifdef DEBUG
				printf("troff output\n");
#endif
				ftype = T_IFTROFF;
				goto out;
			}
			ftype = T_IFDATA;
#ifdef DEBUG
			printf("data\n"); 
#endif
			goto out; 
		}
	if (fstat->st_mode&((S_IEXEC)|(S_IEXEC>>3)|(S_IEXEC>>6))) {
#ifdef DEBUG
		printf("commands text");
#endif
		ftype = T_IFSCRPT;
#ifdef OLD
	} else if(english(fbuf, fbsz)) {
		ftype = T_IFENG;
#ifdef DEBUG
		printf("English text");
#endif
#endif
	} else {
		ftype = T_IFASCII;
#ifdef DEBUG
		printf("ascii text");
#endif
	}
outa:
	while(i < fbsz)
		if((fbuf[i++]&0377) > 127) {
#ifdef DEBUG
			printf(" with garbage\n");
#endif
			goto out;
		}
#ifdef DEBUG
	printf("\n");
#endif
out:
#ifdef DEBUG
	utime(file, &fstat->st_atime); 
#endif
	close (ifd);
	return (ftype);
}

int mkmtab(cflg)
reg	int	cflg;
{
	reg	Entry	*ep;
	reg	FILE	*fp;
	reg	int	lcnt = 0;
	auto	char	buf[BSZ];
	auto	Entry	*mend;
	char 	*fullpath;
	extern  char *dircat ();

	ep = (Entry *) calloc(sizeof(Entry), NENT);
	if(ep == NULL) {
		fprintf(stderr, "no memory for magic table\n");
		return (-1);
	}
	mtab = ep;
	mend = &mtab[NENT];

	fullpath = _dircat (_freedompath, mfile);

	if (!fullpath) {
	   fprintf(stderr, "mktab:_dircat failed\n");
	   return (-1);
	}

	fp = fopen(fullpath, "r");
	free (fullpath);
	if(fp == NULL) {
		perror (fullpath);
		return (-1);
	}
	while(fgets(buf, BSZ, fp) != NULL) {
		reg	char	*p = buf;
		reg	char	*p2;
		reg	char	opc;

		if(*p == '\n' || *p == '#')
			continue;
		lcnt++;
			

			/* LEVEL */
		if(*p == '>') {
			ep->e_level = 1;
			p++;
		}
			/* OFFSET */
		p2 = strchr(p, '\t');
		if(p2 == NULL) {
			if(cflg)
				fprintf(stderr, "fmt error, no tab after %son line %d\n", p, lcnt);
			continue;
		}
		*p2++ = NULL;
		ep->e_off = atolo(p);
		while(*p2 == '\t')
			p2++;
			/* TYPE */
		p = p2;
		p2 = strchr(p, '\t');
		if(p2 == NULL) {
			if(cflg)
				fprintf(stderr, "fmt error, no tab after %son line %d\n", p, lcnt);
			continue;
		}
		*p2++ = NULL;
		if(*p == 's') {
			if(*(p+1) == 'h')
				ep->e_type = SHORT;
			else
				ep->e_type = STR;
		} else if (*p == 'l')
			ep->e_type = LONG;
		while(*p2 == '\t')
			*p2++;
			/* OP-VALUE */
		p = p2;
		p2 = strchr(p, '\t');
		if(p2 == NULL) {
			if(cflg)
				fprintf(stderr, "fmt error, no tab after %son line %d\n", p, lcnt);
			continue;
		}
		*p2++ = NULL;
		if(ep->e_type != STR) {
			opc = *p++;
			switch(opc) {
			case '=':
				ep->e_opcode = EQ;
				break;

			case '>':
				ep->e_opcode = GT;
				break;

			case '<':
				ep->e_opcode = LT;
				break;

			case 'x':
				ep->e_opcode = ANY;
				break;

			default:
				p--;
			}
		}
		if(ep->e_opcode != ANY) {
			if(ep->e_type != STR)
				ep->e_value.num = atolo(p);
			else {
				ep->e_value.str = malloc(strlen(p) + 1);
/*
				strcpy(ep->e_value.str, p);
*/

				{
				int dummy;
				getstr(p, ep->e_value.str, 
					strlen(p) + 1, &dummy);
				}
#ifdef DEBUG
				fprintf (stderr, "%s\n", ep->e_value.str);
#endif
			}
		}
		while(*p2 == '\t')
			*p2++;
			/* STRING */
		ep->e_str = malloc(strlen(p2) + 1);
		p = ep->e_str;
		while(*p2 != '\n') {
			if(*p2 == '%')
				ep->e_opcode |= SUB;
			*p++ = *p2++;
		}
		*p = NULL;
		ep++;
		if(ep >= mend) {
			fprintf(stderr, "file: magic tab overflow - increase NENT in file.c.\n");
			fclose (fp);	/* Close magic file */
			return (-1);
		}
	}
	ep->e_off = -1L;
	fclose (fp);	
	return (1);
}

long
atolo(s)
reg	char	*s;
{
	reg	char	c;
	reg	char	*fmt = "%ld";
	auto	long	j = 0L;

	if(*s == '0') {
		s++;
		if(*s == 'x') {
			s++;
			fmt = "%lx";
		} else
			fmt = "%lo";
	}
	sscanf(s, fmt, &j);
	return(j);
}

ckmtab()
{

	reg	Entry	*ep;
	reg	char	*p;
	reg	int	lev1 = 0;
	auto	union	{
		long	l;
		char	ch[4];
		}	val, revval;
	static  int	init = 0;
	static	char	tmpbyte;

	if (init < 0)
		return (0);

	if(!init) {
		if ((init = mkmtab(0)) < 0)
			return (0); 
	}
	for(ep = mtab; ep->e_off != -1L; ep++) {
		if(lev1) {
			if(ep->e_level != 1)
				break;
			putchar(' ');
		} else if(ep->e_level == 1)
			continue;
		p = &fbuf[ep->e_off];
		switch(ep->e_type) {
		case STR:
		{
			if(strncmp(p,ep->e_value.str,strlen(ep->e_value.str)))
				continue;
#ifdef DEBUG
			if(ep->e_opcode & SUB)
				printf(ep->e_str, ep->e_value.str);
			else
				printf(ep->e_str);
#endif
			return (StrToType ( ep->e_str)); /* ugly */
			lev1 = 1;
		}

		case BYTE:
			val.l = (long)(*(unsigned char *) p);
			break;

		case SHORT:
			val.l = (long)(*(unsigned short *) p);
			break;

		case LONG:
			val.l = (*(long *) p);
			break;
		}
		switch(ep->e_opcode & ~SUB) {
		case EQ:
#ifdef u3b
			if(val.l != ep->e_value.num)
				if(ep->e_type == SHORT) {
					/* reverse bytes */
					revval.l = 0L;
					tmpbyte = val.ch[3];
					revval.ch[3] = val.ch[2];
					revval.ch[2] = tmpbyte;
					if(revval.l != ep->e_value.num)
						continue;
					else
						break;
				}
				else	continue;
			else
				break;
#else
			if(val.l != ep->e_value.num)
				continue;
			break;
#endif
		case GT:
			if(val.l <= ep->e_value.num)
				continue;
			break;

		case LT:
			if(val.l >= ep->e_value.num)
				continue;
			break;
		}

#ifdef DEBUG
		if(ep->e_opcode & SUB)
			printf(ep->e_str, val.l);
		else
			printf(ep->e_str);
#endif
		return (StrToType ( ep->e_str)); /* ugly */
		lev1 = 1;
	}
	if(lev1) {
#ifdef DEBUG
		putchar('\n');
#endif
		return(1);
	}
	return(0);
}

lookup(tab)
reg	char **tab;
{
	reg	char	r;
	reg	int	k,j,l;

	while(fbuf[i] == ' ' || fbuf[i] == '\t' || fbuf[i] == '\n')
		i++;
	for(j=0; tab[j] != 0; j++) {
		l = 0;
		for(k=i; ((r=tab[j][l++]) == fbuf[k] && r != '\0');k++);
		if(r == '\0')
			if(fbuf[k] == ' ' || fbuf[k] == '\n' || fbuf[k] == '\t'
			    || fbuf[k] == '{' || fbuf[k] == '/') {
				i=k;
				return(1);
			}
	}
	return(0);
}

ccom()
{
	reg	char	cc;

	while((cc = fbuf[i]) == ' ' || cc == '\t' || cc == '\n')
		if(i++ >= fbsz-1) /* fixed 6/30/93 */
			return(0);
	if(fbuf[i] == '/' && fbuf[i+1] == '*') {
		i += 2;
		while(fbuf[i] != '*' || fbuf[i+1] != '/') {
			if(fbuf[i] == '\\')
				i += 2;
			else
				i++;
			if(i >= fbsz)
				return(0);
		}
		if((i += 2) >= fbsz)
			return(0);
	}
	if(fbuf[i] == '\n')
		if(ccom() == 0)
			return(0);
	return(1);
}

ascom()
{
	while(fbuf[i] == ASCOMCHAR) {
		i++;
		while(fbuf[i++] != '\n')
			if(i >= fbsz)
				return(0);
		while(fbuf[i] == '\n')
			if(i++ >= fbsz)
				return(0);
	}
	return(1);
}

sccs() {
	reg int i;

	if(fbuf[0] == 1 && fbuf[1] == 'h')
		for(i=2; i<=6; i++)
			if(isdigit(fbuf[i])) continue;
			else return(0);
	else
		return(0);
	return(1);
}

english (bp, n)
char *bp;
{
#	define NASC 128
	reg	int	j, vow, freq, rare;
	reg	int	badpun = 0, punct = 0;
	auto	int	ct[NASC];

	if (n<50)
		return(0); /* no point in statistics on squibs */
	for(j=0; j<NASC; j++)
		ct[j]=0;
	for(j=0; j<n; j++)
	{
		if (bp[j]<NASC)
			ct[bp[j]|040]++;
		switch (bp[j])
		{
		case '.': 
		case ',': 
		case ')': 
		case '%':
		case ';': 
		case ':': 
		case '?':
			punct++;
			if(j < n-1 && bp[j+1] != ' ' && bp[j+1] != '\n')
				badpun++;
		}
	}
	if (badpun*5 > punct)
		return(0);
	vow = ct['a'] + ct['e'] + ct['i'] + ct['o'] + ct['u'];
	freq = ct['e'] + ct['t'] + ct['a'] + ct['i'] + ct['o'] + ct['n'];
	rare = ct['v'] + ct['j'] + ct['k'] + ct['q'] + ct['x'] + ct['z'];
	if(2*ct[';'] > ct['e'])
		return(0);
	if((ct['>']+ct['<']+ct['/'])>ct['e'])
		return(0);	/* shell file test */
	return (vow*5 >= n-ct[' '] && freq >= 10*rare);
}


/*
 * Convert a string containing C character escapes.  Stop at an unescaped
 * space or tab.
 * Copy the converted version to "p", returning its length in *slen.
 * Return updated scan pointer as function result.
 */
char *
getstr(s, p, plen, slen)
register char	*s;
register char	*p;
int	plen, *slen;
{
	char	*origs = s, *origp = p;
	char	*pmax = p + plen - 1;
	register int	c;
	register int	val;

	while((c = *s++) != '\0') {
		if (isspace(c)) break;
		if (p >= pmax) {
			fprintf(stderr, "String too long: %s\n", origs);
			break;
		}
		if(c == '\\') {
			switch(c = *s++) {

			case '\0':
				goto out;

			default:
				*p++ = c;
				break;

			case 'n':
				*p++ = '\n';
				break;

			case 'r':
				*p++ = '\r';
				break;

			case 'b':
				*p++ = '\b';
				break;

			case 't':
				*p++ = '\t';
				break;

			case 'f':
				*p++ = '\f';
				break;

			case 'v':
				*p++ = '\v';
				break;

			/* \ and up to 3 octal digits */
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
				val = c - '0';
				c = *s++;  /* try for 2 */
				if(c >= '0' && c <= '7') {
					val = (val<<3) | (c - '0');
					c = *s++;  /* try for 3 */
					if(c >= '0' && c <= '7')
						val = (val<<3) | (c-'0');
					else
						--s;
				}
				else
					--s;
				*p++ = val;
				break;

			/* \x and up to 3 hex digits */
			case 'x':
				val = 'x';	/* Default if no digits */
				c = hextoint(*s++);	/* Get next char */
				if (c >= 0) {
					val = c;
					c = hextoint(*s++);
					if (c >= 0) {
						val = (val << 4) + c;
						c = hextoint(*s++);
						if (c >= 0) {
							val = (val << 4) + c;
						} else
							--s;
					} else
						--s;
				} else
					--s;
				*p++ = val;
				break;
			}
		} else
			*p++ = c;
	}
out:
	*p = '\0';
	*slen = p - origp;
	return(s);
}

/* Single hex char to int; -1 if not a hex char. */
int
hextoint(c)
        char c;
{
        if (!isascii(c))        return -1;
        if (isdigit(c))         return c - '0';
        if ((c>='a')&(c<='f'))  return c + 10 - 'a';
        if ((c>='A')&(c<='F'))  return c + 10 - 'A';
}

/*
 * Print a string containing C character escapes.
 */
void
showstr(s)
register char   *s;
{
        register char   c;

        while((c = *s++) != '\0') {
                if(c >= 040 && c <= 0176)
                        putchar(c);
                else {
                        putchar('\\');
                        switch (c) {

                        case '\n':
                                putchar('n');
                                break;

                        case '\r':
                                putchar('r');
                                break;

                        case '\b':
                                putchar('b');
                                break;

                        case '\t':
                                putchar('t');
                                break;

                        case '\f':
                                putchar('f');
                                break;

                        case '\v':
                                putchar('v');
                                break;

                        default:
                                printf("%.3o", c & 0377);
                                break;

                        }
                }
        }
        putchar('\t');
}


/*
 * is_tar() -- figure out whether file is a tar archive.
 *
 * Stolen (by the author!) from the public domain tar program:
 * Pubic Domain version written 26 Aug 1985 John Gilmore (ihnp4!hoptoad!gnu).
 *
 * @(#)list.c 1.18 9/23/86 Public Domain - gnu
 *
 * Comments changed and some code/comments reformatted
 * for file command by Ian Darwin.
 */


#define	isodigit(c)	( ((c) >= '0') && ((c) <= '7') )

long from_oct();			/* Decode octal number */

/*
 * Return 
 *	0 if the checksum is bad (i.e., probably not a tar archive), 
 *	1 for old UNIX tar file,
 *	2 for Unix Std (POSIX) tar file.
 */
int
is_tar(header)
	register union record *header;
{
	register int	i;
	register long	sum, recsum;
	register char	*p;

	recsum = from_oct(8,  header->header.chksum);

	sum = 0;
	p = header->charptr;
	for (i = sizeof(*header); --i >= 0;) {
		/*
		 * We can't use unsigned char here because of old compilers,
		 * e.g. V7.
		 */
		sum += 0xFF & *p++;
	}

	/* Adjust checksum to count the "chksum" field as blanks. */
	for (i = sizeof(header->header.chksum); --i >= 0;)
		sum -= 0xFF & header->header.chksum[i];
	sum += ' '* sizeof header->header.chksum;	

	if (sum != recsum)
		return 0;	/* Not a tar archive */
	
	if (0==strcmp(header->header.magic, TMAGIC)) 
		return 2;		/* Unix Standard tar archive */

	return 1;			/* Old fashioned tar archive */
}


/*
 * Quick and dirty octal conversion.
 *
 * Result is -1 if the field is invalid (all blank, or nonoctal).
 */
long
from_oct(digs, where)
	register int	digs;
	register char	*where;
{
	register long	value;

	while (isspace(*where)) {		/* Skip spaces */
		where++;
		if (--digs <= 0)
			return -1;		/* All blank field */
	}
	value = 0;
	while (digs > 0 && isodigit(*where)) {	/* Scan til nonoctal */
		value = (value << 3) | (*where++ - '0');
		--digs;
	}

	if (digs > 0 && *where && !isspace(*where))
		return -1;			/* Ended on non-space/nul */

	return value;
}

char *typeToStr (ftype)
int ftype;
{
   switch (ftype) {
	case T_INVALID:
	   return (strdup ("Unknown"));
	case T_IFCHR:
	   return (strdup ("character"));
	case T_IFDIR:
	   return (strdup ("directory"));
	case T_IFIFO:
	   return (strdup ("FIFO"));
	case T_IFBLK:
	   return (strdup ("block special"));
	case T_IFREG:
	   return (strdup ("regular"));
	case T_IFLNK:
	   return (strdup ("link"));
	case T_IFSOCK: 
	   return (strdup ("socket"));
	case T_IFEMPTY:
	   return (strdup ("empty"));
	case T_IFSCCS:
	   return (strdup ("sccs file"));
	case T_IFCPIO:
	   return (strdup ("cpio file"));
	case T_IFPCKD:
	   return (strdup ("compacted"));
	case T_IFCMP:
	   return (strdup ("compressed"));
	case T_IFAR:
	   return (strdup ("archive library"));
	case T_IFPS:
	   return (strdup ("PostScript"));
	case T_IFRAS:
	   return (strdup ("Raster"));
	case T_IFEXC:
	   return (strdup ("Executable"));
	case T_IFOBJ:
	   return (strdup ("Object file"));
	case T_IFLEX:
	   return (strdup ("Lex"));
	case T_IFPASCL:
	   return (strdup ("Pascal"));
	case T_IFRATFOR:
	   return (strdup ("Ratfor"));
	case T_IFYACC:
	   return (strdup ("Yacc"));
	case T_IFMOD2:
	   return (strdup ("Modula2"));
	case T_IFTAR:
	   return (strdup ("Tar file"));
	case T_IFDATA:
	   return (strdup ("data"));
	case T_IFC:
	   return (strdup ("C"));
	case T_IFH:
	   return (strdup ("Header file"));
	case T_IFORTRN:
	   return (strdup ("Fortran"));
	case T_IFASSM:
	   return (strdup ("Assembler"));
	case T_IFTROFF:
	   return (strdup ("[NT]roff"));
	case T_IFSCRPT:
	   return (strdup ("Shell script"));
	case T_IFENG:
	    return (strdup ("English text"));
	case T_IFASCII:
	    return (strdup ("ASCII"));
	case T_IFXWD:
	    return (strdup ("XWD"));
	case T_IFCORE:
	    return (strdup ("Core"));
	case T_IFMAKEFILE:
	    return (strdup ("Makefile"));
	case T_IFOSCRPT:
	    return (strdup ("Open Script"));
	default:
	   return (NULL);
    }
}

int _strmatch (s, s1)
char *s, *s1;
{
   if (!s || !s1)
	return (0);

   while (*s && *s1)
	if (*s++ != *s1++)
	   return (0);

   if (*s1)
	return (0);
   else
	return (1);
}

int StrToType (s)
register char *s;
{
   if (_strmatch (s, "compressed"))
	return (T_IFCMP);
   if (_strmatch (s, "archive"))
	return (T_IFAR);
   if (_strmatch (s, "sparc"))
	return (T_IFEXC); 
   if (_strmatch (s, "core"))
	return (T_IFCORE); 
   if (_strmatch (s, "Open"))
	return (T_IFOSCRPT);
   if (_strmatch (s, "PostScript"))
	return (T_IFPS);
   if (_strmatch (s, "cpio"))
	return (T_IFCPIO);
   if (_strmatch (s, "packed"))
	return (T_IFPCKD);
#if defined(SOLARIS) || defined (linux)
   if (strstr (s, "ELF"))
	return (T_IFEXC);
#endif
   return (0);
}
