/* $XConsortium: List.c,v 1.34 91/09/27 18:35:07 converse Exp $ */

/*
 * Copyright 1989 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

/*
 * XedwList.h - XedwList widget
 *
 * This is the XedwList widget. It is very similar to the Athena Widget List,
 * except it has the ability to display an icon with the string.
 * It allows the user to select an item in a xedwList and notifies the
 * application through a callback function.
 *
 *  List Created:   8/13/88
 *  By:     Chris D. Peterson
 *                      MIT X Consortium
 *
 *  Modified to XedwList: 1/26/91
 *  By:      Edward Groenendaal
 *                      University of Sussex, UK.
 */

/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */


#ifndef _XawXedwList_h
#define _XawXedwList_h

/*
 * XedwList Widget
 */

/*
 * Value returned when there are no highlighted objects.
 */

#define XDTM_LIST_NONE -1


#define XtCXedwList "XedwList"
#define XtCSpacing "Spacing"
#define XtCColumns "Columns"
#define XtCNumberStrings "NumberStrings"
#define XtCFitParent     "FitParent"
#define XtCLayoutPolicy	"LayoutPolicy"


#define XtNrubberbanding "rubberbanding"
#define XtNfitParent     "fitParent"
#define XtNlayoutPolicy  "layoutPolicy"
#define XtNcursor "cursor"
#define XtNcolumnSpacing "columnSpacing"
#define XtNdefaultColumns "defaultColumns"
#define XtNforceColumns "forceColumns"
#define XtNxedwList "xedwList"
#define XtNiconWidth "iconWidth"
#define XtNiconHeight "iconHeight"
#define XtNdefaultIcon "defaultIcon"
#define XtNnumberStrings "numberStrings"
#define XtNpasteBuffer "pasteBuffer"
#define XtNrowSpacing "rowSpacing"
#define XtNshowIcons "showIcons"
#define XtNmSelections "mSelections"
#define XtNverticalList "verticalList"
#define XtNdoubleClick	"doubleClick"
#define XtNdrop	"drop"
#define XtNexpose	"expose"
#define XtNconvertProc	"convertProc"
#define XtNhandlePopup	"handledPopup"

#define XedwDYNAMIC     1
#define XedwSTATIC      2

#define XedwSingle    1
#define XedwMultiple  2

#define XedwEps		0
#define XedwIdle	0
#define XedwPickingItem	1
#define XedwDraggingItem 2
#define XedwItemsSelected 4
#define XedwReadyToDrop 8
#define XedwCheckDoubleClick 16
#define XedwRubberBox 32

#define XedwAll			-1

#define IconBitmapWidth       32
#define IconBitmapHeight      32

/* Class record constants */

extern WidgetClass xedwListWidgetClass;

typedef struct _XedwListClassRec *XedwListWidgetClass;
typedef struct _XedwListRec      *XedwListWidget;

/* The structure of XedwList */


#define ItemInitted		1
#define _ItemHighlighted 	2
#define _ItemInRubberBox 	4
#define _ItemDeleted		8
#define _ItemMarked		16	/* Temporary mark */
#define _ItemReceptor		32
#define _ItemGreyedOut		64

#define IsHighlighted(item)	((item)->item_stat&_ItemHighlighted)
#define IsInRubberBox(item)	((item)->item_stat&_ItemInRubberBox)
#define IsReceptor(item)	((item)->item_stat&_ItemReceptor)

#define XwCollSortByName(w)	(XwCollSort((Widget) w,ncmp))

typedef struct _item {
  struct _item *item_h_prv, *item_h_nxt;
  int 	 it_stat;
  int	 item_stat;
  char  *item_name;
  char  *item_label;
  Pixmap item_icon;
  Pixmap item_mask;
  int    item_x, item_y;		/* Upper left corner */
  int    item_label_x, item_label_y;
  short  item_label_width;
} _ITEM;

typedef _ITEM XedwList;


typedef struct _XedwCallbackStruct {
  int          reason;
  XEvent      *event;
  _ITEM       *xedw_h_item;
  _SimpleList *xedw_h_lst;
  _ITEM       *xedw_receptor;
  /* the next fields are valid only when coming from a different process */
  char	      *data;		/* pointer to dropped data */
  int	      len;		/* length of data          */
  int	      type;		/* type of data dropped	   */
  Window      from;		/* window where the message comes from */
  u_int       keymask;		/* keyboard modifier mask  */
  
} XedwCallbackStruct;


#define XedwCR_DOUBLE_CLICK	1
#define XedwCR_INTERNAL_MOVE	2
#define XedwCR_INTERNAL_COPY	3
#define XedwCR_INTERNAL_LINK	4
#define XedwCR_EXTERNAL_MOVE	5
#define XedwCR_EXTERNAL_COPY	6
#define XedwCR_EXTERNAL_LINK	7
#define XedwCR_EXPOSE		8
#define XedwCR_HANDLE_POPUP	9
/*
 * Functions
 */

extern void XedwListChange(); 
extern void XedwListUnhighlight();
extern void XedwListHighlight(); 
extern Boolean XedwListSelection();
extern void XedwAListUnhighlight ();
extern _ITEM *XwCollItemInsertO ();
extern _ITEM *XwCollItemUInsertO ();
extern char  *XwCollItemsSelected();
extern char  **XwCollVItemsSelected();

#endif /* _XedwList_h */
