
/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#ifndef _XwDirP_h
#define _XwDirP_h

#include <sys/types.h>
#include <sys/stat.h>
#include "hash.h"

#include "xpm.h"

/*
 * XwDir Widget Private Data
 */

/* New fields for the XwDir widget class record */

typedef struct _XwDirClassPart {
	int foo;
} XwDirClassPart;

/* Class record declaration */

typedef struct _XwDirClassRec {
    CoreClassPart      	core_class;
    XedwListClassPart   xedwList_class;
    XwDirClassPart	dir_class;
} XwDirClassRec;

extern XwDirClassRec xwDirClassRec;


/* New fields for the directory widget record */

typedef struct _XwDirPart {

  char		*directory_path;
  int		long_listing_flags; /* Long listing flags  */
  int		pty;
  char		*base_directory;    /* root directory for the widget     */
				    /* files. Icons and the magic file   */
				    /* belong here			 */
  Boolean	showparent;	 /* show ..  */
  Boolean 	showhidden;	 /* show hidden files */
  Boolean	termmode;	 /* send commands to the terminal window */
  Boolean	keepsynchronized;/* send commands to the terminal window */
  Boolean	force_move;
  int 		update_period;	/* Update period		                   */
  				/* Once this period expires the directory is       */
  				/* reread (period measured in seconds)             */
  int		long_directory;	/* Number of files needed to be considered a       */
  				/* long directory. Automatic update is disabled    */
  				/* for long directories. File types are determined */
  				/* with the simplest algorithm possible.           */     

  Boolean 	islong_dir;	/* current directory is a long directory	   */	
  
  void (*activateproc) (); 	/* double click function 	 */
  /* private state */
  struct stat	dir_stat;	/* Directory status record */
  Hash		*htbl;		/* Hash Table		   */
  _SimpleList	*req_lst;	/* Request list		   */
  unsigned long	req_max_age;	/* Maximun age of any request */
				/* Kill requests older than this */
  XtIntervalId  timer;		/* Timer		   */
  unsigned long delay;		/* Timer delay		   */
  Widget *widgets;		/* Menu widgets (actions)  */

} XwDirPart;


typedef struct _XwDirRec {
  CorePart	core;
  XedwListPart	xedwList;
  XwDirPart	dir;
} XwDirRec;


typedef _ELEM ListPart;


/*
 * Request List
 */


typedef struct _DirReqPart {
   short        type;   /* Request type */
   char 	*path;  /* directory path  */
   DirItemObject entry; /* directory entry */
   unsigned long age;	/* Request age     */
} DirReqPart;

typedef struct _DirReqRec {
   ListPart list;
   DirReqPart req;
} DirReqRec;

typedef DirReqRec     *DirReqObject;

#define DRECSIZE sizeof (DirReqRec)
#define DEFAULT_BASE_DIRECTORY	"/usr/local/guiWidgets/Directory"
#define ICONS_SUBDIRECTORY	"icons"

/*
 * Operation Codes
 */

#define DELETE_ENTRY	0	/* Delete directory entry */
#define ADD_ENTRY	1	/* Add directory entry    */

/*
 * Macros
 */

/* Delete a request from the list */
#define _DReqDelete(rl,dr) {free (dr->req.path); \
   dr->req.path = NULL;\
   _SListDelete (rl, dr);}

/* Add a request of type <rtype> to the list */
#define _DReqEnQueue(w,rl,rtype,rentry)					\
{									\
DirReqObject dr;							\
static size_t drecsize = DRECSIZE;					\
									\
        if (!(dr = (DirReqObject) malloc (drecsize))) {			\
           fprintf (stderr, "_DReqEnQueue: Not enough memory\n");	\
           exit (1);							\
        }								\
	dr->req.entry = rentry;						\
	dr->req.type = rtype;						\
	dr->req.path = _strclone (w->dir.directory_path);		\
	dr->req.age = 0L;						\
        _SListAppend (rl, dr); /* Free this later */			\
}

/* Clear item structure      */

#define _DirItemClear(ip) {				\
static int itemsize = sizeof(_DirItemRec);		\
register char *ptr = (char *) ip;			\
register int i;						\
							\
   i = itemsize;					\
   while (i--)						\
	*(ptr++) = 0;					\
}


/* Initialize directory item  */
#define _DirItemInit(dw,path,ip,st) { 			\
PicInfo *Pic; 						\
static int statsize = sizeof(struct stat); 		\
							\
							\
   /* Update file status */				\
   memcpy (&(ip->fileInfo.fstat), st, statsize);	\
							\
							\
   /* Determine file type */				\
   ip->fileInfo.ftype = _fasttype (path, &(ip->fileInfo.fstat)); \
							\
   /* Get icon  */					\
   if (Pic = get_icon (dw, ip)) {			\
	ip->item_icon = Pic->pixmap;			\
	ip->item_mask = Pic->mask;			\
	ip->fileInfo.pic  = Pic;			\
   } else {						\
	ip->item_icon = ip->item_mask = NULL; /* check this */	\
	ip->fileInfo.pic  = NULL;			\
   }							\
}

#define _DirItemFastInit(dw,path,ip,st) { 			\
PicInfo *Pic; 						\
static int statsize = sizeof(struct stat); 		\
							\
							\
   /* Update file status */				\
   memcpy (&(ip->fileInfo.fstat), st, statsize);	\
							\
							\
   /* Determine file type */				\
   ip->fileInfo.ftype = _veryfasttype (path, &(ip->fileInfo.fstat)); \
							\
   /* Get icon  */					\
   if (Pic = get_icon (dw, ip)) {			\
	ip->item_icon = Pic->pixmap;			\
	ip->item_mask = Pic->mask;			\
	ip->fileInfo.pic  = Pic;			\
   } else {						\
	ip->item_icon = ip->item_mask = NULL; /* check this */	\
	ip->fileInfo.pic  = NULL;			\
   }							\
}

#define _DwReqMaxAge	600L  /* tune these numbers */
#define _DwTimerDelay	200L

#ifdef OLD
/* _UpdateWidgetReqL: Update the request list with new offsets */
/* This function is called after sorting the directory list    */

#define _UpdateWidgetReqL(dw) { 					\
   DirReqObject dr;		 					\
   DirItemObject item;							\
									\
   dr = (DirReqObject) _ListFirst (dw->dir.req_lst); 			\
						     			\
   while (dr) {					     			\
	if (dr->req.type == DELETE_ENTRY)	     			\
	   item = (DirItemObject) hash__Lookup(dw->dir.htbl,   \
						(char *) (dr->req.entry));\
	   dr->req.entry = item;					\
        dr = (DirReqObject) _ListNext (dw->dir.req_lst);		\
   }									\
}
#endif

#define DisplayWaitCursor(w)	{ \
Display *disp = XtDisplay(( XedwListWidget )w); \
	XDefineCursor(disp,\
	XtWindow(( XedwListWidget )w), \
	(( XedwListWidget )w)->xedwList.wait_cursor);\
	XDefineCursor(disp,\
        RootWindow( disp,  DefaultScreen(disp)),\
	(( XedwListWidget )w)->xedwList.wait_cursor);\
	XSync (XtDisplay(w), False);\
}

#define DisplayNormalCursor(w)  { \
Display *disp = XtDisplay(( XedwListWidget )w); \
	XUndefineCursor (disp\
	,XtWindow(( XedwListWidget )w)); \
	XUndefineCursor (disp\
        ,RootWindow( disp,  DefaultScreen(disp))),\
	XSync (XtDisplay(w), False); \
}



#endif /* _XwDirP_h */



