
/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#ifndef _XwDir_h
#define _XwDir_h
#include "XedwList.h"
#include <sys/types.h>
#include <sys/stat.h>
#include "build_option.h"
#include "pixmaps.h"


/*
 * XwDir widget
 */


/* Class record constants */

extern WidgetClass xwDirWidgetClass;

typedef struct _XwDirClassRec	*XwDirWidgetClass;
typedef struct _XwDirRec	*XwDirWidget;

/*
 * Define resource strings for the Directory Widget
 */

#define XtNdirectoryPath	"directoryPath"
#define XtCDirectoryPath	"DirectoryPath"

#define XtNshowParent		"showParent"
#define XtCShowParent		"ShowParent"
#define XtNshowHidden		"showHidden"
#define XtCShowHidden		"ShowHidden"
#define XtNactivateProc		"activateProc"
#define XtCActivateProc		"ActivateProc"
#define XtCActivateProc		"ActivateProc"
#define XtNkeepSynchronized	"keepSynchronized"
#define XtCKeepSynchronized	"KeepSynchronized"

#define XtNforceMove		"forceMove"
#define XtCForceMove		"ForceMove"

#define XtNtermMode		"termMode"
#define XtCTermMode		"TermMode"

#define XtNpty	"pty"
#define XtCPty	"Pty"	

#define XtNbaseDirectory	"baseDirectory"
#define XtCBaseDirectory	"BaseDirectory"


#define XwDirFilesSelected(w) XwCollItemsSelected(w)
#define XwDirVFilesSelected(w) XwCollVItemsSelected(w)

#define XtNupdatePeriod	"updatePeriod"
#define XtNlongDirectory "longDirectory"

typedef struct {
  char *long_label;
  struct stat fstat;
  short	 ftype;
  PicInfo *pic;
} _FileInfoPart;

/*
 * Commands
 */

#define MKDIR	0
#define RM	1
#define RMDIR	2
#define MV	3
#define CP	4
#define LN	5

#define _XTERM 1
#define _SHELL 2
#define _NOWAIT 4
#define _PAUSE 8
#define _CHECKEDITOR 16
#define _USEPATH 32
#define _PAGE 64
#define _CONFIRM 128
#define _SETCWD 256


typedef struct {
  struct _item *item_h_prv, *item_h_nxt;
  int    it_stat;
  int    item_stat;
  char  *item_name;
  char  *item_label;
  Pixmap item_icon;
  Pixmap item_mask;
  int    item_x, item_y;                /* Upper left corner */
  int    item_label_x, item_label_y;
  short  item_label_width;
  _FileInfoPart fileInfo;
} _DirItemRec ;

/*
 * Debugging purposes only
 */

typedef struct _DebugItemRec {
  struct _elem *elm_nxt, *elm_prv; /* Next and previous Elements */
  int elm_stat;                    /* Element Status             */
  struct _item *item_h_prv, *item_h_nxt;
  int    it_stat;
  int    item_stat;
  char  *item_label;
  Pixmap item_icon;
  Pixmap item_mask;
  int    item_x, item_y;                /* Upper left corner */
  int    item_label_x, item_label_y;
  short  item_label_width;
  _FileInfoPart fileInfo;
} DebugItemRec;

/* Actions */

typedef struct _cmd {
   char *cmd;
   int flags;
} Cmd;

typedef struct _action {
   MenuItem *menu_item;
   Cmd *cmd_tbl;
} Action;


typedef _DirItemRec	*DirItemObject;

#define DITEMSIZE	sizeof (_DirItemRec)

/*
 * Public Widget operations
 */

extern void XwDirSortByName ();
extern void XwDirLongListing ();
extern int XwDirExecute ();
extern int ncmp ();

extern char *_trashpath;

#define MAXOPCNT        50

#ifdef DEMO
#define _check_opcnt(dw)  if (_opcnt >= MAXOPCNT) { \
                           _XmCErrorDialogPost (dw, \
                           "Evaluation period has expired, please exit", "Error"); \
                           return; \
                        }
extern int _opcnt;
#endif



#endif /* _XwDir_h */

