
/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#ifndef XENTRY_FORM
#define XENTRY_FORM

#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <Xm/DialogS.h>
#include "lst.h"

/*
 * Macros and definitions
 */

#define _DFSIZE	(sizeof (DataFieldRec))
#define NENTRIES	20
#define _DEFAULT_VALUE  ""

#define _IN_OUT		1
#define _SENSITIVE	2
#define _MANAGED	4
#define _APPEND		8
#define _FIXED		16


#define _strcmp(s,s1)   (s?(s1?strcmp(s,s1):1):(s1?-1:0))


#define _EntryFormSPLoadPos(ef,value,n) _EntryFormSChangeField(ef,value,n)
#define _EntryFormSIfFieldChanged(df) \
		(df?(_strcmp (df->data_field.value, _EntryFormSGetField (df)) != 0):0)

#define _DATA		0
 
#define _EntryFormFieldSetFixedMode(df)  ((df)?((df)->data_field.status|=_FIXED):0)

#define _EntryFormSClearField(ef, df)  _EntryFormSLoadField (df, _DEFAULT_VALUE) 
#define _EntryFormClearUnmanagedChildren(ef)  _EntryFormTraverse (ef, clearUnmanagedField)
#define _EntryFormGetShell(ef)	(ef->entry_form.shell)

/*
 * Make a field visible by restoring 
 * the original foreground color
 */

#define _EntryFormVisibleField(df) { \
   if (df->data_field.saved_foreground) \
   	XtVaSetValues (df->data_field.widget, XmNforeground, \
        	df->data_field.saved_foreground, NULL); \
}


typedef struct _EntryFormPart {
   Widget *formW;	/* form widget			*/
   int dfcnt;		/* number of children		*/
   Widget *messW;	/* message widget (optional)	*/
   int status;
   Widget shell;	/* shell ancestor		*/
} EntryFormPart;


/*
 * Entry form record
 */

typedef struct _EntryFormRec {
   _LST  		*field_list;
   EntryFormPart	entry_form;
} EntryFormRec;

typedef struct _EntryFormRec  * EntryFormObject;

typedef struct _DataFieldPart {
   Widget widget;	/* field widget				  */
   int	  widget_type;	/* internal widget type			  */
   char *resource;	/* main resource			  */
   int resource_type;	/* main resource type			  */
   char *value;		/* field value 				  */
   size_t pos;		/* field position			  */
   int type;		/* field type			  	  */
   int size;		/* field size			  	  */
   char *def_value;	/* default value			  */
   int (*validation) ();/* validation function			  */ 
   char *prompt;	/* prompt				  */
   int status;		/* field status				  */
   Widget *widgets;
   int n_widgets;	/* number of widgets			  */
   Pixel saved_foreground;
   Pixel saved_background;	/* original foreground & background colors*/
				/* Used by _EntryFormVisibleField         */
				/* and _EntryFormInvisibleField  	  */
} DataFieldPart;

/*
 * Data field record
 */

typedef struct _DataFieldRec { 
   DataFieldPart data_field;
} DataFieldRec;

typedef struct _DataFieldRec  * DataFieldObject;

/*
 * This structure is defined here for debugging purposes only
 */

typedef struct _EnhDataFieldRec {
   _ELEM header;
   DataFieldPart data_field;
};
   

/*
 * Functions
 */

extern EntryFormObject 	_EntryFormCreate ();		
extern void		_EntryFormDestroy ();
extern EntryFormObject 	_EntryFormSLoadData ();
extern char 		**_EntryFormSDumpData ();
extern EntryFormObject 	_EntryFormLoadFormatFromFile ();
extern void		_EntryFormSClear ();
extern char		*_EntryFormSGetField ();
extern DataFieldObject  _EntryFormPosToField ();
extern Widget 		_EntryFormPosToWidget ();
extern Widget 		_EntryFormOptionNameToWidget ();
extern int              clearUnmanagedField ();
extern void		_EntryFormInvisibleField ();
extern char		*_EntryFormSPDumpPos();

#endif
