/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#ifndef _XLIB
#define _XLIB
#include <Xm/List.h>

/*
 * Internal resource types 
 */

#define XmSTRING_TYPE	1 /* XmString */
#define XmBOOL_TYPE	2 /* Boolean  */
#define STRING_TYPE	3 /* char *   */

/*
 * Resource table indexes
 */

#define _XVALUE 	0
#define _XLABEL_STRING	1
#define _XSET		2
#define _XMENU_HISTORY	3

/*
 * Internal Widget Types
 */

#define _XIsUNKNOWN	0
#define _XIsLABEL	1
#define _XIsTEXT	2
#define _XIsOPTION_MENU	3
#define _XIsPUSH_BUTTON	4
#define _XIsLIST	5
#define _XIsTOGGLE	6

/*
 * Dialog buttons
 */

#define _OK_BUTTON	1
#define _CANCEL_BUTTON	2
#define _HELP_BUTTON	4

#define _XmCErrorDialogPost(parent,msg,title) (_XmCDialogPost(parent, msg, title, XmDIALOG_ERROR,\
	XmDIALOG_FULL_APPLICATION_MODAL, _OK_BUTTON))

#define _XmCMessageDialogPost(parent,msg,title) (_XmCDialogPost(parent, msg, title, XmDIALOG_MESSAGE,\
	XmDIALOG_FULL_APPLICATION_MODAL, _OK_BUTTON))

#define XLabelSetString(label,str)	{ \
  XmString Str;				  \
	Str = XmStringCreateLtoR (str, XmSTRING_DEFAULT_CHARSET);   \
	XtVaSetValues (label, XmNlabelString, Str, NULL); \
	XmStringFree (Str); \
}

#define _XmClabelSetString(label,str) XLabelSetString(label,str)
#define _XmClabelGetString(label) XLabelGetString(label)

#define XLabelConcatString(label,str)      { \
  XmString Str;                           \
  XmString Str1;			  \
  XmString newStr;			  \
        Str = XmStringCreateLtoR (str, XmSTRING_DEFAULT_CHARSET);   \
        XtVaGetValues (label, XmNlabelString, &Str1, NULL); \
	newStr = XmStringConcat (Str1, Str); \
        XtVaSetValues (label, XmNlabelString, newStr, NULL); \
        XmStringFree (newStr); \
	XmStringFree (Str); \
}

#define _XmCStringToStr(cs,sp)  (XmStringGetLtoR(cs, XmSTRING_DEFAULT_CHARSET, sp))
	
 
#define _XmCListAddItemUnselected(list_w, str, position) { \
   XmString cs; \
        cs = XmStringCreateSimple(str); \
        XmListAddItemUnselected(list_w, cs, position); \
        XmStringFree (cs); \
}


#define _XmCListAddItem(list_w, str, position) { \
   XmString cs; \
        cs = XmStringCreateSimple(str); \
        XmListAddItem(list_w, cs, position); \
        XmStringFree (cs); \
}


/*
 * Functions
 */

extern char *XLabelGetString();
extern Widget locateShell ();
extern char *_XCgetFromCmd ();
extern Widget _XmCGetSubmenu ();
extern Widget _XmCFindMenuItem ();

#include "build_option.h"
#include "xentry_form.h"

#endif
