/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * X Pixmap object
 */

#include "XpmObj.h"


void XpmInitialize ();
void XpmActivate ();
void XpmRealize ();
void XpmDestroy ();
void XpmSetValues ();
static void update_pixmap ();

static RtResource resources[] = {
   {RtNxpmPixmap, NULL, RtPOINTER_TYPE, sizeof(char *), 
   RtOffset(XpmObj,xpm.pixmap), 0, NULL, 0, NULL},
   {RtNxpmData, NULL, RtPOINTER_TYPE, sizeof(char **), 
   RtOffset(XpmObj,xpm.data), 0, NULL, 0, NULL},
   {RtNxpmMask, NULL, RtPOINTER_TYPE, sizeof(char *), 
   RtOffset(XpmObj,xpm.mask), 0, NULL, 0, NULL},
   {RtNxpmPath, NULL, RtSTRING_TYPE, sizeof(char *), 
   RtOffset(XpmObj,xpm.path), 0, NULL, 0, NULL},
   {RtNxpmDisplay, NULL, RtPOINTER_TYPE, sizeof(char *), 
   RtOffset(XpmObj,xpm.display), 0, NULL, 0, NULL},
   {RtNxpmWidget, NULL, RtPOINTER_TYPE, sizeof(Widget), 
   RtOffset(XpmObj,xpm.widget), 0, NULL, 0, NULL},
   {RtNxpmWhiteBackground, NULL, RtBIT_TYPE, 1,
   RtOffset(XpmObj,xpm.flags), 0, NULL, 0, RtXPM_WHITE_BACKGROUND}
};


XpmClassRec xpmClassRec = {
  {
    (ObjClass) &objClassRec,	/* superclass		*/
    "X Pixmap",			/* class name		*/
    NULL,	
    0,
    resources,			/* resource table	*/
    RtNumber(resources),	/* number of resources  */
    /* object size              */  sizeof(XpmRec),
    XpmInitialize,
    XpmRealize,
    NULL,
    XpmSetValues,
    NULL,
    XpmDestroy,
    NULL,
    "xpm",
    "Rt1.00",
    NULL
  },
  {
  0,
  }
  
};

ObjClass xpmObjClass = (ObjClass) &xpmClassRec; 

/*
 * XpmSetValues: set resource values
 */
 
void XpmSetValues (current, new)
XpmObj current, new;
{
   if (current->xpm.path != new->xpm.path) {
   
      /* Check if the path (not the pointer) hasn't changed */
      if (current->xpm.path && new->xpm.path)
        /* The pixmaps might need to be created */
        /* A pixmap is created only when it is needed */
   	if (new->xpm.pixmap && !strcmp (current->xpm.path, 
   		new->xpm.path)) {
      		RtUpdateString (current->xpm.path, new->xpm.path);
   		return;
   	}
   		   
      RtUpdateString (current->xpm.path, new->xpm.path);
      if (new->core.object_flags & RtOBJ_REALIZED)
	update_pixmap (new);   
   }
}


/*
 * XpmInitialize: initialize object
 */
 
void XpmInitialize (new)
XpmObj new;
{
#ifdef DEBUG
   new->core.object_name = strdup ("Xpm Object");
#endif
}

/*
 * XpmRealize: realize object
 */

void XpmRealize (obj)
XpmObj obj;
{
   /* try to update the pixmap */
   if (obj->core.object_flags & RtOBJ_REALIZED)
      return;
   update_pixmap (obj);
   obj->core.object_flags |= RtOBJ_REALIZED;
}

/*
 * XpmDestroy: destroy object
 */
 
void XpmDestroy (new)
XpmObj new;
{

Display  *disp;

   if (!new->xpm.widget)
      return;
      
   disp = XtDisplay (new->xpm.widget);
   
   /*
    * Destroy pixmaps
    */

   if (new->xpm.pixmap) {
        XFreePixmap(disp, new->xpm.pixmap);
        new->xpm.pixmap = NULL;
   }

   if (new->xpm.mask) {
        XFreePixmap(disp, new->xpm.mask);
        new->xpm.mask = NULL;
   }

   if (new->xpm.old_pixmap) {
        XFreePixmap(disp, new->xpm.old_pixmap);
        new->xpm.old_pixmap = NULL;
   }

   if (new->xpm.old_mask) {
        XFreePixmap(disp, new->xpm.old_mask);
        new->xpm.old_mask = NULL;
   }

   /* check - destroy data */
   
   RtDestroyString (new->xpm.path);     	
}

static unsigned long
COLOR(w, name)
Widget w;
char *name;
{
XrmValue	fromVal, toVal;
unsigned long *pixel;

    fromVal.size = sizeof(char*);
    fromVal.addr = name;

    XtConvert(w, XmRString, &fromVal, XmRPixel, &toVal);
    pixel = (unsigned long*)toVal.addr;
    if( pixel == NULL )
    {
    	fromVal.addr = XtDefaultBackground;
    	XtConvert(w, XmRString, &fromVal, XmRPixel, &toVal);
    	pixel = (unsigned long*)toVal.addr;
    }
    return(*pixel);
}

/*
 * update_pixmap: update the pixmap
 */
 
static void update_pixmap (new)
XpmObj new;
{
Display  *disp;
XpmAttributes *att;
XpmColorSymbol symbols[1];
Pixel bg;

   if (!new->xpm.widget) {
#ifdef DEBUG   
   	fprintf (stderr, 
   	   "update_pixmap: failed, the widget resource must be set\n");
#endif
   	new->core.status = RtINVALID_RESOURCES;
   	return;   
   }
   
   disp = XtDisplay (new->xpm.widget);
   
   if (!disp)
   	return;

   new->core.status = 0;
   att = &new->xpm.attributes;

   XtVaGetValues (new->xpm.widget,
   	XmNdepth, &att->depth,
   	XmNcolormap, &att->colormap,
   	XmNbackground, &bg,
   	NULL);

   symbols[0].name = "None";
   symbols[0].value = NULL;
   if (new->xpm.flags & RtXPM_WHITE_BACKGROUND)
   	symbols[0].pixel = COLOR(new->xpm.widget, "white");
   else
   	symbols[0].pixel = bg;
   
   att->colorsymbols = symbols;
   att->numsymbols = 1;
   
   att->visual = DefaultVisual (disp, DefaultScreen (disp));
   att->valuemask = XpmColorSymbols | XpmDepth | XpmColormap 
   		| XpmVisual;

   /*
    * Destroy old pixmaps
    */

   if (new->xpm.old_pixmap) {
        XFreePixmap(disp, new->xpm.old_pixmap);
        new->xpm.old_pixmap = NULL;
   }

   if (new->xpm.old_mask) {
        XFreePixmap(disp, new->xpm.old_mask);
        new->xpm.old_mask = NULL;
   }
      	
   /* 
    * Save current pixmaps (they might be still in use)
    */
    
   new->xpm.old_pixmap = new->xpm.pixmap;
   new->xpm.old_mask = new->xpm.mask;
   new->xpm.pixmap = NULL;
   new->xpm.mask = NULL;
   
   if (new->xpm.path) {
      
       if (!*new->xpm.path)
	  return; /* This is not considered an error */
	          
       new->core.status = XpmReadFileToPixmap(disp,
            			RootWindow(disp, DefaultScreen(disp)),
                                new->xpm.path,
                                &new->xpm.pixmap,
                                &new->xpm.mask,
                                &new->xpm.attributes);
   } else if (new->xpm.data) {
       new->core.status = XpmCreatePixmapFromData(disp,
            			RootWindow(disp, DefaultScreen(disp)),
                                new->xpm.data,
                                &new->xpm.pixmap,
                                &new->xpm.mask,
                                &new->xpm.attributes);   
   } else {
   	new->core.status = RtINVALID_RESOURCES;
   	return;
   }

   	
   if (new->core.status != XpmSuccess) {
   	new->xpm.pixmap = NULL;
   	new->xpm.mask = NULL;
   	new->core.status = RtXPM_INVALID_PIXMAP;
        RtSetValue (stdmsg, RtNmsgId, 
        		RtERR_ID);
        RtSetValue (stdmsg, RtNmsgContent, 
        		RtXPM_INVALID_PIXMAP);
        RtSetValue (stdmsg, RtNmsgClient, 
        "Invalid file specification or file format.\n X Pixmap format (XPM) required.");
        RtSendMessage (new->core.obj_stderr, stdmsg);
   	
   	return;
   }
   new->core.status = 0;
   	
   
}


