/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#include "PushBWrapper.h"
/*
 * XmPushButton wrapper
 */
 
void XPBWInitialize ();
void XPBWActivate ();
int XPBWRealize ();
void XPBWDestroy ();
void XPBWSetValues ();
void XPBWProcessMessage ();
static void activate_callback ();

static RtResource resources[] = {
   {RtNxpbwMakeInsensitive, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(XmPushButtonWrapperObj,button_wrapper.make_insensitive), 
   0, NULL, 0, NULL}
};


XmPushButtonWrapperClassRec xmPushButtonWrapperClassRec = {
  {
    (ObjClass) &rtWidgetClassRec,
    "Push Button Wrapper",
    NULL,
    0,
    resources,
    RtNumber (resources),
    /* object size              */  sizeof(XmPushButtonWrapperRec),
    XPBWInitialize,
    XPBWRealize,
    NULL,
    XPBWSetValues,
    XPBWActivate,
    XPBWDestroy,
    XPBWProcessMessage,
    "xpbw",
    "Rt1.00",
    NULL
  },
  {
  0,
  }
  
};

ObjClass xmPushButtonWrapperObjClass = (ObjClass) &xmPushButtonWrapperClassRec; 

/*
 * XPBWSetValues: set object values
 */
 
void XPBWSetValues (current, new)
XmPushButtonWrapperObj current, new;
{
   RtUpdateString (current->core.object_name, 
        	new->core.object_name);
}

/*
 * XPBWInitialize: set object values
 */
 
void XPBWInitialize (obj)
XmPushButtonWrapperObj obj;
{
#ifdef DEBUG
   obj->core.object_name = strdup ("XmPushButton wrapper");
#endif
}

/*
 * XPBWActivate: activate object
 */
 
void XPBWActivate (obj)
XmPushButtonWrapperObj obj;
{
}


/*
 * XPBWRealize: realize object
 */
 
int XPBWRealize (obj)
XmPushButtonWrapperObj obj;
{
Widget widget = obj->widget.widget;

   if (widget) {
        XtAddCallback (widget, XmNactivateCallback, 
        	activate_callback, obj);
   } 
}

/*
 * XPBWDestroy: destroy object 
 */
 
void XPBWDestroy (obj)
XmPushButtonWrapperObj obj;
{
   if (!obj->widget.widget) {
	XtDestroyWidget (obj->widget.widget);
	obj->widget.widget = NULL;
   }	
   RtDestroyString (obj->core.object_name);   

#ifdef OLD
   /* destroy the broadcaster portion of the object */
   (*broadCasterObjClass->core_class.destroy) (obj);

   /* free the object itself */
   if (obj->core.object_class == xmPushButtonWrapperObjClass)
      free (obj);   
#endif
}

/*
 * XPBWProcessMessage: process object message 
 */
 
void XPBWProcessMessage (obj, data, client)
XmPushButtonWrapperObj obj;
void *data;
void *client;
{
MessageObj msg;
char *content;
int message_id;

   msg = (MessageObj) data;
   RtGetValue (msg, RtNmsgId, &message_id);   
   RtGetValue (msg, RtNmsgContent, &content);   
      
   switch (message_id) {
      case RtRELEASE_DATA: /* Broadcast data */
        break;
      case RtRESET:
        obj->broadcaster.reset = (int) content;
        break;
      case RtADD_RECEPTOR:
      case RtADD_CONVERSION:
      case RtADD_ID_CONVERSION:
        /* Invoke the superclass method to add a new receptor */
        (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) data, NULL);
        break;
      case RtWIDGET_POPUP:
      case RtWIDGET_POPDOWN:
        /* Invoke the superclass method to add a new receptor */
        (*rtWidgetObjClass->core_class.process_message) (obj, 
                        (char *) data, NULL);
        break;
      default:
#ifdef OLD
        fprintf (stderr, 
        "XPBWProcessMessage: I don't know how to process this message\n");
#endif
        RtSuperclassProcessMessage (xmPushButtonWrapperObjClass,
        	obj, data, client);
	break;
   }
}

/*
 * _XmClabelGetString: get the label on the button
 */
 
static char *_XmClabelGetString (widget)
Widget widget;
{
  XmString Str;
  char *str;

   XtVaGetValues (widget, XmNlabelString, &Str, NULL);    
   if (!XmStringGetLtoR (Str, XmSTRING_DEFAULT_CHARSET, &str)) {
#ifdef DEBUG
	fprintf (stderr, "XLabelGetString: Can't get value, Possibly wrong charset?"); 
#endif
	return (NULL);
   }
   XmStringFree (Str);
   return (str);
}

/*
 * activate_callback: push button activate callback 
 */
 
static void activate_callback (widget, client_data, cbs)
Widget widget;
XtPointer client_data;
XtPointer *cbs;
{
XmPushButtonWrapperObj obj = (XmPushButtonWrapperObj) client_data;
int sensitive_flag = 0;
char *label_string;

   if (!obj)
     return;
     
#ifdef DEBUG   
   fprintf (stderr, "activate_callback\n");
#endif

   /* Make Insensitive */
   if (obj->button_wrapper.make_insensitive)
      if (XtIsSensitive (widget) == True ) {
      	sensitive_flag = 1;
      	XtSetSensitive (widget, False);
      }   
   
   /* The push button has been pressed                              */
   /* Send a message to the receiver object                         */
   /* Because an object is also a message, the object itself is     */
   /* passed							    */
   RtSetValue (obj, RtNmsgId, RtXPBW_PRESSED_BUTTON);
#ifdef OLD
#ifdef DEBUG
   RtSetValue (obj, RtNmsgType, RtMSG_STRING);
#endif
#endif
   
   label_string =  _XmClabelGetString (widget);
   RtSetValue (obj, RtNmsgContent, label_string);
      
   /* Invoke the superclass method to broadcast the message */
   (*broadCasterObjClass->core_class.process_message) (obj, 
                        (char *) obj, NULL);
   free (label_string);
   if (obj->button_wrapper.make_insensitive && sensitive_flag) {
      XtSetSensitive (widget, True);
   }   
}
