#include "X.h"
#include <Xm/DialogS.h>
#include "MessageDialog.h"


void MDInitialize ();
void MDRealize ();
void MDActivate ();
void MDDestroy ();
void MDSetValues ();
void MDCancelButtonCB ();
void MDOkButtonCB ();
void MDHelpButtonCB ();
void MDProcessMessage ();

static RtResource resources[] = {
   {RtNmdConfirmMessage, NULL, RtSTRING_TYPE, sizeof(char *), 
   RtOffset(MessageDialogObj, message_dialog.message), 0, NULL, 0, NULL},
   {RtNmdDialogType, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(MessageDialogObj, message_dialog.dialog_type), 0, NULL, 0, 
   NULL},
   {RtNmdSysError, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(MessageDialogObj, message_dialog.sys_error), 0, NULL, 0, 
   NULL},
   {RtNmdDefaultButtonType, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(MessageDialogObj, message_dialog.default_button), 0, NULL, 
   0, NULL},
   {RtNmdUnmanageCancelButton, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(MessageDialogObj, message_dialog.unmanage_cancel), 0, NULL, 
   0, NULL},
   {RtNmdUnmanageOkButton, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(MessageDialogObj, message_dialog.unmanage_ok), 0, NULL, 
   0, NULL},
   {RtNmdUnmanageHelpButton, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(MessageDialogObj, message_dialog.unmanage_help), 0, NULL, 
   0, NULL},
   {RtNmdPressedButton, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(MessageDialogObj, message_dialog.pressed_button), 0, NULL, 
   0, NULL}
};


MessageDialogClassRec messageDialogClassRec = {
  {
    (ObjClass) &rtWidgetClassRec,/* superclass		*/
    "Message Dialog",		/* class name		*/
    NULL,	
    0,
    resources,			/* resource table	*/
    RtNumber (resources),	/* number of resources  */
    /* object size              */  sizeof(MessageDialogRec),
    MDInitialize,
    MDRealize,
    NULL,
    MDSetValues,
    MDActivate,
    MDDestroy,
    MDProcessMessage,
    "md",
    "Rt1.00",
    NULL
  },
  {
  0,
  }
  
};

ObjClass messageDialogObjClass = (ObjClass) &messageDialogClassRec; 

void MDSetValues (current, new)
MessageDialogObj current, new;
{
#ifdef DEBUG   
   if (current->core.object_name != new->core.object_name)
        RtUpdateString (current->core.object_name, new->core.object_name);
#endif
#ifdef OLD
   if (current->message_dialog.message != new->message_dialog.message) {
   	if (current->message_dialog.message) {
      	   free (current->message_dialog.message);
	}
	if (new->message_dialog.message)
	    new->message_dialog.message =  
		strdup (new->message_dialog.message);  
   }
#endif
   RtUpdateString (current->message_dialog.message,
   	new->message_dialog.message);
}

static _XCeventLoop (widget, wait_in_loop)
Widget widget;
int *wait_in_loop;
{
   XtAppContext app_con;
   XEvent event;
   
   if (!widget)
   	return;
   	
   app_con = XtWidgetToApplicationContext (widget);
   while (*wait_in_loop) {
	XtAppNextEvent (app_con, &event);
	XtDispatchEvent (&event);
   }

}



void MDInitialize (obj)
MessageDialogObj obj;
{
   obj->message_dialog.dialog_type = XmDIALOG_MESSAGE;
   obj->message_dialog.default_button = XmDIALOG_CANCEL_BUTTON;
   obj->message_dialog.pressed_button = RtCANCEL_BUTTON;
#ifdef DEBUG
   obj->core.object_name = strdup ("Dhotlist");
#endif
}

void MDRealize (new)
Obj new;
{
}


void MDActivate (new)
Obj new;
{
  MessageDialogObj obj = (MessageDialogObj) new;   
  XmString text = NULL;
  Widget dialog;
  Widget shell;
  char *message;
  int aux;
  Boolean override_redirect;
  extern char *_vstrconcat (), _syserror ();
  
  if (obj->widget.widget) {
     XtDestroyWidget (obj->widget.widget);
     obj->widget.widget = NULL;
  }   
  
  /* locate the shell associated to this object */
  shell = locateShell (obj->widget.parent); 

  if (!obj->widget.parent)
     return;

  dialog = (Widget) XmCreateMessageDialog(obj->widget.parent, 
  	"dialog", NULL, 0);
  obj->widget.widget = dialog;

  if (obj->widget.widget)
     XtSetSensitive (obj->widget.widget, True);
     
  /* save errno */
  aux = errno;

  /* restore sys_error - just in case */
  if (obj->message_dialog.sys_error)
     errno = obj->message_dialog.sys_error;  
     
  if (obj->message_dialog.message) {
     if (obj->message_dialog.sys_error) {
  	message = _vstrconcat (obj->message_dialog.message, 
  		": ", _syserror (), NULL);
	free (obj->message_dialog.message);
	obj->message_dialog.message = message;
     }
  } else {
     obj->message_dialog.message = _syserror ();
  }
 
  /* restore errno */
  errno = aux;
   
  text = XmStringCreateLtoR (obj->message_dialog.message, XmSTRING_DEFAULT_CHARSET);
  XtVaSetValues (obj->widget.widget, XmNdialogType, 
  		obj->message_dialog.dialog_type,
  		XmNdefaultButtonType,
	        obj->message_dialog.default_button,
		XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
		XmNmessageString, text,
		NULL);

  if (obj->message_dialog.unmanage_help)
     XtUnmanageChild (XmMessageBoxGetChild (obj->widget.widget, 
   	   	XmDIALOG_HELP_BUTTON));
  
  if (obj->message_dialog.unmanage_cancel)
     XtUnmanageChild (XmMessageBoxGetChild (obj->widget.widget, 
   	   	XmDIALOG_CANCEL_BUTTON));
  
  if (obj->message_dialog.unmanage_ok)
     XtUnmanageChild (XmMessageBoxGetChild (obj->widget.widget, 
   	   	XmDIALOG_OK_BUTTON));
  

  if (obj->widget.title)
     XtVaSetValues (XtParent(dialog), XtNtitle, obj->widget.title, NULL);
  
  XtAddCallback (dialog, XmNokCallback, MDOkButtonCB, obj);
  XtAddCallback (dialog, XmNcancelCallback, MDCancelButtonCB, obj);
  XtAddCallback (dialog, XmNhelpCallback, MDHelpButtonCB, obj);
  
  if (text)  
  	XmStringFree (text);

  /* Map the shell window */
  if (shell)
     XMapWindow (XtDisplay (shell), XtWindow (shell));
            
  XtManageChild(dialog);
  XtPopup (XtParent(dialog), XtGrabNone);
  XSync (XtDisplay(dialog), False);

#ifdef OLD  
  XtVaGetValues (shell, XmNoverrideRedirect, 
  	&override_redirect, NULL);

  if (override_redirect)	    
	_XCKeepRaised (XtParent(dialog));
#endif
    
  _XmCSetDeleteWindowCB (XtParent(dialog), MDCancelButtonCB, obj);
  
  (*rtWidgetObjClass->core_class.realize) (obj);
  if (obj->widget.synchronous) {
    obj->widget.stay_in_loop = 1;
    _XCeventLoop (obj->widget.widget, &obj->widget.stay_in_loop);
  }
}

void MDOkButtonCB (widget, client_data, cbs)
Widget widget;
XtPointer client_data;
XtPointer *cbs;
{
  MessageDialogObj obj = (MessageDialogObj) client_data;
  
   obj->widget.stay_in_loop = 0; /* stop condition - a button has been*/
   				 /* pressed			      */
   obj->message_dialog.pressed_button = RtOK_BUTTON;

}

void MDCancelButtonCB (widget, client_data, cbs)
Widget widget;
XtPointer client_data;
XtPointer *cbs;
{
  MessageDialogObj obj = (MessageDialogObj) client_data;
  
   obj->widget.stay_in_loop = 0; /* stop condition */
   obj->message_dialog.pressed_button = RtCANCEL_BUTTON;

}

void MDHelpButtonCB (widget, client_data, cbs)
Widget widget;
XtPointer client_data;
XtPointer *cbs;
{
  MessageDialogObj obj = (MessageDialogObj) client_data;
  
  obj->widget.stay_in_loop = 0; /* stop condition */
  obj->message_dialog.pressed_button = RtHELP_BUTTON;

}

void MDDestroy (obj)
MessageDialogObj obj;
{
   Widget w = obj->widget.widget;
   
   if (!w)
     return;
   
   while (w && !XtIsWMShell(w)) 
      w = XtParent(w);

   XtPopdown (w);
   XtDestroyWidget(w);
   free (obj);
    
}

void MDProcessMessage (obj, data, client)
MessageDialogObj obj;
void *data;
void *client;
{
MessageObj msg;
char *content;
int message_id;

   msg = (MessageObj) data;
   RtGetValue (msg, RtNmsgId, &message_id);   
   RtGetValue (msg, RtNmsgContent, &content);   
      
   switch (message_id) {
      case RtMESSAGE: 
	RtSetValue (obj, RtNmdConfirmMessage, content);
	MDActivate (obj);
	break;
      default:    
        fprintf (stderr,
           "MDProcessMessage: unknown message ID, I don't know how to process this message\n");
   }
}
