/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * Menu Object - Object used to handle Motif menus
 */

#include "Menu.h"

void MENInitialize ();
void MENActivate ();
void MENDestroy ();
void MENSetValues ();
void MENCancelButtonCB ();
void MENOkButtonCB ();
void MENHelpButtonCB ();
void MENProcessMessage ();
void MENRealize ();

static RtResource resources[] = {
   {RtNmenuReceiver, NULL, RtOBJ_TYPE, sizeof(Obj), 
   RtOffset(MenuObj, menu.receiver), 0, NULL, 0, NULL},
   {RtNmenuOneInstance, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(MenuObj, menu.one_instance), 0, NULL, 0, NULL},   
   {RtNmenuTitle, NULL, RtSTRING_TYPE, sizeof(char *), 
   RtOffset(MenuObj, menu.title), 0, NULL, 0, NULL},
};


MenuClassRec menuClassRec = {
  {
    (ObjClass) &rtWidgetClassRec,/* superclass		*/
    "Menu",			/* class name		*/
    NULL,	
    0,
    resources,			/* resource table	*/
    RtNumber (resources),	/* number of resources  */
    /* object size              */  sizeof(MenuRec),
    MENInitialize,
    MENRealize,
    NULL,
    MENSetValues,
    MENActivate,
    MENDestroy,
    MENProcessMessage,
    "menu",
    "Rt1.00",
    NULL
  },
  {
  0,
  }
  
};

ObjClass menuObjClass = (ObjClass) &menuClassRec; 

/*
 * MENSetValues: set object resources
 */
 
void MENSetValues (current, new)
MenuObj current, new;
{
   /* Check - The superclass should do this */
   if (current->core.object_name != new->core.object_name)
   	RtUpdateString (current->core.object_name, 
   			new->core.object_name);
   RtUpdateString (current->menu.title, 
   			new->menu.title);
   RtUpdateString (current->core.object_name, 
   			new->core.object_name);
}

/*
 * MENInitialize: initialize the object
 */

void MENInitialize (obj)
MenuObj obj;
{
   /* Initialize menu type (pulldown menus) */
   obj->menu.menu_type = XmMENU_PULLDOWN;
#ifdef DEBUG
   obj->core.object_name = strdup ("Menu");
#endif

}

/*
 * MENRealize: realize the object
 */
 
void MENRealize (obj)
MenuObj obj;
{
        
Widget parent;

   parent = obj->widget.parent;
   
   if (!parent)
   	return;

   if (obj->core.object_flags & RtOBJ_REALIZED)
   	return;
   		
   /* for now - Perhaps a different object per each type  */
   /* of menu will be needed. The children of this object */
   /* need to use the widget pointer			  */
   
   if (obj->menu.menu_type == XmMENU_PULLDOWN || 
    	obj->menu.menu_type == XmMENU_OPTION) {
    	Widget dummy = XtCreatePopupShell("dummy1", 
    				       transientShellWidgetClass,
                                      (Widget) parent, NULL, 0);
        /* Create a Menu object 		*/
        obj->widget.widget = (Widget) XmCreatePulldownMenu(
        		dummy, "_pulldown", 
        		NULL, 0);
        /* Make the cascade button insensitive 	*/
        XtSetSensitive (parent, False);
        
        /* Update the XmNsubMenuId resource in the parent */
   	XtVaSetValues (parent, XmNsubMenuId, obj->widget.widget);
   } 

   obj->core.object_flags |= RtOBJ_REALIZED;
   
}

/*
 * MENActivate: activate the object
 */
 
void MENActivate (new)
Obj new;
{
  
}

/*
 * destroy_object_list: destroy the list of objects. One object
 *			is defined per each menu entry
 */
 
static void destroy_object_list (obj)
MenuObj obj;
{
Obj *sobj;
register int i = 0;

   if (!obj->menu.object_list)
	return;

   sobj = obj->menu.object_list;
   
   while (*sobj) {
	RtDestroyObject (*sobj);
	*sobj++ = NULL;    
   }
   	
   free (obj->menu.object_list);
   obj->menu.object_list = NULL;
   
   obj->menu.max_cnt = obj->menu.index = 0;
}

/*
 * _XmClabelGetString: return the string associated with the
 *		       label widget
 */
 
static char *_XmClabelGetString (widget)
Widget widget;
{
  XmString Str;
  char *str;

   XtVaGetValues (widget, XmNlabelString, &Str, NULL);    
   if (!XmStringGetLtoR (Str, XmSTRING_DEFAULT_CHARSET, &str)) {
#ifdef DEBUG
	fprintf (stderr, "XLabelGetString: Can't get value, Possibly wrong charset?"); 
#endif
	return (NULL);
   }
   XmStringFree (Str);
   return (str);
}

/*
 * find_menu_item: Search for a menu item
 */
 
Obj *find_menu_item (obj, content)
MenuObj obj;
char *content;
{
Widget widget;
char *str;
register int i = 0;
register Obj *op;
extern char *_XmClabelGetString ();
   
   if (!obj->menu.object_list)
   	return (NULL);

   op = obj->menu.object_list;	
   
   while (i++ < obj->menu.max_cnt) {
	if (*op == NULL) {
	   op++;
	   continue;
	}
	RtGetValue (*op, RtNwidget, &widget);

	if (widget) {
	   str = _XmClabelGetString (widget);   
	   if (str && !strcmp (str, content)) {
	   	XtFree (str);
	   	return (op);
	   }
	   XtFree (str);	   	
	}
	op++;	   
   }
   return (NULL);

}


/*
 * MENDeleteItem: delete menu item
 */
 
static void MENDeleteItem (obj, content)
MenuObj obj;
char *content;
{
Widget widget;
extern Widget _XmCFindMenuItem ();
Obj *obj_slot;
Obj button_obj;

   if (!obj || !content ||
   	!obj->widget.widget)
   	return;

   /* find button object */
   obj_slot = find_menu_item (obj, content);
   
   if (!obj_slot)
       	return;
    
   button_obj = *obj_slot;
      	 
   /* get button widget */		
   RtGetValue (button_obj, RtNwidget, &widget);
   
   
   if (widget) {
	XtUnmanageChild (widget);
   }
   
   RtDestroyObject (button_obj);
   *obj_slot = NULL;
   
   obj->menu.cnt--;
   
   /* Make the parent insensitive if the menu is empty */
   if (!obj->menu.cnt && obj->widget.parent)
        XtSetSensitive (obj->widget.parent, False);   
   
}

/*
 * free_slot: traverse the item list a return the next free slot
 */
 
Obj *free_slot (obj)
MenuObj obj;
{
  register Obj *op;
  register int i = 0;

   if (!obj->menu.object_list)
   	return (NULL);
   
   op = obj->menu.object_list;	
   
   while (i++ < obj->menu.max_cnt) {
	if (*op == NULL)
	   return (op);
	op++;	   
   }
   return (NULL);
}

/*
 * MENAddItem: add a new item to the menu
 */
 
static void MENAddItem (obj, content)
MenuObj obj;
char *content;
{
Widget button;
Obj button_obj;
int id;
Obj *tmp;
int first_time = 0;

   if (!obj || !content)
      return;
   
   if (!obj->widget.widget)
      return;

   if (obj->menu.one_instance) { 

        /* Check if the item already exists */
   	if (find_menu_item (obj, content))
   	   return;
   }
   		
   /*
    * Manipulate the list of objects
    */
    	
   if (!obj->menu.object_list) {
        first_time = 1;
        obj->menu.object_list = (Obj *) malloc (sizeof (Obj) * 
        		ML_CHUNK_SIZE);
        memset ((char *) obj->menu.object_list, '\0',
        	sizeof (Obj) * ML_CHUNK_SIZE);
        	 
        if (!obj->menu.object_list)
           return;
        obj->menu.max_cnt = ML_CHUNK_SIZE;
   } else if (obj->menu.cnt >= obj->menu.max_cnt) {
        tmp = realloc (obj->menu.object_list, sizeof (Obj) 
                        * (obj->menu.max_cnt + ML_CHUNK_SIZE));
        if (tmp) {
	   obj->menu.object_list = tmp;
	   
           memset ((char *) (tmp + obj->menu.max_cnt), '\0',
        	sizeof (Obj) * ML_CHUNK_SIZE);
	   
	   obj->menu.max_cnt += ML_CHUNK_SIZE;                    
        }
                           
   }
   
   if (obj->menu.cnt >= obj->menu.max_cnt)
        return;


   /*
    * Menu title and a separator
    */
    
   if (first_time && obj->menu.title) {
 
   	/* Make the cascade button sensitive when the first */
   	/* menu item is added				    */
   	

	XtCreateManagedWidget (obj->menu.title, 
		xmLabelWidgetClass, obj->widget.widget, NULL, 0);   
   
	XtCreateManagedWidget ("separator", 
		xmSeparatorWidgetClass, obj->widget.widget, NULL, 0);   
   }

   if (obj->widget.parent)
        XtSetSensitive (obj->widget.parent, True);

   
   /*
    * Create a push button
    */
      	
   button = XtVaCreateManagedWidget (content, xmPushButtonWidgetClass,
   	obj->widget.widget, NULL);

   /* Create a new object */
   button_obj = RtCreateObject (NULL, xmPushButtonWrapperObjClass);
   RtSetValue (button_obj, RtNwidget, button);
   
   /* This is the message ID that should be broadcasted to */
   /* the receiver object when a button is pressed 	   */
   RtGetValue (obj, RtNbcNewId, &id);
   
   /* Plug object into the receiver object 		*/
   /* A message to the receiver object is sent when 	*/
   /* the button is pushed				*/
   
   RtPlugObjectInto (obj->menu.receiver, button_obj, 0); 
   
   
   if (id)    	      
   	RtSetValue (button_obj, RtNbcNewId, id);
   	
   RtRealizeObject (button_obj);	
   
   tmp = free_slot (obj);
   
   if (!tmp)
   	return;
   	
   /* Add the object to the object list */
   *tmp = (Obj) button_obj;

   obj->menu.cnt++;
}

MENAddObject (obj, obj1)
Obj obj, obj1;
{
 /* Not used */      
}

/*
 * MENProcessMessage: process object messages
 */
 
void MENProcessMessage (obj, data)
MenuObj obj;
void *data;
{
MessageObj msg;
char 	   *content;
Obj	   sobj;
int 	   message_id;


   msg = (MessageObj) data;
   RtGetValue (msg, RtNmsgId, &message_id);   
   RtGetValue (msg, RtNmsgContent, &content);   

   switch (message_id) {
      case RtMEN_ADD_ITEM:	/* add a new menu item */	
        MENAddItem (obj, content);
        break;
      case RtMEN_ADD_OBJECT: 	/* add a subobject */
        MENAddObject (obj, (Obj) content);
        break;      
      case RtMEN_DELETE_ITEM: 	/* delete an item */
        MENDeleteItem (obj, content);
        break;      
      default:
#ifdef DEBUG
   	fprintf (stderr, 
   	"MENProcessMessag: I don't know how to process this message\n");
#endif
        break;
   }

   		   
}

/*
 * MENDestroy: destroy object
 */
 
void MENDestroy (obj)
MenuObj obj;
{
   /* destroy the menu widget */
   if (obj->widget.widget) {
	XtDestroyWidget (obj->widget.widget);
	obj->widget.widget = NULL;
   }
   
   /* destroy the object list */	
   destroy_object_list (obj);

   /* free the space allocated for other strings */
   
   if (obj->core.object_name) {
	free (obj->core.object_name);
	obj->core.object_name = NULL;
   }
   	   
   if (obj->menu.title) {
	free (obj->menu.title);
	obj->menu.title = NULL;
   }
   
   /* free broadcaster part */
   /* destroy the broadcaster portion of the object */
   (*broadCasterObjClass->core_class.destroy) (obj);
   
   /* free the object itself */
   if (obj->core.object_class == menuObjClass)
   	free (obj);

}
