/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * Main object: main object used to store all the Rt internal
 * structures. All the other objects are created by the main object. 
 */
 
void MainInitialize ();
void MainActivate ();
void MainRealize ();
void MainDestroy ();
void MainSetValues ();
void MainProcessMessage ();

MainClassRec dragDropClassRec = {
  {
    NULL,			/* superclass		*/
    "Main",			/* class name		*/
    NULL,	
    0,
    NULL,			/* resource table	*/
    0,				/* number of resources  */
    /* object size              */  sizeof(MainRec),
    MainInitialize,
    MainRealize,
    MainSetValues,
    MainActivate,
    MainDestroy,
    MainProcessMessage,
  },
  {
  0,
  }
  
};

ObjClass dragDropObjClass = (ObjClass) &dragDropClassRec; 

/*
 * MainSetValues: set object resources
 */
 
void MainSetValues (current, new)
MainObj current, new;
{
   /* Check - This should be done by the superclass */
   
   if (current->core.object_name != new->core.object_name)
        RtUpdateString (current->core.object_name, 
        	new->core.object_name);
}


/*
 * MainInitialize: initialize object
 */

void MainInitialize (obj)
MainObj obj;
{
   obj->core.object_name = strdup ("Main");
}

/*
 * MainActivate: activate object
 */
 
void MainActivate (obj)
MainObj obj;
{
}


/*
 * MainRealize: realize object
 */
 
void MainRealize (obj)
MainObj obj;
{
}


/*
 * MainDestroy: destroy object
 */
 
void MainDestroy (obj)
MainObj obj;
{
   /* free the object itself */
}

void MainProcessMessage (obj, message_id, data, client)
MainObj obj;
int message_id;
void *data;
char *client;
{
MessageObj msg;
char *content;
int flags;

   if (message_id != RtMESSAGE) {
	return;	
   }
   
   msg = (MessageObj) data;
   RtGetValue (msg, RtNmsgId, &message_id);   
   RtGetValue (msg, RtNmsgContent, &content);   
   RtGetValue (msg, RtNmsgFlags, &flags);   
   
   /* ignore the function paramenter  		*/
   /* get the client info from the message 	*/
   RtGetValue (msg, RtNmsgClient, &client); 

   switch (message_id) {
      case RtINITIALIZE_CLASS:
         if (!content)
         	return;
         initialize_class (content);
      default:
#ifdef DEBUG
   	fprintf (stderr, 
   	"MainProcessMessage: I don't know how to process this message\n");
#endif
        break;
   }
}

/*
 * cmp_res_name: compare resource names
 */
cmp_res_name (item, item1)
char *item, *item1;
{
   RtResource *res, *res1;
   
   if (!res && !res1)
   	return (0);
   
   if (!res)
   	return (-1);
   	
   if (!res1) 
   	return (1);
   	
   return (strcmp (res->name, res1->name));
}

 
/*
 * initialize_class: Initialize class 
 */
 
static void initialize_class (class)
ObjClass class;
{

   if (class->core_class.class_inited)   
	return;

   if (!class->core_class.resources)
   	return;

   /* sort the resource table for fast access */
   
   qsort (class->core_class.resources,
   	class->core_class.num_resources,
   	sizeof (RtResource)),
   	cmp_res_name);

   class->core_class.class_inited++;   
}
