/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * XmLabel wrapper object
 */
 
#include "LabelWrapper.h"

void LABELWInitialize ();
void LABELWActivate ();
int LABELWRealize ();
void LABELWDestroy ();
void LABELWSetValues ();
void LABELWProcessMessage ();
static void update_widget ();

static RtResource resources[] = {
   {RtNlabelIconPath, NULL, RtSTRING_TYPE, sizeof(char *), 
   RtOffset(XmLabelWrapperObj,label_wrapper.icon_path), 0, NULL, 
   0, NULL}
};

XmLabelWrapperClassRec xmLabelWrapperClassRec = {
  {
    (ObjClass) &rtWidgetClassRec,/* superclass		*/
    "Label",			/* class name		*/
    NULL,	
    0,
    resources,			/* resource table	*/
    RtNumber (resources),	/* number of resources  */
    /* object size              */  sizeof(XmLabelWrapperRec),
    LABELWInitialize,
    LABELWRealize,
    NULL,
    LABELWSetValues,
    LABELWActivate,
    LABELWDestroy,
    LABELWProcessMessage,
    "label",
    "Rt1.00",
    NULL
  },
  {
  0,
  }
  
};

ObjClass xmLabelWrapperObjClass = (ObjClass) &xmLabelWrapperClassRec; 



/*
 * LABELWSetValues: set object resources
 */
 
void LABELWSetValues (current, new)
XmLabelWrapperObj current, new;
{
   Pixmap i_pixmap = NULL;
   Boolean bool = True;
   XmString Str;
   
   RtUpdateString (current->core.object_name, new->core.object_name);

   if (current->core.obj_stderr != new->core.obj_stderr) {
   	/* Make sure that the parent and the child share */
   	/* the same obj_stderr				 */
   	RtSetValue (new->label_wrapper.xpm, RtNobjStderr,
   		new->core.obj_stderr);
   }
   
   if (new->label_wrapper.icon_path
   	!= current->label_wrapper.icon_path) {

/*
	if (new->label_wrapper.icon_path && 
		!strcmp (new->label_wrapper.icon_path, ""))
*/
		
	RtUpdateString (current->label_wrapper.icon_path,
		new->label_wrapper.icon_path);
		
	if (!(new->core.object_flags & RtOBJ_REALIZED))
		return;

#ifdef OLD
   	if (!new->label_wrapper.icon_path ||
   		!new->widget.widget)
   		return;
   		
	if (!new->label_wrapper.xpm) {	
	    new->label_wrapper.xpm = 
	    	(XpmObj) RtCreateObject (NULL, xpmObjClass);	    	
	  
       	    RtSetValue (new->label_wrapper.xpm, RtNxpmWidget,
       	    	new->widget.widget);
       	    RtRealizeObject (new->label_wrapper.xpm);
       	    Str = XmStringCreateSimple ("");
       	    XtVaSetValues (new->widget.widget,
      	        XmNrecomputeSize, False, /* check */
      	    	XmNlabelType, XmSTRING,
      	    	XmNlabelString, Str,
		NULL);
       	}
#endif
       	
       	RtSetValue (new->label_wrapper.xpm, RtNxpmPath,
       	    	new->label_wrapper.icon_path);
       	update_widget (new);    	
   }
}

/*
 * LABELWInitialize: initialize object
 */
 
void LABELWInitialize (obj)
XmLabelWrapperObj obj;
{
#ifdef DEBUG
   obj->core.object_name = strdup ("TextWrapper");
#endif
}

/*
 * LABELWActivate: activate object
 */
 
void LABELWActivate (obj)
XmLabelWrapperObj obj;
{
}


/*
 * LABELWRealize: realize object
 */
 

int LABELWRealize (obj)
XmLabelWrapperObj obj;
{

   if (obj->core.object_flags & RtOBJ_REALIZED)
      return;

   if (!obj->label_wrapper.xpm)
 	obj->label_wrapper.xpm = 
	    	(XpmObj) RtCreateObject (NULL, xpmObjClass);	    	

	  
   RtSetValue (obj->label_wrapper.xpm, RtNxpmWidget,
       	    	obj->widget.widget);
   RtRealizeObject (obj->label_wrapper.xpm);

#ifdef OLD   
   Str = XmStringCreateSimple ("");
   XtVaSetValues (new->widget.widget,
      	        XmNrecomputeSize, False, /* check */
      	    	XmNlabelType, XmSTRING,
      	    	XmNlabelString, Str,
		NULL);
#endif
   
   obj->core.object_flags |= RtOBJ_REALIZED;
}

/*
 * LABELWDestroy: destroy object
 */

void LABELWDestroy (obj)
XmLabelWrapperObj obj;
{
}

/*
 * LABELWProcessMessage: process object messages
 */
 
void LABELWProcessMessage (obj, data, client)
XmLabelWrapperObj obj;
void *data;
void *client;
{
MessageObj msg;
char *content;
int message_id;

   msg = (MessageObj) data;
   RtGetValue (msg, RtNmsgId, &message_id);   
      
   switch (message_id) {
      default:
#ifdef DEBUG      
        fprintf (stderr, 
        "LABELWProcessMessage: I don't know how to process this message\n");
#endif
        RtSuperclassProcessMessage (xmLabelWrapperClassRec,
        	obj, data, client);
	break;
   }
}

static void update_widget (obj)
XmLabelWrapperObj obj;
{
   Pixmap i_pixmap = NULL;
   Boolean bool = True;

   if (!obj->widget.widget ||
   	!obj->label_wrapper.xpm)
     	return;
   	
   RtGetValue (obj->label_wrapper.xpm, RtNxpmPixmap, 
       			&i_pixmap);
       	
   if (!i_pixmap) {
	i_pixmap = XmUNSPECIFIED_PIXMAP;
       	bool = False;
   }  
       	
   XtVaSetValues (obj->widget.widget,
      	 XmNrecomputeSize, bool, /* check */
      	 XmNlabelType, XmPIXMAP,
      	 XmNlabelPixmap,  
	i_pixmap, NULL); 
}
