/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * Error object: object used to display error and warning messages
 */

#include "Error.h"
 
void ERRInitialize ();
void ERRActivate ();
void ERRRealize ();
void ERRDestroy ();
void ERRSetValues ();
void ERRProcessMessage ();
static void register_id ();
static ErrorCode search_id ();

static RtResource resources[] = {
   {RtNerrDialog, NULL, RtOBJ_TYPE, sizeof(Obj), 
   RtOffset(ErrorObj, error.dialog), 0, NULL, 0, NULL },   
};

ErrorClassRec errorClassRec = {
  {
    (ObjClass) &messageClassRec,/* superclass		*/
    "Error",			/* class name		*/
    NULL,	
    0,
    resources,			/* resource table	*/
    RtNumber (resources),	/* number of resources  */
    /* object size              */  sizeof(ErrorRec),
    ERRInitialize,
    ERRRealize,
    NULL,
    ERRSetValues,
    ERRActivate,
    ERRDestroy,
    ERRProcessMessage,
    "err",
    "Rt1.00",
    NULL
  },
  {
  0,
  }
  
};

ObjClass errorObjClass = (ObjClass) &errorClassRec; 

/*
 * ERRSetValues: set object resources
 */
 
void ERRSetValues (current, new)
ErrorObj current, new;
{
   /* Check - This should be done by the superclass */
   
   if (current->core.object_name != new->core.object_name)
        RtUpdateString (current->core.object_name, 
        	new->core.object_name);
}


/*
 * ERRInitialize: initialize object
 */

void ERRInitialize (obj)
ErrorObj obj;
{
#ifdef DEBUG
   obj->core.object_name = strdup ("Error Object");
#endif
   obj->error.dialog = RtCreateObject (NULL, messageDialogObjClass);
}

/*
 * ERRActivate: activate object
 */
 
void ERRActivate (obj)
ErrorObj obj;
{
}


/*
 * ERRRealize: realize object
 */
 
void ERRRealize (obj)
ErrorObj obj;
{
   if (!obj->error.dialog)
   	return;
   if (obj->core.object_flags & RtOBJ_REALIZED)
        return;
        
   RtSetValue (obj->error.dialog, RtNmdDialogType, 
   	XmDIALOG_ERROR);
   RtSetValue (obj->error.dialog, RtNmdDefaultButtonType, 
   	XmDIALOG_OK_BUTTON);
   RtSetValue (obj->error.dialog, RtNwidgetTitle, "Warning");
   RtSetValue (obj->error.dialog, RtNwidgetSynchronous, 1);
   RtSetValue(obj->error.dialog, RtNmdUnmanageCancelButton, 1);
   RtSetValue(obj->error.dialog, RtNmdUnmanageOkButton, 0);
   RtSetValue(obj->error.dialog, RtNmdUnmanageHelpButton, 1);
   obj->core.object_flags |= RtOBJ_REALIZED;	
}


/*
 * ERRDestroy: destroy object
 */
 
void ERRDestroy (obj)
ErrorObj obj;
{
}

void ERRProcessMessage (obj, data, client)
ErrorObj obj;
void *data;
char *client;
{
MessageObj msg;
char *content;
int flags;
int message_id;
ErrorCode code;
static char format[] = "Rt error code:%d";
static char error_msg[20];

   msg = (MessageObj) data;
   RtGetValue (msg, RtNmsgId, &message_id);   
   RtGetValue (msg, RtNmsgContent, &content);   
   RtGetValue (msg, RtNmsgFlags, &flags);   
   
   /* ignore the function paramenter  		*/
   /* get the client info from the message 	*/
   RtGetValue (msg, RtNmsgClient, &client); 

   switch (message_id) {
      case RtERR_ID:
        code = search_id (obj, (int) content);
        
        if (code && code->err_msg) {
   	   RtSetValue(obj->error.dialog, RtNmdConfirmMessage, 
   	   	code->err_msg);
        } else if (client) {
   	   RtSetValue(obj->error.dialog, RtNmdConfirmMessage, 
   	   	client);        
        } else {
	   sprintf (error_msg,
	    	format,
	   	(int) content);	              
   	   RtSetValue(obj->error.dialog, RtNmdConfirmMessage, 
   	   	error_msg);
	}
    	ERRRealize (obj);
   	RtActivateObject (obj->error.dialog);
        break;
      case RtERR_REGISTER_ID:
        register_id (obj, (int) content, (char *) client);
        break;
      default:
#ifdef DEBUG
   	fprintf (stderr, 
   	"ERRProcessMessage: I don't know how to process this message\n");
#endif
	/* Invoke the superclass to process the message */
	RtSuperclassProcessMessage (errorObjClass,
		obj, data, client); 
        break;
   }
}

/*
 * register_code: register error id
 */
 
static ErrorCode search_id (obj, code_id)
ErrorObj obj;
int code_id;
{
register ErrorCode ecode;
register int index = 0;

   if (!obj->error.code_list)
	return (NULL);

   ecode = obj->error.code_list;
   
   while (index <  obj->error.cnt) {
	if (ecode->err_code == code_id)
	   return (ecode);
	index++;
	ecode++;   
   }
   return (NULL);    	
}


/*
 * register_code: register error id
 */
 
static void register_id (obj, code_id, msg)
ErrorObj obj;
int code_id;
char *msg;
{
ErrorCode tmp;
   
   if (!code_id || !msg)
   	return;
   			
   /*
    * Manipulate the code list
    */
    	
   if (!obj->error.code_list) {
        obj->error.code_list = (Obj *) malloc (sizeof (Obj) * 
        		RtERR_CHUNK_SIZE);
        memset ((char *) obj->error.code_list, '\0',
        	sizeof (Obj) * RtERR_CHUNK_SIZE);
        	 
        if (!obj->error.code_list)
           return;
        obj->error.max_cnt = RtERR_CHUNK_SIZE;
   } else if (obj->error.cnt >= obj->error.max_cnt) {
        tmp = realloc (obj->error.code_list, sizeof (Obj) 
                        * (obj->error.max_cnt + RtERR_CHUNK_SIZE));
        if (tmp) {
	   obj->error.code_list = tmp;
	   
           memset ((char *) (tmp + obj->error.max_cnt), '\0',
        	sizeof (Obj) * RtERR_CHUNK_SIZE);
	   
	   obj->error.max_cnt += RtERR_CHUNK_SIZE;                    
        }
                           
   }
   
   if (obj->error.cnt >= obj->error.max_cnt)
        return;

   tmp = obj->error.code_list + obj->error.cnt;
   tmp->err_code = code_id;
   tmp->err_msg = (msg ? strdup (msg): NULL); 
   obj->error.cnt++;
}
