/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#include "DragDrop.h"

#if defined(SYSV) || defined(SVR4)
#include <string.h>
#else
#include <strings.h>
#endif


void DDInitialize ();
void DDActivate ();
int  DDRealize ();
void DDDestroy ();
void DDSetValues ();
void DDProcessMessage ();
void DropEventHandler ();
extern char *_dircat ();
extern char *_Cargvtocmd ();

static RtResource resources[] = {
   {RtNddDropSite, NULL, RtPOINTER_TYPE, sizeof(Widget), 
   RtOffset(DragDropObj,dd.drop_site), 0, NULL, 0, NULL }, 
   {RtNddData, NULL, RtSTRING_TYPE, sizeof(char *), 
   RtOffset(DragDropObj,dd.data), 0, NULL, 0, NULL }, 
};

DragDropClassRec dragDropClassRec = {
  {
    (ObjClass) &objClassRec,	/* superclass		*/
    "Drag and Drop",		/* class name		*/
    NULL,	
    0,
    resources,			/* resource table	*/
    RtNumber(resources),	/* number of resources  */
    /* object size              */  sizeof(DragDropRec),
    DDInitialize,
    DDRealize,
    NULL,
    DDSetValues,
    NULL,
    DDDestroy,
    DDProcessMessage,
    "dd",
    "Rt1.00",
    NULL
  },
  {
  0,
  }
  
};

ObjClass dragDropObjClass = (ObjClass) &dragDropClassRec; 

void DDSetValues (current, new)
DragDropObj current, new;
{
}


void DDInitialize (new)
DragDropObj new;
{
}


int DDRealize (new)
DragDropObj new;
{
   if (!new->dd.drop_site) {
   	fprintf (stderr, "DDRealize: set drop site widget");
   	return (-1);
   }
   rddRegDropSiteClient ((Widget) new->dd.drop_site, DropEventHandler, new);
   return (0);
}


void DDDestroy (obj)
DragDropObj obj;
{
}

void DDProcessMessage (obj)
DragDropObj obj;
{
}

static int data_length (data)
char *data;
{
    char *dp = data;
    char *aux;
    register int cnt = 0;

	dp++;			 /* skip operation code */
	dp = index (data, '\n'); /* machine name        */

	if (!dp)
	  return (-1);
	
        dp++;
	dp = index (dp, '\n');	/* source directory     */

	if (!dp)
	  return (-1);

	dp++;
	if (!*dp)
	  return (0);

	do {
	   dp = index (dp, ' ');

	   if (dp) {
		cnt++;
		dp++;
	   }

	} while (dp);

	cnt++;	/* last one */
	return (cnt);

}

/*
 * DropEventHandler: drop event handler
 */

static void
DropEventHandler(w, client_data, ev)
Widget w;
XtPointer client_data;
XClientMessageEvent *ev;
{
   int nbytes;
   u_char *sdata;
   register char *data;
   int n_slots;
   char *srcDir;
   char *fname;
   char **argv, **cmd;
   DragDropObj obj;
   
	if (!rddIsRddMessageEvent(*((XEvent *) ev)))
		return;

	if (!client_data)
		return;

	obj = (DragDropObj) client_data;
	
	obj->dd.data = NULL;	/* Initialization needed (goto) */
	 	
	if (ev->data.l[0] & RDD_DRAG_EVENT) {
#ifdef DEBUG
            fprintf (stderr,"GOT DRAG MESSAGE \n");
#endif
	    return;
	}

        nbytes = rddGetSelection (&sdata);
        
        if (nbytes <= 0)
        	return;
        
        data = (char *) sdata;
        

	if ((n_slots = data_length (data)) <= 0)
	   return;
        n_slots++;		/* Slot for NULL	*/
        if (!(argv = (char **) malloc (sizeof (char *) * n_slots)))
	   return;

	cmd = argv;
	data++;
        fname = strtok (data, "\n"); /* skip the machine name */
        srcDir = strtok (NULL, "\n");
        fname = strtok (NULL, " ");

        while (fname) {
	   *cmd = _dircat (srcDir, fname); 
	   if (!*cmd)
	      goto out;
	   cmd++;
	   fname = strtok (NULL, " ");
        }
        
        *cmd = '\0';
        obj->dd.data = _Cargvtocmd (argv, 0);
        
        /* Send the data to the standard receiver */
        /* Usually the parent object              */
        RtSetValue (stdmsg, RtNmsgId,
        		RtDD_DROP_DATA);
        RtSetValue (stdmsg, RtNmsgContent,
        		obj->dd.data);
        RtSendMessage (obj->core.obj_stdout, 
                        (char *) stdmsg, NULL);
#ifdef DEBUG
        fprintf (stderr, "data = %s\n", obj->dd.data);
#endif
			
out:
	_freeargv (argv);
	return;
	
}
