/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * DataBase of objects
 */

#include "Db.h"
 
void DBInitialize ();
void DBRealize ();
void DBDestroy ();
void DBSetValues ();
void DBProcessMessage ();
void DBGetValues ();

static void load_db ();

static Obj load_line ();
static void load_line_into_object ();
static void set_resource ();
static void retrieve_by_key ();
static void db_dump ();
static void db_add ();
static void db_remove ();
extern char *_vstrconcat ();
static char *build_line ();
char *mktemp ();
static void db_edit ();
static void db_traverse ();
static void db_drop ();
#ifdef OLD
static void db_reload ();
#endif
static void update_timestamp ();

static RtResource resources[] = {
   {RtNdbCnvMsg, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(DataBaseObj,db.cnv_msg), 0, NULL, 0, NULL},
   {RtNdbObjClass, NULL, RtPOINTER_TYPE, sizeof(char *), 
   RtOffset(DataBaseObj,db.obj_class), 0, NULL, 0, NULL }, 
   {RtNdbObj, NULL, RtOBJ_TYPE, sizeof(Obj), 
   RtOffset(DataBaseObj,db.obj), 0, NULL, 0, NULL }, 
   {RtNdbCurrentPos, NULL, RtSUBOBJ_TYPE, sizeof(int), 
   RtOffset(DataBaseObj,db.list), 0, NULL, 0, RtNlistCurrentPos}, 
   {RtNdbCurrent, NULL, RtOBJ_TYPE, sizeof(Obj), 
   RtOffset(DataBaseObj,db.current), 0, NULL, 0, NULL }, 
   {RtNdbKey, NULL, RtSTRING_TYPE, sizeof(char *), 
   RtOffset(DataBaseObj,db.key), 0, NULL, 0, NULL }, 
   {RtNdbBroadcastRecord , NULL, RtBIT_TYPE, 1, 
   RtOffset(DataBaseObj,db.db_flags), 0, NULL, 0, 
   (char *) RtDB_BROADCAST_RECORD},   
   {RtNdbDestroyObjects , NULL, RtBIT_TYPE, 1, 
   RtOffset(DataBaseObj,db.db_flags), 0, NULL, 0, 
   (char *) RtDB_DESTROY_OBJECTS},  
   {RtNdbOutOfSync , NULL, RtBIT_TYPE, 1, 
   RtOffset(DataBaseObj,db.db_flags), 0, NULL, RtInvokeClassGetValue, 
   (char *) RtDB_OUT_OF_SYNC}, /* the memory content is out of date */   
   {RtNdbLoaded , NULL, RtBIT_TYPE, 1, 
   RtOffset(DataBaseObj,db.db_flags), 0, NULL, 0, 
   (char *) RtDB_LOADED},  
};

DataBaseClassRec dataBaseClassRec = {
  {
    (ObjClass) &fileClassRec,
    "Data Base",
    NULL,
    0,
    resources,
    RtNumber (resources),
    /* object size              */  sizeof(DataBaseRec),
    DBInitialize,
    DBRealize,
    DBGetValues,
    DBSetValues,
    NULL,
    DBDestroy,
    DBProcessMessage,
    "db",
    "Rt1.00",
    NULL
  },
  {
  0,
  }
  
};

ObjClass dataBaseObjClass = (ObjClass) &dataBaseClassRec; 

/*
 * DBSetValues: set object resources
 */
 
void DBSetValues (current, new)
DataBaseObj current, new;
{
   /* Check - This should be done by the superclass */

#ifdef OLD   
   if (current->core.object_name != new->core.object_name)
        RtUpdateString (current->core.object_name, 
        	new->core.object_name);
#endif
   if (current->db.key != new->db.key) {
   	RtUpdateString (current->db.key, new->db.key);
   	RtSetValue (new->db.list, RtNlistKey, new->db.key);
   }
   
   /* this should be done by the toolkit automatically. */
   /* Waiting for improvements in cpu speed		*/
   (*fileObjClass->core_class.set_values) 
   			(current, new);
}

/*
 * DBGetValues: get object resources
 */
void DBGetValues (obj, res, value_pointer)
DataBaseObj obj;
char *res;
void **value_pointer;
{
int *int_ptr;
MessageObj msg;

   if (!res)
   	return;
   
   if (strcmp (res, RtNdbOutOfSync))
   	return;
   	
   int_ptr = (int *) value_pointer;
   
   *int_ptr = 0;
   msg = RtCreateMessage ();
   if (!msg) {
   	obj->core.status = RtINTERNAL_ERROR;
   	return;
   }
   
   RtSetValue (msg, RtNmsgId, RtFILE_STAT);
   RtSendMessage (obj, msg, NULL);
   
   if (obj->core.status)
   	return;
   	
   if ((obj->file.st).st_mtime > obj->db.timestamp)
   	*int_ptr = 1;
   else
   	*int_ptr = 0;
   
   RtDestroyObject (msg); 
}

/*
 * DBInitialize: initialize object
 */

void DBInitialize (obj)
DataBaseObj obj;
{

#ifdef DEBUG
   obj->core.object_name = strdup ("DataBase Object");
#endif
   obj->db.separator = ' ';
   obj->file.open_flags = O_RDWR|O_CREAT;
   obj->file.strip_newlines = 1;
   obj->db.list = RtCreateObject (NULL, listObjClass);
   RtSetValue (obj->db.list, RtNlistOrdered, 1);
}

/*
 * BCRealize: realize object
 */
 
void DBRealize (obj)
DataBaseObj obj;
{
   ObjClass class;
   
   class = obj->db.obj_class;
   
   if (class) {
   	obj->db.obj = RtCreateObject (NULL, class);
   	obj->db.obj_size = class->core_class.object_size;
   	/* the object is a database object 		    */
   	/* obj->file.db_file is also used as the message Id */
   	obj->file.db_file = RtDB_LOAD_LINE; 
   }
}


/*
 * BCDestroy: destroy object
 */
 
void DBDestroy (obj)
DataBaseObj obj;
{
   /*
    * destroy the database key
    */
    
   RtDestroyString (obj->db.key);
   
   /*
    * destroy the object list
    */
   
   RtDestroyObject (obj->db.list);
}

/*
 * broadcast_record: broadcast the affected record after each
 *		     operation
 */
 
static void broadcast_record (obj, db_entry, message_id, original)
DataBaseObj obj;
Obj db_entry;
int message_id;
char *original;
{
int cnv_msg_id;
char *output;
  
  if (!obj || !db_entry)
  	return;
  	
  RtGetValue (obj, RtNdbCnvMsg, &cnv_msg_id);
  
  
  if (cnv_msg_id != 0) { /* Massage the record */
	RtSetValue (stdmsg, RtNmsgId, cnv_msg_id);
	RtSetValue (stdmsg, RtNmsgContent, NULL);   
	RtSetValue (stdmsg, RtNmsgClient, NULL);
  	RtSendMessage (db_entry, stdmsg, NULL);
  	RtGetValue (db_entry, RtNobjOutput, &output);
  	RtSetValue (stdmsg, RtNmsgId, message_id);
  	if (original) {
  	   RtSetValue (stdmsg, RtNmsgContent, original);
  	   RtSetValue (stdmsg, RtNmsgClient, output);
  	} else {   
  	   RtSetValue (stdmsg, RtNmsgContent, output);
  	   RtSetValue (stdmsg, RtNmsgClient, NULL);
  	}
  } else  {
  	RtSetValue (stdmsg, RtNmsgId, message_id);
  	RtSetValue (stdmsg, RtNmsgContent, db_entry);   
  	RtSetValue (stdmsg, RtNmsgClient, NULL);   
  }
  obj->core.object_flags &=~obj->core.object_flags;
  (*broadCasterObjClass->core_class.process_message) 
   			(obj, (char *) stdmsg, NULL);

}


/*
 * DBProcessMessage: process object messages
 */
 
void DBProcessMessage (obj, data, client)
DataBaseObj obj;
void *data;
char *client;
{
MessageObj msg;
char *content;
int flags;
int message_id;
int tmp;
char *key;
Obj aux;
char *output;


   msg = (MessageObj) data;
   RtGetValue (msg, RtNmsgId, &message_id);   
   RtGetValue (msg, RtNmsgContent, &content);
   obj->core.status = 0;   

   switch (message_id) {
#ifdef OLD
      case RtDB_RELOAD:
         db_reload (obj);
         break;
#endif         
      case RtDB_LOAD:
         update_timestamp (obj);
         load_db (obj);
         break;
      case RtDB_ADD:
        if (!content || !obj->db.key)
           return;

	db_add (obj, content);

	if (obj->core.status) {
           RtSetValue (stdmsg, RtNmsgId, RtERR_ID);
           RtSetValue (stdmsg, RtNmsgContent, obj->core.status);
           RtSetValue (stdmsg, RtNmsgClient, NULL);
           RtSendMessage (obj->core.obj_stderr, stdmsg, NULL);
	   return;
	}
	   
        db_dump (obj);
        if (obj->db.db_flags & RtDB_BROADCAST_RECORD)
	   broadcast_record (obj, content, message_id, NULL);
        break;
      case RtDB_EDIT:
        output = NULL;
        if (!content || !obj->db.key)
           return;
         
   	key = NULL;
   	RtGetValue ((Obj) content, obj->db.key, &key);
   	
   	if (!key) {
           obj->core.status = RtDB_INVALID_KEY;
   	   return;
	}
	
   	retrieve_by_key (obj, key);

	aux = obj->db.current;
   	if (!aux) {
           obj->core.status = RtDB_OBJECT_NOT_FOUND;
   	   return;
   	}
	
	if (obj->db.cnv_msg != 0) {
	   output = NULL;
	   RtSetValue (stdmsg, RtNmsgId, obj->db.cnv_msg);
	   RtSetValue (stdmsg, RtNmsgContent, NULL);   
	   RtSetValue (stdmsg, RtNmsgClient, NULL);
  	   RtSendMessage (aux, stdmsg, NULL);
  	   RtGetValue (aux, RtNobjOutput, &output);
  	   if (output)
  	       	output = strdup (output);
	}
	
        db_edit (obj, aux, content);
          
	if (obj->core.status) 
	   return;

        db_dump (obj);

	if ((obj->db.cnv_msg != 0) && !output)
	   return;
	   
	/* 
	 * broadcast the record 
	 */

        if (obj->db.db_flags & RtDB_BROADCAST_RECORD)
	   broadcast_record (obj, aux, 
	   	message_id, output);
           
	if ((obj->db.cnv_msg != 0) && output)
	   free (output);
	   
	break;
      case RtDB_DUMP:
        db_dump (obj);
        break;

      case RtDB_REMOVE: /* remove object */

        retrieve_by_key (obj, content);

	aux = obj->db.current;
        if (!aux) {
           obj->core.status = RtDB_OBJECT_NOT_FOUND;
           return;
	}
	
	
	/*
	 * remove object from the object list
	 */
        db_remove (obj);

        obj->db.current = NULL;
	if (obj->core.status) 
	   return;

        /*
         * Update file
         */
        db_dump (obj);
           
	/* 
	 * broadcast the record 
	 */

        if (obj->db.db_flags & RtDB_BROADCAST_RECORD)
	   broadcast_record (obj, aux, message_id, NULL);
	
	/*
	 * destroy the current object after broadcasting the message
	 * (careful, the object will be gone after this)
	 */
	    
        if (obj->db.db_flags & RtDB_DESTROY_OBJECTS)
	   RtDestroyObject (aux);
        break;
        
      case RtDB_RETRIEVE_BY_KEY:
        retrieve_by_key (obj, content);
   	
        if (!obj->db.current) {
           obj->core.status = RtDB_OBJECT_NOT_FOUND;
           return; 
        }

   	RtSetValue (stdmsg, RtNmsgId, RtMESSAGE);
   	RtSetValue (stdmsg, RtNmsgContent, obj->db.current);
   	(*broadCasterObjClass->core_class.process_message) 
   			(obj, (char *) stdmsg, NULL);
        break;
      case RtDB_TRAVERSE:
        db_traverse (obj);
        break;
      case RtDB_DROP:
        db_drop (obj);
        break;
      case RtDB_LOAD_LINE:
        if (!content) {
           obj->core.status = RtDB_INVALID_INPUT;
           return;
        }
        
        aux = load_line (obj, content);
        
        /* add object to the database */
        if (!aux) {
           obj->core.status = RtINTERNAL_ERROR;
           return;
        }
        
        db_add (obj, aux);

	if (obj->core.status) 
	   return;

        if ((obj->db.db_flags & RtDB_BROADCAST_RECORD)
        	&& aux)
	   broadcast_record (obj, aux, message_id, NULL);
  	   
        break;
      default:
#ifdef DEBUG
   	fprintf (stderr, 
   	"DBProcessMessage: I don't know how to process this message\n");
#endif
	RtSuperclassProcessMessage (dataBaseObjClass,
		obj, data, client); 
       break;
   }
}

/*
 * load_db: load the database object
 */
 
static void load_db (obj)
DataBaseObj obj;
{

   /* drop the database */
   db_drop (obj);
   RtSetValue (stdmsg, RtNmsgId, RtFILE_READ_LINES);
   /* this should force RtDB_LOAD_LINE messages to be sent */
   /* to this object					   */
   RtSendMessage (obj, stdmsg, NULL);
   if (obj->core.status)
   	return;
   obj->db.db_flags |= RtDB_LOADED;
}

/*
 * build_line: build a string
 */
 
static char *build_line (obj, entry)
DataBaseObj obj;
Obj entry;
{
int status;
char *output;

   if (!obj || !entry)
   	return (NULL);
   	
   RtSetValue (stdmsg, RtNmsgId, RtOBJ_TO_STRING);
   RtSendMessage (entry, stdmsg, NULL);
   RtGetValue (entry, RtNobjStatus, &status);
   if (status != 0)
   	return (NULL);
   RtGetValue (entry, RtNobjOutput, &output);
   return (output);
}

/*
 * db_dump: dump object database
 */
 
static void db_dump (obj)
DataBaseObj obj;
{
  register int i = 0;
  Obj lst, op;
  char *line;
  char *aux;
  char *template;
  char *tmp;
  int tmp1;
  char *dirname = NULL;
  char *file = NULL;

   if (!obj)
   	return;
   
   /*
    * Flags for the file superclass
    */
    	
   tmp1 = obj->file.open_flags;
   obj->file.open_flags = O_RDWR|O_CREAT|O_TRUNC; 

   lst = obj->db.list;
   
   if (!obj->file.path || !lst) {
   	obj->core.status = RtINVALID_RESOURCES;
   	obj->file.open_flags = tmp1;
   	return;
   }
   
   /*
    * Create a temporal file
    */
    
   RtSetValue (stdmsg, RtNmsgId, RtFILE_DIRNAME);
   RtSendMessage (obj, stdmsg, NULL);
   
   RtGetValue (obj, RtNfileDirectory, &dirname);
   
   RtSetValue (stdmsg, RtNmsgId, RtFILE_BASENAME);
   RtSendMessage (obj, stdmsg, NULL);
   
   RtGetValue (obj, RtNfileBasename, &file);

   if (!dirname || !file) {
   	obj->core.status = RtINTERNAL_ERROR;
   	obj->file.open_flags = tmp1;
	return;   	
   }
   
   template = _vstrconcat (dirname, "/", 
   	".", file, "XXXXXX", NULL);
   
   if (!template) {
   	obj->core.status = RtNOT_ENOUGH_MEMORY;	
   	obj->file.open_flags = tmp1;
   	return;   
   }
   	
   tmp = mktemp (template);
   
   if (!tmp) {
   	obj->core.status = RtINTERNAL_ERROR;
   	obj->file.open_flags = tmp1;
	return;   	
   }
   
   aux = strdup (obj->file.path);
   
   if (!aux) {
   	obj->core.status = RtNOT_ENOUGH_MEMORY;	
   	obj->file.open_flags = tmp1;
   	return;
   }

   RtSetValue (obj, RtNfilePath, tmp); 

   RtSetValue (stdmsg, RtNmsgId, RtLIST_FIRST);
   RtSendMessage (lst, stdmsg, NULL);
   
   op = NULL;
   RtGetValue (lst, RtNlistCurrent, &op);
   
   /*
    * traverse the object list
    */
    
   while (op) {
   	
   	/*
   	 * Convert the object into a string
   	 */
   	 
   	line = build_line (obj, op);
   	
   	if (!line) {
   	   obj->core.status = RtINTERNAL_ERROR;
   	   break;
   	}
   	
   	/*
   	 * Write the line into the file
   	 */
   	   
   	RtSetValue (stdmsg, RtNmsgContent, line);
   	RtSetValue (stdmsg, RtNmsgClient, 0);
   	RtSetValue (stdmsg, RtNmsgId, RtFILE_WRITE_LINE);
   	RtSendMessage (obj, stdmsg, NULL);

	/*
	 * Retrieve next object
	 */
	 
   	RtSetValue (stdmsg, RtNmsgId, RtLIST_NEXT);
   	RtSendMessage (lst, stdmsg, NULL);
   
   	op = NULL;
   	RtGetValue (lst, RtNlistCurrent, &op);
		
   }
   RtSetValue (stdmsg, RtNmsgContent, NULL);
   RtSetValue (stdmsg, RtNmsgId, RtFILE_WRITE_LINE);
   RtSendMessage (obj, stdmsg, NULL);

   /*
    * Rename the file
    */
   if (!obj->core.status) { 
   	RtSetValue (stdmsg, RtNmsgContent, aux);
   	RtSetValue (stdmsg, RtNmsgId, RtFILE_RENAME);
   	RtSendMessage (obj, stdmsg, NULL);
   }

   RtSetValue (obj, RtNfilePath, aux);
   obj->file.open_flags = tmp1;
   free (aux);
   free (template);
   update_timestamp (obj);
}

/*
 * db_drop: drop the database
 */
 
static void db_drop (obj)
DataBaseObj obj;
{
   RtSetValue (stdmsg, RtNmsgId, RtLIST_CLEAR);
   RtSendMessage (obj->db.list, stdmsg, NULL);
   obj->db.db_flags &= ~RtDB_LOADED;
}

/*
 * traverse_db: traverse the database
 * check - changes the current element
 */

static void db_traverse (obj)
DataBaseObj obj;
{
  Obj lst, op;

   lst = obj->db.list;
   
   if (!lst)
   	return;
   	
   RtSetValue (stdmsg, RtNmsgId, RtLIST_FIRST);
   RtSendMessage (lst, stdmsg, NULL);
   
   op = NULL;
   RtGetValue (lst, RtNlistCurrent, &op);
   
   /*
    * traverse the object list
    */

   while (op) {
   	
	broadcast_record (obj, op, RtDB_TRAVERSE, NULL);
	/*
	 * Retrieve next object
	 */
	 
   	RtSetValue (stdmsg, RtNmsgId, RtLIST_NEXT);
   	RtSendMessage (lst, stdmsg, NULL);
   
   	op = NULL;
   	RtGetValue (lst, RtNlistCurrent, &op);
		
   }
   
} 
 
 
/*
 * load_line: load line content into object
 */
 
static Obj load_line (obj, content)
DataBaseObj obj;
char *content;
{
    Obj item, mp, tmp, op;
    unsigned int obj_size;
    ObjClass class;
    int status;

    item = obj->db.obj;
    if (!item)
    	return (NULL);
    	
    class = item->core.object_class;
    if (!content || !class)
    	return (NULL);

    tmp = RtCreateObject (NULL, class);
    RtSetValue (stdmsg, RtNmsgId, RtSTRING_TO_OBJ);
    RtSetValue (stdmsg, RtNmsgContent, content);
    RtSendMessage (tmp, stdmsg, NULL);
    RtGetValue (tmp, RtNobjStatus, &status);

    if (status != 0) {
        /* check - broadcast a message */
#ifdef OLD
    	obj->db.current = NULL;
#endif
    	return (NULL);
    }
    return (tmp);	

}

#ifdef OLDVERSION
/*
 * load_line_into_object: load input line into object
 */
 
static void load_line_into_object (obj, item, content)
DataBaseObj obj;
Obj item;
char *content;
{
    ObjClass class;
    register char *res;
    RtResource *resources;
    register int i = 0;
    char *cp;
    int done = 0, len;
    
    
    if (!obj || !item)
    	return;
    	
    class = item->core.object_class;
    
    if (!class || !content)
    	return;
    
    resources = class->core_class.resources;
    if (!resources)
    	return;
    		
    res = content;
    for (i = 0; i < class->core_class.num_resources; i++) {
    	cp = strchr (res, obj->db.separator);
    	
    	resources = RtGetPResource (item, i);
    	
    	if (!resources) {
    	   obj->core.status = RtINVALID_RESOURCES;
    	   return;
        }
        
    	if (cp)
    	   *cp = '\0';
    	else
    	   done = 1;
    	      
        if (!resources->name)
       	   return;

    	switch (resources->type) {
    	   case RtSTRING_TYPE:
	   	RtSetValue (item, resources->name, res); 
	   	break;
	   default:
#ifdef DEBUG
		fprintf (stderr, "load_line: invalid resource type\n");
#endif
		obj->core.status = RtDB_INVALID_RESOURCE_TYPE;	   
	   	break;	   
	}
	if (done)
	   break;
	   
	len = strlen (res);
	res += (len+1); 
    }	  
}
#endif

/*
 * retrieve_by_key: retrieve an object by using a key
 */
 
static void retrieve_by_key (obj, key)
DataBaseObj obj;
char *key;
{
Obj op = NULL;


   obj->db.current = NULL;
   if (!obj->db.list || !obj->db.key)
   	return;

   if (!key)        
   	return;

   RtSetValue (stdmsg, RtNmsgId, RtLIST_FIND);
   RtSetValue (stdmsg, RtNmsgContent, obj->db.key);
   RtSetValue (stdmsg, RtNmsgClient, key);
   RtSendMessage (obj->db.list, stdmsg, NULL);
   
   RtGetValue (obj->db.list, RtNlistCurrent, &op); 
   obj->db.current = op;
#ifdef DEBUG
   if (op)
	fprintf (stderr, "retrieve_by_key: found %s\n", key);
#endif				   	
   
} 


/*
 * db_edit: edit the content of an object
 */

static void db_edit (obj, item, new_item)
DataBaseObj obj;
Obj new_item;
{
char *key;

   if (!new_item || !obj->db.key)
   	return;
   	
   if (!obj->db.current) {
#ifdef REMOVEME
        obj->core.status = RtDB_OBJECT_NOT_FOUND;
#endif        
   	return;
   } else
   	RtCopyObject ((Obj) new_item, item); /* update object */
}

/*
 * db_add: add a new object to the object list
 */

static void db_add (obj, item)
DataBaseObj obj;
Obj item;
{
    Obj tmp;
    char *key;
    int status;

    if (!obj->db.key || !item)
    	return;
    	
    key = NULL;
    
    /* limitation: key is expected to be a string */
    RtGetValue ((Obj) item, obj->db.key, &key);
    
    if (!key) {
    	obj->core.status = RtDB_INVALID_KEY;
    	return;
    }	
    if (!*key) {
    	obj->core.status = RtDB_INVALID_KEY;
    	return;
    }	   
    retrieve_by_key (obj, key);
    
    if (obj->db.current) {
        obj->core.status = RtDB_OBJECT_ALREADY_EXISTS;
    	return; /* check */ 
    }  

    RtSetValue (stdmsg, RtNmsgId, RtLIST_ADD);
    RtSetValue (stdmsg, RtNmsgContent, item);
    RtSendMessage (obj->db.list, stdmsg, NULL);
    
    RtGetValue (obj->db.list, RtNobjStatus, &status);
    
    if (!status)
    	obj->db.current = item;
    else
    	obj->db.current = NULL; /* check - move from here */
    
}

/*
 * db_remove: remove an object from the object list
 */

static void db_remove (obj)
DataBaseObj obj;
{
   /* check - current does not get used */
   RtSetValue (stdmsg, RtNmsgId, RtLIST_DELETE);
   RtSendMessage (obj->db.list, stdmsg, NULL);
}
#ifdef OLD
/*
 * db_reload: reload the database
 */

static void db_reload (obj)
DataBaseObj obj;
{
#ifdef OLD
   /* destroy the objects if needed */
   if (obj->db.db_flags & RtDB_DESTROY_OBJECTS) {
   	RtSetValue (obj, RtNmsgId, RtBROADCAST_MESSAGE);
   	RtSetValue (stdmsg, RtNmsgId, RtDESTROY);
   	RtSetValue (obj, RtNmsgContent, stdmsg);
   	RtSendMessage (obj->db.list, obj, NULL);
   }
#endif
   RtSetValue (stdmsg, RtNmsgId, RtDB_CLEAR);
   RtSendMessage (obj, stdmsg, NULL);
   RtSetValue (stdmsg, RtNmsgId, RtDB_LOAD);
   RtSendMessage (obj, stdmsg, NULL);   
      
}
#endif

/*
 * update_timestamp: update timestamp
 */
 
static void update_timestamp (obj)
DataBaseObj obj;
{
MessageObj msg;

   msg = RtCreateMessage ();
   if (!msg) {
   	obj->core.status = RtINTERNAL_ERROR;
   	return;
   }
   
   RtSetValue (msg, RtNmsgId, RtFILE_STAT);
   RtSendMessage (obj, msg, NULL);
   
   if (obj->core.status)
   	return;
   	
   if (obj->db.timestamp = (obj->file.st).st_mtime)
   RtDestroyObject (msg); 
}
