/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */


#include "Cursor.h"
#include "wait_cursor.bitmap"
#include "wait_mask.bitmap"


void CURInitialize ();
void CURActivate ();
void CURRealize ();
void CURDestroy ();
void CURSetValues ();

static RtResource resources[] = {
   {RtNcursorEnabled, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(CursorObj,cursor.enabled), 0, NULL, 0, NULL}
};


CursorClassRec cursorClassRec = {
  {
    (ObjClass) &rtWidgetClassRec,/* superclass		*/
    "Cursor",			/* class name		*/
    NULL,	
    0,
    resources,			/* resource table	*/
    RtNumber (resources),	/* number of resources  */
    /* object size              */  sizeof(CursorRec),
    CURInitialize,
    CURRealize,
    NULL,
    CURSetValues,
    NULL,
    CURDestroy,
    NULL,
    "cursor",
    "Rt1.00",
    NULL
  },
  {
  0,
  }
  
};

ObjClass cursorObjClass = (ObjClass) &cursorClassRec; 

Cursor create_wait_cursor (obj)
CursorObj obj;
{
    Display *dpy;
    Window  win;
    Pixmap tmp1, tmp2;
    XColor  fg, bg;
    Cursor cursor;
    
    if (!obj->widget.widget)
    	return (NULL);
    	
    dpy = XtDisplay((Widget) obj->widget.widget);
    win = RootWindowOfScreen(XtScreen(obj->widget.widget));

    bg.red   = 0xffff;
    bg.green = 0xffff;
    bg.blue  = 0xffff;
    bg.flags = DoRed | DoGreen | DoBlue;

    fg.red   = 0;
    fg.green = 0;
    fg.blue  = 0;
    fg.flags = DoRed | DoGreen | DoBlue;

    cursor = 
      XCreatePixmapCursor(dpy,
			  tmp1 = XCreateBitmapFromData(dpy, win, wait_cursor_bits,
						wait_cursor_width,
						wait_cursor_height),
			  tmp2 = XCreateBitmapFromData(dpy, win, wait_mask_bits,
						wait_mask_width,
						wait_mask_height),
			  &fg, &bg,
			  wait_cursor_x_hot, wait_cursor_y_hot);
    XFreePixmap(dpy, tmp1);
    XFreePixmap(dpy, tmp2);
    return (cursor);

}
void CURSetValues (current, new)
CursorObj current, new;
{

   if (!new->widget.widget) {
	fprintf (stderr, "CURRealize: no widget specified for this object\n"); 
	return;  
   }
   
   if (!XtIsRealized(new->widget.widget)) 
  	return; /* Just in case... */

   if (current->cursor.enabled != new->cursor.enabled) {
   	if (new->cursor.enabled) {
	    XDefineCursor(XtDisplay (new->widget.widget), 
		XtWindow (new->widget.widget), new->cursor.cursor);   
   	
   	} else {
   	    XUndefineCursor (XtDisplay (new->widget.widget), 
   	    			XtWindow (new->widget.widget));
   	}
   	XSync (XtDisplay (new->widget.widget), False);
   
   }
}


void CURInitialize (new)
Obj new;
{
}


void CURRealize (obj)
CursorObj obj;
{

   if (!obj->widget.widget) {
	fprintf (stderr, "CURRealize: no widget specified for this object\n"); 
	return;  
   }
   if (!obj->cursor.filename) {   
   	obj->cursor.cursor = create_wait_cursor (obj);
   }
   
   if (!obj->cursor.cursor)
   	return;

  if (!XtIsRealized(obj->widget.widget)) 
  	return; /* Just in case... */
   	
   if (obj->cursor.enabled) {
	XDefineCursor(XtDisplay (obj->widget.widget), 
		XtWindow (obj->widget.widget), obj->cursor.cursor);   
   	XSync (XtDisplay (obj->widget.widget), False);
   }
}


void CURDestroy (obj)
Obj obj;
{
}

