/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */


/*
 * Broadcaster object: Object used to broadcast messages. The 
 * input message is broadcasted to the list of receptors stored 
 * in the object. 
 */

#include "Rt.h"
 
void BCInitialize ();
void BCActivate ();
void BCRealize ();
void BCDestroy ();
void BCSetValues ();
void BCProcessMessage ();
static int reset_object ();

static RtResource resources[] = {
   {RtNbcNewId, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(BroadcasterObj,broadcaster.new_id), 0, NULL, 0, NULL},
   {RtNbcNewFlags, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(BroadcasterObj,broadcaster.new_flags), 0, NULL, 0, NULL},
   {RtNbcNewContent, NULL, RtSTRING_TYPE, sizeof(char *), 
   RtOffset(BroadcasterObj,broadcaster.new_content), 0, NULL, 0, NULL},
   {RtNbcNewType, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(BroadcasterObj,broadcaster.new_type), 0, NULL, 0, NULL},
   {RtNbcNegate, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(BroadcasterObj,broadcaster.negate), 0, NULL, 0, NULL},
   {RtNbcTrueValues, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(BroadcasterObj,broadcaster.true_values), 0, NULL, 0, NULL},
   {RtNbcStopFlow, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(BroadcasterObj,broadcaster.stop_flow), 0, NULL, 0, NULL},
   {RtNbcMultiplexerMode, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(BroadcasterObj,broadcaster.multiplexer_mode), 0, NULL, 0, NULL},
   {RtNbcReceiverSelected, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(BroadcasterObj,broadcaster.receiver_selected), 0, NULL, 0, NULL},
   {RtNbcSetContent, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(BroadcasterObj,broadcaster.set_content), 0, NULL, 0, NULL},
   {RtNbcMustMatch, NULL, RtINT_TYPE, sizeof(int), 
   RtOffset(BroadcasterObj,broadcaster.must_match), 0, NULL, 0, NULL},
};
	
BroadcasterClassRec broadCasterClassRec = {
  {
    (ObjClass) &messageClassRec,/* superclass		*/
    "Broadcaster",		/* class name		*/
    NULL,	
    0,
    resources,			/* resource		*/
    RtNumber (resources),	/* number of resources  */
    /* object size              */  sizeof(BroadcasterRec),
    BCInitialize,
    BCRealize,
    NULL,
    BCSetValues,
    BCActivate,
    BCDestroy,
    BCProcessMessage,
    "bc",
    "Rt1.00",
    NULL
  },
  {
  0,
  }
  
};

ObjClass broadCasterObjClass = (ObjClass) &broadCasterClassRec; 

/*
 * BCSetValues: set object resources
 */
 
void BCSetValues (current, new)
BroadcasterObj current, new;
{
   /* Check - This should be done by the superclass */
   
   RtUpdateString (current->core.object_name, 
        	new->core.object_name);
}

/*
 * BCInitialize: Initialize object
 */

void BCInitialize (obj)
BroadcasterObj obj;
{
#ifdef DEBUG
   obj->core.object_name = strdup ("Broadcaster");
#endif
}

/*
 * BCActivate: activate object
 */
 
void BCActivate (new)
BroadcasterObj new;
{
}

/*
 * BCRealize: realize object
 */
 
void BCRealize (new)
BroadcasterObj new;
{
}

/*
 * BCDestroy: destroy object
 */
 
void BCDestroy (obj)
BroadcasterObj obj;
{
   /* free object list */
   if (obj->broadcaster.receptor_list) {
   	free (obj->broadcaster.receptor_list);
   	obj->broadcaster.receptor_list = NULL;
   }
   
   /* free the conversion table */
   if (obj->broadcaster.cnv_tbl) {
	free (obj->broadcaster.cnv_tbl);
	obj->broadcaster.cnv_tbl = NULL;   
   }
   
   /* free the object itself */
   if (obj->core.object_class == broadCasterObjClass) {
      RtDestroyString (obj->core.object_name);
      free (obj);       
   }  
}

/*
 * BCProcessMessage: process object messages
 */
 
void BCProcessMessage (obj, data, client)
BroadcasterObj obj;
void *data;
void *client;
{
Receptor tmp;
register int i = 0;
MessageObj msg, mp, msg1, aux;
char *content;
char *msg_client;
int id;
int message_id;

   msg = (MessageObj) data;

#ifdef OLD   
   if (!msg)
   	return;
#endif
   
   /* Retrieve the message information */	
   RtGetValue (msg, RtNmsgId, &message_id);   
   RtGetValue (msg, RtNmsgContent, &content);   
   RtGetValue (msg, RtNmsgClient, &msg_client);

   switch (message_id) {
      case RtRESET:
        obj->broadcaster.reset = 1;
        break;
      case RtADD_RECEPTOR:	/* Add a new receptor */
        if (!obj->broadcaster.receptor_list) {
           obj->broadcaster.receptor_list = (Receptor) 
           	malloc (sizeof (struct _Receptor) 
                * BC_CHUNK_SIZE);
           if (!obj->broadcaster.receptor_list)
              return;
           obj->broadcaster.max_cnt = BC_CHUNK_SIZE;
        } else if (obj->broadcaster.index >= obj->broadcaster.max_cnt) {
           /* Allocate an additional chunk of memory */
           tmp = (Receptor) realloc (obj->broadcaster.receptor_list, 
           		sizeof (struct _Receptor) 
                        * (obj->broadcaster.max_cnt + BC_CHUNK_SIZE));
           if (tmp) {
                obj->broadcaster.receptor_list = tmp;
                obj->broadcaster.max_cnt += BC_CHUNK_SIZE;                    
           }
                           
        }
        
        if (obj->broadcaster.index >= obj->broadcaster.max_cnt)
           return;
       
        tmp = obj->broadcaster.receptor_list + obj->broadcaster.index;
        
        tmp->object = (Obj) content;
        tmp->new_msg = NULL;
        
        if (msg_client) {
   	   tmp->new_msg = (MessageObj) 
                   RtCreateObject (NULL,  messageObjClass);
	   /* check - allocate memory */
           memcpy (tmp->new_msg, msg_client, sizeof (MessageRec));
        }
/*        
        tmp->new_content = 0;
        tmp->new_flags = 0;
 */
        obj->broadcaster.index++;
        break;
      case RtADD_CONVERSION: /* message conversion */
      
        if (!client)
           return;
           
      case RtADD_ID_CONVERSION: /* message id conversion */
        if (!obj->broadcaster.cnv_tbl) {
        
           /* BC_CHUNK_SIZE must be an even number */
           
           obj->broadcaster.cnv_tbl = (MessageObj) malloc (sizeof (MessageRec) 
                * BC_CHUNK_SIZE);

           if (!obj->broadcaster.cnv_tbl)       
           	return;

   	   memset (obj->broadcaster.cnv_tbl, '\0', 
   	   	sizeof (MessageRec) * BC_CHUNK_SIZE);
           	    
           obj->broadcaster.cnv_max_cnt = BC_CHUNK_SIZE;
        } else if (obj->broadcaster.cnv_index >= obj->broadcaster.cnv_max_cnt) {
           mp = (MessageObj) realloc ((char *) obj->broadcaster.cnv_tbl, 
           		sizeof (MessageRec) 
                        * (obj->broadcaster.cnv_max_cnt + BC_CHUNK_SIZE));
           if (mp) {
   	   	memset (mp+obj->broadcaster.cnv_max_cnt, '\0', 
   	   		sizeof (MessageRec) * BC_CHUNK_SIZE);
                obj->broadcaster.cnv_tbl = (MessageObj) mp;
                obj->broadcaster.cnv_max_cnt += BC_CHUNK_SIZE;                    
           }
                           
        }
        
        if (obj->broadcaster.cnv_index >= 
        	obj->broadcaster.cnv_max_cnt)
           return;
       
        mp = obj->broadcaster.cnv_tbl + obj->broadcaster.cnv_index;
           
        
        if (message_id == RtADD_CONVERSION) {             
           memcpy (mp++, client, sizeof (MessageRec));
        
           RtGetValue ((MessageObj) client, RtNmsgClient,  &msg1);
        
           memcpy (mp++, msg1, sizeof (MessageRec));
        } else {
#ifdef OLD
           /* create a message to get the basic object structure */           
   	   aux = (MessageObj) 
                   RtCreateObject (NULL,  messageObjClass);
           /* check aux */
                   
           /* copy aux into the messages table */
#endif
           memcpy (mp, stdmsg, sizeof (MessageRec));
           id = (int) content;
           RtInitializeObject (mp);
	   RtSetValue (mp, RtNmsgId, id);
	   mp++;
	   id = (int) msg_client;
           memcpy (mp, stdmsg, sizeof (MessageRec));
           RtInitializeObject (mp);
	   RtSetValue (mp, RtNmsgId, id);
#ifdef OLD	   
	   RtDestroyObject (aux);
#endif
        }
        
        obj->broadcaster.cnv_index += 2;
        break;
      default: 
#ifdef OLD
	if (message_id < RtADD_RECEPTOR) {
#endif
        /* This might not be enough */
        if (obj->core.object_flags & RtOBJ_SUPERCLASS_PROCESS_MESSAGE) {
            RtSuperclassProcessMessage (broadCasterObjClass,
            	obj, data, client);        
            return;
        }

	/* broadcast all the other types of messages */
        if (obj->core.object_flags & RtOBJ_BUSY) 
           return; /* this object is already processing a message */
        obj->core.object_flags |= RtOBJ_BUSY; /* process one message at a time */
        broadcast_message (obj, msg, client);
        obj->core.object_flags &= ~RtOBJ_BUSY;
   }
}

/*
 * conv_msg: convert messages before being broadcasted
 */

static int conv_msg (obj, msg)
BroadcasterObj obj;
MessageObj msg;
{
int id, id1;
MessageObj mp = obj->broadcaster.cnv_tbl;
register int i = 0;

   if (!obj || !msg)
   	return (0);

   if (!obj->broadcaster.cnv_tbl)
        return (0);
       
   /* Get the current message Id */
   RtGetValue (msg, RtNmsgId, &id);

   mp = obj->broadcaster.cnv_tbl;
   
   while ((mp - obj->broadcaster.cnv_tbl) < 
   	obj->broadcaster.cnv_index) {
   	
   	/* Get message Id of the next element in the table */
   	RtGetValue (mp, RtNmsgId, &id1);
   	
   	/* Compare with the current message Id */
   	if (id != id1) {
   	   mp += 2;
   	   continue;
   	}
#ifdef DEBUG
	fprintf (stderr, "cnv %d to %d\n", id, id1);
#endif
	mp++;
	/* get new message Id */
   	RtGetValue (mp, RtNmsgId, &id1);
   	/* change message Id */
   	RtSetValue (msg, RtNmsgId, id1);
	mp++;
	return (1);			   	   	      
	
   }
   return (0);
}


/*
 * broadcast_message: broadcast message to all the receptors
 *                    of this object
 */
 
broadcast_message (obj, msg, client)
BroadcasterObj obj;
MessageObj msg;
void *client;
{
Receptor tmp;
char *content;
char *mclient;
int id;
int flags;
register int i = 0;
int new_id;
int new_flags;
char *new_content;
char *new_client;


   obj->broadcaster.reset = 0;
   if (!obj->broadcaster.receptor_list)
        return;

   /* The flow of data has been stopped. Don't do anything */
    
   if (obj->broadcaster.stop_flow)
        return;
        
   tmp = obj->broadcaster.receptor_list;
   
   /* Save the state of the message */
   RtGetValue (msg, RtNmsgContent, &content);

   /* Broadcast only "true" values */ 
   if (obj->broadcaster.true_values)
      if ((obj->broadcaster.negate && content) ||
        (!obj->broadcaster.negate && !content))
      return;

   RtGetValue (msg, RtNmsgId, &id);
   RtGetValue (msg, RtNmsgFlags, &flags);
   RtGetValue (msg, RtNmsgClient, &mclient);

   /* Act as a Multiplexer (i.e. send message	*/
   /* to the selected object)			*/
   
   if (obj->broadcaster.multiplexer_mode) {
      i = obj->broadcaster.receiver_selected;
      tmp += i;
   }	
    
   while (i < obj->broadcaster.index) {


      if (obj->broadcaster.reset) {
         reset_object (obj);
         /* Restore the state of the message    */
         /* The receptors might have changed it */  
         RtSetValue (msg, RtNmsgContent, content);
         RtSetValue (msg, RtNmsgId, id);
         RtSetValue (msg, RtNmsgFlags, flags);
         RtSetValue (msg, RtNmsgClient, mclient);         
         return;
      } 


      /* Transform message if needed                              */
      /* The receiver might be expecting a different message Id   */
        
      /* check the message conversion table */
      if (!conv_msg (obj, msg) && obj->broadcaster.must_match)
      	return; /* no conversion made, the message Id is not  */
      		/* in the conversion table		      */
      
      if (obj->broadcaster.new_id)
         RtSetValue (msg, RtNmsgId, obj->broadcaster.new_id);
       
      if (obj->broadcaster.negate) {
         if ((int) content)
            content = (char *) 0;
         else
            content = (char *) 1;
         RtSetValue (msg, RtNmsgContent, content);
      }
      if (obj->broadcaster.set_content || obj->broadcaster.new_content)
         RtSetValue (msg, RtNmsgContent, obj->broadcaster.new_content);   

      if (obj->broadcaster.new_type)
         RtSetValue (msg, RtNmsgType, obj->broadcaster.new_type);   
      
      if (obj->broadcaster.new_flags) /* check */
         RtSetValue (msg, RtNmsgFlags, obj->broadcaster.new_flags); 
      
      if (tmp->new_msg) {
      	RtGetValue (tmp->new_msg, RtNmsgContent, &new_content);
      	RtGetValue (tmp->new_msg, RtNmsgId, &new_id);
      	RtGetValue (tmp->new_msg, RtNmsgFlags, &new_flags);
      	RtGetValue (tmp->new_msg, RtNmsgClient, &new_client);

      	if (new_id) {
      	   RtSetValue (msg, RtNmsgId, new_id);      
      	}
      
      	if (new_flags) {
      	   RtSetValue (msg, RtNmsgFlags, new_flags);      
        }

        if (obj->broadcaster.set_content || new_content)
           RtSetValue (msg, RtNmsgContent, new_content);   

	if (new_client) {
      	   RtSetValue (msg, RtNmsgClient, new_client);      	
	}
      }
      
#ifdef DEBUG
      fprintf (stderr, 
      	"broadcasting from %s, (%s)\n", obj->core.object_name,
      	(obj->core.object_class)->core_class.class_name);
#endif

      RtSendMessage (tmp->object, msg, client);
      tmp++; 
      i++;                 

      /* Restore state of the message        */
      /* The receptors might have changed it */  
      RtSetValue (msg, RtNmsgContent, content);
      RtSetValue (msg, RtNmsgId, id);
      RtSetValue (msg, RtNmsgFlags, flags);
      RtSetValue (msg, RtNmsgClient, mclient);         

      if (obj->broadcaster.multiplexer_mode)
      	return;
   } 
}

/*
 * reset_object: stop broadcasting messages
 */

static int reset_object (obj)
BroadcasterObj obj;
{
  obj->broadcaster.reset = 0; 
}
