/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * Array object. 
 */

#include "Array.h"
 
void ARRInitialize ();
void ARRActivate ();
void ARRRealize ();
void ARRDestroy ();
void ARRSetValues ();
void ARRProcessMessage ();
static void arr_add ();
static Obj *allocate_slot ();
static Obj *arr_find ();
static Obj *arr_first ();
static Obj *arr_next ();
static Obj *arr_free_slot ();
static void arr_delete ();

static RtResource resources[] = {
   {RtNarrCurrent, NULL, RtOBJ_TYPE, sizeof(Obj), 
   RtOffset(ArrayObj,arr.current), 0, NULL, 0, NULL }, 
};
  
ArrayClassRec arrayClassRec = {
  {
    &objClassRec,		/* superclass		*/
    "Array",			/* class name		*/
    NULL,	
    0,
    resources,			/* resource table	*/
    RtNumber (resources),	/* number of resources  */
    /* object size              */  sizeof(ArrayRec),
    ARRInitialize,
    ARRRealize,
    NULL,
    ARRSetValues,
    ARRActivate,
    ARRDestroy,
    ARRProcessMessage,
    "array",
    "Rt1.00",
    NULL
  },
  {
  0,
  }
  
};

ObjClass arrayObjClass = (ObjClass) &arrayClassRec; 

/*
 * ARRSetValues: set object resources
 */
 
void ARRSetValues (current, new)
ArrayObj current, new;
{
   /* Check - This should be done by the superclass */
   
   if (current->core.object_name != new->core.object_name)
        RtUpdateString (current->core.object_name, 
        	new->core.object_name);
}


/*
 * ARRInitialize: initialize object
 */

void ARRInitialize (obj)
ArrayObj obj;
{
#ifdef DEBUG
   obj->core.object_name = strdup ("Array Object");
#endif
}

/*
 * ARRActivate: activate object
 */
 
void ARRActivate (obj)
ArrayObj obj;
{
}


/*
 * ARRRealize: realize object
 */
 
void ARRRealize (obj)
ArrayObj obj;
{
}


/*
 * ARRDestroy: destroy object
 */
 
void ARRDestroy (obj)
ArrayObj obj;
{
}

void ARRProcessMessage (obj, data, client)
ArrayObj obj;
void *data;
char *client;
{
MessageObj msg;
char *content;
int flags;
int message_id;
Obj *tmp;

   msg = (MessageObj) data;
   RtGetValue (msg, RtNmsgId, &message_id);   
   RtGetValue (msg, RtNmsgContent, &content);   
   RtGetValue (msg, RtNmsgFlags, &flags);   
   
   /* ignore the function paramenter  		*/
   /* get the client info from the message 	*/
   RtGetValue (msg, RtNmsgClient, &client); 

   switch (message_id) {
      case RtLIST_ADD:
      	if (!content)
      	  return;
      	arr_add (obj, content);
      	break;
      case RtLIST_FIRST:
        tmp = arr_first (obj);
        obj->arr.curr_addr = tmp;
        obj->arr.current = tmp ? *tmp: NULL;
        break;      	 
      case RtLIST_NEXT:
        tmp = arr_next (obj);
        obj->arr.curr_addr = tmp;
        obj->arr.current = tmp ? *tmp: NULL;
        break;      	 
      case RtLIST_FIND:
      	if (!client && !content)
      	   return;
        tmp = arr_find (obj, content, client);
        obj->arr.curr_addr = tmp;
        obj->arr.current = tmp ? *tmp: NULL;
        break;
      case RtLIST_DELETE:
      	if (!obj->arr.current)
      	   return;
        arr_delete (obj);
        break;      
      default:
#ifdef DEBUG
   	fprintf (stderr, 
   	"ARRProcessMessage: I don't know how to process this message\n");
#endif
	/* Invoke the superclass to process the message */
	RtSuperclassProcessMessage (arrayObjClass,
		obj, data, client); 
        break;
   }
}

/*
 * arr_add:
 */
 
static void arr_add (obj, new_obj)
ArrayObj obj;
Obj new_obj;
{
Obj *tmp;

   tmp = allocate_slot (obj);
    
   if (!tmp)
	return;

   *tmp = new_obj;
}

/*
 * allocate_slot: 
 */

static Obj *allocate_slot (obj)
ArrayObj obj;
{
  Obj *tmp, *mp;
  static unsigned int obj_size = sizeof (Obj); 
    	
    if (!obj->arr.obj_array) {
        
           
	obj->arr.obj_array = (Obj *) malloc 
			(obj_size * RtARR_CHUNK_SIZE);

        if (!obj->arr.obj_array)       
           return;

   	memset (obj->arr.obj_array, '\0', 
   	   	obj_size * RtARR_CHUNK_SIZE);
           	    
        obj->arr.max_cnt = RtARR_CHUNK_SIZE;
    } else if (obj->arr.cnt >= obj->arr.max_cnt) {
           mp = (Obj *) realloc ((char *) obj->arr.obj_array, 
           		obj_size 
                        * (obj->arr.max_cnt + RtARR_CHUNK_SIZE));
           if (mp) {
   	   	memset (((char *) mp) + (obj_size * obj->arr.max_cnt), 
   	   		'\0', 
   	   		obj_size * RtARR_CHUNK_SIZE);
                obj->arr.obj_array = mp;
                obj->arr.max_cnt += RtARR_CHUNK_SIZE;                    
           }
                           
    }
        
    if (obj->arr.cnt >= obj->arr.max_cnt)
           return (NULL);

    tmp = array_free_slot (obj);
    
    return (tmp);
}

/*
 * array_free_slot: traverse the object array and return the next 
 * free slot
 */
 
static Obj *array_free_slot (obj)
ArrayObj obj;
{
  register Obj *op;
  register int i = 0;

   if (!obj->arr.obj_array)
   	return (NULL);
   
   op = obj->arr.obj_array;	
   
   while (i++ < obj->arr.max_cnt) {
	if (!*op)
	   return (op);
	op++;	   
   }
   return (NULL);
}

/*
 * array_find: find an object in the array
 */
 
static Obj *array_find (obj, res, value)
ArrayObj obj;
char *res;
char *value;
{
  register int i = 0;
  char *value1;
  register Obj *op;

   if (!res || !obj->arr.obj_array)
   	return (NULL);
   
   if (!value)
   	return (NULL);
   	
   op = obj->arr.obj_array;	
   
   while (i++ < obj->arr.max_cnt) {
   	if (*op == NULL) {
   	   op++;
   	   continue;
   	}
   	value1 = NULL;
	RtGetValue (*op, res, &value1);
	if (value1 && !strcmp (value, value1)) {	   
	   return (op);
	}
	op++;	   
   }
   return (NULL);
   
}

/*
 * array_first: get the first object in the array
 */
 
static Obj *array_first (obj)
ArrayObj obj;
{
  register int i = 0;
  register Obj *op;

   if (!obj->arr.obj_array)
   	return (NULL);
   
   op = obj->arr.obj_array;	
   
   while (i++ < obj->arr.max_cnt) {
   	if (*op != NULL) {
   	   return (op);
   	}
	op++;	   
   }
   return (NULL);
   
}

/*
 * array_next: get the next object in the array
 */
 
static Obj *array_next (obj)
ArrayObj obj;
{
  register int i = 0;
  register Obj *op;
  

   if (!obj->arr.obj_array)
   	return (NULL);
   
   if (!obj->arr.curr_addr)
   	return (array_first (obj));
   	
   i = obj->arr.curr_addr - obj->arr.obj_array;
   op = obj->arr.curr_addr;

   while (++i < obj->arr.max_cnt) {
   	if (*++op != NULL) {
   	   return (op);
   	}
   }
   return (NULL);   
}

/*
 * array_delete: delete current
 */
 
static void array_delete (obj)
ArrayObj obj;
{
   if (!obj->arr.current || !obj->arr.curr_addr)
	return;

   *(obj->arr.curr_addr) = NULL;

}
