/*
 * Freedom Desktop 
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#ifndef _RT_STRINGS_H
#define _RT_STRINGS_H

/*
 * Toolkit Messages
 */

#ifdef OLD
#define RtMESSAGE       2 /* Data Item				      */
#define RtRELEASE_DATA  3 /* Direct the object to release its content */

#define RtADD_RECEPTOR  4 /* plug object			      */
#define RtACTIVATE      6 /* force the invocation of the Activate     */ 
                          /* Method                                   */
#define RtRESET         8 /* Reset object			      */
#define RtSET_VALUE     9 /* Set the value of a resource              */
#define RtADD_CONVERSION 10 /* Message conversion		      */
#define RtADD_ID_CONVERSION 11 /* Message conversion		      */
#define RtDISABLE 12 	  /* disable the object		      	      */
#define RtENABLE 13	  /* enable the object		              */
#define RtADD_OBJECT   14 /* Add a subobjet to a container object     */
#define RtWIDGET_SET_XT_RESOURCE 15
#define RtCLEAR		16
#define RtINITIALIZE_CLASS 50
#define RtOBJ_TO_STRING	20 /* Convert to string			      */
#define RtSTRING_TO_OBJ	21 /* Convert from string 		      */
#endif

/*
 * Core Messages
 */
#define RtSET_VALUE     1 /* Set the value of a resource              */
#define RtDISABLE 	2 /* disable the object		      	      */
#define RtENABLE 	3 /* enable the object		              */
#define RtWIDGET_SET_XT_RESOURCE 4
#define RtACTIVATE      5 /* force the invocation of the Activate     */ 
                          /* Method                                   */
#define RtMATCH		6 
#define RtDESTROY	7
#define RtSTOP		8

/*
 * Broadcaster messages
 */
 
#define RtADD_RECEPTOR  50 /* plug object			      */
#define RtRESET         51 /* Reset object			      */
#define RtADD_CONVERSION 52 /* Message conversion		      */
#define RtADD_ID_CONVERSION 53 /* Message conversion		      */

/*
 * Conversions
 */
 
#define RtOBJ_TO_STRING	80 /* Convert to string			      */
#define RtSTRING_TO_OBJ	81 /* Convert from string 		      */

#define RtADD_OBJECT   95 /* Add a subobjet to a container object     */

/*
 * 
 */
 
#define RtMESSAGE       100 /* Data Item				      */
#define RtRELEASE_DATA  101 /* Direct the object to release its content */
#define RtCLEAR		102
#define RtPRINT_OBJECT	103 
#define RtVALIDATE	104
#define RtBROADCAST_MESSAGE	105

#define RtRESERVED_IDS	1000 /* 1000 ids reserved for internal	      */
			     /* messages (0-999)		      */

#define RtINTERNAL_MSG_RANGE_MAX	100



/*
 * Error messages (-1 is reserved for the systems calls)
 */

#define RtNOT_ENOUGH_MEMORY	-2	/* no enough memory 	      */
#define RtINVALID_RESOURCES	-3	/* Invalid object resource    */
#define RtINVALID_PARAMETERS	-4	/* Invalid parameters passed  */
					/* to internal function	      */
#define RtINVALID_RESOURCE_TYPE -5
#define RtINTERNAL_ERROR	-6	/* internal error	      */
#define RtREQUIRED_RESOURCE	-7	/* resource value required    */
#define RtINVALID_VALUE		-8	/* invalid resource value     */

/*
 * Status values
 */

#define RtGREATER_THAN		2
#define RtLESS_THAN		3

 
/*
 * Dialog buttons
 */
 
#define RtOK_BUTTON		1
#define RtCANCEL_BUTTON		2
#define RtHELP_BUTTON		3


/*
 * Resource types
 */
 
#define RtINT_TYPE       1       /* integer */
#define RtSTRING_TYPE    2       /* string  */
#define RtPOINTER_TYPE	 3	 /* generic pointer */
#define RtTIME_TYPE	 4	 /* time_t type */
#define RtUID_TYPE	 5	 /* uid_t type */
#define RtOBJ_TYPE	 6	 /* Obj type */
#define RtBIT_TYPE	 7	 /* Bit type */
#define RtXMSTRING_TYPE	 8	 /* XmString */
#define RtSUBOBJ_TYPE	 9

/*
 * Resource flags 
 */

#define RtWidgetXtResource	1	/* Widget resource 	   */
#define RtInvokeClassGetValue	2	/* Invoke class get value  */
#define RtRES_REQUIRED		4	/* Resource value required */
#define RtRES_PRINTING		8	/* check for garbage       */
#define RtRES_DEL_TRAILING_SPACES 16	/* delete trailing spaces  */
#define RtRES_DEL_LEADING_SPACES 32	/* delete leading spaces   */
#define RtRES_SINGLE_WORD 64		/* single word  	   */
#define RtRES_INTERNAL 128		/* internal resource	   */

#endif
