/*
 * Freedom Desktop 
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#ifndef _RT_H
#define _RT_H

#include <sys/types.h>
#include <stdlib.h>
#include <errno.h>
#include <stdio.h>
#include <ctype.h>

#include "RtStrings.h"
#include "ObjCore.h"
#include "ResourceLink.h"
#include "Message.h"
#include "Broadcaster.h"

Obj  RtCreateObject (); 
ObjClass xx_rt_set_resource ();
void RtInitializeObject ();
RtResource *RtGetPResource ();
Obj RtCloneObject ();
void RtCopyObject ();
extern MessageObj stdmsg;

extern char *_strconcat (); 

#ifdef DEBUG
#define xxValidateObject(obj) RtValidateObject (obj)
#else
#define xxValidateObject(obj) ;
#endif

#define RtSetValue(obj,res,value) \
{ \
Obj xx_new;\
ObjClass class; \
int xxbool = 0; \
ObjClass subclass; \
   xxValidateObject(obj); \
   if (obj && res) { \
   	class = obj->core.object_class; \
   	xx_new = (Obj) malloc (class->core_class.object_size); \
   	if (xx_new && obj) {\
      	   memcpy (xx_new, obj, class->core_class.object_size);\
      	   xx_new->core.self = xx_new;\
	   subclass = xx_rt_set_resource (xx_new, res, value); \
      	   if (subclass) \
       	   	RtSetObjectValues (subclass, obj, xx_new);\
       	   obj->core.self = (Obj) obj;\
   	}\
   } \
}



#define RtGetValue(obj,res,value_pointer) \
{ \
Obj xx_new;\
ObjClass class; \
   xxValidateObject(obj); \
   if (obj) \
     class = (obj)->core.object_class; \
   if (class && obj) { \
     xx_new = (Obj) (obj);\
     xx_rt_get_resource (obj, res, value_pointer); \
   } \
}

	
#define RtCreateMessage()       ((MessageObj) RtCreateObject (NULL, messageObjClass))

#define RtUpdateString(current,new) \
{ \
   if (current != new) {\
        new  = new ? strdup(new):NULL; \
        if (current) { \
           free (current); \
           current = NULL; \
        } \
   } \
}

#define RtUpdateArgv(current,new) \
{ \
   if (current != new) {\
        new  = (new) ? argv_clone (new):NULL; \
        if (current) { \
           argv_free (current); \
           current = NULL; \
        } \
   } \
}

#define RtDestroyString(str) \
{ \
   if (str) {\
   	free (str); \
	(str) = NULL; \
   } \
} 

#ifdef _NO_RESOURCES
/* obsolete */
#define RtGetValue(obj,res,value_pointer) \
{ \
Obj new;\
ObjClass class; \
   class = (obj)->core.object_class; \
   if (class && obj) { \
     new = (Obj) (obj);\
     *value_pointer = 0;\
     if (!class->core_class.resources) \
     	*value_pointer = res; \
     else \
     	xx_rt_get_resource (obj, res, value_pointer); \
   } \
}
#define RtSetValue(obj,res,value) \
{ \
Obj new;\
ObjClass class; \
   if (obj || !res) { \
   	class = obj->core.object_class; \
   	new = (Obj) malloc (class->core_class.object_size); \
   	if (new && obj) {\
      	   memcpy (new, obj, class->core_class.object_size);\
      	   res = value; \
       	   RtSetObjectValues (obj, new);\
   	}\
   } \
}
#endif

/*
 * RtOffset - Borrowed from the X system
 */

#if defined(CRAY) || defined(__arm)
#if __STDC__
#define RtOffset(p_type,field) _Offsetof(p_type,field)
#else
#ifdef CRAY2
#define RtOffset(p_type,field) \
	(sizeof(int)*((unsigned int)&(((p_type)NULL)->field)))

#else	/* !CRAY2 */

#define RtOffset(p_type,field) ((unsigned int)&(((p_type)NULL)->field))

#endif	/* !CRAY2 */
#endif  /* __STDC__ */
#else	/* ! (CRAY || __arm) */

#define RtOffset(p_type,field) \
	((((char *) (&(((p_type)NULL)->field))) - ((char *) NULL)))

#endif /* !CRAY */
  	

/*
 * RtNumber: number of elements in the array
 */
 
#define RtNumber(arr) (sizeof(arr)/sizeof (arr[0]))


#endif
