/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * Object core - All the other objects are a subclass of this one
 */


#ifndef OBJ_CORE_H
#define OBJ_CORE_H

#include "RtStrings.h"

typedef struct _ObjRec *Obj;
typedef struct _ObjClassRec *ObjClass;

/*
 * Object resources
 */
 
typedef struct _RtResource {
    char *name;		/* resource name			*/
    char *class;	/* resource class			*/
    int  type;		/* resource type			*/
    unsigned int  size;	/* resource size			*/
    unsigned int offset;/* location of the resource inside the  */
    			/* object				*/
    int  default_type;	/* will be converted to resource type   */
    void *default_address; /* address of default value          */
    int flags;		/* resource flags			*/
    char *client;	
} RtResource;

#ifdef OLD
/*
 * Resource link
 */
  
typedef struct _RtResourceLink {
   Obj obj1;
   char *res;
   char *res1;
} *RtResourceLink;
#endif

/*
 * Links table
 */
typedef struct _RtLinksTbl {
#ifdef OLD
   RtResourceLink rlink_list;
#endif
   Obj *rlink_list;
   int max_cnt;
   int index;
} *RtLinksTbl;
    

/*
 * Object class part
 */
 
typedef struct _ObjCoreClassPart {
    ObjClass	  superclass;	    /* pointer to the superclass */
    char 	  *class_name;	    /* class name                */
    void          (*class_initialize) ();
    int		  class_inited; 
    RtResource	  *resources;	   /* class resources           */ 
    int		  num_resources;   /* number of resources       */  
    size_t        object_size;	   /* size in bytes of object   */
    /* class methods */
    void          (*initialize) ();
    int	  	  (*realize) ();
    void	  (*get_values) ();
    void	  (*set_values) ();
    void	  (*activate) ();
    void	  (*destroy) ();
    void	  (*process_message) ();
    char	  *prefix;	  /* resource prefix user for   */
    				  /* fast access		*/
    char	  *version;	  /* Object version		*/
    char	  *client;
} ObjCoreClassPart;

/*
 * Object class record
 */
 
typedef struct _ObjClassRec {
    ObjCoreClassPart core_class;
} ObjClassRec;

extern  ObjClassRec   	objClassRec;
extern  ObjClass 	objClass;

/*
 * Object core part
 */
 
typedef struct _ObjCorePart {
    Obj	    	self;		/* pointer to the object itself      */
    char	*object_name;	/* object name			     */
    RtLinksTbl  rlinks; 	/* links to other resources          */
    int		object_flags;	/* object flags			     */ 			
    ObjClass	object_class;	/* pointer to object's ClassRec	     */
    Obj		parent_object;	/* pointer to the parent object	     */
    Obj		obj_stdout;	/* stdout object. Messages are       */
    				/* sent to this object by default    */
    Obj		obj_stderr;	/* stderr object. error messages and */
    				/* warnings are sent to this object  */
    				/* by default.  		     */
    Obj		obj_stdin;	/* stdin  object input is received   */
    				/* from this object by default.	     */
    char	*obj_output;	/* Output 		             */
    int		status;		/* Object status		     */
} ObjCorePart;

/*
 * Object core
 */
 
typedef struct _ObjRec {
    ObjCorePart core;
} ObjRec;

/*
 * Resources
 */
 
#ifdef _NO_RESOURCES
#define RtparentObject  ((Obj)(new))->core.parent_object
#define RtNstdOutput  ((Obj)(new))->core.output_object
#define RtNobjStderr  ((Obj)(new))->core.obj_stderr
#define RtNstatus   ((Obj)(new))->core.status 
#define RtNobjectName ((Obj)(new))->core.object_name /* Create memory */
#define RtNchained ((Obj)(new))->core.chained
#define RtNbusy ((Obj)(new))->core.busy
#define RtNrealized ((Obj)(new))->core.realized
#else
#define RtNobjName		"objName"
#define RtNobjStatus		"objStatus"
#define RtNobjParent		"objParent"
#define RtNobjClass		"objClass"
#define RtNobjStderr		"objStderr"
#define RtNobjStdin		"objStdin"
#define RtNobjStdout		"objStdout"
#define RtNobjAutoRealize	"objAutoRealize"
#define RtNobjChained		"objChained" 
#define RtNobjRealized 		"objRealized"
#define RtNobjOutput 		"objOutput"
#endif

/*
 * Object flags
 */
 
#define RtOBJ_DISABLED				1
#define RtOBJ_REALIZED				2
#define RtOBJ_AUTO_REALIZE			4
#define RtOBJ_BUSY				8
#define RtOBJ_CHAINED				16	
#define RtOBJ_SUPERCLASS_PROCESS_MESSAGE	32
#define RtOBJ_DESTROYED				64
#define RtOBJ_STOPPED				128

#define LTBL_CHUNK_SIZE		2

#endif

 
