/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * File Object: object used to manipulate files/directories
 */
 

#ifndef XFILE_H
#define XFILE_H

#include <fcntl.h>
#if defined(SYSV) || defined(SVR4)
#include <string.h>
#else
#include <strings.h>
#endif
#include "Rt.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <utime.h>
#include <errno.h>

/*
 * Macros and definitions
 */


typedef struct _FileClassPart {
    int foo;  
} FileClassPart;

typedef struct _FileClassRec {
    ObjCoreClassPart core_class;
    FileClassPart file_class;
} FileClassRec;

extern  FileClassRec   fileClassRec;
extern  ObjClass fileObjClass;


typedef struct _FilePart {
   char *path;                  /* File/Directory path 		     */
   char *dir;                   /* Parent directory 		     */
   char *basename;              /* Last component of the file name   */
                                /* Set either path or dir & basename */         
   struct stat st;              /* file status 			     */
   int fd;                      /* File Descriptor 		     */
   FILE *fp;			/* File pointer			     */
   int open_flags;		/* flags for the open system call    */
   int strip_newlines;		/* remove newlines from output       */
   				/* messages			     */
   int db_file;			/* database file		     */ 
} FilePart;

/*
 * File record
 */
typedef struct _FileRec {
   ObjCorePart core;
   MessagePart message;
   BroadcasterPart broadcaster;
   FilePart file;
} FileRec;

typedef FileRec         *FileObj;
typedef FileClassRec    *FileObjClass;

/*
 * Object messages
 */
 
#define RtFILE_STAT             500     /* Get the stat information             */
#define RtFILE_OPEN             501     /* Open the file                        */
#define RtFILE_CHMOD            502     /* Change the mode of the file          */
#define RtFILE_UTIME            503     /* Change the modification and the access */
                                        /* time of a file                       */
#define RtFILE_CHOWN            504     /* Change owner and group               */
#define RtFILE_APPEND_NAME      505     /* Append file name to path             */
#define RtFILE_EXISTS           506     /* Check if the file already exists     */
#define RtFILE_IS_DIRECTORY     507     /* Check if the file is a directory     */
#define RtFILE_DIRNAME          508     /* Sets the dir resource with all but   */
                                        /* the last level of the path name      */
#define RtFILE_WRITABLE_BY      509     /* Determines if a file is writable by  */
                                        /* a specific user                      */
#define RtFILE_RENAME           510     /* Rename a file                        */                                      
#define RtFILE_PATH_APPEND      511     /* Append to the path                   */
#define RtFILE_VALVE_IS_DIRECTORY 512	/* Act as a valve. Allow the flow of directories */ 
#define RtFILE_READ_LINES	513	/* Read the file line by line		*/
#define RtFILE_READ_LINE        514     /* Read one line of the file            */
#define RtFILE_WRITE_LINE       515     /* write into the file one line at a time*/
#define RtFILE_UNLINK           516     /* unlink the file                      */
#define RtFILE_BASENAME		517	/* Updates the basename resource        */
/*
 * Object resources
 */

#ifdef _NO_RESOURCES 
#define RtNfileDirectory (((FileObj)(new))->file.dir)
#define RtNfilePath (((FileObj)(new))->file.path)
#define RtNfileUid (((FileObj)(new))->file.st.st_uid)
#define RtNfileGid (((FileObj)(new))->file.st.st_gid)
#define RtNfileMode (((FileObj)(new))->file.st.st_mode)
#define RtNfileAccessTime (((FileObj)(new))->file.st.st_atime)
#define RtNfileModificationTime (((FileObj)(new))->file.st.st_mtime)
#define RtNfileChangeTime (((FileObj)(new))->file.st.st_ctime)
#define RtNfileOpenFlags (((FileObj)(new))->file.open_flags)
#define RtNfileDbFile (((FileObj)(new))->file.db_file)
#else
#define RtNfileDirectory "fileDirectory"
#define RtNfileBasename "fileBasename"
#define RtNfilePath "filePath"
#define RtNfileUid "fileUid"
#define RtNfileGid "fileGid"
#define RtNfileMode "fileMode"
#define RtNfileAccessTime "fileAccessTime"
#define RtNfileModificationTime "fileModificationTime"
#define RtNfileChangeTime "fileChangeTime"
#define RtNfileOpenFlags "fileOpenFlags"
#define RtNfileDbFile "fileDbFile"
#endif

#define MAXFLINE	1024 

/*
 * Error messages
 */

#define RtFILE_INVALID_PATH		-100
 

/*
 * Flags (object messages)
 */

#define RtFILE_CLOSE    1       /* Close the file after processing */
                                /* each message                    */
#define RtFILE_STRIP_NEW_LINES	2 /* Strip newlines from each      */
				  /* input/output line             */    
#endif

