/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

#ifndef _DATA_BASE_H
#define _DATA_BASE_H

#include <string.h>
#include "List.h"
#include "File.h"
#include "Error.h"

typedef struct _DataBaseClassPart {
    int foo;  
} DataBaseClassPart;

typedef struct _DataBaseClassRec {
    ObjCoreClassPart core_class;
    DataBaseClassPart data_base_class;
} DataBaseClassRec;

extern  DataBaseClassRec   dataBaseClassRec;
extern  ObjClass dataBaseObjClass;

typedef struct _DataBasePart {
  ObjClass  obj_class;	/* object class stored in the database	      */
  Obj  obj;
  Obj  current;		/* Current object (use for retrieval          */
  			/* operations)				      */
  int  current_pos;	/* position of the current element	      */
  size_t  obj_size;	/* object size				      */
  char *key;		/* resource used as the database key	      */  
  char separator;	/* field separator			      */ 
  int db_flags;
  int cnv_msg;
  Obj list;
  time_t timestamp;	/* time stamp, updated after each modification*/
} DataBasePart;

/*
 * Record
 */

typedef struct _DataBaseRec { 
   ObjCorePart core;
   MessagePart message;
   BroadcasterPart broadcaster;
   FilePart file;
   DataBasePart db;
} DataBaseRec;


typedef DataBaseRec  		*DataBaseObj;
typedef DataBaseClassRec	*DataBaseObjClass;

#define RtDB_CHUNK_SIZE		10 

#define RtDB_LOAD		2500
#define RtDB_LOAD_LINE		2501
#define RtDB_RETRIEVE_BY_KEY	2502
#define RtDB_DUMP		2503
#define RtDB_EDIT		2504
#define RtDB_REMOVE		2505
#define RtDB_ADD		2506
#define RtDB_TRAVERSE		2507
#define RtDB_CLEAR		2508
#define RtDB_DROP		2509
#define RtDB_OUT_OF_SYNC	2510

#define RtDB_INVALID_RESOURCE_TYPE	2

#define RtNdbObjClass 	"dbObjClass"
#define RtNdbObj      	"dbObj"
#define RtNdbKey      	"dbKey"
#define RtNdbCurrent  	"dbCurrent"
#define RtNdbCurrentPos	"dbCurrentPos"
#define RtNdbCnvMsg	"dbCnvMsg"
#define RtNdbBroadcastRecord "dbBroadcastRecord" /* broadcast the */
			/* affected record after each operation      */
#define RtNdbDestroyObjects "dbDestroyObjects"
#define RtNdbOutOfSync	"dbOutOfSync"
#define RtNdbLoaded	"dbLoaded"

/* Flags */

#define RtDB_BROADCAST_RECORD	1
#define RtDB_DESTROY_OBJECTS	2
#define RtDB_LOADED		4

/* Error codes */

#define RtDB_OBJECT_NOT_FOUND		-2500
#define RtDB_OBJECT_ALREADY_EXISTS	-2501
#define RtDB_INVALID_KEY		-2502
#define RtDB_INVALID_INPUT		-2503
	
#endif
