/*
 * Freedom Desktop
 * Copyright 1994 by Freedom Software
 *
 * Freedom Software retains all rights to Freedom Desktop (hereafter Software)
 * in binary and in source code form.
 *
 * The commercial use of this Software shall be governed by a separate License
 * agreement. Any individual or institution wishing to make commercial use of
 * the Software must sign a license agreement with Freedom Software. In such
 * cases, the Licensee agrees to abide by the terms contained in the License
 * Agreement and not those contained in this document. Examples of commercial
 * use include (without limitation): (i) integration of the Software (source
 * code form), in whole or in part, into a commercial product sold by or on
 * on behalf of the Licensee; (ii) distribution of the Software (binary form or
 * source code form) in combination with a commercial product sold by or on
 * behalf of the Licensee.
 *
 * Freedom Software (Licensor) grants you (Licensee) a license: (i) to use,
 * copy and make changes and improvements to this Software for licensee's
 * internal business purposes; (ii) to use, copy, and distribute this Software
 * or the derivative works provided that the copyright notice and this
 * permission notice appear on all copies and that NO CHARGE is associated
 * with such copies. However, if Licensee distributes any derivative work
 * based on the Software, then Licensee shall (i) notify Licensor in writing
 * (ii) clearly state that such derivative work is a modified and not the
 * original Freedom Desktop distributed by Freedom Software (iii) publish
 * the corresponding machine-readable source code or information as to
 * where it may be obtained. Each time Licensee redistribute the Software
 * or any derivative work, the recipient automatically agrees to abide
 * by the same terms as the Licensee. Licensee may not impose terms
 * more restrictive than the terms granted herein.
 *
 * By using, copying, modifying or distributing this Software (or any
 * derivative work based on this Software) Licensee indicates acceptance
 * of the terms and conditions set forth in this License.
 *
 * Licensor reserves the right to terminate this License immediately on written
 * notice, for material breach by the Licensee.
 *
 * FREEDOM SOFTWARE DISCLAIMS ALL WARRANTIES EXPRESS OR IMPLIED WITH REGARD
 * TO THIS SOFTWARE INCLUDING BUT NOT LIMITED TO ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND  FITNESS,  IN  NO  EVENT  SHALL LICENSOR BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTUOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE
 */

/*
 * Command: object used to execute Unix commands. This object
 *          handles signals and error messages. Based in code
 *	    taken from Nedit. 
 */
 
#ifndef _COMMAND_H
#define _COMMAND_H
#include "Rt.h"
#include "MessageDialog.h"
#include "SignalHandler.h"
#include "Cursor.h"
#include <fcntl.h>
#include <errno.h>
#include <sys/wait.h>
#include <sys/param.h>

#define EBUFSIZ	128

#define _CMDSIZE	(sizeof (CommandRec))



typedef struct _CommandClassPart {
    int foo;  
} CommandClassPart;

typedef struct _CommandClassRec {
    ObjCoreClassPart core_class;
    CommandClassPart dialog_class;
} CommandClassRec;

extern  CommandClassRec   commandClassRec;
extern  ObjClass commandObjClass;

/*
 * Command Part
 */
 
typedef struct _CommandPart {
  char *cmd_name;
  char *cmd_string;		/* Command string	*/
  char *cwd;			/* Current working directory */
  char saved_cwd[MAXPATHLEN];		
  char **argv;
  Obj sig_handler;
  int stdout_fd;
  int child_stdout_fd;
  int stdin_fd;
  int child_stdin_fd;
  int stderr_fd;
  int child_stderr_fd;
  int child_pid;
  char *src_path;
  char *single_path;	/* Path of a single file		     */
  char *dest_path;	/* Destination path provided by the user     */
  
  char *target_path;
  int  wait_pid;	/* Wait until the command is done 	     */
  char *trash_path;	/* Path to the trash directory 		     */
  MessageDialogObj  message_dialog;	/* Object used to display warnings and error
  			   messages */
  int process_xevents;	/* Process X events while waiting	     */
  Widget widget;
  int flags;		/* flags				     */
  int status;		/* Process returned status(obsolete)	     */
  int confirm_remove;
  int restore_signals;	/* Signals need to be restored		     */
  Obj cursor;		/* Cursor object			     */
  int default_button;	/* default button - testing purposes only    */
  int shell_unsensitive;/* Make the shell unsensitive during the     */
  			/* execution of the command    		     */
} CommandPart;

/*
 * Record
 */

typedef struct _CommandRec { 
   ObjCorePart core;  
   CommandPart cmd;
} CommandRec;


typedef CommandRec  		*CommandObj;
typedef CommandClassRec		*CommandObjClass;

/*
 * Messages
 */

#define RtCMD_COPY_FILES   1000 /* Copy files			*/
#define RtCMD_MOVE_FILES   1001 /* Move src to target 		*/
#define RtCMD_EXECUTE	   1002 /* Execute command    		*/
#define RtCMD_TRASH_FILES  1003 /* Trash files       		*/
#define RtCMD_REMOVE_FILE  1004 /* Remove File        		*/
#define RtCMD_EMPTY_TRASH  1005 /* Empty Trash       		*/
#define RtCMD_OUTPUT	   1006 /* Command output		*/

/* Flags 		*/

#define RtCMD_SHELL		1
#define RtCMD_STDERR_IS_STDOUT	2
#define RtCMD_BROADCAST_STDOUT	4
#define RtCMD_STDOUT_UNBUFFERED 8  /* read stdout one character at a time */

/* Abnormal termination - Does not handle stopped processes */
#define abnormal(status) (WIFEXITED (status) ? WEXITSTATUS(status) : 1) 

/*
 * Resources
 */
 
#ifdef _NO_RESOURCE
#define RtNcmdWaitPid	((CommandObj)(new))->cmd.wait_pid
#define RtNcmdString	((CommandObj)(new))->cmd.cmd_string
#define RtNcmdWidget	((CommandObj)(new))->cmd.widget
#define RtNcmdMessageDialog	((CommandObj)(new))->cmd.message_dialog
#define RtNcmdTrashPath	((CommandObj)(new))->cmd.trash_path
#define RtNcmdSrcPath	((CommandObj)(new))->cmd.src_path
#define RtNcmdDestPath	((CommandObj)(new))->cmd.dest_path
#define RtNcmdArgv	((CommandObj)(new))->cmd.argv
#define RtNcmdStatus	((CommandObj)(new))->cmd.status /* check */
#define RtNcmdCwd	((CommandObj)(new))->cmd.cwd
#define RtNcmdFlags	((CommandObj)(new))->cmd.flags
#define RtNcmdDefaultButton	((CommandObj)(new))->cmd.default_button
#define RtNshellUnsensitive ((CommandObj)(new))->cmd.shell_unsensitive
#else
#define RtNcmdWaitPid		"cmdWaitPid"
#define RtNcmdString		"cmdString"
#define RtNcmdWidget		"cmdWidget"
#define RtNcmdMessageDialog	"cmdMessageDialog"
#define RtNcmdTrashPath		"cmdTrashPath"
#define RtNcmdSrcPath		"cmdSrcPath"
#define RtNcmdDestPath		"cmdDestPath"
#define RtNcmdArgv		"cmdArgv"
#define RtNcmdStatus		"cmdStatus"
#define RtNcmdCwd		"cmdCwd"
#define RtNcmdFlags		"cmdFlags"
#define RtNcmdDefaultButton	"cmdDefaultButton"
#define RtNshellUnsensitive 	"shellUnsensitive"
#define RtNcmdStderrIsStdout	"cmdStderrIsStdout"
#define RtNcmdBroadcastStdout	"cmdBroadcastStdout"
#define RtNcmdStdoutUnbuffered	"cmdStdoutUnbuffered"
#endif

/* 
 * Error an warning codes
 */

#define RtCMD_COPY_CANCELLED		100 
#define RtCMD_INVALID_ARGUMENTS		101
#define RtCMD_NOT_SUCH_DIRECTORY	102
#define RtCMD_FILE_DOES_NOT_EXISTS	103
#define RtCMD_MOVE_CANCELLED		104
#define RtCMD_CANCELLED			105 

#endif
