/* 
 * Copyright (C) 1995 Andrew Scherpbier <Andrew@sdsu.edu>
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "forms.h"
#include "xrplay.h"
#include "state.h"
#include "vu.h"

typedef struct
{
	FL_OBJECT	*block;
	int			color;
	int			current_color;
} Block;

static Block	vu_l[13];
static Block	vu_r[13];
static int		old_left = 0;
static int		old_right = 0;

/********************************************************************
 * Create the VU meter below the slider.
 */
void create_vu_meter()
{
	int			i;
	for (i = 0; i < 13; i++)
	{
		vu_r[i].block = fl_add_box(FL_DOWN_BOX, i * 10 + 145, 80, 10, 10, "");
		vu_l[i].block = fl_add_box(FL_DOWN_BOX, 125 - i * 10, 80, 10, 10, "");
		fl_set_object_bw(vu_l[i].block, -1);
		fl_set_object_bw(vu_r[i].block, -1);
		vu_r[i].current_color = FL_MCOL;
		vu_l[i].current_color = FL_MCOL;
	}
	for (i = 0; i < 8; i++)
	{
		vu_r[i].color = FL_GREEN;
		vu_l[i].color = FL_GREEN;
	}
	for (i = 8; i < 11; i++)
	{
		vu_r[i].color = FL_YELLOW;
		vu_l[i].color = FL_YELLOW;
	}
	for (i = 11; i < 13; i++)
	{
		vu_r[i].color = FL_RED;
		vu_l[i].color = FL_RED;
	}
}


/********************************************************************
 * Set the vu meter colors according to the levels given.
 * The levels range from 0 to 255 so we have to scale it into our 13 block
 * range first...
 */
void set_vu(int left, int right)
{
	int		i, left_level, right_level;

	left_level = left;
	right_level = right;
		
	left *= 13;
	left >>= 8;
	right *= 13;
	right >>= 8;

	if (left_level && left == 0)
		left = 1;
	if (right_level && right == 0)
		right = 1;

	if (left == old_left && right == old_right)
		return;

	old_left = left;
	old_right = right;

	for (i = 0; i < 13; i++)
	{
		if (left > i)
		{
			if (vu_l[i].color != vu_l[i].current_color)
			{
				fl_set_object_color(vu_l[i].block, vu_l[i].color, FL_MCOL);
				vu_l[i].current_color = vu_l[i].color;
			}
		}
		else if (vu_l[i].color != FL_MCOL)
		{
			fl_set_object_color(vu_l[i].block, FL_MCOL, FL_MCOL);
			vu_l[i].current_color = FL_MCOL;
		}
		if (right > i)
		{
			if (vu_r[i].color != vu_r[i].current_color)
			{
				fl_set_object_color(vu_r[i].block, vu_r[i].color, FL_MCOL);
				vu_r[i].current_color = vu_r[i].color;
			}
		}
		else if (vu_r[i].color != FL_MCOL)
		{
			fl_set_object_color(vu_r[i].block, FL_MCOL, FL_MCOL);
			vu_r[i].current_color = FL_MCOL;
		}
	}
}

/*
 * Local variables:
 * tab-width: 4
 * End:
 */
