/* 
 * Copyright (C) 1995 Andrew Scherpbier <Andrew@sdsu.edu>
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "state.h"
#include "forms.h"
#include "xrplay.h"

#include <stdarg.h>

extern FD_xrplay	*fd_xrplay;

/********************************************************************
 * Set the gray state of an object.
 */
static void set_object_gray_state(FL_OBJECT *obj, int state)
{
	if (state)
	{
		fl_set_object_lcol(obj, FL_BLACK);
	}
	else
	{
		fl_set_object_lcol(obj, FL_INACTIVE);
	}
}


/********************************************************************
 * Set the gray state of the play button.
 */
void play_button_state(int state)
{
	if (state)
	{
		fl_set_object_color(fd_xrplay->action_start, FL_COL1, FL_BLACK);
		fl_activate_object(fd_xrplay->action_start);
		fl_set_button_shortcut(fd_xrplay->action_start, "\r", 0);
	}
	else
	{
		fl_set_object_color(fd_xrplay->action_start, FL_COL1, FL_INACTIVE);
		fl_deactivate_object(fd_xrplay->action_start);
		fl_set_button_shortcut(fd_xrplay->action_start, "", 0);
	}
}


/********************************************************************
 * Set the gray state of the bottom buttons according to the parameters given.
 */
void set_gray_state(int n_playing, int n_paused)
{
	int	enable = 0;

	if (n_playing)
		n_playing = 1;
	if (n_paused)
		n_paused = 1;

	enable = n_playing || n_paused;

	/*
	 * Since we know the existing status of the buttons from the state structure,
	 * we only have to change things if really needed.
	 */
	if (n_playing != state.is_playing || n_paused != state.is_paused)
	{
		state.is_playing = n_playing;
		state.is_paused = n_paused;
		if (enable)
		{
			fl_activate_object(fd_xrplay->bitmap_buttons);
			fl_set_button_shortcut(fd_xrplay->action_skip_back, "bB", 0);
			fl_set_button_shortcut(fd_xrplay->action_pause_play, "pP", 0);
			fl_set_button_shortcut(fd_xrplay->action_stop, "sS", 0);
			fl_set_button_shortcut(fd_xrplay->action_skip_forward, "fF", 0);
		}
		else
		{
			fl_deactivate_object(fd_xrplay->bitmap_buttons);
			fl_deactivate_object(fd_xrplay->action_stop);
		}

		set_object_gray_state(fd_xrplay->action_skip_back, enable);
		set_object_gray_state(fd_xrplay->action_pause_play, enable);
		set_object_gray_state(fd_xrplay->action_stop, enable);
		set_object_gray_state(fd_xrplay->action_skip_forward, enable);
		fl_set_button(fd_xrplay->action_pause_play, n_paused);
	}
}


/********************************************************************
 * Show a message in the window
 */
void display_message(char *fmt, ...)
{
	va_list	args;
	char	string[1000];

	va_start(args, fmt);

	vsprintf(string, fmt, args);
	fl_set_object_label(fd_xrplay->message, string);
	fl_check_forms();
}


/********************************************************************
 * Create some hidden buttons so that we can attach shortcut keys to them
 */
void create_hidden_objects()
{
	FL_OBJECT	*obj;

	obj = fl_add_button(FL_HIDDEN_BUTTON, 10, 10, 10, 10, "");
		fl_set_button_shortcut(obj, "qQ", 0);
		fl_set_object_callback(obj, quit_cb, 0);
	obj = fl_add_button(FL_HIDDEN_BUTTON, 10, 10, 10, 10, "");
		fl_set_button_shortcut(obj, "+=>.", 0);
		fl_set_object_callback(obj, increase_volume_cb, 0);
	obj = fl_add_button(FL_HIDDEN_BUTTON, 10, 10, 10, 10, "");
		fl_set_button_shortcut(obj, "-_,<", 0);
		fl_set_object_callback(obj, decrease_volume_cb, 0);
}



/*
 * Local variables:
 * tab-width: 4
 * End:
 */
