/* 
 * Copyright (C) 1995 Andrew Scherpbier <Andrew@sdsu.edu>
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _sound_list_h_
#define _sound_list_h_

enum
{
	Use_play,
	Use_flow,
};


/*
 * The following structure is used to hold the sounds to be played
 * when sounds are specified on the command line
 */
struct sound_s
{
	char			*sound_name;
	int				sound_flow;
	int				sound_size;
	struct sound_s	*next;
	struct sound_s	*prev;
};

typedef struct sound_s	Sound;

extern Sound	*current_sound;

void sound_list_append(char *s);
Sound *next_sound();
Sound *previous_sound();
int all_play();

#endif

/*
 * Local variables:
 * tab-width: 4
 * End:
 */
