/* $XConsortium: rawplay.c /main/9 1996/12/30 16:35:40 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/


/*
 * xaplay.c
 *
 * XA client for playing audio files.
 *
 *
 *  @(#)xaplay.c	1.6 96/04/23   
*/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <malloc.h>
#include <unistd.h>
#include <string.h>

#include <Xa/Xafuncs.h>
#include <Xa/atomstrings.h>

const char *programName = "xaplay";

#ifdef sun
#define NO_USLEEP
#endif

int          fileFD;

void usage()
{
    printf ("usage: %s\n", programName);
    printf (" [-v] [-d<D>] [-b<S>] [-e<encoding>] [-r<rate>] [-c<channels>] [-w<sampleWidth in bits> <audio files ...>\n");
    printf ("\t\t-d<D>        D = integer debug noise level.\n");
    printf ("\t\t-v           verbose (debug = 1)\n");
    printf (" \t\t-b<S>      S = buffer size in milliseconds\n");
}


/* Debug noise levels */
int verbose = 0;
const int D_VERBOSE = 1;
#define VERBOSE (D_VERBOSE <= verbose)
const int D_NOISY = 50;
#define NOISY (D_NOISY <= verbose)
const int D_VNOISY = 100;
#define VNOISY (D_VNOISY <= verbose)

int rawMode = FALSE;


/* Read from file, write to port
   use the buffer paramaters given. */
static int 
readWrite(XaTag  file, XaAudio server, XaTag port, char *buff, int buffSize)
{
    
    static int bytesLeft = 0;
    CARD32     nBitsReturned;
    INT8       leftPad;
    int bytesRead;
    
    /*  fill buffer if we have too.*/
    if(bytesLeft == 0) {
	if(VNOISY) 
	    fprintf(stderr, "Refilling buffer.\n");
	
	if (rawMode)
	{
	bytesRead = read(fileFD, buff, buffSize); 
	if (bytesRead > 0)
	    bytesLeft = bytesRead;
	else
	    bytesLeft = 0;
	}
	else
	{
	    while (bytesLeft < buffSize)
	    {
		char *buffPtr = buff + bytesLeft;

		XaRead (server, file, 0, 0, 0, buffSize*8, &buffPtr, 
			&nBitsReturned, &leftPad, NULL);
		if (!nBitsReturned)
		    break;
		bytesLeft += nBitsReturned / 8; /* XXX mod 8-bit assumption */
	    }
	}
  	if (bytesLeft == 0)
	{
	    /* All done. */
	    if(VERBOSE)
	    {
		fprintf (stderr, "File finished.\n");
	    }
	    return 0;
	}
    }
    /* Play the buffer - all at once. */
    XaWrite(server, port, 0, XaAlastAccessTime, buff, bytesLeft * 8, 0, NULL);


    /* Make sure the requests have been processed. */
    /* XaPing(server, XaFalse, NULL); */

    
    bytesLeft = 0;
    return 1;
}


main( int argc, char *argv[])
{
    
    int          exitStatus = 0;
    /*
     * - Open a connectionto the server.
     * - Open the file
     * - Process local arguments.
     * - Create an output port
     * - funnel bits from the file to the port.
     * - shut down the connection.
    */


    /*
      Resources
     */
    XaTag        speaker;
    XaTag        format;
    XaAtom       atom;
    XaTag        file = XaTnone;
    int          bufferLength;
    int          sampleFrame;
    int		 bufferSamples;
    int		 samplesSent;
    int		 buffersSent = 0;
    int		 samplesPlayed;
    char        *buffer = NULL;
#ifdef NO_USLEEP
    int		 preLoadBufs = 1;
    int		 sleepSecs;
#else
    int		 preLoadBufs = 2;
#endif
    int		 preLoadSamples;
    int		 eof;

    /* Format resources */
    unsigned     sampleRate = 8000;
    unsigned     samplesPerUnit = 1;
    unsigned     channels;
    unsigned     dataSize;
    XaTag        encodingTag;
    XaTag        endian;
    char	 encodingName[16];
    char	 endianName[16];
    unsigned     bitsPerSample = 8;
    XaArgList    arglist;
    int          option;
    int          buffSizeMsecs = 1200;
    extern char *optarg;
    extern int   optind;
    char        *fileName;
    char         errString[256];
    XaAudio      audioServer;

    char bs[50];

    /* default values */
    sampleRate = 8000;
    samplesPerUnit = 1;
    bitsPerSample = 8;
    encodingTag = XaAencodeUlaw;
    strcpy(encodingName, "encodeUlaw");
    strcpy(endianName, "endianSmall");
    endian =
    dataSize =
    channels = 1;

    /* Open connection to the audio server. */
    /* This is done first to allow argv to be processed. */

    if((audioServer = XaOpenAudio(NULL, errString, &argc, argv)) == NULL) {
	fprintf (stderr, "Couldn't open XAudio connection: %s\n", errString);
	exit(-1);
    }
    
    /* Process local arguments.*/
    while( (option = getopt(argc, argv, "vb:d:e:r:c:w:p:")) != EOF) {
	switch(option) {
	case 'b':
	    buffSizeMsecs = atoi(optarg);
	    break;
	case 'v':
	    verbose = D_VERBOSE;
	    break;
	case 'd':
	    verbose = atoi(optarg);
	    break;
	case 'e':
	    strcpy(encodingName, optarg);
	    break;
	case 'r':
	    if (isdigit(optarg[0]))
		sampleRate = atoi(optarg);
	    else if (0==strcmp("aw", optarg))
		rawMode = TRUE;
	    break;
	case 'c':
	    channels = atoi(optarg);
	    break;
	case 'w':
	    bitsPerSample = atoi(optarg);
	    break;
	case 'p':
	    preLoadBufs = atoi(optarg);
	    break;
	case '?':
	    fprintf (stderr, "Don't know option: %c\n", (char)option);
	    usage();
	    XaCloseAudio(audioServer);
	    exit(1);
	}
    }


    /*  XXXXX should probably learn to process multiple files.*/
    if( optind >= argc) {
	fprintf (stderr, "No files to play\n");
	usage();
	exitStatus = -1;
	goto close;
    }
    fileName = argv[optind];

    encodingTag = XaFindAtom (audioServer, encodingName, FALSE, NULL);
    endian = XaFindAtom (audioServer, endianName, FALSE, NULL);

    if (!rawMode)
    {
	file = XaCreate(audioServer, XaNfile,
			XaNname, "client file object", NULL);
	if (file == XaTnone) {
	    fprintf (stderr, "Unable to create file object.\n");
	    exitStatus = -1;
	    goto close;
	}

	XaSet (audioServer, file, XaNpathName, fileName, 
			   XaNfileMode, XaAopenForRead, NULL);
	arglist = XaGet (audioServer, file, NULL, XaNpathName, XaNfileMode, 
			    XaNsampleRate, XaNsamplesPerUnit, 
			    XaNbitsPerSample, XaNencoding,
			    XaNendian, XaNdataSize, 
			    XaNnumChannels, NULL);
	if (!arglist) {
	  fprintf (stderr, "XaGet file attributes failed.\n");
	  exitStatus = -1;
	  goto close;
	}

	while (arglist->name) {
	  atom = XaFindAtom (audioServer, arglist->name, FALSE, NULL);
	  switch (atom) {
	  case XaApathName:
	    printf ("filename is %s\n", (char *)arglist->value);
	    break;
	  case XaAfileMode:
	    printf ("filemode is %d\n", (int)arglist->value);
	    break;
	  case XaAsampleRate:
	    sampleRate = (unsigned) arglist->value;
	    break;
	  case XaAsamplesPerUnit:
	    samplesPerUnit = (unsigned) arglist->value;
	    break;
	  case XaAbitsPerSample:
	    bitsPerSample = (unsigned) arglist->value;
	    break;
	  case XaAencoding:
	    encodingTag = (XaTag) arglist->value;
	    break;
	  case XaAendian:
	    endian = (unsigned)arglist->value; 
	    break;
	  case XaAdataSize:
	    dataSize = (unsigned) arglist->value;
	    break;
	  case XaAnumChannels:
	    channels = (unsigned) arglist->value;
	    break;
	  default:
	    break;
	  }
	  arglist++;
	}

    }
    else
    {
	/* raw mode */

	fileFD = open(fileName, O_RDONLY);
	if( fileFD == -1)
	{
	    fprintf (stderr, "Couldn't open file %s\n", fileName);
	    exitStatus = -1;
	    goto close;
	} else
	{
	    if(VERBOSE)
	    {
		fprintf (stderr, "Opened file: %s\n", fileName);
	    }
	}
	/* Read past the .au header. */
	/* lseek(fileFD, 25 ,SEEK_SET); */
    }
	
    /* Create a format 
     */
    format = XaCreate (audioServer, XaNformat,
		       XaNname, "format", NULL);
    if (format == NULL) {
	fprintf (stderr, "Couldn't create format object.\n");
	exitStatus = -1;
	goto manage;
    }
    
    /* Set attributes on this format
     */
    XaSet (audioServer, format, 
	   XaNencoding, encodingTag, 
	   XaNnumChannels, channels,
	   XaNbitsPerSample, bitsPerSample,
	   XaNsampleRate, sampleRate,
	   NULL);

    /* .... Create a a port to talk to ....
    // XXXXXX (As of now all ports are default output ports.)
    */
    speaker = XaCreate(audioServer, XaNport,
		       XaNformat, format,
		       XaNname, "speaker port", 
		       XaNrun, (void *)XaFalse, 
		       NULL);
    arglist = XaGet (audioServer, speaker, NULL, XaNformat, NULL);
    
    if( speaker == XaTnone) {
	fprintf (stderr, "Couldn't create speaker port.");
	exitStatus = -1;
	goto manage;
    } else {
	if(VERBOSE) {
	    fprintf (stderr, "Created speaker port with tag: %d\n", speaker);
	}
    }
    
    /* Calculate Sample Frame (a complete unit) */
    sampleFrame = channels * (bitsPerSample/8);

    /* Build a buffer. */
    bufferLength = sampleRate * (buffSizeMsecs / 1000.0) * sampleFrame;
    /* If bufferLength is not a multiple of the
       sampleFrame, then truncate to the closest.
       */
    if ((bufferLength % sampleFrame) != 0)
	bufferLength = bufferLength - (bufferLength % sampleFrame);
    bufferSamples = bufferLength / sampleFrame;

    if( (buffer = (char*)malloc(bufferLength)) == NULL) {
	fprintf (stderr, "Can't allocate a %d buffer.\n", buffSizeMsecs);
	exitStatus = -1;
	goto manage;
    }

	/*
    XaSet(audioServer, speaker,
	    XaNrun, (void *)XaTrue,
	    NULL);
	*/
    
    /* Loop until the file is finished */
    /* XXXXXXXXXXXXXXXX!!!!!!!!!!!!!!!!!!
    ** This should be changed to use events when they're ready.
    */
    samplesPlayed = 0;
    samplesSent = 0;

    preLoadSamples = bufferSamples * preLoadBufs;
    eof = FALSE;
    buffersSent = 0;

    while(buffersSent < preLoadBufs)
    {
	if (!readWrite(file, audioServer, speaker, buffer, bufferLength))
	{
	    eof = TRUE;
	    break;
	}
	if(VNOISY) 
	    fprintf (stderr, "Read/Write a buffer.\n");
    
	samplesSent += bufferSamples;
	if (samplesSent >= preLoadSamples)
	    break;
	buffersSent++;
    }
	
    XaSet(audioServer, speaker,
	    XaNrun, (void *)XaTrue,
	    NULL);

    /*
     * Need at least a slight overlap to avoid dropouts.
     */
    if (preLoadSamples == 0)
	preLoadSamples = bufferSamples/8;

    if (!eof)
    {
	while (readWrite(file, audioServer, speaker, buffer, bufferLength))
	{
	    if(VNOISY) fprintf (stderr, "Read/Write a buffer.\n");

	    samplesSent += bufferSamples;

	    while (samplesPlayed < (samplesSent - preLoadSamples))
	    {
		arglist = XaGet (audioServer, speaker, NULL, XaNoutputTimestamp,
				    NULL);
		/* atom = XaFindAtom (audioServer, arglist->name, FALSE, NULL);
		*/
		atom = (XaAtom)arglist->name;
		if (atom == XaAoutputTimestamp)
		{
		    int sleepUsecs;

		    samplesPlayed = (int)arglist->value;
		    if (samplesPlayed < (samplesSent - preLoadSamples))
		    {
			sleepUsecs =
				(samplesSent - preLoadSamples - samplesPlayed)
					* (1000000/sampleRate);
			if(VNOISY) 
			    fprintf(stderr,
				    "outputTimestamp %ld, sleeping %d usecs\n",
				    samplesPlayed, sleepUsecs);
#ifdef NO_USLEEP
			sleepSecs = (sleepUsecs + 500000)/1000000;
			if (sleepSecs == 0)
			    sleepSecs = 1;
			sleep(sleepSecs);
#else
			usleep(sleepUsecs);
#endif

		    }
		}
	    }
	}
	XaPing(audioServer, XaFalse, NULL);
    }

    /*
     * Now wait until it's done playing before exiting.
     */
    while (samplesPlayed < samplesSent)
    {
	arglist = XaGet (audioServer, speaker, NULL, XaNoutputTimestamp,
			    NULL);
	/* atom = XaFindAtom (audioServer, arglist->name, FALSE, NULL);
	*/
	atom = (XaAtom)arglist->name;
	if (atom == XaAoutputTimestamp)
	{
	    int sleepUsecs;

	    samplesPlayed = (int)arglist->value;
	    if (samplesPlayed < samplesSent)
	    {
		sleepUsecs = (samplesSent - samplesPlayed)
					* (1000000/sampleRate);
		if(VNOISY) 
		    fprintf(stderr,
			    "outputTimestamp %ld, sleeping %d usecs\n",
			    samplesPlayed, sleepUsecs);
#ifdef NO_USLEEP
		sleepSecs = (sleepUsecs + 500000)/1000000;
		if (sleepSecs == 0)
		    sleepSecs = 1;
		sleep(sleepSecs);
#else
		usleep(sleepUsecs);
#endif
	    }
	}
    }

    

    /* In lieu of exceptions we use the "evil goto"
     //     to help with maintenance and clean up.
     */
  manage:
    XaSet(audioServer, file, XaNcurrentSample, 367, NULL);
    if(VERBOSE) 
	fprintf (stderr, "Destroying objects in the server.\n");
    /* scanf("type something to quit: %s\n", bs); */
    if( speaker != XaTnone) {
	if(VERBOSE)  
	    fprintf (stderr, "Speaker port - %d\n", speaker);
	XaDestroy(audioServer, speaker);
    }
    if (file != XaTnone) {
	if (VERBOSE)
	    fprintf (stderr, "destroy file - %d\n", file);
        XaDestroy(audioServer, file);
    }
    
    
    if(VERBOSE) fprintf (stderr, "... Done.\n");
    
    /*  Close the connection ......*/
  close:    
    XaCloseAudio(audioServer);
    if(VERBOSE) fprintf (stderr, "Audio Conection Closed.\n");
    return exitStatus;
}
