/* $XConsortium: lib-test.cc /main/2 1996/12/30 16:35:34 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
 * Copyright (c) 1996 Digital Equipment Corporation
 * 
 * Digital Equipment Corporation makes no representations about
 * the suitability of this Software for any purpose.  The Software
 * is provided "as is" without express or implied warranty.
 */
/*
 * HISTORY
 * 	save intermediate work
 */
 /*
 * @(#)$RCSfile: lib-test.cc $ $Revision: /main/2 $ (DEC) $Date: 1996/12/30 16:35:34 $
 */

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <Xa/Xafuncs.h>
#include <Xa/atomstrings.h>




main (int argc, char* argv[])
{
    XaAudio conn;
    char 	errString[256];
    XaTag	tag;
    XaTag	defaultDevice;
    XaAtom	atom;
    Card32	nBitsReturned;
    Int8	leftPad;
    char	*readData;
    Card32	gainArray[4] = {1, 2, 3, 4};
    XaArgList	retArgList;

    fprintf(stderr,"Creating connection.\n");

    conn = XaOpenAudio(NULL, errString, &argc, argv);
    
    if (!conn)
    {
	fprintf(stderr, errString);
	exit(1);
    }

    XaFlush(conn);

    XaPing(conn, FALSE, NULL);

    tag = XaCreate(conn, XaNbuffer, "maxSize", 1024, XaNname,
		    "my-bucket", NULL);
    printf("Tag for buffer is %d\n", tag);
    atom = XaFindAtom(conn, "array", TRUE, NULL);
    printf("array atom is %d\n", atom);
    atom = XaFindAtom(conn, "XaParray", TRUE, NULL);
    printf("XaParray atom is %d\n", atom);
    atom = XaFindAtom(conn, "deviceAvailFormats", TRUE, NULL);
    printf("deviceAvailFormats atom is %d\n", atom);
    atom = XaFindAtom(conn, "XaAdeviceAvailFormats", TRUE, NULL);
    printf("XaAdeviceAvailFormats atom is %d\n", atom);


    atom = XaFindAtom(conn, "random string", TRUE, NULL);
    printf("random string atom is %d\n", atom);
    atom = XaFindAtom(conn, "random string", TRUE, NULL);
    printf("random string atom is %d\n", atom);
    atom = XaFindAtom(conn, "second random string", FALSE, NULL);
    printf("second random string atom is %d\n", atom);

    defaultDevice = XaFindAtom(conn, "XaNdefaultDevice", FALSE, NULL);
    printf("XaNdefaultDevice atom is %d\n", defaultDevice);

    tag = XaCreate(conn, XaNport, "XaNmaxSize", 1024, NULL);
    printf("Tag for port is %d\n", tag);

    XaDestroy(conn, tag);

    /* XaSet(conn, tag, "XaNmaxSize", 2048, XaNobjectName, "my-bucket",
	    "XaParray", 4, "XaNgain", gainArray, NULL);
    */
    atom = XaFindAtom(conn, XaNformat, TRUE, NULL);
    printf("XaNformat atom is %d\n", atom);

    atom = XaFindAtom(conn, XaNnumChannels, TRUE, NULL);
    printf("XaNnumChannels atom is %d\n", atom);

    atom = XaFindAtom(conn, XaNnumChannels, TRUE, NULL);
    printf("XaNnumChannels atom is %d\n", atom);

    atom = XaFindAtom(conn, XaNsampleRate, TRUE, NULL);
    printf("XaNsampleRate atom is %d\n", atom);

    tag = XaCreate(conn, XaNformat, "XaNencoding", XaAencodeUlaw,
		    XaNnumChannels, 2, XaNbitsPerSample, 8,
		    XaNsampleRate, 8000, NULL);

    printf("Tag for format is %d\n", tag);
    XaSet(conn, tag, "bitsPerSample", 16, XaNname, "my-format",
	    XaParray, 4, XaNgain, gainArray, XaNnumChannels, 2, NULL);

    retArgList = XaGet(conn, tag, NULL, "XaNmaxSize", XaNencoding,
				XaNname, "bitsPerSample",
				XaNnumChannels, NULL);
    if (retArgList)
	{
	printf ("Get results:\n");
	while (retArgList->name)
	    {
	    printf("  argname atom %d; argvalue %lx \n", retArgList->name,
		retArgList->value);
	    retArgList++;
	    }
	}

    XaRead(conn, defaultDevice,
		0, 0,
		0, 1024,
		&readData,
		&nBitsReturned, &leftPad,
		NULL);

    printf("Read request results: nBitsReturned = %d; leftPad = %d\n",
	    nBitsReturned, leftPad);
    readData = "This is random data to test Write.";
    XaWrite(conn, defaultDevice, 0, 0, readData, strlen(readData) * 8, 0,
		NULL);
    XaDestroy(conn, tag);



    fprintf(stderr,"Running connection main loop.\n");
    XaMainLoop(conn);
}


