/* $XConsortium: filetest.c /main/2 1996/12/30 16:35:27 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/


/*
 * filetest.c
 *
 * XA client for playing audio files.
 *
 *
 *  @(#)filetest.c	1.5 96/04/19   
*/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <malloc.h>
#include <unistd.h>
#include <string.h>

#include <Xa/Xafuncs.h>
#include <Xa/atomstrings.h>

const char *programName = "filetestxaplay";

void usage() {
    printf ("usage: %s\n", programName);
    printf (" [-v] [-d<D>] [-b<S>]  <audio files ...>\n");
    printf ("\t\td<D>        D = integer debug noise level.\n");
    printf ("\t\tv           verbose (debug = 1)\n");
    printf (" \t\t-b<S>      S = buffer size in milliseconds\n");
}


/* Debug noise levels */
int verbose = 0;
const int D_VERBOSE = 1;
#define VERBOSE (D_VERBOSE <= verbose)
const int D_NOISY = 50;
#define NOISY (D_NOISY <= verbose)
const int D_BARF = 100;
#define BARF (D_BARF <= verbose)

int      convertTo16 = FALSE;
unsigned endian;

unsigned short
swapw(unsigned short us)
{
    return ((us >> 8) | (us << 8)) & 0xffff;
}

void
wshort(unsigned short us, unsigned char *newdata)
{
    us = swapw(us);
    newdata[0] = (us) & 0xff;
    newdata[1] = (us >> 8) & 0xff;
}

static void 
convert8To16(char *buff, int buffSize, char *newBuff)
{
    long    datum;
    long   *longs;
    char   *newPtr;
    int     i;
    
    longs = (long *)malloc (buffSize * sizeof (long));

    for (i = 0; i < buffSize; i++) {
        datum = (long)buff[i];
	/* Another kludge: we know that most aiff data is signed
  	   So only do this only for wav.   */
	if (endian == XaAendianSmall)
	    datum ^= 128;
	longs[i] = datum << 24;  /* Scale signed up to long's range */
    }
    
    newPtr = newBuff;
    for (i = 0; i < buffSize; i++) {
	datum = longs[i] >> 16;
        wshort (datum, (unsigned char *)newPtr);
	newPtr += 2;
    }
}

/* Read from file, write to port
   use the buffer paramaters given. */
static int 
readWrite(XaTag infile, XaTag outfile, XaAudio server, XaTag port, char *buff, int buffSize) {
    
    static int bytesLeft = 0;
    CARD32     nBitsReturned;
    INT8       leftPad;
    
    /*  fill buffer if we have too.*/
    if(bytesLeft == 0) {
	if(BARF) 
	    fprintf(stderr, "Refilling buffer.\n");
	
  	XaRead (server, infile, 0, 0, 0, buffSize*8, &buff, &nBitsReturned, &leftPad,
		NULL);
  	if ((bytesLeft = nBitsReturned / 8) == 0) {
	    /* All done. */
	    if(VERBOSE) {
		fprintf (stderr, "File finished.\n");
	    }
	    return 0;
	}
    }
/*
// KLUDGE TO PLAY .wav FILES: 
//       If data is 8-bit linear (like the wav files), 
//       convert to 16-bit linear so that it will play on a dbri.
*/
    if (convertTo16 == TRUE) {
	char *newBuff = (char *)malloc (bytesLeft * 2);
	if (!newBuff) {
	    fprintf (stderr, "Can't allocate a %d buffer.\n", bytesLeft * 2);
	    exit (-1);
	}
	
	convert8To16(buff, bytesLeft, newBuff);
	XaWrite(server, port, 0, 0, newBuff, (bytesLeft * 2) * 8, 0, NULL);
	free (newBuff);
    }
    else {
	/* Play the buffer - all at once. */
	XaWrite(server, port, 0, 0, buff, bytesLeft * 8, 0, NULL);
	XaWrite(server, outfile, 0, 0, buff, bytesLeft * 8, 0, NULL);
    }
    
    bytesLeft = 0;
    return 1;
}

main( int argc, char *argv[]) {
    
    int          exitStatus = 0;
    /*
     * - Open a connectionto the server.
     * - Open the file
     * - Process local arguments.
     * - Create an output port
     * - funnel bits from the file to the port.
     * - shut down the connection.
    */


    /*
      Resources
     */
    int          fileFD;
    XaTag        speaker;
    XaTag        format;
    XaAtom       atom;
    XaTag        infile = XaTnone;
    XaTag        outfile = XaTnone;
    int          bufferLength;
    int          sampleFrame;
    char        *buffer = NULL;

    /* Format resources */
    unsigned     sampleRate = 8000;
    unsigned     samplesPerUnit = 1;
    unsigned     channels;
    unsigned     dataSize;
    XaTag        encodingTag;
    unsigned     bitsPerSample = 8;
    XaArgList    arglist;
    int          option;
    int          buffSizeMsecs = 500;
    extern char *optarg;
    extern int   optind;
    char        *fileName;
    char        *outFileName;
    char         errString[256];
    XaAudio      audioServer;

    /* Open connection to the audio server. */

    if((audioServer = XaOpenAudio(NULL, errString, &argc, argv)) == NULL) {
	fprintf (stderr, "Couldn't open XAudio connection: %s\n", errString);
	exit(-1);
    }
    /* What do we do this? */
    XaFlush(audioServer);
    /*XaSync(audioServer, FALSE, NULL); */
    
    /* Process local arguments.*/
    while( (option = getopt(argc, argv, "vb:d:")) != EOF) {
	switch(option) {
	case 'b':
	    buffSizeMsecs = atoi(optarg);
	    break;
	case 'v':
	    verbose = D_VERBOSE;
	    break;
	case 'd':
	    verbose = atoi(optarg);
	    break;
	case '?':
	    fprintf (stderr, "Don't know option: %c\n", (char)option);
	    usage();
		exitStatus = -1;
	    XaCloseAudio(audioServer);
	}
    }

    /*  XXXXX should probably learn to process multiple files.*/
    if( optind >= argc-1) {
	fprintf (stderr, "No files to play\n");
	usage();
	exitStatus = -1;
	goto close;
    }
    fileName = argv[optind];
    outFileName = argv[optind+1];

    infile = XaCreate(audioServer, XaNfile,
		    XaNname, "client infile object", NULL);
    if (infile == XaTnone) {
	fprintf (stderr, "Unable to create infile object.\n");
	exitStatus = -1;
	goto close;
    }

    XaSet (audioServer, infile, XaNpathName, fileName, 
		       XaNfileMode, XaAopenForRead, NULL);
    arglist = XaGet (audioServer, infile, NULL, XaNpathName, XaNfileMode, 
			XaNsampleRate, XaNsamplesPerUnit, 
			XaNbitsPerSample, XaNencoding,
			XaNendian, XaNdataSize, 
			XaNnumChannels, NULL);
    /*
     * Create an outfile to write to.
     */
    outfile = XaCreate(audioServer, XaNfile,
			XaNname, "out file", 
			XaNfileMode, XaNopenForWrite, NULL);
    if (outfile == XaTnone) {
	fprintf (stderr, "Unable to create outfile object.\n");
	exitStatus = -1;
	goto close;
    }

    if (!arglist) {
      fprintf (stderr, "XaGet infile attributes failed.\n");
      exitStatus = -1;
      goto close;
    }
    while (arglist->name) {
      atom = XaFindAtom (audioServer, arglist->name, FALSE, NULL);
      switch (atom) {
      case XaApathName:
	printf ("filename is %s\n", (char *)arglist->value);
 	break;
      case XaAfileMode:
	printf ("filemode is %d\n", (int)arglist->value);
 	break;
      case XaAsampleRate:
	sampleRate = (unsigned) arglist->value;
	XaSet(audioServer, outfile, XaNsampleRate, sampleRate, NULL);
 	break;
      case XaAsamplesPerUnit:
	samplesPerUnit = (unsigned) arglist->value;
	XaSet(audioServer, outfile, XaNsamplesPerUnit, samplesPerUnit, NULL);
 	break;
      case XaAbitsPerSample:
	bitsPerSample = (unsigned) arglist->value;
	XaSet(audioServer, outfile, XaNbitsPerSample, bitsPerSample, NULL);
 	break;
      case XaAencoding:
	encodingTag = (XaTag) arglist->value;
	XaSet(audioServer, outfile, XaNencoding, encodingTag, NULL);
 	break;
      case XaAendian:
	endian = (unsigned)arglist->value; 
	XaSet(audioServer, outfile, XaNendian, endian, NULL);
 	break;
      case XaAdataSize:
	dataSize = (unsigned) arglist->value;
	XaSet(audioServer, outfile, XaNdataSize, dataSize, NULL);
 	break;
      case XaAnumChannels:
	channels = (unsigned) arglist->value;
	XaSet(audioServer, outfile, XaNnumChannels, channels, NULL);
 	break;
      default:
	break;
      }
      arglist++;
    }

/*
// Need to set fileMode to write before setting pathname
// because fileMode doesn't work in XaCreate and
// the fileMode needs to be set before pathName initialization.
*/
    XaSet (audioServer, outfile, XaNfileMode, XaAopenForWrite, NULL);
    XaSet (audioServer, outfile, XaNpathName, outFileName, NULL);
    
    /* .... Create a a port to talk to ....
    // XXXXXX (As of now all ports are default output ports.)
    */
    speaker = XaCreate(audioServer, XaNport,
		       XaNname, "speaker port", 
		       XaNformat, 1,
		       NULL);
    arglist = XaGet (audioServer, speaker, NULL, XaNformat, NULL);
    
    if( speaker == XaTnone) {
	fprintf (stderr, "Couldn't create speaker port.");
	exitStatus = -1;
	goto manage;
    } else {
	if(VERBOSE) {
	    fprintf (stderr, "Created speaker port with tag: %d\n", speaker);
	}
    }
    
    /* Create a format 
     */
    format = XaCreate (audioServer, XaNformat,
		       XaNname, "format",  NULL);
    if (format == NULL) {
	fprintf (stderr, "Couldn't create format object.\n");
	exitStatus = -1;
	goto manage;
    }
    
    /* Set attributes on this format
     */
    if (encodingTag == XaAencodeLinear && bitsPerSample == 8) {
	/* Kludge: To play 8-bit linear wav files, we going to
	   //         convert the data to 16-bit linear and swap the bytes
	   //         so let's set the format now.  Note, this will only
	   //         work for dbri).
	   */
	bitsPerSample = 16;
	XaSet (audioServer, format, 
	       XaNencoding, encodingTag, 
	       XaNnumChannels, channels,
	       XaNbitsPerSample, bitsPerSample,
	       XaNsampleRate, sampleRate,
	       NULL);
	convertTo16 = TRUE;
    }
    else
	XaSet (audioServer, format, 
	       XaNencoding, encodingTag, 
	       XaNnumChannels, channels,
	       XaNbitsPerSample, bitsPerSample,
	       XaNsampleRate, sampleRate,
	       NULL);
    
    /*
     // Set this format on the speaker
     */
    XaSet (audioServer, speaker, XaNformat, format, NULL);
    
    /* Build a buffer. */
    bufferLength = sampleRate * (buffSizeMsecs / 1000.0)
	* (bitsPerSample/8) * samplesPerUnit;
    /* Calculate Sample Frame (a complete unit) */
    sampleFrame = channels * (bitsPerSample/8);
    /* If bufferLength is not a multiple of the
       sampleFrame, then truncate to the closest.
       */
    if ((bufferLength % sampleFrame) != 0)
	bufferLength = bufferLength - (bufferLength % sampleFrame);
    if( (buffer = (char*)malloc(bufferLength)) == NULL) {
	fprintf (stderr, "Can't allocate a %d buffer.\n", buffSizeMsecs);
	exitStatus = -1;
	goto manage;
    }
    
    /* Loop until the file is finished */
    while(readWrite(infile, outfile, audioServer, speaker, buffer, bufferLength)) {
 	if(BARF) 
	    fprintf (stderr, "Read/Write a buffer.\n");
    }
    
    /* In lieu of exceptions we use the "evil goto"
     //     to help with maintenance and clean up.
     */
  manage:
    XaSet(audioServer, infile, XaNcurrentSample, 367, NULL);
    if(VERBOSE) 
	fprintf (stderr, "Destroying objects in the server.\n");
    
    if( speaker != XaTnone) {
	if(VERBOSE)  
	    fprintf (stderr, "Speaker port - %d\n", speaker);
	XaDestroy(audioServer, speaker);
    }
    if (infile != XaTnone) {
	if (VERBOSE)
	    fprintf (stderr, "destroy infile - %d\n", infile);
        XaDestroy(audioServer, infile);
    }
    
    
    if(VERBOSE) fprintf (stderr, "... Done.\n");
    
    /*  Close the connection ......*/
  close:    
    XaCloseAudio(audioServer);
    if(VERBOSE) fprintf (stderr, "Audio Conection Closed.\n");
    return exitStatus;
}
